/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.text.Normalizer;
import jgamebase.tools.FileTools;

public abstract class StringTools {
    public static String beforeChar(String s, char delemiter) {
        if (s == null || s.indexOf(delemiter) == -1) {
            return "";
        }
        String t = s.trim();
        return t.substring(0, t.indexOf(delemiter));
    }

    public static String beforeSpace(String s) {
        return StringTools.beforeChar(s, ' ');
    }

    public static String beforeEqualsign(String s) {
        return StringTools.beforeChar(s, '=');
    }

    public static String afterChar(String s, char delemiter) {
        if (s == null) {
            return "";
        }
        String t = s.trim();
        int pos = t.indexOf(delemiter);
        if (pos == -1) {
            return "";
        }
        return t.substring(pos + 1, t.length());
    }

    public static String afterSpace(String s) {
        return StringTools.afterChar(s, ' ');
    }

    public static String afterEqualsign(String s) {
        return StringTools.afterChar(s, '=');
    }

    public static String padZeroBefore(String s, int length) {
        if (s == null) {
            return "";
        }
        StringBuilder t = new StringBuilder(s.trim());
        while (t.length() < length) {
            t.insert(0, "0");
        }
        return t.toString();
    }

    public static String firstCharAsString(String s) {
        String t;
        if (s != null && (t = s.trim()).length() > 0) {
            return Character.toString(StringTools.firstChar(t));
        }
        return "";
    }

    public static char firstChar(String s) {
        String t;
        if (s != null && (t = s.trim()).length() > 0) {
            return t.charAt(0);
        }
        return '\u0000';
    }

    public static String lastCharAsString(String s) {
        String t;
        if (s != null && (t = s.trim()).length() > 0) {
            return Character.toString(StringTools.lastChar(t));
        }
        return "";
    }

    public static char lastChar(String s) {
        String t;
        if (s != null && (t = s.trim()).length() > 0) {
            return t.charAt(t.length() - 1);
        }
        return '\u0000';
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        s = " " + s.toLowerCase();
        char[] chars = s.toCharArray();
        StringBuilder t = new StringBuilder(Character.toUpperCase(chars[0]));
        int i = 1;
        while (i < chars.length) {
            if (Character.isWhitespace(chars[i - 1]) || chars[i - 1] == '.' || chars[i - 1] == '!' || chars[i - 1] == '?' || chars[i - 1] == '_') {
                t.append(Character.toUpperCase(chars[i]));
            } else {
                t.append(chars[i]);
            }
            ++i;
        }
        return t.toString().trim();
    }

    public static String htmlDecode(String s) {
        return s.replaceAll("\\<[^>]*>", "");
    }

    public static String htmlEncode(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder t = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                t.append("&lt;");
            } else if (c == '>') {
                t.append("&gt;");
            } else if (c == '&') {
                t.append("&amp;");
            } else if (c == '\"') {
                t.append("&quot;");
            } else if (c == '\'') {
                t.append("&apos;");
            } else {
                t.append(c);
            }
            ++i;
        }
        return t.toString();
    }

    public static String startWithUpperCase(String s) {
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String sanitize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        s = s.replaceAll("\u00e4", "ae");
        s = s.replaceAll("\u00f6", "oe");
        s = s.replaceAll("\u00fc", "ue");
        s = s.replaceAll("\u00c4", "Ae");
        s = s.replaceAll("\u00d6", "Oe");
        s = s.replaceAll("\u00dc", "Ue");
        s = s.replaceAll("\u00df", "ss");
        s = s.replaceAll("&", " and ");
        s = s.replaceAll("\\(([^\\)]*)\\)", " $1");
        s = s.replaceAll("\\[([^\\]]*)\\]", " $1");
        s = s.replaceAll("\\{([^\\}]*)\\}", " $1");
        s = s.replaceAll("(\\w)?\\.(\\w)?", "$1$2");
        s = s.replaceAll("'", "");
        s = s.replaceAll("`", "");
        s = s.replaceAll("#(\\d+)", "Nr$1");
        s = s.replaceAll("(\\D+)0+(\\d*)", "$1 $2");
        s = Normalizer.normalize(s, Normalizer.Form.NFKD);
        s = s.replaceAll("[\\s\\W]", "_");
        s = s.replaceAll("_+", "_");
        s = s.replaceAll("^_", "");
        s = s.replaceAll("_$", "");
        return s;
    }

    public static String nextMedium(String fullFilename) {
        if (fullFilename == null || fullFilename.isEmpty()) {
            return "";
        }
        String filename = FileTools.removeExtension(fullFilename);
        if (filename.isEmpty() || filename.length() == 1) {
            return "";
        }
        if (Character.isDigit(StringTools.lastChar(filename))) {
            StringBuilder s = new StringBuilder();
            int pos = filename.length() - 1;
            while (pos > 0 && Character.isDigit(filename.charAt(pos))) {
                s = s.append(filename.charAt(pos));
                --pos;
            }
            s.reverse();
            try {
                int i = Integer.parseInt(s.toString()) + 1;
                return String.valueOf(filename.substring(0, pos + 1)) + i + "." + FileTools.getExtension(fullFilename);
            }
            catch (NumberFormatException numberFormatException) {
                return "";
            }
        }
        StringBuilder s = new StringBuilder(fullFilename);
        int pos = filename.length() - 1;
        s.setCharAt(pos, (char)(s.charAt(pos) + '\u0001'));
        return s.toString();
    }

    public static double getStringSimilarity(String s1, String s2) {
        String str2;
        String str1 = s1.trim();
        int levenshteinDistance = StringTools.getLevenshteinDistance(str1, str2 = s2.trim());
        if (levenshteinDistance == 0) {
            return 1.0;
        }
        String longestString = str1.length() > str2.length() ? str1 : str2;
        return 1.0 - 1.0 / (double)longestString.length() * (double)levenshteinDistance;
    }

    private static int getLevenshteinDistance(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int[][] d = new int[l1 + 1][l2 + 1];
        int i1 = 0;
        while (i1 <= l1) {
            d[i1][0] = i1;
            ++i1;
        }
        int i2 = 0;
        while (i2 <= l2) {
            d[0][i2] = i2;
            ++i2;
        }
        i1 = 1;
        while (i1 <= l1) {
            char s1_i1 = s1.charAt(i1 - 1);
            i2 = 1;
            while (i2 <= l2) {
                char s2_i2 = s2.charAt(i2 - 1);
                int cost = s1_i1 == s2_i2 ? 0 : 1;
                d[i1][i2] = StringTools.minimum(d[i1 - 1][i2] + 1, d[i1][i2 - 1] + 1, d[i1 - 1][i2 - 1] + cost);
                ++i2;
            }
            ++i1;
        }
        return d[l1][l2];
    }

    private static int minimum(int a, int b, int c) {
        int min = a;
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }

    public static int countLowerCase(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        char[] a = s.toCharArray();
        int c = 0;
        char[] cArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (Character.getType(element) == 2) {
                ++c;
            }
            ++n2;
        }
        return c;
    }

    public static int countUpperCase(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        char[] a = s.toCharArray();
        int c = 0;
        char[] cArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (Character.getType(element) == 1) {
                ++c;
            }
            ++n2;
        }
        return c;
    }

    public static int countWhitespace(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        char[] a = s.toCharArray();
        int c = 0;
        char[] cArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (Character.getType(element) == 12) {
                ++c;
            }
            ++n2;
        }
        return c;
    }

    public static boolean isCamelCase(String s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        int lower = StringTools.countLowerCase(s);
        int upper = StringTools.countUpperCase(s);
        int space = StringTools.countWhitespace(s);
        if (space != 0 || lower == 0 || upper == 0) {
            return false;
        }
        char[] a = s.toCharArray();
        boolean camelCase = false;
        int i = 0;
        while (i < a.length - 1) {
            if (Character.getType(a[i]) == 2 && Character.getType(a[i + 1]) == 1) {
                camelCase = true;
            }
            ++i;
        }
        return camelCase;
    }

    public static String deCamelCase(String s) {
        if (!StringTools.isCamelCase(s)) {
            return s;
        }
        char[] a = s.toCharArray();
        StringBuilder sb = new StringBuilder(s.length() * 2);
        int i = 0;
        while (i < a.length - 1) {
            sb.append(a[i]);
            if (Character.getType(a[i]) == 2 && Character.getType(a[i + 1]) == 1) {
                sb.append(' ');
            }
            ++i;
        }
        sb.append(a[a.length - 1]);
        return sb.toString();
    }

    public static String simplifyForMatching(String s) {
        if (s == null) {
            return "";
        }
        String n = s;
        n = StringTools.deCamelCase(n);
        int p = (n = n.replaceAll(":", " - ")).indexOf(" - ");
        if (p > 3) {
            n = n.substring(0, p);
        }
        n = n.replaceAll("\\(.*\\)", " ");
        n = n.replaceAll("\\[.*\\]", " ");
        n = n.replaceAll("(\\w)'([sS])", "$1$2");
        n = n.replaceAll("(\\d+)[']*[eE][rR]", "$1");
        n = n.replaceAll("'", " ");
        n = n.replaceAll("\"", " ");
        n = n.replaceAll("\\++$", " +");
        n = n.replaceAll("\\+", " plus ");
        n = n.replaceAll("/\\S+$", "");
        n = n.replaceAll("(\\D+)0+(\\d*)", "$1 $2");
        n = n.replaceAll("1[sS][tT]", "1");
        n = n.replaceAll("2[nN][dD]", "2");
        n = n.replaceAll("3[rR][dD]", "3");
        n = n.replaceAll("(\\d+)[tT][hH]", "$1");
        n = StringTools.removeArticle(n, "[aA][nN]");
        n = StringTools.removeArticle(n, "[aA]");
        n = StringTools.removeArticle(n, "[dD][aA][sS]");
        n = StringTools.removeArticle(n, "[dD][eE][nN]");
        n = StringTools.removeArticle(n, "[dD][eE][rR]");
        n = StringTools.removeArticle(n, "[dD][eE][sS]");
        n = StringTools.removeArticle(n, "[dD][eE][tT]");
        n = StringTools.removeArticle(n, "[dD][eE]");
        n = StringTools.removeArticle(n, "[dD][iI][eE]");
        n = StringTools.removeArticle(n, "[eE][eE][nN]");
        n = StringTools.removeArticle(n, "[eE][iI][nN][eE]");
        n = StringTools.removeArticle(n, "[eE][iI][nN]");
        n = StringTools.removeArticle(n, "[eE][lL]");
        n = StringTools.removeArticle(n, "[hH][eE][tT]");
        n = StringTools.removeArticle(n, "[iI][lL]");
        n = StringTools.removeArticle(n, "[lL][aA][sS]");
        n = StringTools.removeArticle(n, "[lL][aA]");
        n = StringTools.removeArticle(n, "[lL][eE][sS]");
        n = StringTools.removeArticle(n, "[lL][eE]");
        n = StringTools.removeArticle(n, "[lL][oO][sS]");
        n = StringTools.removeArticle(n, "[tT][hH][eE]");
        n = StringTools.removeArticle(n, "[uU][nN][oO]");
        n = n.replaceAll("\\s[iI][nN]\\s", " ");
        n = n.replaceAll("\\s[oO][fF]\\s", " ");
        n = n.replaceAll("\\s[aA][nN][dD]\\s", " ");
        n = n.replaceAll("\\s&\\s", " ");
        n = n.replaceAll("[dD][oO][cC][tT][oO][rR]", " Dr ");
        n = n.replaceAll("[dD][oO][cC]", " Dr ");
        n = n.replaceAll("([a-zA-Z]+)(\\d+)", "$1 $2");
        n = n.replaceAll("(\\d+)([a-zA-Z]+)", "$1 $2");
        n = StringTools.convertNumbers_RomanToArabic(n);
        n = StringTools.convertNumbers_ArabicToText(n);
        n = n.replaceAll("\\s[oO][nN][eE]\\s", " ");
        n = n.replaceAll("\\s[oO][nN][eE]$", "");
        n = StringTools.sanitize(n);
        n = n.replaceAll("_", " ");
        return n.toUpperCase();
    }

    private static String removeArticle(String s, String pattern) {
        s = s.replaceAll("^" + pattern + "[\\s]+", "");
        s = s.replaceAll("[\\s,;]+" + pattern + "$", "");
        s = s.replaceAll("\\W" + pattern + "\\s", " ");
        return s;
    }

    private static String convertNumbers_ArabicToText(String s) {
        s = s.replaceAll("(\\D+)1(\\D+)", "$1 one $2");
        s = s.replaceAll("(\\D+)1(\\D+)", "$1 one $2");
        s = s.replaceAll("(\\D+)2(\\D+)", "$1 two $2");
        s = s.replaceAll("(\\D+)3(\\D+)", "$1 three $2");
        s = s.replaceAll("(\\D+)4(\\D+)", "$1 four $2");
        s = s.replaceAll("(\\D+)5(\\D+)", "$1 five $2");
        s = s.replaceAll("(\\D+)6(\\D+)", "$1 six $2");
        s = s.replaceAll("(\\D+)7(\\D+)", "$1 seven $2");
        s = s.replaceAll("(\\D+)8(\\D+)", "$1 eight $2");
        s = s.replaceAll("(\\D+)9(\\D+)", "$1 nine $2");
        s = s.replaceAll("(\\D+)10(\\D+)", "$1 ten $2");
        s = s.replaceAll("(\\D+)11(\\D+)", "$1 eleven $2");
        s = s.replaceAll("(\\D+)12(\\D+)", "$1 twelve $2");
        s = s.replaceAll("(\\D+)13(\\D+)", "$1 thirteen $2");
        s = s.replaceAll("(\\D+)14(\\D+)", "$1 fourteen $2");
        s = s.replaceAll("(\\D+)15(\\D+)", "$1 fifteen $2");
        s = s.replaceAll("(\\D+)16(\\D+)", "$1 sixteen $2");
        s = s.replaceAll("(\\D+)17(\\D+)", "$1 seventeen $2");
        s = s.replaceAll("(\\D+)18(\\D+)", "$1 eighteen $2");
        s = s.replaceAll("(\\D+)19(\\D+)", "$1 nineteen $2");
        s = s.replaceAll("(\\D+)20(\\D+)", "$1 twenty $2");
        s = s.replaceAll("(\\D+)21(\\D+)", "$1 twentyone $2");
        s = s.replaceAll("(\\D+)22(\\D+)", "$1 twentytwo $2");
        s = s.replaceAll("(\\D+)23(\\D+)", "$1 twentythree $2");
        s = s.replaceAll("(\\D+)24(\\D+)", "$1 twentyfour $2");
        s = s.replaceAll("(\\D+)25(\\D+)", "$1 twentyfive $2");
        s = s.replaceAll("(\\D+)1$", "$1 one");
        s = s.replaceAll("(\\D+)2$", "$1 two");
        s = s.replaceAll("(\\D+)3$", "$1 three");
        s = s.replaceAll("(\\D+)4$", "$1 four");
        s = s.replaceAll("(\\D+)5$", "$1 five");
        s = s.replaceAll("(\\D+)6$", "$1 six");
        s = s.replaceAll("(\\D+)7$", "$1 seven");
        s = s.replaceAll("(\\D+)8$", "$1 eight");
        s = s.replaceAll("(\\D+)9$", "$1 nine");
        s = s.replaceAll("(\\D+)10$", "$1 ten");
        s = s.replaceAll("(\\D+)11$", "$1 eleven");
        s = s.replaceAll("(\\D+)12$", "$1 twelve");
        s = s.replaceAll("(\\D+)13$", "$1 thirteen");
        s = s.replaceAll("(\\D+)14$", "$1 fourteen");
        s = s.replaceAll("(\\D+)15$", "$1 fifteen");
        s = s.replaceAll("(\\D+)16$", "$1 sixteen");
        s = s.replaceAll("(\\D+)17$", "$1 seventeen");
        s = s.replaceAll("(\\D+)18$", "$1 eighteen");
        s = s.replaceAll("(\\D+)19$", "$1 nineteen");
        s = s.replaceAll("(\\D+)20$", "$1 twenty");
        s = s.replaceAll("(\\D+)21$", "$1 twentyone");
        s = s.replaceAll("(\\D+)22$", "$1 twentytwo");
        s = s.replaceAll("(\\D+)23$", "$1 twentythree");
        s = s.replaceAll("(\\D+)24$", "$1 twentyfour");
        s = s.replaceAll("(\\D+)25$", "$1 twentyfive");
        return s;
    }

    public static String convertNumbers_AllToArabic(String s) {
        s = StringTools.convertNumbers_RomanToArabic(s);
        s = StringTools.convertNumbers_TextToArabic(s);
        return s;
    }

    private static String convertNumbers_TextToArabic(String s) {
        s = s.replaceAll("\\s+one\\s+", " 1 ");
        s = s.replaceAll("\\s+two\\s+", " 2 ");
        s = s.replaceAll("\\s+three\\s+", " 3 ");
        s = s.replaceAll("\\s+four\\s+", " 4 ");
        s = s.replaceAll("\\s+five\\s+", " 5 ");
        s = s.replaceAll("\\s+six\\s+", " 6 ");
        s = s.replaceAll("\\s+seven\\s+", " 7 ");
        s = s.replaceAll("\\s+eight\\s+", " 8 ");
        s = s.replaceAll("\\s+nine\\s+", " 9 ");
        s = s.replaceAll("\\s+ten\\s+", " 10 ");
        s = s.replaceAll("\\s+eleven\\s+", " 11 ");
        s = s.replaceAll("\\s+twelve\\s+", " 12 ");
        s = s.replaceAll("\\s+thirteen\\s+", " 13 ");
        s = s.replaceAll("\\s+fourteen\\s+", " 14 ");
        s = s.replaceAll("\\s+fifteen\\s+", " 15 ");
        s = s.replaceAll("\\s+sixteen\\s+", " 16 ");
        s = s.replaceAll("\\s+seventeen\\s+", " 17 ");
        s = s.replaceAll("\\s+eighteen\\s+", " 18 ");
        s = s.replaceAll("\\s+nineteen\\s+", " 19 ");
        s = s.replaceAll("\\s+twenty\\s+", " 20 ");
        s = s.replaceAll("\\s+twentyone\\s+", " 21 ");
        s = s.replaceAll("\\s+twentytwo\\s+", " 22 ");
        s = s.replaceAll("\\s+twentythree\\s+", " 23 ");
        s = s.replaceAll("\\s+twentyfour\\s+", " 24 ");
        s = s.replaceAll("\\s+twentyfive\\s+", " 25 ");
        s = s.replaceAll("\\s+one$", " 1");
        s = s.replaceAll("\\s+two$", " 2");
        s = s.replaceAll("\\s+three$", " 3");
        s = s.replaceAll("\\s+four$", " 4");
        s = s.replaceAll("\\s+five$", " 5");
        s = s.replaceAll("\\s+six$", " 6");
        s = s.replaceAll("\\s+seven$", " 7");
        s = s.replaceAll("\\s+eight$", " 8");
        s = s.replaceAll("\\s+nine$", " 9");
        s = s.replaceAll("\\s+ten$", " 10");
        s = s.replaceAll("\\s+eleven$", " 11");
        s = s.replaceAll("\\s+twelve$", " 12");
        s = s.replaceAll("\\s+thirteen$", " 13");
        s = s.replaceAll("\\s+fourteen$", " 14");
        s = s.replaceAll("\\s+fifteen$", " 15");
        s = s.replaceAll("\\s+sixteen$", " 16");
        s = s.replaceAll("\\s+seventeen$", " 17");
        s = s.replaceAll("\\s+eighteen$", " 18");
        s = s.replaceAll("\\s+nineteen$", " 19");
        s = s.replaceAll("\\s+twenty$", " 20");
        s = s.replaceAll("\\s+twentyone$", " 21");
        s = s.replaceAll("\\s+twentytwo$", " 22");
        s = s.replaceAll("\\s+twentythree$", " 23");
        s = s.replaceAll("\\s+twentyfour$", " 24");
        s = s.replaceAll("\\s+twentyfive$", " 25");
        return s;
    }

    public static String convertNumbers_RomanToArabic(String s) {
        s = s.replaceAll("[\\s]+[iI][\\s]+", " 1 ");
        s = s.replaceAll("[\\s]+[iI][iI][\\s]+", " 2 ");
        s = s.replaceAll("[\\s]+[iI][iI][iI][\\s]+", " 3 ");
        s = s.replaceAll("[\\s]+[iI][vV][\\s]+", " 4 ");
        s = s.replaceAll("[\\s]+[vV][\\s]+", " 5 ");
        s = s.replaceAll("[\\s]+[vV][iI][\\s]+", " 6 ");
        s = s.replaceAll("[\\s]+[vV][iI][iI][\\s]+", " 7 ");
        s = s.replaceAll("[\\s]+[vV][iI][iI][iI][\\s]+", " 8 ");
        s = s.replaceAll("[\\s]+[iI][xX][\\s]+", " 9 ");
        s = s.replaceAll("[\\s]+[xX][\\s]+", " 10 ");
        s = s.replaceAll("[\\s]+[xX][iI][\\s]+", " 11 ");
        s = s.replaceAll("[\\s]+[xX][iI][iI][\\s]+", " 12 ");
        s = s.replaceAll("[\\s]+[iI]$", " 1");
        s = s.replaceAll("[\\s]+[iI][iI]$", " 2");
        s = s.replaceAll("[\\s]+[iI][iI][iI]$", " 3");
        s = s.replaceAll("[\\s]+[iI][vV]$", " 4");
        s = s.replaceAll("[\\s]+[vV]$", " 5");
        s = s.replaceAll("[\\s]+[vV][iI]$", " 6");
        s = s.replaceAll("[\\s]+[vV][iI][iI]$", " 7");
        s = s.replaceAll("[\\s]+[vV][iI][iI][iI]$", " 8");
        s = s.replaceAll("[\\s]+[iI][xX]$", " 9");
        s = s.replaceAll("[\\s]+[xX]$", " 10");
        s = s.replaceAll("[\\s]+[xX][iI]$", " 11");
        s = s.replaceAll("[\\s]+[xX][iI][iI]$", " 12");
        return s;
    }
}

