/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;

public abstract class CreateOptionsObjectNode
extends JavaScriptBaseNode {
    @Node.Child
    JSToObjectNode toObjectNode;
    private final JSContext context;

    public JSContext getContext() {
        return this.context;
    }

    public CreateOptionsObjectNode(JSContext context) {
        this.context = context;
    }

    public abstract DynamicObject execute(Object var1);

    @Specialization(guards={"isUndefined(opts)"})
    public DynamicObject fromUndefined(Object opts) {
        return JSOrdinary.createWithNullPrototype(this.getContext());
    }

    @Specialization(guards={"!isUndefined(opts)"})
    public DynamicObject fromOtherThenUndefined(Object opts) {
        return this.toDynamicObject(opts);
    }

    private DynamicObject toDynamicObject(Object o) {
        if (this.toObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toObjectNode = (JSToObjectNode)this.insert(JSToObjectNode.createToObject(this.getContext()));
        }
        return (DynamicObject)this.toObjectNode.execute(o);
    }
}

