/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyBuiltins;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWebAssembly {
    public static final String CLASS_NAME = "WebAssembly";
    public static final HiddenKey FUNCTION_ADDRESS = new HiddenKey("FunctionAddress");

    private JSWebAssembly() {
    }

    public static DynamicObject create(JSRealm realm) {
        DynamicObject webAssembly = JSOrdinary.createInit(realm);
        JSObjectUtil.putToStringTag(webAssembly, CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(realm, webAssembly, WebAssemblyBuiltins.BUILTINS);
        return webAssembly;
    }

    public static boolean isExportedFunction(Object function) {
        return JSDynamicObject.isJSDynamicObject(function) && JSObjectUtil.hasHiddenProperty((JSDynamicObject)((Object)function), FUNCTION_ADDRESS);
    }
}

