/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Null;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Context;

public class DebugJSAgent
extends JSAgent {
    private OptionValues optionValues;
    private final Deque<Object> reportValues;
    private final List<AgentExecutor> spawnedAgent;
    private boolean quit;
    private Object debugReceiveBroadcast;

    @CompilerDirectives.TruffleBoundary
    public DebugJSAgent(boolean canBlock, OptionValues optionValues) {
        super(canBlock);
        this.optionValues = optionValues;
        this.reportValues = new ConcurrentLinkedDeque<Object>();
        this.spawnedAgent = new LinkedList<AgentExecutor>();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "DebugJSAgent{signifier=" + this.getSignifier() + "}";
    }

    @CompilerDirectives.TruffleBoundary
    public Object startNewAgent(final String source) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        final CountDownLatch barrier = new CountDownLatch(1);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Context.Builder contextBuilder = Context.newBuilder((String[])new String[]{"js"}).allowExperimentalOptions(true);
                for (OptionDescriptor optionDescriptor : DebugJSAgent.this.optionValues.getDescriptors()) {
                    if (!optionDescriptor.getKey().hasBeenSet(DebugJSAgent.this.optionValues)) continue;
                    contextBuilder.option(optionDescriptor.getName(), String.valueOf(optionDescriptor.getKey().getValue(DebugJSAgent.this.optionValues)));
                }
                Context polyglotContext = contextBuilder.build();
                polyglotContext.enter();
                try {
                    polyglotContext.initialize("js");
                    DebugJSAgent debugJSAgent = (DebugJSAgent)JavaScriptLanguage.getCurrentJSRealm().getContext().getJSAgent();
                    AgentExecutor executor = DebugJSAgent.this.registerChildAgent(Thread.currentThread(), debugJSAgent);
                    polyglotContext.eval("js", (CharSequence)source);
                    barrier.countDown();
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            executor.executeBroadcastCallback();
                        }
                        if (executor.jsAgent.quit) {
                            return;
                        }
                        executor.jsAgent.processAllPromises(false);
                    }
                }
                finally {
                    polyglotContext.leave();
                    polyglotContext.close();
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("Debug-JSAgent-Worker-Thread");
        thread.start();
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return result.get();
    }

    @CompilerDirectives.TruffleBoundary
    public void setDebugReceiveBroadcast(Object lambda) {
        this.debugReceiveBroadcast = lambda;
    }

    @CompilerDirectives.TruffleBoundary
    public AgentExecutor registerChildAgent(Thread thread, DebugJSAgent jsAgent) {
        AgentExecutor spawned = new AgentExecutor(thread, jsAgent);
        this.spawnedAgent.add(spawned);
        return spawned;
    }

    @CompilerDirectives.TruffleBoundary
    public void broadcast(Object sab) {
        for (AgentExecutor e : this.spawnedAgent) {
            e.pushMessage(sab);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getReport() {
        for (AgentExecutor e : this.spawnedAgent) {
            if (((AgentExecutor)e).jsAgent.reportValues.size() <= 0) continue;
            return ((AgentExecutor)e).jsAgent.reportValues.pollLast();
        }
        return Null.instance;
    }

    @CompilerDirectives.TruffleBoundary
    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void report(Object value) {
        this.reportValues.push(value);
    }

    @CompilerDirectives.TruffleBoundary
    public void leaving() {
        this.quit = true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void wakeAgent(int w) {
        for (AgentExecutor e : this.spawnedAgent) {
            if (e.jsAgent.getSignifier() != w) continue;
            e.thread.interrupt();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isTerminated() {
        throw new UnsupportedOperationException("Not supported in Debug agent");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void terminate(int timeout) {
        throw new UnsupportedOperationException("Not supported in Debug agent");
    }

    private static final class AgentExecutor {
        private final DebugJSAgent jsAgent;
        private final Thread thread;
        private ConcurrentLinkedDeque<Object> incoming;

        @CompilerDirectives.TruffleBoundary
        AgentExecutor(Thread thread, DebugJSAgent jsAgent) {
            this.thread = thread;
            this.jsAgent = jsAgent;
            this.incoming = new ConcurrentLinkedDeque();
        }

        @CompilerDirectives.TruffleBoundary
        private void pushMessage(Object sab) {
            this.incoming.add(sab);
            this.thread.interrupt();
        }

        @CompilerDirectives.TruffleBoundary
        public void executeBroadcastCallback() {
            assert (this.jsAgent.debugReceiveBroadcast != null);
            while (this.incoming.size() > 0) {
                DynamicObject cb = (DynamicObject)this.jsAgent.debugReceiveBroadcast;
                JSFunction.call(cb, cb, new Object[]{this.incoming.pop()});
            }
        }
    }
}

