/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityNotFoundException;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.db.Export;
import jgamebase.db.Import;
import jgamebase.db.Table;
import jgamebase.db.Update;
import jgamebase.db.model.Cracker;
import jgamebase.db.model.Difficulty;
import jgamebase.db.model.Extra;
import jgamebase.db.model.Game;
import jgamebase.db.model.Genre;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemView;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Language;
import jgamebase.db.model.Music;
import jgamebase.db.model.Musician;
import jgamebase.db.model.Programmer;
import jgamebase.db.model.Publisher;
import jgamebase.db.model.Selection;
import jgamebase.db.model.Year;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.tools.FileTools;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;

public class Db {
    private static String dbDriver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String dbUrl = "jdbc:derby:";
    public static final String FALSE = "('false', '0')";
    public static final String TRUE = "('true', '1')";
    private static SessionFactory sessionFactory = null;
    private static Session session = null;
    protected static final double NEEDED_VERSION = 2.8;

    public static synchronized void init(String dbName, boolean createDb) {
        try {
            Configuration config;
            if (session != null) {
                Db.close();
            }
            System.setProperty("derby.system.home", Const.GBDIR_RW.getAbsolutePath());
            if (createDb) {
                Const.log.info((Object)("\nCreating database '" + dbName + "'..."));
                config = new Configuration().configure(new File(Const.GBDIR_RO, "hibernateImport.cfg.xml"));
                config.setProperty("hibernate.connection.driver_class", dbDriver);
                config.setProperty("hibernate.default_schema", "APP");
                config.setProperty("hibernate.connection.url", String.valueOf(dbUrl) + new File(new File(Const.GBDIR_RW, dbName), "Database") + ";create=true");
                config.setProperty("hbm2ddl.auto", "create");
            } else {
                Const.log.info((Object)("\nOpening database '" + dbName + "'..."));
                config = new Configuration().configure(new File(Const.GBDIR_RO, "hibernate.cfg.xml"));
                config.setProperty("hibernate.connection.driver_class", dbDriver);
                config.setProperty("hibernate.default_schema", "APP");
                config.setProperty("hibernate.connection.url", String.valueOf(dbUrl) + new File(new File(Const.GBDIR_RW, dbName), "Database") + ";upgrade=true");
            }
            sessionFactory = config.buildSessionFactory();
            session = sessionFactory.openSession();
            session.setHibernateFlushMode(FlushMode.ALWAYS);
            if (!createDb) {
                double version = Db.getVersion();
                if (version == 0.0) {
                    Const.log.info((Object)"Warning: Could not read database version.");
                    Gui.displayWarningDialog("Could not read database version.");
                } else if (version < 2.8) {
                    Const.log.info((Object)("\nFound database in version " + version + ", but need version " + 2.8 + ": trying to update it...\n"));
                    Export.db2Csv(Db.getTableNames());
                    Db.shutdown();
                    Const.log.info((Object)("\nDeleting old database directory '" + new File(new File(Const.GBDIR_RW, dbName), "Database") + "'.\n"));
                    FileTools.deleteAll(new File(new File(Const.GBDIR_RW, dbName), "Database"));
                    boolean errorOccured = Update.updateFrom(Databases.getCurrent().getExportPath(), version);
                    if (errorOccured) {
                        Const.log.info((Object)"ERROR: Could not update database to version 2.8.");
                        Gui.displayErrorDialog("Could not update database to version 2.8.");
                        JGameBase.quit();
                    }
                    Class.forName(dbDriver).newInstance();
                    Db.init(dbName, true);
                    Import.csv2Db(Databases.getCurrent().getExportPath());
                    Const.log.info((Object)"DB Converted.");
                    Db.close();
                    Db.init(dbName, false);
                }
            }
            if (!Db.getTableNames().contains("VIEWCOLUMNS")) {
                try {
                    Const.log.info((Object)"\nTable 'VIEWCOLUMNS' does not exist, trying to create it...");
                    Db.createTable_ViewColumns();
                    Const.log.info((Object)"Table successfully created.\n");
                }
                catch (Exception e) {
                    Const.log.info((Object)"Table could NOT be created!\n");
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable ex) {
            Const.log.error((Object)("Initial SessionFactory or Session creation failed." + ex));
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex);
        }
    }

    protected static synchronized Session getSession() {
        return session;
    }

    public static double getVersion() {
        double version = 0.0;
        try {
            version = (Double)session.doReturningWork(connection -> {
                ResultSet srs = connection.createStatement().executeQuery("SELECT * FROM Config");
                srs.next();
                return (double)Double.valueOf(String.valueOf(srs.getInt("MajorVersion")) + "." + srs.getInt("MinorVersion"));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }

    public static List<String> getTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            ResultSet tables = (ResultSet)session.doReturningWork(connection -> {
                DatabaseMetaData myMT = connection.getMetaData();
                return myMT.getTables(null, null, "%", new String[]{"TABLE"});
            });
            while (tables != null && tables.next()) {
                String dbTableName = tables.getString("TABLE_NAME");
                boolean found = false;
                for (String jgbTableName : Table.getNames()) {
                    if (!dbTableName.equalsIgnoreCase(jgbTableName) || found) continue;
                    tableNames.add(jgbTableName);
                    found = true;
                }
                if (found) continue;
                tableNames.add(dbTableName.toUpperCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableNames;
    }

    protected static void createTable_ViewColumns() {
        session.beginTransaction();
        Db.executeSql("create table APP.VIEWCOLUMNS (VC_ID integer not null, VW_ID integer, MODELINDEX integer, VIEWINDEX integer, WIDTH integer, FILTER varchar(32) default '' not null, primary key (VC_ID))");
        Db.executeSql("create index VIEWCOLUMNS_VW_ID on APP.VIEWCOLUMNS (VW_ID)");
        Db.executeSql("create index VIEWCOLUMNS_VC_ID on APP.VIEWCOLUMNS (VC_ID)");
        Db.executeSql("alter table APP.VIEWCOLUMNS add constraint FK55249D78475830E5 foreign key (VW_ID) references APP.VIEWDATA");
        session.getTransaction().commit();
    }

    protected static void executeSql(String sql) {
        try {
            session.doWork(connection -> {
                Statement stmt = connection.createStatement();
                stmt.executeUpdate(sql);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void close() {
        try {
            if (session != null) {
                if (session.getTransaction().isActive()) {
                    session.getTransaction().commit();
                }
                if (session.isOpen()) {
                    session.close();
                }
                session = null;
            }
        }
        catch (HibernateException hibernateException) {}
    }

    public static synchronized void shutdown() {
        boolean gotSQLExc;
        block16: {
            Db.close();
            gotSQLExc = false;
            Connection connection = null;
            try {
                try {
                    connection = DriverManager.getConnection(String.valueOf(dbUrl) + ";shutdown=true");
                }
                catch (SQLException se) {
                    if (se.getSQLState() == null || se.getSQLState() != null && "XJ015".equals(se.getSQLState())) {
                        gotSQLExc = true;
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (!gotSQLExc) {
            Const.log.info((Object)"Database did not shut down normally.");
        }
        session = null;
        sessionFactory = null;
    }

    public static synchronized List<Item> getItems(ItemView view) {
        List<Item> musicItems;
        List<Item> gameItems;
        ArrayList<Item> items = new ArrayList<Item>();
        if ((view.getInclude() == 2 || view.getInclude() == 0) && (gameItems = Db.getItemsFromGametable(view)) != null) {
            items.addAll(gameItems);
        }
        if ((view.getInclude() == 2 || view.getInclude() == 1) && (musicItems = Db.getItemsFromMusictable(view)) != null) {
            items.addAll(musicItems);
        }
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (item.getName() != null && !item.getName().isEmpty()) continue;
            iterator.remove();
            Db.delete(item);
        }
        items = new ArrayList(new TreeSet(items));
        return items;
    }

    private static synchronized List<Item> getItemsFromGametable(ItemView view) {
        List<Item> items = null;
        try {
            items = session.createSQLQuery(Db.buildGameQuery(view)).addEntity(Game.class).list();
        }
        catch (NullPointerException nullPointerException) {
            items = new ArrayList<Item>();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items;
    }

    public static synchronized List<Selection> getSelections(ItemViewFilter filter) {
        List selections = null;
        String linkField = Db.GetLinkFieldName(filter.getGameField());
        String query = "SELECT " + linkField + " AS NAME, " + filter.getGameField() + " AS VALUE FROM " + filter.getGameTable() + " WHERE " + linkField + " <> '' ORDER BY ";
        query = "DIFFICULTY".equals(linkField) ? String.valueOf(query) + filter.getGameField() : String.valueOf(query) + linkField;
        try {
            selections = session.createSQLQuery(query).addEntity(Selection.class).list();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return selections;
    }

    private static String GetLinkFieldName(String strLinkField) {
        switch (strLinkField = strLinkField.toUpperCase()) {
            case "PU_ID": {
                return "PUBLISHER";
            }
            case "PR_ID": {
                return "PROGRAMMER";
            }
            case "MU_ID": {
                return "MUSICIAN";
            }
            case "LA_ID": {
                return "LANGUAGE";
            }
            case "GE_ID": {
                return "GENRE";
            }
            case "PG_ID": {
                return "PARENTGENRE";
            }
            case "CR_ID": {
                return "CRACKER";
            }
            case "DI_ID": {
                return "DIFFICULTY";
            }
        }
        return "";
    }

    public static synchronized List<Selection> getGenreSelections() {
        ArrayList<Selection> selections;
        block16: {
            selections = new ArrayList<Selection>();
            ResultSet rs = null;
            try {
                try {
                    rs = (ResultSet)session.doReturningWork(connection -> {
                        Statement statement = connection.createStatement();
                        return statement.executeQuery("SELECT GENRE, PARENTGENRE, GE_ID FROM PGENRES INNER JOIN GENRES ON (PGENRES.PG_ID = GENRES.PG_ID) ORDER BY PGENRES.PARENTGENRE, GENRES.GENRE");
                    });
                    while (rs.next()) {
                        String genre = rs.getString("GENRE") == null ? "" : rs.getString("GENRE");
                        String parentGenre = rs.getString("PARENTGENRE") == null ? "" : rs.getString("PARENTGENRE");
                        int id = rs.getInt("GE_ID");
                        if (!parentGenre.isEmpty()) {
                            selections.add(new Selection(String.valueOf(parentGenre) + " - " + genre, id));
                            continue;
                        }
                        selections.add(new Selection(genre, id));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return selections;
    }

    private static String buildGameQuery(ItemView view) {
        String query = "SELECT * FROM GAMES ";
        String whereClause = Db.getWhereClause(view, true);
        if (whereClause.contains("YEARS")) {
            query = String.valueOf(query) + "JOIN YEARS ON (GAMES.YE_ID = YEARS.YE_ID) ";
        }
        if (whereClause.contains("PUBLISHERS")) {
            query = String.valueOf(query) + "JOIN PUBLISHERS ON (GAMES.PU_ID = PUBLISHERS.PU_ID) ";
        }
        if (whereClause.contains("GENRES")) {
            query = String.valueOf(query) + "JOIN GENRES ON (GAMES.GE_ID = GENRES.GE_ID) ";
            query = String.valueOf(query) + "JOIN PGENRES ON (GENRES.PG_ID = PGENRES.PG_ID) ";
        }
        if (whereClause.contains("MUSICIANS")) {
            query = String.valueOf(query) + "JOIN MUSICIANS ON (GAMES.MU_ID = MUSICIANS.MU_ID) ";
        }
        if (whereClause.contains("DIFFICULTY")) {
            query = String.valueOf(query) + "JOIN DIFFICULTY ON (GAMES.DI_ID = DIFFICULTY.DI_ID) ";
        }
        if (whereClause.contains("LANGUAGES")) {
            query = String.valueOf(query) + "JOIN LANGUAGES ON (GAMES.LA_ID = LANGUAGES.LA_ID) ";
        }
        if (whereClause.contains("PROGRAMMERS")) {
            query = String.valueOf(query) + "JOIN PROGRAMMERS ON (GAMES.PR_ID = PROGRAMMERS.PR_ID) ";
        }
        if (whereClause.contains("EXTRAS")) {
            query = String.valueOf(query) + "JOIN EXTRAS ON (GAMES.GA_ID = EXTRAS.GA_ID) ";
        }
        if (whereClause.contains("CRACKERS")) {
            query = String.valueOf(query) + "JOIN CRACKERS ON (GAMES.CR_ID = CRACKERS.CR_ID) ";
        }
        query = String.valueOf(query) + whereClause;
        return query;
    }

    private static synchronized List<Item> getItemsFromMusictable(ItemView view) {
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            String musicQuery = Db.buildMusicQuery(view);
            if (musicQuery != null) {
                items.addAll(session.createSQLQuery(musicQuery).addEntity(Music.class).list());
            }
        }
        catch (NullPointerException nullPointerException) {
            items = new ArrayList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items;
    }

    private static String buildMusicQuery(ItemView view) {
        String query = "SELECT * FROM MUSIC ";
        String whereClause = Db.getWhereClause(view, false);
        if ("WHERE ()".equals(whereClause)) {
            return null;
        }
        if (whereClause.contains("MUSICIANS")) {
            query = String.valueOf(query) + "JOIN MUSICIANS ON (MUSIC.MU_ID = MUSICIANS.MU_ID) ";
        }
        query = String.valueOf(query) + whereClause;
        return query;
    }

    public static synchronized Extra getExtraById(int id) {
        Extra extra = null;
        try {
            extra = (Extra)session.createQuery("from Extra where EX_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extra;
    }

    public static synchronized List<Extra> getExtrasByGameId(int id) {
        List extras = null;
        try {
            extras = session.createQuery("from Extra where GA_ID=" + id + " ORDER BY DisplayOrder").list();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extras;
    }

    private static int getExtraIdCountByGameId(int id) {
        int count = 0;
        try {
            Query q = session.createQuery("select count (*) from Extra where GA_ID=:gameId");
            q.setInteger("gameId", id);
            count = ((Long)q.uniqueResult()).intValue();
        }
        catch (Exception exception) {}
        return count;
    }

    private static int[] getExtraIdsByGameId(int id) {
        int[] extraIds = new int[]{};
        List extraIdsList = null;
        try {
            Query q = session.createQuery("select id from Extra where GA_ID=:gameId");
            q.setInteger("gameId", id);
            extraIdsList = q.list();
            extraIds = ArrayUtils.toPrimitive((Integer[])extraIdsList.toArray(new Integer[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extraIds;
    }

    private static synchronized void deleteExtrasbyGameIdExtraId(int gameId, int extraId) {
        Query q = session.createQuery("delete from Extra where GA_ID=:gameId AND EX_ID=:extraId");
        q.setInteger("gameId", gameId);
        q.setInteger("extraId", extraId);
        q.executeUpdate();
    }

    public static synchronized Publisher getPublisherById(int id) {
        Publisher publisher = null;
        try {
            publisher = (Publisher)session.createQuery("from Publisher where PU_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return publisher;
    }

    public static synchronized Programmer getProgrammerById(int id) {
        Programmer programmer = null;
        try {
            programmer = (Programmer)session.createQuery("from Programmer where PR_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return programmer;
    }

    public static synchronized Musician getMusicianById(int id) {
        Musician musician = null;
        try {
            musician = (Musician)session.createQuery("from Musician where MU_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return musician;
    }

    public static synchronized Language getLanguageById(int id) {
        Language language = null;
        try {
            language = (Language)session.createQuery("from Language where LA_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return language;
    }

    public static synchronized Difficulty getDifficultyById(int id) {
        Difficulty difficulty = null;
        try {
            difficulty = (Difficulty)session.createQuery("from Difficulty where DI_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return difficulty;
    }

    public static synchronized Cracker getCrackerById(int id) {
        Cracker cracker = null;
        try {
            cracker = (Cracker)session.createQuery("from Cracker where CR_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cracker;
    }

    public static synchronized Year getYearById(int id) {
        Year year = null;
        try {
            year = (Year)session.createQuery("from Year where YE_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return year;
    }

    public static synchronized Item getItembyId(String id) {
        if (id.startsWith("G")) {
            return Db.getGameById(Integer.parseInt(id.substring(1)));
        }
        if (id.startsWith("M")) {
            return Db.getMusicById(Integer.parseInt(id.substring(1)));
        }
        return null;
    }

    public static synchronized Game getGameById(int id) {
        Game game = null;
        try {
            game = (Game)session.createQuery("from Game where GA_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return game;
    }

    public static synchronized void resetGamesPlayedInformation() {
        try {
            session.beginTransaction();
            session.createQuery("update Game set timesPlayed=0, dateLastPlayed=''").executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized int getMaxTimesPlayed() {
        int timesPlayed = 0;
        try {
            timesPlayed = (Integer)session.createQuery("select max(timesPlayed) from Game").uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timesPlayed;
    }

    public static synchronized Game getOneGameByTimesPlayed(int timesPlayed) {
        Game game = null;
        try {
            List games = session.createQuery("from Game where timesPlayed=" + timesPlayed).list();
            if (!games.isEmpty()) {
                game = (Game)games.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return game;
    }

    public static synchronized Music getMusicById(int id) {
        Music music = null;
        try {
            music = (Music)session.createQuery("from Music where GA_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return music;
    }

    public static synchronized Genre getGenreById(int id) {
        Genre genre = null;
        try {
            genre = (Genre)session.createQuery("from Genre where GE_ID=" + id).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return genre;
    }

    public static synchronized List<Extra> getExtras() {
        List extras = null;
        try {
            extras = session.createQuery("from Extra").list();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extras;
    }

    public static synchronized List<ItemView> getSystemViews() {
        ArrayList views = null;
        try {
            views = session.createQuery("from ItemView where name like '<%' order by name").list();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (views == null) {
            views = new ArrayList();
        }
        return views;
    }

    public static synchronized List<ItemView> getNormalViews() {
        List views = null;
        try {
            views = session.createQuery("from ItemView order by name").list();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (views == null) {
            views = new ArrayList();
        }
        views.stream().filter(view -> view.getName().startsWith("[")).forEach(view -> {
            Const.log.info((Object)("Deleting quick-view '" + view.getName() + "' from database."));
            Db.delete(view);
        });
        try {
            views = session.createQuery("from ItemView where name not like '<%' order by name").list();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (views == null) {
            views = new ArrayList();
        }
        return views;
    }

    public static synchronized Set<ItemViewFilter> getViewFilters(int id) {
        List viewFilters = new ArrayList();
        try {
            viewFilters = session.createQuery("from ViewFilter where ID=" + id).list();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new HashSet<ItemViewFilter>(viewFilters);
    }

    private static String getWhereClause(ItemView view, boolean isGameTable) {
        StringBuilder whereClause = new StringBuilder("WHERE (");
        if (view.getFilterCount() == 0) {
            if (Databases.getCurrent().getPreferences().is("adult_filter")) {
                whereClause.append("CAST(").append(isGameTable ? "GAMES" : "MUSIC").append(".ADULT AS CHAR(5)) IN ").append(FALSE).append(" )");
                return whereClause.toString();
            }
            return "";
        }
        String andOr = view.getMode() == 0 ? " AND " : " OR ";
        ArrayList list = new ArrayList();
        view.getFilters().stream().filter(filter -> isGameTable && !filter.getGameTable().isEmpty() || !isGameTable && !filter.getMusicTable().isEmpty()).forEach(filter -> {
            boolean bl2 = list.add("(" + Db.GetFilter(filter, isGameTable) + ")");
        });
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            whereClause.append((String)iter.next());
            if (!iter.hasNext()) continue;
            whereClause.append(andOr);
        }
        if (Databases.getCurrent().getPreferences().is("adult_filter")) {
            whereClause.append(" AND ( CAST(").append(isGameTable ? "GAMES" : "MUSIC").append(".ADULT AS CHAR(5)) IN ").append(FALSE).append(" )");
        }
        whereClause.append(")");
        return whereClause.toString();
    }

    private static String GetFilter(ItemViewFilter filter, boolean isGameTable) {
        String GetFilter;
        block80: {
            block83: {
                String clauseData;
                String tableDotField;
                String fieldName;
                int operator;
                block89: {
                    block88: {
                        block87: {
                            block86: {
                                block84: {
                                    int clauseType;
                                    block82: {
                                        block81: {
                                            block79: {
                                                String tableName;
                                                GetFilter = "";
                                                clauseType = filter.getClauseType();
                                                operator = filter.getOperator();
                                                if (isGameTable) {
                                                    fieldName = filter.getGameField();
                                                    tableName = filter.getGameTable();
                                                } else {
                                                    fieldName = filter.getMusicField();
                                                    tableName = filter.getMusicTable();
                                                }
                                                tableDotField = String.valueOf(tableName) + "." + fieldName;
                                                clauseData = filter.getClauseData().toUpperCase();
                                                if (clauseData == null) {
                                                    clauseData = "";
                                                }
                                                if ("YEARS.YEAR".equals(tableDotField)) {
                                                    tableDotField = "YEARS.YE_ID";
                                                }
                                                if (clauseType != 0) break block79;
                                                GetFilter = operator == 0 ? ("GENRES".equals(tableName) ? "UPPER(" + tableDotField + ") LIKE '%" + Db.replaceWildcards(clauseData) + "%' OR UPPER(PGenres.ParentGenre) LIKE '%" + Db.replaceWildcards(clauseData) + "%'" : "UPPER(" + tableDotField + ") LIKE '%" + Db.replaceWildcards(clauseData) + "%'") : (operator == 1 ? ("GENRES".equals(tableName) ? "UPPER(" + tableDotField + ") NOT LIKE '%" + Db.replaceWildcards(clauseData) + "%' AND UPPER(PGenres.ParentGenre) NOT LIKE '%" + Db.replaceWildcards(clauseData) + "%'" : "UPPER(" + tableDotField + ") NOT LIKE '%" + Db.replaceWildcards(clauseData) + "%'") : (operator == 6 ? ("GENRES".equals(tableName) ? "UPPER(" + tableDotField + ") LIKE '" + Db.replaceWildcards(clauseData) + "%' OR UPPER(PGenres.ParentGenre) LIKE '" + Db.replaceWildcards(clauseData) + "%'" : "UPPER(" + tableDotField + ") LIKE '" + Db.replaceWildcards(clauseData) + "%'") : ("GENRES".equals(tableName) ? "UPPER(" + tableDotField + ") LIKE '%" + Db.replaceWildcards(clauseData) + "' OR UPPER(PGenres.ParentGenre) LIKE '%" + Db.replaceWildcards(clauseData) + "'" : "UPPER(" + tableDotField + ") LIKE '%" + Db.replaceWildcards(clauseData) + "'")));
                                                break block80;
                                            }
                                            if (clauseType != 2) break block81;
                                            GetFilter = operator == 0 ? String.valueOf(tableDotField) + " <> ''" : String.valueOf(tableDotField) + " = ''";
                                            break block80;
                                        }
                                        if (clauseType != 1) break block82;
                                        GetFilter = operator == 0 ? "CAST(" + tableDotField + " AS CHAR(5)) IN " + TRUE : "CAST(" + tableDotField + " AS CHAR(5)) IN " + FALSE;
                                        break block80;
                                    }
                                    if (clauseType != 3) break block83;
                                    if (operator != 0) break block84;
                                    switch (fieldName) {
                                        case "PLAYERSFROM": {
                                            GetFilter = "(" + tableDotField + " = " + clauseData + ") AND (Games.PlayersTo = " + clauseData + ")";
                                            break;
                                        }
                                        case "PLAYERSTO": {
                                            GetFilter = "(" + tableDotField + " = " + clauseData + ")";
                                            break;
                                        }
                                        case "SEQUEL": 
                                        case "PREQUEL": 
                                        case "RELATED": {
                                            if ("-1".equals(clauseData)) {
                                                GetFilter = String.valueOf(tableDotField) + " > 0";
                                                break;
                                            }
                                            GetFilter = String.valueOf(tableDotField) + " = 0";
                                            break;
                                        }
                                        case "PLAYERSSIM": 
                                        case "V_TRUEDRIVEEMU": 
                                        case "V_INCLUDEDDOCS": 
                                        case "FA": 
                                        case "SA": 
                                        case "FAV": 
                                        case "SFAV": 
                                        case "ADULT": 
                                        case "V_LOADINGSCREEN": 
                                        case "V_HIGHSCORESAVER": 
                                        case "CLASSIC": 
                                        case "EXTRAS": {
                                            if ("-1".equals(clauseData)) {
                                                GetFilter = "CAST(" + tableDotField + " AS CHAR(5)) IN " + TRUE;
                                                break;
                                            }
                                            GetFilter = "CAST(" + tableDotField + " AS CHAR(5)) IN " + FALSE;
                                            break;
                                        }
                                        default: {
                                            GetFilter = String.valueOf(tableDotField) + " = " + clauseData;
                                            break;
                                        }
                                    }
                                    break block80;
                                }
                                if (operator != 1) break block86;
                                GetFilter = "PLAYERSFROM".equals(fieldName) ? "NOT (" + tableDotField + " = " + clauseData + ") AND (Games.PlayersTo = " + clauseData + ")" : "NOT (" + tableDotField + " = " + clauseData + ")";
                                break block80;
                            }
                            if (operator != 3) break block87;
                            GetFilter = "(" + tableDotField + " > " + clauseData + ") AND (" + tableDotField + " < 9991)";
                            break block80;
                        }
                        if (operator != 2) break block88;
                        GetFilter = String.valueOf(tableDotField) + " < " + clauseData;
                        break block80;
                    }
                    if (operator != 4) break block89;
                    switch (fieldName) {
                        case "PLAYERSTO": 
                        case "V_Trainers": {
                            GetFilter = "(" + tableDotField + " < " + clauseData + ") AND (" + tableDotField + " > -1)";
                            break;
                        }
                        case "V_LENGTH": 
                        case "V_LENGTHTYPE": {
                            GetFilter = "(" + tableDotField + " < " + clauseData + ")";
                            break;
                        }
                        default: {
                            GetFilter = "(" + tableDotField + " < " + clauseData + ") AND (" + tableDotField + " > 0)";
                            break;
                        }
                    }
                    break block80;
                }
                if (operator != 5) break block80;
                switch (fieldName) {
                    case "PLAYERSFROM": {
                        GetFilter = "(" + tableDotField + " > " + clauseData + ") OR (PlayersTo > " + clauseData + ")";
                        break;
                    }
                    case "RATING": 
                    case "V_TRAINERS": {
                        GetFilter = String.valueOf(tableDotField) + " > " + clauseData;
                        break;
                    }
                    case "V_LENGTH": 
                    case "V_LENGTHTYPE": {
                        GetFilter = String.valueOf(tableDotField) + " > " + clauseData;
                    }
                }
                break block80;
            }
            GetFilter = String.valueOf(isGameTable ? "GAMES" : "MUSIC") + ".NAME <> ''";
        }
        return GetFilter;
    }

    private static String replaceWildcards(String withWildcards) {
        String withoutWildcards = withWildcards.replace("%", "_");
        withoutWildcards = withoutWildcards.replace("'", "_");
        return withoutWildcards;
    }

    public static synchronized void delete(Object object) {
        try {
            session.beginTransaction();
            session.delete(object);
            session.getTransaction().commit();
        }
        catch (EntityNotFoundException | HibernateException throwable) {}
    }

    public static synchronized void deleteAll(List list) {
        session.beginTransaction();
        for (Object object : list) {
            session.delete(object);
        }
        session.getTransaction().commit();
    }

    public static synchronized void saveOrUpdate(Object object) {
        Db.saveOrUpdate(object, true);
    }

    private static synchronized void saveOrUpdate(Object object, boolean transactional) {
        Extra extra;
        Item item;
        ItemView view;
        if (object instanceof ItemView && (view = (ItemView)object).getType() == 2) {
            return;
        }
        if (object instanceof Item && ((item = (Item)object).getName() == null || item.getName().isEmpty())) {
            return;
        }
        if (object instanceof Extra && (extra = (Extra)object).getGameId() < 1) {
            Db.delete(extra);
            return;
        }
        if (transactional) {
            session.beginTransaction();
            if (object instanceof Game) {
                Game game = (Game)object;
                game.setExtras(game.getExtras());
                if (game.getExtras().size() < Db.getExtraIdCountByGameId(game.getId())) {
                    Const.log.info((Object)("Removing orphaned extras for game '" + game.getName() + "'..."));
                    int[] extraIdsInGame = new int[game.getExtras().size()];
                    int i = 0;
                    while (i < extraIdsInGame.length) {
                        extraIdsInGame[i] = game.getExtras().get(i).getId();
                        ++i;
                    }
                    int[] extraIdsInDb = Db.getExtraIdsByGameId(game.getId());
                    int[] nArray = extraIdsInGame;
                    int n = extraIdsInGame.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int anExtraIdsInGame = nArray[n2];
                        int j = 0;
                        while (j < extraIdsInDb.length) {
                            if (anExtraIdsInGame == extraIdsInDb[j]) {
                                extraIdsInDb[j] = 0;
                            }
                            ++j;
                        }
                        ++n2;
                    }
                    nArray = extraIdsInDb;
                    n = extraIdsInDb.length;
                    n2 = 0;
                    while (n2 < n) {
                        int anExtraIdsInDb = nArray[n2];
                        if (anExtraIdsInDb > 0) {
                            Const.log.info((Object)".");
                            Db.deleteExtrasbyGameIdExtraId(game.getId(), anExtraIdsInDb);
                        }
                        ++n2;
                    }
                }
            }
        }
        session.saveOrUpdate(object);
        if (transactional) {
            session.getTransaction().commit();
        }
    }

    public static synchronized void saveOrUpdateAll(List list) {
        session.beginTransaction();
        list.forEach(object -> Db.saveOrUpdate(object, false));
        session.getTransaction().commit();
    }

    private static void reorganizeTable(Session session, String tableName) throws Exception {
        Const.log.info((Object)("  Reorganizing table '" + tableName.toUpperCase() + "'."));
        session.doWork(connection -> {
            CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?,?,?)");
            cs.setString(1, "APP");
            cs.setString(2, tableName.toUpperCase());
            cs.setShort(3, (short)0);
            cs.execute();
            cs.close();
        });
    }

    public static void reorganize() {
        try {
            Const.log.info((Object)"Starting reorganization of database.");
            Db.getSession().beginTransaction();
            for (String tablename : Table.getNames()) {
                Db.reorganizeTable(Db.getSession(), tablename);
            }
            Db.getSession().getTransaction().commit();
            Const.log.info((Object)"Reorganization of database successfully finished.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reorganizeExtras() {
        try {
            Const.log.info((Object)"Starting reorganization of database.");
            Db.getSession().beginTransaction();
            Db.reorganizeTable(Db.getSession(), Table.EXTRAS.getName());
            Db.getSession().getTransaction().commit();
            Const.log.info((Object)"Reorganization of database successfully finished.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

