/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.util.ExportFilter;
import com.healthmarketscience.jackcess.util.ExportUtil;
import com.healthmarketscience.jackcess.util.ImportFilter;
import com.healthmarketscience.jackcess.util.ImportUtil;
import com.healthmarketscience.jackcess.util.SimpleExportFilter;
import com.healthmarketscience.jackcess.util.SimpleImportFilter;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.List;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.db.Db;
import jgamebase.db.Table;
import jgamebase.db.Update;
import jgamebase.db.filter.DigitAsBoolean_ImportFilter;
import jgamebase.db.filter.TextNotNull_ImportFilter;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.tools.FileTools;
import org.hibernate.Session;

public class Export {
    public static void mdb2Csv(File mdbFile) {
        try {
            Export.mdb2Csv_clear(mdbFile);
            Export.mdb2Csv_export(mdbFile);
            Export.mdb2Csv_update(mdbFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mdb2Csv_clear(File mdbFile) {
        File dir = new File(mdbFile.getParentFile(), "Export");
        if (dir.exists()) {
            FileTools.deleteAll(dir);
        }
        dir.mkdirs();
    }

    public static void mdb2Csv_export(File mdbFile) throws IOException, FileNotFoundException {
        List<String[]> data;
        File dir = new File(mdbFile.getParentFile(), "Export");
        System.setProperty("com.healthmarketscience.jackcess.charset." + JetFormat.VERSION_3, "ISO-8859-1");
        new DatabaseBuilder().setReadOnly(true);
        Database mdb = DatabaseBuilder.open((File)mdbFile);
        ExportUtil.exportAll((Database)mdb, (File)dir, (String)"csv", (boolean)false, (String)",", (char)'\"', (ExportFilter)SimpleExportFilter.INSTANCE);
        File dataFile = new File(dir, String.valueOf(Table.VIEWFILTERS.getName()) + ".csv");
        Throwable throwable = null;
        Object var6_6 = null;
        try (CSVReader reader = new CSVReader((Reader)new FileReader(dataFile));){
            data = reader.readAll();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        data = Update.transformColumns(data, -1, 0, 1, 2, 3, 4, 5, 6, 7);
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(dataFile));
        writer.writeAll(data);
        writer.close();
    }

    public static double mdb2Csv_getVersion(File mdbFile) throws IOException, FileNotFoundException {
        List data;
        File dir = new File(mdbFile.getParentFile(), "Export");
        File dataFile = new File(dir, String.valueOf(Table.CONFIG.getName()) + ".csv");
        Throwable throwable = null;
        Object var5_6 = null;
        try (CSVReader reader = new CSVReader((Reader)new FileReader(dataFile));){
            data = reader.readAll();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        double version = 0.0;
        try {
            version = Double.valueOf(String.valueOf(((String[])data.get(0))[0]) + "." + ((String[])data.get(0))[1]);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return version;
    }

    public static void mdb2Csv_update(File mdbFile) throws IOException, FileNotFoundException {
        File dir = new File(mdbFile.getParentFile(), "Export");
        double version = Export.mdb2Csv_getVersion(mdbFile);
        if (version == 0.0) {
            Const.log.info((Object)"Warning: Could not read database version.");
            Gui.displayWarningDialog("Could not read database version.");
        } else if (version < 2.8) {
            Const.log.info((Object)("\nFound database in version " + version + ", but need version " + 2.8 + ": trying to update it...\n"));
            boolean errorOccured = Update.updateFrom(dir, version);
            if (errorOccured) {
                Const.log.info((Object)"ERROR: Could not update database to version 2.8.");
                Gui.displayErrorDialog("Could not update database to version 2.8.");
                JGameBase.quit();
            }
        }
    }

    public static void db2Csv(List<String> tableNames) throws Exception {
        File exportPath = Databases.getCurrent().getCleanExportPath();
        Const.log.info((Object)("Starting export of database: " + Databases.getCurrent().getName()));
        Session session = Db.getSession();
        for (String table : tableNames) {
            File csvFile = new File(exportPath, String.valueOf(table) + ".csv");
            if (csvFile.exists() && !csvFile.delete()) {
                String error = "Can't delete CSV file '" + csvFile + "'!";
                throw new Exception(error);
            }
            Const.log.info((Object)("  Exporting data from table '" + table.toUpperCase() + "' into csv file '" + csvFile + "'."));
            session.doWork(connection -> {
                CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE(?,?,?,?,?,?)");
                cs.setString(1, null);
                cs.setString(2, table.toUpperCase());
                cs.setString(3, csvFile.getAbsolutePath());
                cs.setString(4, null);
                cs.setString(5, null);
                cs.setString(6, null);
                cs.execute();
                cs.close();
            });
            Const.log.info((Object)("  Table '" + table + "': " + session.createSQLQuery("select count(*) from " + table).uniqueResult() + " rows exported.\n"));
        }
        Const.log.info((Object)"Export of database successfully finished.");
    }

    public static void db2Mdb() throws Exception {
        String name = Databases.getCurrent().getName();
        File mdbTemplateFile = new File(Const.GBDIR_RO, "Empty.mdb");
        File mdbFile = new File(Databases.getCurrent().getCleanExportPath(), String.valueOf(name) + ".mdb");
        Const.log.info((Object)("Starting export of database '" + name + "' to '" + mdbFile + "'"));
        FileTools.copyFile(mdbTemplateFile, mdbFile);
        new DatabaseBuilder().setReadOnly(false).setAutoSync(false);
        Database mdbDatabase = DatabaseBuilder.open((File)mdbFile);
        mdbDatabase.setAllowAutoNumberInsert(Boolean.valueOf(true));
        for (Table table : Table.getValuesAsList()) {
            Object filter;
            ResultSet rs;
            Const.log.info((Object)("  Exporting table '" + table.getName() + "'."));
            switch (table) {
                case VIEWFILTERS: {
                    rs = (ResultSet)Db.getSession().doReturningWork(connection -> connection.createStatement().executeQuery("SELECT VW_ID, FIELDTABLE, FIELDNAME, OPERATOR, CLAUSETYPE, CLAUSEDATA, MUSICFIELDNAME, MUSICFIELDTABLE FROM " + table.getName()));
                    break;
                }
                default: {
                    rs = (ResultSet)Db.getSession().doReturningWork(connection -> connection.createStatement().executeQuery("SELECT * FROM " + table.getName()));
                }
            }
            switch (table) {
                case PGENRES: {
                    filter = new TextNotNull_ImportFilter("Parent-Genre", 1);
                    break;
                }
                case MUSIC: {
                    filter = new DigitAsBoolean_ImportFilter(4, 5, 6);
                    break;
                }
                case GAMES: {
                    filter = new DigitAsBoolean_ImportFilter(17, 18, 19, 22, 23, 30, 31);
                    break;
                }
                case EXTRAS: {
                    filter = new DigitAsBoolean_ImportFilter(6);
                    break;
                }
                default: {
                    filter = SimpleImportFilter.INSTANCE;
                }
            }
            ImportUtil.importResultSet((ResultSet)rs, (Database)mdbDatabase, (String)table.getName(), (ImportFilter)filter, (boolean)true);
        }
        mdbDatabase.close();
        Const.log.info((Object)"Export of database successfully finished.");
    }
}

