/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SortOrder;
import jgamebase.db.Db;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemViewColumn;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.gui.ColumnHeader;

public class ItemView
implements Cloneable,
Comparable<ItemView> {
    private static final long serialVersionUID = 5846102476547722542L;
    public static final int MODE_AND = 0;
    public static final int MODE_OR = 1;
    public static final int INCLUDE_GAMES = 0;
    public static final int INCLUDE_MUSIC = 1;
    public static final int INCLUDE_BOTH = 2;
    public static final int INCLUDE_NOTHING = 3;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_SYSTEM = 1;
    public static final int TYPE_QUICK = 2;
    private int id;
    private int mode;
    private String name;
    private int filterCount;
    private int include;
    private int sortColumn;
    private int _sortOrder;
    private String selectedItem;
    private String extraColumns;
    private int ordinal;
    private Set<ItemViewFilter> filters = new HashSet<ItemViewFilter>();
    private int type;
    protected List<Item> data = null;
    private Set<ItemViewColumn> columns = new HashSet<ItemViewColumn>();

    public ItemView() {
        this.setColumnVisibility(Arrays.asList(ColumnHeader.NAME.getName(), ColumnHeader.YEAR.getName(), ColumnHeader.PUBLISHER.getName(), ColumnHeader.GENRE.getName()));
    }

    private ItemViewColumn[] getColumnsAsArray() {
        ItemViewColumn[] columnsArray = new ItemViewColumn[ColumnHeader.size()];
        this.columns.forEach(column -> {
            ItemViewColumn itemViewColumn = itemViewColumnArray[column.getModelIndex()] = column;
        });
        int i = 0;
        while (i < columnsArray.length) {
            if (columnsArray[i] == null) {
                columnsArray[i] = new ItemViewColumn(this.getId(), i);
            }
            ++i;
        }
        return columnsArray;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.clearCache();
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    private void setFilterCount(int filterCount) {
        this.filterCount = filterCount;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public void setInclude(int include) {
        if (this.include != include) {
            this.clearCache();
        }
        this.include = include;
    }

    public int getInclude() {
        return this.include;
    }

    private void setListViewType(int listViewType) {
    }

    private int getListViewType() {
        return 3;
    }

    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.set_sortOrder(sortOrder.ordinal());
    }

    private void set_sortOrder(int _sortOrder) {
        this._sortOrder = _sortOrder;
    }

    public SortOrder getSortOrder() {
        return SortOrder.values()[this.get_sortOrder()];
    }

    private int get_sortOrder() {
        return this._sortOrder;
    }

    public void setExtraColumns(String extraColumns) {
        this.extraColumns = extraColumns;
    }

    public String getExtraColumns() {
        return this.extraColumns == null ? "" : this.extraColumns;
    }

    private void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    private int getOrdinal() {
        return this.ordinal;
    }

    public Set<ItemViewFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Set<ItemViewFilter> filters) {
        if (filters != null) {
            this.filters = filters;
            this.setFilterCount(filters.size());
            filters.forEach(filter -> filter.setViewId(this.getId()));
        } else {
            this.filters = new HashSet<ItemViewFilter>();
            this.setFilterCount(0);
        }
        this.clearCache();
    }

    public void addFilter(ItemViewFilter filter) {
        filter.setViewId(this.getId());
        Set<ItemViewFilter> filters = this.getFilters();
        filters.add(filter);
        this.setFilters(filters);
    }

    private Set<ItemViewColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Set<ItemViewColumn> columns) {
        this.columns = columns;
        columns.forEach(column -> column.setViewId(this.getId()));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setColumnVisibility(List<String> columnNames) {
        ItemViewColumn[] columnsArray;
        ItemViewColumn[] itemViewColumnArray = columnsArray = this.getColumnsAsArray();
        int n = columnsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemViewColumn element = itemViewColumnArray[n2];
            element.setViewIndex(-1);
            ++n2;
        }
        int viewIndex = 0;
        for (String name : columnNames) {
            int modelIndex = this.getModelIndex(name);
            ItemViewColumn column = columnsArray[modelIndex];
            column.setViewIndex(viewIndex);
            ++viewIndex;
        }
        this.columns = new HashSet<ItemViewColumn>(Arrays.asList(columnsArray));
    }

    private int getModelIndex(String name) {
        int modelIndex = -1;
        int i = 0;
        while (i < ColumnHeader.size()) {
            if (name.equals(ColumnHeader.nameAt(i))) {
                modelIndex = i;
            }
            ++i;
        }
        return modelIndex;
    }

    public List<String> getColumnVisibility() {
        ArrayList<String> columnNames = new ArrayList<String>();
        ItemViewColumn[] columnsArray = this.getColumnsAsArray();
        int viewIndex = 0;
        while (viewIndex < columnsArray.length) {
            int i = 0;
            while (i < columnsArray.length) {
                ItemViewColumn column = columnsArray[i];
                if (column.getViewIndex() == viewIndex) {
                    columnNames.add(ColumnHeader.nameAt(i));
                }
                ++i;
            }
            ++viewIndex;
        }
        return columnNames;
    }

    public List<Integer> getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        ItemViewColumn[] columnsArray = this.getColumnsAsArray();
        int viewIndex = 0;
        while (viewIndex < columnsArray.length) {
            ItemViewColumn[] itemViewColumnArray = columnsArray;
            int n = columnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemViewColumn column = itemViewColumnArray[n2];
                if (column.getViewIndex() == viewIndex) {
                    columnWidth.add(column.getWidth());
                }
                ++n2;
            }
            ++viewIndex;
        }
        return columnWidth;
    }

    public void setColumnWidth(List<Integer> columnWidth) {
        ItemViewColumn[] columnsArray = this.getColumnsAsArray();
        int viewIndex = 0;
        for (String name : this.getColumnVisibility()) {
            int modelIndex = this.getModelIndex(name);
            ItemViewColumn column = columnsArray[modelIndex];
            column.setWidth(columnWidth.get(viewIndex));
            ++viewIndex;
        }
        this.columns = new HashSet<ItemViewColumn>(Arrays.asList(columnsArray));
    }

    public String toString() {
        String name = this.getName();
        if (this.data != null) {
            name = String.valueOf(name) + " (" + this.data.size() + ")";
        }
        return name;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public synchronized boolean isLoaded() {
        return this.data != null;
    }

    public synchronized List<Item> getData() {
        if (!this.isLoaded()) {
            this.data = Db.getItems(this);
        }
        return this.data;
    }

    public synchronized void clearCache() {
        this.data = null;
    }

    public String getSelectedItem() {
        return this.selectedItem == null ? "" : this.selectedItem;
    }

    public void setSelectedItem(String selectedItem) {
        this.selectedItem = selectedItem == null ? "" : selectedItem;
    }

    @Override
    public int compareTo(ItemView other) {
        return this.getName().compareTo(other.getName());
    }
}

