/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jgamebase.db.Db;
import jgamebase.db.model.Extra;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemView;

public class ItemViewDuplicateUrls
extends ItemView {
    @Override
    public synchronized List<Item> getData() {
        if (!this.isLoaded()) {
            this.data = new ArrayList();
            List<Extra> allExtras = Db.getExtras();
            CopyOnWriteArrayList<Extra> urlExtras = new CopyOnWriteArrayList<Extra>();
            for (Extra extra : allExtras) {
                if (!extra.isUrl() || extra.getFilename().toLowerCase().startsWith("http://www.gamebase64.com") || urlExtras.contains(extra)) continue;
                urlExtras.add(extra);
            }
            for (Extra extra : urlExtras) {
                Game game = Db.getGameById(extra.getGameId());
                if (this.data.contains(game)) continue;
                this.data.add(game);
            }
        }
        return this.data;
    }

    private boolean containsShorter(String s1, String s2) {
        int l2;
        if (s1 == null || s2 == null || s1.isEmpty() || s2.isEmpty()) {
            return false;
        }
        int l1 = s1.length();
        if (l1 == (l2 = s2.length())) {
            return s1.equalsIgnoreCase(s2);
        }
        if (l1 > l2) {
            return s1.toLowerCase().contains(s2.toLowerCase());
        }
        return s2.toLowerCase().contains(s1.toLowerCase());
    }
}

