/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.model;

import java.util.ArrayList;
import java.util.List;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Selection;

public class ItemViewFilter
implements Cloneable {
    private static final long serialVersionUID = -5314888349437255940L;
    public static final int CLAUSETYPE_CONTAINSTEXT = 0;
    public static final int CLAUSETYPE_EXISTS = 1;
    public static final int CLAUSETYPE_FILLED = 2;
    public static final int CLAUSETYPE_DBFIELD = 3;
    public static final int CLAUSETYPE_NO = 4;
    public static final int OPERATOR_EQUAL = 0;
    public static final int OPERATOR_NOTEQUAL = 1;
    public static final int OPERATOR_BEFORE = 2;
    public static final int OPERATOR_AFTER = 3;
    public static final int OPERATOR_LESSTHAN = 4;
    public static final int OPERATOR_MORETHAN = 5;
    public static final int OPERATOR_STARTSWITH = 6;
    public static final int OPERATOR_ENDSWITH = 7;
    public static final int SELECTOR_YESNO = 0;
    public static final int SELECTOR_TEXT = 1;
    public static final int SELECTOR_DB = 2;
    public static final int SELECTOR_NONE = 3;
    public static final int SELECTOR_OTHER = 4;
    private int id;
    private int viewId;
    private String gameTable;
    private String gameField;
    private int operator;
    private int clauseType;
    private String clauseData;
    private String musicTable;
    private String musicField;
    private String name;
    private int selector;

    public ItemViewFilter(int clauseType, int operator, String fieldTable, String fieldName, String musicFieldTable, String musicFieldName, String clauseData) {
        this.clauseType = clauseType;
        this.operator = operator;
        this.gameTable = fieldTable;
        this.gameField = fieldName;
        this.musicTable = musicFieldTable;
        this.musicField = musicFieldName;
        this.clauseData = clauseData;
    }

    public ItemViewFilter(int clauseType, int operator, String gameFieldTable, String gameFieldName, String musicFieldTable, String musicFieldName, int clauseData) {
        this(clauseType, operator, gameFieldTable, gameFieldName, musicFieldTable, musicFieldName, Integer.toString(clauseData));
    }

    public ItemViewFilter(String name, int selector, int clauseType, int operator, String gameFieldTable, String gameFieldName, String musicFieldTable, String musicFieldName) {
        this(clauseType, operator, gameFieldTable, gameFieldName, musicFieldTable, musicFieldName, "");
        this.name = name;
        this.selector = selector;
    }

    private ItemViewFilter() {
    }

    private int getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    public void setViewId(int viewId) {
        this.viewId = viewId;
    }

    private int getViewId() {
        return this.viewId;
    }

    public String getGameTable() {
        return this.gameTable.toUpperCase();
    }

    public void setGameTable(String fieldTable) {
        this.gameTable = fieldTable.toUpperCase();
    }

    public String getGameField() {
        return this.gameField.toUpperCase();
    }

    public void setGameField(String fieldName) {
        this.gameField = fieldName.toUpperCase();
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getClauseType() {
        return this.clauseType;
    }

    public void setClauseType(int clauseType) {
        this.clauseType = clauseType;
    }

    public String getClauseData() {
        return this.clauseData;
    }

    public void setClauseData(String clauseData) {
        this.clauseData = clauseData;
    }

    public String getMusicTable() {
        return this.musicTable.toUpperCase();
    }

    public void setMusicTable(String musicFieldTable) {
        this.musicTable = musicFieldTable != null ? musicFieldTable.toUpperCase() : "";
    }

    public String getMusicField() {
        return this.musicField.toUpperCase();
    }

    public void setMusicField(String musicFieldName) {
        this.musicField = musicFieldName != null ? musicFieldName.toUpperCase() : "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setSelector(int selector) {
        this.selector = selector;
    }

    public int getSelector() {
        return this.selector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Selection> getSelections() {
        List<Selection> list;
        block63: {
            list = new ArrayList<Selection>();
            block0 : switch (this.getSelector()) {
                case 0: {
                    list.add(new Selection("Yes", "-1"));
                    list.add(new Selection("No", "0"));
                    return list;
                }
                case 2: {
                    return Db.getSelections(this);
                }
                case 4: {
                    String field = this.getGameField();
                    int operator = this.getOperator();
                    switch (field) {
                        case "YE_ID": {
                            list = Selection.createSelections(Const.FORDISPLAY_YEAR);
                            break block0;
                        }
                        case "YEARVAL": 
                        case "YEAR": {
                            if (operator == 3) {
                                int i = 10;
                                while (i < 140) {
                                    list.add(new Selection(Const.FORDISPLAY_YEAR[i], i));
                                    ++i;
                                }
                            } else {
                                int i = 11;
                                while (i <= 140) {
                                    list.add(new Selection(Const.FORDISPLAY_YEAR[i], i));
                                    ++i;
                                }
                            }
                            break block63;
                        }
                        case "GE_ID": {
                            list = Db.getGenreSelections();
                            break block0;
                        }
                        case "PLAYERSFROM": {
                            if (operator == 0 || operator == 1) {
                                list.add(new Selection("(Unknown)", -1));
                                list.addAll(Selection.createSelections(0, 10));
                                break block0;
                            }
                            if (operator != 5) return list;
                            list = Selection.createSelections(0, 10);
                            break block0;
                        }
                        case "PLAYERSTO": {
                            list = Selection.createSelections(1, 10);
                            break block0;
                        }
                        case "V_TRAINERS": {
                            if (operator == 0 || operator == 1) {
                                list.add(new Selection("(Unknown)", -1));
                                list.addAll(Selection.createSelections(0, 20));
                                break block0;
                            }
                            if (operator == 5) {
                                list = Selection.createSelections(0, 20);
                                break block0;
                            }
                            if (operator != 4) return list;
                            list = Selection.createSelections(1, 21);
                            break block0;
                        }
                        case "V_LENGTH": {
                            list = Selection.createSelections(0, 1000);
                            break block0;
                        }
                        case "V_LENGTHTYPE": {
                            list = Selection.createSelections(Const.FORDISPLAY_LENGTHTYPE);
                            break block0;
                        }
                        case "RATING": {
                            if (operator == 0 || operator == 1) {
                                int i = 0;
                                while (i <= 5) {
                                    list.add(new Selection(Const.FORDISPLAY_RATING[i], i));
                                    ++i;
                                }
                            } else if (operator == 5) {
                                int i = 1;
                                while (i <= 4) {
                                    list.add(new Selection(Const.FORDISPLAY_RATING[i], i));
                                    ++i;
                                }
                            } else {
                                if (operator != 4) return list;
                                int i = 2;
                                while (i <= 5) {
                                    list.add(new Selection(Const.FORDISPLAY_RATING[i], i));
                                    ++i;
                                }
                            }
                            break block63;
                        }
                        case "CONTROL": {
                            list = Selection.createSelections(Const.FORDISPLAY_CONTROL);
                            break block0;
                        }
                        case "V_PALNTSC": {
                            list = Selection.createSelections(Const.FORDISPLAY_PALNTSC);
                            break block0;
                        }
                        case "VERSION": {
                            if (operator == 0 || operator == 1) {
                                list = Selection.createSelections(0, 999);
                                break block0;
                            }
                            if (operator == 5) {
                                list = Selection.createSelections(0, 998);
                                break block0;
                            }
                            if (operator != 4) return list;
                            list = Selection.createSelections(1, 999);
                        }
                    }
                }
            }
        }
        return list;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void print() {
        Const.log.info((Object)(String.valueOf(this.id) + ", " + this.viewId + ", " + this.gameTable + ", " + this.gameField + ", " + this.operator + ", " + this.clauseType + ", " + this.clauseData + ", " + this.musicTable + ", " + this.musicField));
    }
}

