/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jgamebase.db.Db;
import jgamebase.db.model.Game;

public class ClearGameLinkDialog
extends JDialog {
    private static final long serialVersionUID = -7723623461226397832L;
    Game game;
    Game linkGame;
    private JCheckBox bidirectionalLink;
    private JRadioButton prequel;
    private JRadioButton related;
    private JRadioButton sequel;

    public ClearGameLinkDialog(Game game) {
        this.game = game;
        this.initComponents();
        this.prequel.setEnabled(game.hasPrequel());
        this.sequel.setEnabled(game.hasSequel());
        this.related.setEnabled(game.hasRelated());
        if (this.prequel.isEnabled()) {
            this.prequel.setSelected(true);
        } else if (this.sequel.isEnabled()) {
            this.sequel.setSelected(true);
        } else {
            this.related.setSelected(true);
        }
        this.linkTypeChanged();
        this.setSize(320, 160);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        JPanel emulatorsPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        this.prequel = new JRadioButton();
        this.sequel = new JRadioButton();
        this.related = new JRadioButton();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.bidirectionalLink = new JCheckBox();
        this.setTitle("Clear Game Link");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ClearGameLinkDialog.this.exitFormWindowClosing(evt);
            }
        });
        emulatorsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        emulatorsPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder("Clear which link?"));
        mainPanel.setLayout(new GridLayout(3, 1));
        buttonGroup1.add(this.prequel);
        this.prequel.setMnemonic('P');
        this.prequel.setText("Precursor");
        this.prequel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearGameLinkDialog.this.linkTypeChanged_ActionPerformed(evt);
            }
        });
        mainPanel.add(this.prequel);
        buttonGroup1.add(this.sequel);
        this.sequel.setMnemonic('S');
        this.sequel.setText("Sequel");
        this.sequel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearGameLinkDialog.this.linkTypeChanged_ActionPerformed(evt);
            }
        });
        mainPanel.add(this.sequel);
        buttonGroup1.add(this.related);
        this.related.setMnemonic('R');
        this.related.setText("Related Game");
        this.related.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearGameLinkDialog.this.linkTypeChanged_ActionPerformed(evt);
            }
        });
        mainPanel.add(this.related);
        emulatorsPanel.add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)emulatorsPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearGameLinkDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearGameLinkDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "East");
        this.bidirectionalLink.setMnemonic('M');
        this.bidirectionalLink.setText("Clear bidirectional Link");
        OkCancelPanel.add((Component)this.bidirectionalLink, "West");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void linkTypeChanged_ActionPerformed(ActionEvent evt) {
        this.linkTypeChanged();
    }

    private void linkTypeChanged() {
        this.linkGame = null;
        this.bidirectionalLink.setSelected(false);
        if (this.prequel.isSelected() && this.game.hasPrequel()) {
            this.linkGame = Db.getGameById(this.game.getPrequelId());
            this.bidirectionalLink.setEnabled(this.linkGame.getSequelId() == this.game.getId());
        } else if (this.sequel.isSelected() && this.game.hasSequel()) {
            this.linkGame = Db.getGameById(this.game.getSequelId());
            this.bidirectionalLink.setEnabled(this.linkGame.getPrequelId() == this.game.getId());
        } else if (this.game.hasRelated()) {
            this.linkGame = Db.getGameById(this.game.getRelatedId());
            this.bidirectionalLink.setEnabled(this.linkGame.getRelatedId() == this.game.getId());
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        if (this.prequel.isSelected()) {
            this.game.setPrequelId(0);
            if (this.bidirectionalLink.isSelected() && this.linkGame != null) {
                this.linkGame.setSequelId(0);
            }
        } else if (this.sequel.isSelected()) {
            this.game.setSequelId(0);
            if (this.bidirectionalLink.isSelected() && this.linkGame != null) {
                this.linkGame.setPrequelId(0);
            }
        } else {
            this.game.setRelatedId(0);
            if (this.bidirectionalLink.isSelected() && this.linkGame != null) {
                this.linkGame.setRelatedId(0);
            }
        }
        this.dispose();
        Db.saveOrUpdate(this.game);
        if (this.linkGame != null) {
            Db.saveOrUpdate(this.linkGame);
        }
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

