/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.util.ArrayList;
import java.util.List;

public enum ColumnHeader {
    NAME("Name"),
    PUBLISHER("Publisher"),
    YEAR("Year"),
    PROGRAMMER("Programmer"),
    MUSICIAN("Musician"),
    GENRE("Genre"),
    PLAYERS("# Players"),
    CONTROL("Control"),
    LANGUAGE("Language"),
    COMMENT("Comment"),
    FILENAME("Filename"),
    CRACKER("Cracker"),
    TRAINER("# Trainers"),
    LENGTH("Length"),
    TRUE_DRIVE("True Drive"),
    SAVES_HIGHSCORE("Saves Highscore"),
    PAL_NTSC("PAL/NTSC"),
    INCLUDES_DOCS("Docs"),
    LOADINGSCREEN("Loading Screen"),
    VERSION_COMMENT("Version Comment"),
    MUSIC_FILENAME("Music Filename"),
    HIGHSCORE("Highscore"),
    DIFFICULTY("Difficulty"),
    TIMES_PLAYED("Times Played"),
    LAST_PLAYED("Last Played"),
    RATING("Rating");

    private final String name;

    public static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        ColumnHeader[] columnHeaderArray = ColumnHeader.values();
        int n = columnHeaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnHeader header = columnHeaderArray[n2];
            names.add(header.getName());
            ++n2;
        }
        return names;
    }

    public static int size() {
        return ColumnHeader.values().length;
    }

    public static ColumnHeader valueAt(int index) {
        return ColumnHeader.values()[index];
    }

    public static String nameAt(int index) {
        return ColumnHeader.values()[index].getName();
    }

    public static int indexOf(ColumnHeader header) {
        return header.ordinal();
    }

    public static int indexOf(String name) {
        int index = 0;
        ColumnHeader[] columnHeaderArray = ColumnHeader.values();
        int n = columnHeaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnHeader header = columnHeaderArray[n2];
            if (name.equals(header.getName())) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private ColumnHeader(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

