/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jgamebase.Const;
import jgamebase.db.model.Extra;
import jgamebase.gui.ExtrasChooserDialog;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListMethods;
import jgamebase.gui.ListListModel;

public class ExtrasDialog
extends JDialog {
    private static final long serialVersionUID = 3242124579733208443L;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    String gameName;
    List<Extra> extras;
    JButton extraAddButton;
    JButton extraDownButton;
    JButton extraRemoveButton;
    JButton extraUpButton;
    protected JList extrasList;

    public ExtrasDialog(List<Extra> extras, String gameName) {
        this.initComponents();
        this.extras = extras;
        this.gameName = gameName;
        this.setTitle("Extras for " + gameName);
        this.extrasList.setModel(new ListListModel(extras));
        if (this.extrasList.getModel().getSize() > 0) {
            this.extrasList.setSelectedIndex(0);
        }
        this.setSize(Gui.scaleByFontSize(new Dimension(480, 300)));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel extraPaths = new JPanel();
        JPanel extraPathsPanel = new JPanel();
        this.extraAddButton = new JButton();
        this.extraRemoveButton = new JButton();
        this.extraUpButton = new JButton();
        this.extraDownButton = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.extrasList = new JList();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Paths");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExtrasDialog.this.exitFormWindowClosing(evt);
            }
        });
        extraPaths.setBorder(BorderFactory.createTitledBorder("Extras"));
        extraPaths.setLayout(new BorderLayout());
        extraPathsPanel.setLayout(new FlowLayout(0));
        this.extraAddButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        this.extraAddButton.setBorder(null);
        this.extraAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtrasDialog.this.extraAddActionPerformed(evt);
            }
        });
        extraPathsPanel.add(this.extraAddButton);
        this.extraRemoveButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        this.extraRemoveButton.setBorder(null);
        this.extraRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtrasDialog.this.extraRemoveActionPerformed(evt);
            }
        });
        extraPathsPanel.add(this.extraRemoveButton);
        this.extraUpButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        this.extraUpButton.setBorder(null);
        this.extraUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtrasDialog.this.extraUpActionPerformed(evt);
            }
        });
        extraPathsPanel.add(this.extraUpButton);
        this.extraDownButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        this.extraDownButton.setBorder(null);
        this.extraDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtrasDialog.this.extraDownActionPerformed(evt);
            }
        });
        extraPathsPanel.add(this.extraDownButton);
        extraPaths.add((Component)extraPathsPanel, "North");
        this.extrasList.setSelectionMode(0);
        this.extrasList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExtrasDialog.this.extrasListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(this.extrasList);
        extraPaths.add((Component)jScrollPane1, "Center");
        this.getContentPane().add((Component)extraPaths, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtrasDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtrasDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void extrasListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.editExtra(this.extrasList);
        }
    }

    private void extraDownActionPerformed(ActionEvent evt) {
        this.extras = ListListMethods.moveSelectedDown(this.extrasList);
    }

    private void extraUpActionPerformed(ActionEvent evt) {
        this.extras = ListListMethods.moveSelectedUp(this.extrasList);
    }

    private void extraRemoveActionPerformed(ActionEvent evt) {
        this.extras = ListListMethods.removeSelected(this.extrasList);
    }

    private void extraAddActionPerformed(ActionEvent evt) {
        this.addExtra(this.extrasList);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.setVisible(false);
    }

    public List<Extra> getExtras() {
        int i = 0;
        for (Extra extra : this.extras) {
            extra.setDisplayOrder(i++);
        }
        return this.extras;
    }

    private void editExtra(JList list) {
        Extra extra;
        ExtrasChooserDialog dialog;
        int row = list.getSelectedIndex();
        if (row >= 0 && row < list.getModel().getSize() && (dialog = new ExtrasChooserDialog(this.gameName, extra = (Extra)list.getSelectedValue())).getCloseAction() == Const.CloseAction.OK) {
            extra.setFilename(dialog.getExtraFilename());
            extra.setName(dialog.getExtraName());
        }
    }

    private void addExtra(JList list) {
        Extra extra = new Extra();
        extra.setName("New Extra");
        ExtrasChooserDialog dialog = new ExtrasChooserDialog(this.gameName, extra);
        if (dialog.getCloseAction() == Const.CloseAction.OK) {
            extra.setFilename(dialog.getExtraFilename());
            extra.setName(dialog.getExtraName());
            this.extras.add(extra);
            ((ListListModel)list.getModel()).addElement(extra);
        }
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }
}

