/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import jgamebase.JGameBase;
import jgamebase.db.Db;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemView;
import jgamebase.db.model.Music;
import jgamebase.gui.ColumnHeader;
import jgamebase.gui.sortwrapper.SortWrapper_Highscore;
import jgamebase.gui.sortwrapper.SortWrapper_LastPlayed;
import jgamebase.gui.sortwrapper.SortWrapper_Length;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ItemTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8744154898299054717L;
    private static Game dummyGame = new Game();
    private ItemView currentView;

    public ItemTableModel(ItemView view) {
        this.setView(view);
    }

    public synchronized void saveOrUpdateView() {
        Db.saveOrUpdateAll(this.currentView.getData());
    }

    public synchronized void setView(ItemView newView) {
        if (!JGameBase.isGuiInitialized() || newView == null || newView.getName() == null || newView.getName().isEmpty() || newView.equals(this.currentView)) {
            return;
        }
        JGameBase.getGui().setCursor(Cursor.getPredefinedCursor(3));
        Music.setAllowReadingInfoFromFile(false);
        this.saveGuiParametersToView(this.currentView);
        this.currentView = newView;
        this.fireTableDataChanged();
        this.updateEditRemoveViewEnabled();
        this.loadGuiParametersFromView(newView);
        Music.setAllowReadingInfoFromFile(true);
        JGameBase.getGui().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected synchronized void saveGuiParametersToView(ItemView view) {
        if (!JGameBase.isGuiInitialized() || view == null || view.getName() == null || view.getName().isEmpty()) {
            return;
        }
        view.setColumnVisibility(JGameBase.getGui().getColumnVisibility());
        view.setColumnWidth(JGameBase.getGui().getColumnWidth());
        Item item = JGameBase.getGui().getSelectedItem();
        if (item != null) {
            view.setSelectedItem(item.getStringId());
        } else {
            view.setSelectedItem("");
        }
        List<RowSorter.SortKey> sortKeys = JGameBase.getGui().itemTable.getRowSorter().getSortKeys();
        if (sortKeys.size() > 0) {
            RowSorter.SortKey sortKey = sortKeys.get(0);
            view.setSortColumn(sortKey.getColumn());
            view.setSortOrder(sortKey.getSortOrder());
        }
    }

    private synchronized void loadGuiParametersFromView(ItemView view) {
        if (!JGameBase.isGuiInitialized() || view == null || view.getName() == null || view.getName().isEmpty()) {
            return;
        }
        this.setColumnVisibility(view.getColumnVisibility());
        this.setColumnWidth(view.getColumnWidth());
        JGameBase.getGui().selectItem(view.getSelectedItem(), false);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(view.getSortColumn(), view.getSortOrder()));
        JGameBase.getGui().itemTable.getRowSorter().setSortKeys(sortKeys);
    }

    public void setColumnVisibility(List<String> columnsToShow) {
        JXTable itemTable = JGameBase.getGui().itemTable;
        if (columnsToShow.size() == 0) {
            columnsToShow = new ArrayList<String>(Arrays.asList(ColumnHeader.NAME.getName(), ColumnHeader.YEAR.getName(), ColumnHeader.PUBLISHER.getName()));
        }
        int i = 0;
        while (i < ColumnHeader.size()) {
            TableColumnExt column2 = itemTable.getColumnExt((Object)ColumnHeader.nameAt(i));
            column2.setVisible(false);
            ++i;
        }
        columnsToShow.stream().map(arg_0 -> ((JXTable)itemTable).getColumnExt(arg_0)).forEach(column -> column.setVisible(true));
        itemTable.setColumnSequence(columnsToShow.toArray());
        itemTable.setHorizontalScrollEnabled(columnsToShow.size() > 5);
    }

    public void setColumnWidth(List<Integer> columnsToShow) {
        JXTable itemTable = JGameBase.getGui().itemTable;
        int i = 0;
        while (i < columnsToShow.size()) {
            TableColumnExt column = itemTable.getColumnExt(i);
            int width = columnsToShow.get(i);
            if (width != -1) {
                column.setWidth(width);
            } else {
                itemTable.packColumn(i, 0);
            }
            ++i;
        }
    }

    public synchronized void reloadView() {
        this.currentView.clearCache();
        if (JGameBase.isGuiInitialized()) {
            JGameBase.getGui().setCursor(Cursor.getPredefinedCursor(3));
            this.updateEditRemoveViewEnabled();
        }
        this.fireTableDataChanged();
        if (JGameBase.isGuiInitialized()) {
            JGameBase.getGui().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void updateEditRemoveViewEnabled() {
        boolean b = this.currentView.getType() == 0;
        JGameBase.getGui().viewPopupMenu_EditView.setEnabled(b);
        JGameBase.getGui().viewPopupMenu_RemoveView.setEnabled(b);
        JGameBase.getGui().viewMenu_EditView.setEnabled(b);
        JGameBase.getGui().viewMenu_RemoveView.setEnabled(b);
    }

    public void setSelectedRow(int row) {
        if (JGameBase.isGuiInitialized() && row >= 0 && row < this.getRowCount()) {
            try {
                JXTable itemTable = JGameBase.getGui().itemTable;
                int viewRow = itemTable.convertRowIndexToView(row);
                itemTable.setRowSelectionInterval(viewRow, viewRow);
                itemTable.scrollRectToVisible(itemTable.getCellRect(viewRow, 0, false));
            }
            catch (Exception exception) {}
        }
    }

    public int getSelectedRow() {
        if (!JGameBase.isGuiInitialized()) {
            return 0;
        }
        int selectedRow = JGameBase.getGui().itemTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < JGameBase.getGui().itemTable.getRowCount()) {
            return JGameBase.getGui().itemTable.convertRowIndexToModel(selectedRow);
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return ColumnHeader.size();
    }

    @Override
    public int getRowCount() {
        if (this.currentView != null) {
            return this.currentView.getData().size();
        }
        return 0;
    }

    @Override
    public String getColumnName(int col) {
        return ColumnHeader.nameAt(col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        ColumnHeader header = ColumnHeader.valueAt(col);
        Item item = this.getItem(row);
        if (header == ColumnHeader.NAME) {
            return item;
        }
        if (item instanceof Game) {
            return this.getValues((Game)item, col);
        }
        if (item instanceof Music) {
            return this.getValues((Music)item, col);
        }
        return "";
    }

    private Object getValues(Game game, int col) {
        ColumnHeader header = ColumnHeader.valueAt(col);
        try {
            switch (header) {
                case PUBLISHER: {
                    return game.getPublisher().getName();
                }
                case YEAR: {
                    return game.getYear().getName();
                }
                case PROGRAMMER: {
                    return game.getProgrammer().getName();
                }
                case MUSICIAN: {
                    return game.getMusician().getName();
                }
                case GENRE: {
                    return game.getGenreForDisplay();
                }
                case PLAYERS: {
                    return game.getPlayersForDisplay();
                }
                case CONTROL: {
                    return game.getControlForDisplay();
                }
                case LANGUAGE: {
                    return game.getLanguage().getName();
                }
                case COMMENT: {
                    return game.getComment();
                }
                case FILENAME: {
                    return game.getFilename();
                }
                case CRACKER: {
                    return game.getCracker().getName();
                }
                case TRAINER: {
                    return game.getTrainerForDisplay();
                }
                case LENGTH: {
                    return new SortWrapper_Length(game.getLengthForDisplay());
                }
                case TRUE_DRIVE: {
                    return game.getNeedsTruedriveEmu();
                }
                case SAVES_HIGHSCORE: {
                    return game.getHasHighscoreSaver();
                }
                case PAL_NTSC: {
                    return game.getPalNtscForDisplay();
                }
                case INCLUDES_DOCS: {
                    return game.getHasIncludedDocs();
                }
                case LOADINGSCREEN: {
                    return game.getHasLoadingScreen();
                }
                case VERSION_COMMENT: {
                    return game.getVersionComment();
                }
                case MUSIC_FILENAME: {
                    return game.getMusicFilename();
                }
                case HIGHSCORE: {
                    return new SortWrapper_Highscore(game.getHighscoreForDisplay());
                }
                case DIFFICULTY: {
                    return game.getDifficulty().getName();
                }
                case TIMES_PLAYED: {
                    return game.getTimesPlayedForDisplay();
                }
                case LAST_PLAYED: {
                    return new SortWrapper_LastPlayed(game.getDateLastPlayedForDisplay());
                }
                case RATING: {
                    return game.getRatingForDisplay();
                }
            }
        }
        catch (Exception exception) {}
        return "";
    }

    private Object getValues(Music music, int col) {
        ColumnHeader header = ColumnHeader.valueAt(col);
        switch (header) {
            case PUBLISHER: {
                return music.getPublisherForDisplay();
            }
            case YEAR: {
                return music.getYearForDisplay();
            }
            case MUSICIAN: {
                return music.getMusicianForDisplay();
            }
            case MUSIC_FILENAME: {
                return music.getFilename();
            }
            case TRUE_DRIVE: 
            case SAVES_HIGHSCORE: 
            case INCLUDES_DOCS: 
            case LOADINGSCREEN: {
                return false;
            }
            case LENGTH: {
                return new SortWrapper_Length("");
            }
            case HIGHSCORE: {
                return new SortWrapper_Highscore("");
            }
            case LAST_PLAYED: {
                return new SortWrapper_LastPlayed("");
            }
        }
        return "";
    }

    Item getItem(int row) {
        Item item = new Game();
        try {
            item = this.currentView.getData().get(row);
        }
        catch (Exception exception) {}
        return item;
    }

    public Class<? extends Object> getColumnClass(int col) {
        Object value;
        ColumnHeader header = ColumnHeader.valueAt(col);
        switch (header) {
            case NAME: {
                value = this.getValueAt(0, col);
                break;
            }
            case LENGTH: {
                value = new SortWrapper_Length("");
                break;
            }
            case HIGHSCORE: {
                value = new SortWrapper_Highscore("");
                break;
            }
            case LAST_PLAYED: {
                value = new SortWrapper_LastPlayed("");
                break;
            }
            default: {
                value = this.getValues(dummyGame, col);
            }
        }
        if (value == null) {
            value = "";
        }
        return value.getClass();
    }

    public int getIndexOf(Object o) {
        return this.currentView.getData().indexOf(o);
    }

    public Iterator<Item> iterator() {
        return this.currentView.getData().iterator();
    }
}

