/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import jgamebase.Const;

public class SplashScreen
extends JFrame {
    private static final long serialVersionUID = 4112240114220766904L;
    private transient Image background;
    private transient Image splash;

    public SplashScreen(String filename) {
        if (!new File(filename).exists()) {
            Const.log.warn((Object)("Splashscreen '" + filename + "' not found."));
            this.dispose();
            return;
        }
        try {
            this.setUndecorated(true);
            this.setTitle("[powered by jGameBase V0.71-4]");
            this.setIconImage(Const.IMAGE_JGAMEBASE);
            this.splash = ImageIO.read(new File(filename));
            int w = this.splash.getWidth(null);
            int h = this.splash.getHeight(null);
            this.setSize(w, h);
            int x = (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)w) / 2;
            int y = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)h) / 2;
            this.setLocation(x, y);
            if (x >= 0 && y >= 0 && w > 0 && h > 0) {
                this.background = new Robot().createScreenCapture(new Rectangle(x, y, w, h));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.splash != null && this.background != null) {
            this.background.getGraphics().drawImage(this.splash, 0, 0, this);
            g.drawImage(this.background, 0, 0, this);
        }
    }
}

