/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.Export;
import jgamebase.db.Import;
import jgamebase.gui.Gui;
import jgamebase.tools.GemusToJs;
import jgamebase.tools.TempDir;

public class ToolboxGui
extends JFrame {
    private static final long serialVersionUID = -3626362724285446947L;
    File mdbFile = null;
    JTextArea outputArea;

    public ToolboxGui() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        JScrollPane mainScrollPane = new JScrollPane();
        this.outputArea = new JTextArea();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JSeparator fileMenu_Separator2 = new JSeparator();
        JMenuItem fileMenu_Exit = new JMenuItem();
        JMenu importMenu = new JMenu();
        JMenuItem importMenuItem1 = new JMenuItem();
        JMenuItem importMenuItem2 = new JMenuItem();
        JMenuItem importMenuItem3 = new JMenuItem();
        JMenuItem importMenuItem4 = new JMenuItem();
        JMenuItem importMenuItem5 = new JMenuItem();
        JMenuItem importMenuItem6 = new JMenuItem();
        JMenuItem importMenuItem7 = new JMenuItem();
        JMenu toolsMenu = new JMenu();
        JMenuItem toolsMenu_gemusToJs = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem helpMenu_About = new JMenuItem();
        this.setTitle("jToolBox");
        this.setIconImage(Const.IMAGE_TOOLBOX);
        this.setMinimumSize(new Dimension(320, 200));
        this.setPreferredSize(new Dimension(640, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ToolboxGui.this.exitFormWindowClosing(evt);
            }
        });
        mainPanel.setLayout(new BorderLayout());
        this.outputArea.setEditable(false);
        this.outputArea.setBackground(new Color(237, 236, 236));
        this.outputArea.setColumns(20);
        this.outputArea.setRows(5);
        mainScrollPane.setViewportView(this.outputArea);
        mainPanel.add((Component)mainScrollPane, "Center");
        this.getContentPane().add((Component)mainPanel, "Center");
        fileMenu.setText("File");
        fileMenu_Separator2.setPreferredSize(new Dimension(2, 2));
        fileMenu.add(fileMenu_Separator2);
        fileMenu_Exit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        fileMenu_Exit.setText("Exit");
        fileMenu_Exit.setToolTipText("Exits the program.");
        fileMenu_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.quitActionPerformed(evt);
            }
        });
        fileMenu.add(fileMenu_Exit);
        menuBar.add(fileMenu);
        importMenu.setText("Import");
        importMenuItem1.setText("1 Specify Access file");
        importMenuItem1.setToolTipText("Specify the Access file to import (the file has to be located in a direct subdirectory of jGameBase 'jgb/<DB>/*.mdb').");
        importMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep1_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem1);
        importMenuItem2.setText("2 Create export directory");
        importMenuItem2.setToolTipText("Create the export directory 'jgb/<DB>/Export'.");
        importMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep2_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem2);
        importMenuItem3.setText("3 Export to CSV");
        importMenuItem3.setToolTipText("Export the Access db to CSV files.");
        importMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep3_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem3);
        importMenuItem4.setText("4 Get CSV version");
        importMenuItem4.setToolTipText("Read the database version from the exported Config.csv.");
        importMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep4_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem4);
        importMenuItem5.setText("5 Update CSV if necessary");
        importMenuItem5.setToolTipText("If the version of the CSV files is too low, try to update.");
        importMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep5_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem5);
        importMenuItem6.setText("6 Create empty database");
        importMenuItem6.setToolTipText("Create derby db in 'jgb/<DB>/Database'.");
        importMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep6_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem6);
        importMenuItem7.setText("7 Import CSV files to database");
        importMenuItem7.setToolTipText("Import csv files from 'jgb/<DB>/Export/*.csv' to derby db.");
        importMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.importStep7_ActionPerformed(evt);
            }
        });
        importMenu.add(importMenuItem7);
        menuBar.add(importMenu);
        toolsMenu.setText("Tools");
        toolsMenu_gemusToJs.setText("Gemus to JavaScript");
        toolsMenu_gemusToJs.setToolTipText("Convert a GEMUS script to JavaScript");
        toolsMenu_gemusToJs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.gemusToJsActionPerformed(evt);
            }
        });
        toolsMenu.add(toolsMenu_gemusToJs);
        menuBar.add(toolsMenu);
        helpMenu.setText("Help");
        helpMenu_About.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        helpMenu_About.setText("About");
        helpMenu_About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolboxGui.this.about_ActionPerformed(evt);
            }
        });
        helpMenu.add(helpMenu_About);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    private void importStep1_ActionPerformed(ActionEvent evt) {
        this.println("#1 Get Access (*.mdb) file to import (the file has to be located in a direct subdirectory of jGameBase e.g. 'jgb/<DB>/*.mdb'):");
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getAbsolutePath().toLowerCase().endsWith(".mdb");
                }

                @Override
                public String getDescription() {
                    return "MS Access files (*.mdb)";
                }
            });
            fileChooser.setCurrentDirectory(Const.GBDIR_RW);
            if (fileChooser.showOpenDialog(null) == 0) {
                this.mdbFile = fileChooser.getSelectedFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Gui.displayErrorDialog("Error while getting Access file '" + this.mdbFile.getName() + "'.");
        }
        this.println("  Access file to import ='" + this.mdbFile.getAbsolutePath() + "'.");
        this.println();
    }

    private void importStep2_ActionPerformed(ActionEvent evt) {
        if (!this.validMdbFileSpecified()) {
            return;
        }
        this.println("#2 Create the export directory '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Export':");
        Export.mdb2Csv_clear(this.mdbFile);
        this.println("  Export directory successfully created.\n");
    }

    private void importStep3_ActionPerformed(ActionEvent evt) {
        if (!this.validMdbFileSpecified()) {
            return;
        }
        try {
            this.println("#3 Export database to csv files in directory '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Export':");
            Export.mdb2Csv_export(this.mdbFile);
            this.println("  Export successfully finished.\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importStep4_ActionPerformed(ActionEvent evt) {
        if (!this.validMdbFileSpecified()) {
            return;
        }
        try {
            this.println("#4 Get db version from '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Export/Config.csv':");
            this.println("  Version = '" + Export.mdb2Csv_getVersion(this.mdbFile) + "'.\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importStep5_ActionPerformed(ActionEvent evt) {
        if (!this.validMdbFileSpecified()) {
            return;
        }
        this.println("#5 Update csv files in '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Export' if necessary:");
        try {
            this.println("    current db version = " + Export.mdb2Csv_getVersion(this.mdbFile));
            this.println("    ...");
            Export.mdb2Csv_update(this.mdbFile);
            this.println("    new db version = " + Export.mdb2Csv_getVersion(this.mdbFile));
            this.println("  Update successfully finished.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importStep6_ActionPerformed(ActionEvent evt) {
        if (!this.validMdbFileSpecified()) {
            return;
        }
        this.println("#6 Create derby db in '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Database':");
        Db.init(this.mdbFile.getParentFile().getName(), true);
        this.println("  Derby database '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Database' created.\n");
    }

    private void importStep7_ActionPerformed(ActionEvent evt) {
        if (!this.validMdbFileSpecified()) {
            return;
        }
        this.println("#7 Import csv files from '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Export' to derby db in '" + this.mdbFile.getParentFile().getAbsolutePath() + "/Database':");
        try {
            Import.csv2Db(this.mdbFile);
            Db.close();
            this.println("  Import successfully finished.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void gemusToJsActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.setCurrentDirectory(Const.GBDIR_RW);
            if (fileChooser.showOpenDialog(null) == 0) {
                GemusToJs.gemusToJs(fileChooser.getSelectedFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void about_ActionPerformed(ActionEvent evt) {
        Gui.displayInformationDialog("jToolBox V0.71-4 (2023-11-24).\nUse it to perform additional database tasks for jGameBase.");
    }

    private void quitActionPerformed(ActionEvent evt) {
        this.quit();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.quit();
    }

    private boolean validMdbFileSpecified() {
        if (this.mdbFile != null && this.mdbFile.exists() && this.mdbFile.canRead() && this.mdbFile.getName().endsWith(".mdb")) {
            return true;
        }
        this.println("You must first specify an Access database '*.mdb' file to import (Menu 'Import' => '1 Specify Access file')");
        return false;
    }

    private void quit() {
        TempDir.cleanPath();
        Const.log.info((Object)"jToolBox finished.");
        System.exit(0);
    }

    private void print(String message) {
        Document doc = this.outputArea.getDocument();
        try {
            doc.insertString(doc.getLength(), message, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void println(String message) {
        this.print(message);
        this.println();
    }

    private void println() {
        this.print(System.getProperty("line.separator"));
    }
}

