/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jgamebase.Const;
import jgamebase.db.model.ItemView;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Selection;
import jgamebase.gui.Gui;

public class ViewDialog
extends JDialog {
    private static final long serialVersionUID = 3116509294496520164L;
    private static final String DESCRIPTION_CONTAINS = "contains text";
    private static final String DESCRIPTION_NOTCONTAINS = "excludes text";
    private static final String DESCRIPTION_STARTSWITH = "starts with text";
    private static final String DESCRIPTION_ENDWITH = "ends with text";
    private static final String DESCRIPTION_FILLED = "field is filled";
    private static final String DESCRIPTION_EMPTY = "field is empty";
    private static final String DESCRIPTION_EXISTS = "file exists";
    private static final String DESCRIPTION_MISSING = "file does not exist";
    private static final String DESCRIPTION_EQUAL = "is";
    private static final String DESCRIPTION_NOTEQUAL = "is not";
    private static final String DESCRIPTION_BEFORE = "is before";
    private static final String DESCRIPTION_AFTER = "is after";
    private static final String DESCRIPTION_LESSTHAN = "is Less than";
    private static final String DESCRIPTION_MORETHAN = "is more than";
    private List<FilterRule> filterRules;
    private ItemView view = null;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private ItemViewFilter filter;
    private Const.CloseAction filterDialogCloseAction = Const.CloseAction.CANCEL;
    private JComboBox filterData;
    private JLabel filterDataLabel;
    protected JDialog filterDialog;
    private JComboBox filterField;
    private JRadioButton filterModeAndRadioButton;
    private JRadioButton filterModeOrRadioButton;
    private JList filterOperator;
    private JTable filterTable;
    private JRadioButton includeBothRadioButton;
    private JRadioButton includeGamesRadioButton;
    private JRadioButton includeMusicRadioButton;
    private JTextField viewTitle;

    private FilterRule getTemplateRule(ItemViewFilter filter) {
        for (FilterRule templateRule : this.filterRules) {
            for (ItemViewFilter templateFilter : templateRule.getFilters()) {
                if (filter.getClauseType() != templateFilter.getClauseType() || filter.getOperator() != templateFilter.getOperator() || !filter.getGameTable().equals(templateFilter.getGameTable()) || !filter.getGameField().equals(templateFilter.getGameField()) || !filter.getMusicTable().equals(templateFilter.getMusicTable()) || !filter.getMusicField().equals(templateFilter.getMusicField())) continue;
                return templateRule;
            }
        }
        return null;
    }

    private ItemViewFilter getTemplateFilter(ItemViewFilter filter) {
        for (FilterRule templateRule : this.filterRules) {
            for (ItemViewFilter templateFilter : templateRule.getFilters()) {
                if (filter.getClauseType() != templateFilter.getClauseType() || filter.getOperator() != templateFilter.getOperator() || !filter.getGameTable().equals(templateFilter.getGameTable()) || !filter.getGameField().equals(templateFilter.getGameField()) || !filter.getMusicTable().equals(templateFilter.getMusicTable()) || !filter.getMusicField().equals(templateFilter.getMusicField())) continue;
                return templateFilter;
            }
        }
        return null;
    }

    public ViewDialog(ItemView view, String title) {
        this.initFieldRules();
        this.init();
        this.setTitle(title);
        try {
            this.view = (ItemView)view.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.viewTitle.setText(view.getName());
        if (view.getMode() == 0) {
            this.filterModeAndRadioButton.setSelected(true);
        } else {
            this.filterModeOrRadioButton.setSelected(true);
        }
        FilterTableModel data = (FilterTableModel)this.filterTable.getModel();
        data.set(new ArrayList<ItemViewFilter>(view.getFilters()));
        this.filterTable.getSelectionModel().setSelectionInterval(0, 0);
        if (view.getInclude() == 0) {
            this.includeGamesRadioButton.setSelected(true);
        } else if (view.getInclude() == 1) {
            this.includeMusicRadioButton.setSelected(true);
        } else {
            this.includeBothRadioButton.setSelected(true);
        }
        Gui.fixLookAndFeel(this.filterTable);
        this.setVisible(true);
    }

    protected void init() {
        this.initComponents();
    }

    private void initComponents() {
        ButtonGroup filterModeButtonGroup = new ButtonGroup();
        ButtonGroup includeTablesButtonGroup = new ButtonGroup();
        this.filterDialog = new JDialog();
        JLabel jLabel1 = new JLabel();
        this.filterField = new JComboBox();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.filterOperator = new JList();
        this.filterDataLabel = new JLabel();
        this.filterData = new JComboBox();
        JPanel jPanel1 = new JPanel();
        JButton filterOkButton = new JButton();
        JButton filterCancelButton = new JButton();
        JPanel titlePanel = new JPanel();
        JLabel viewTitleLabel = new JLabel();
        this.viewTitle = new JTextField();
        JPanel filterModePanel = new JPanel();
        this.filterModeAndRadioButton = new JRadioButton();
        this.filterModeOrRadioButton = new JRadioButton();
        JPanel filterPanel = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.filterTable = new JTable();
        JButton addFilter = new JButton();
        JButton editFilter = new JButton();
        JButton removeFilter = new JButton();
        JButton clearFilterButton = new JButton();
        JPanel bottomPanel = new JPanel();
        JPanel includeTablesPanel = new JPanel();
        this.includeGamesRadioButton = new JRadioButton();
        this.includeMusicRadioButton = new JRadioButton();
        this.includeBothRadioButton = new JRadioButton();
        JPanel fillPanel = new JPanel();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.filterDialog.setTitle("Edit Filter");
        this.filterDialog.setModal(true);
        this.filterDialog.setResizable(false);
        this.filterDialog.getContentPane().setLayout(new GridBagLayout());
        jLabel1.setText("Field:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)jLabel1, gridBagConstraints);
        this.filterField.setModel(new DefaultComboBoxModel<Object>(this.filterRules.toArray()));
        this.filterField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.filterFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)this.filterField, gridBagConstraints);
        jLabel2.setText("Operator:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)jLabel2, gridBagConstraints);
        jScrollPane2.setMinimumSize(new Dimension(250, 120));
        jScrollPane2.setPreferredSize(new Dimension(250, 120));
        this.filterOperator.setSelectionMode(0);
        this.filterOperator.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ViewDialog.this.filterOperatorValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(this.filterOperator);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)jScrollPane2, gridBagConstraints);
        this.filterDataLabel.setText("Filter Data:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)this.filterDataLabel, gridBagConstraints);
        this.filterData.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)this.filterData, gridBagConstraints);
        filterOkButton.setText("OK");
        filterOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.filterOkActionPerformed(evt);
            }
        });
        jPanel1.add(filterOkButton);
        filterCancelButton.setText("Cancel");
        filterCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.filterCancelActionPerformed(evt);
            }
        });
        jPanel1.add(filterCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 5, 4, 5);
        this.filterDialog.getContentPane().add((Component)jPanel1, gridBagConstraints);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ViewDialog.this.exitFormWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        titlePanel.setLayout(new GridBagLayout());
        viewTitleLabel.setDisplayedMnemonic('T');
        viewTitleLabel.setLabelFor(this.viewTitle);
        viewTitleLabel.setText("View Title:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        titlePanel.add((Component)viewTitleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        titlePanel.add((Component)this.viewTitle, gridBagConstraints);
        this.getContentPane().add(titlePanel);
        filterModePanel.setBorder(BorderFactory.createTitledBorder("Filter Mode"));
        filterModePanel.setLayout(new GridLayout(1, 2));
        filterModeButtonGroup.add(this.filterModeAndRadioButton);
        this.filterModeAndRadioButton.setMnemonic('f');
        this.filterModeAndRadioButton.setText("All filters must match");
        filterModePanel.add(this.filterModeAndRadioButton);
        filterModeButtonGroup.add(this.filterModeOrRadioButton);
        this.filterModeOrRadioButton.setMnemonic('n');
        this.filterModeOrRadioButton.setText("Any filter can match");
        filterModePanel.add(this.filterModeOrRadioButton);
        this.getContentPane().add(filterModePanel);
        filterPanel.setBorder(BorderFactory.createTitledBorder("View Filters"));
        filterPanel.setLayout(new GridBagLayout());
        jScrollPane1.setPreferredSize(new Dimension(400, 100));
        this.filterTable.setModel(new FilterTableModel());
        jScrollPane1.setViewportView(this.filterTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        filterPanel.add((Component)jScrollPane1, gridBagConstraints);
        addFilter.setMnemonic('A');
        addFilter.setText("Add");
        addFilter.setNextFocusableComponent(editFilter);
        addFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.addFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        filterPanel.add((Component)addFilter, gridBagConstraints);
        editFilter.setMnemonic('E');
        editFilter.setText("Edit");
        editFilter.setNextFocusableComponent(removeFilter);
        editFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.editFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        filterPanel.add((Component)editFilter, gridBagConstraints);
        removeFilter.setMnemonic('R');
        removeFilter.setText("Remove");
        removeFilter.setNextFocusableComponent(clearFilterButton);
        removeFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.removeFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        filterPanel.add((Component)removeFilter, gridBagConstraints);
        clearFilterButton.setMnemonic('l');
        clearFilterButton.setText("Clear");
        clearFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.clearFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        filterPanel.add((Component)clearFilterButton, gridBagConstraints);
        this.getContentPane().add(filterPanel);
        bottomPanel.setLayout(new GridLayout(1, 3));
        includeTablesPanel.setBorder(BorderFactory.createTitledBorder("Include Tables"));
        includeTablesPanel.setLayout(new BoxLayout(includeTablesPanel, 1));
        includeTablesButtonGroup.add(this.includeGamesRadioButton);
        this.includeGamesRadioButton.setMnemonic('G');
        this.includeGamesRadioButton.setText("Games Table only");
        includeTablesPanel.add(this.includeGamesRadioButton);
        includeTablesButtonGroup.add(this.includeMusicRadioButton);
        this.includeMusicRadioButton.setMnemonic('M');
        this.includeMusicRadioButton.setText("Music Table only");
        includeTablesPanel.add(this.includeMusicRadioButton);
        includeTablesButtonGroup.add(this.includeBothRadioButton);
        this.includeBothRadioButton.setMnemonic('B');
        this.includeBothRadioButton.setText("Both Tables");
        includeTablesPanel.add(this.includeBothRadioButton);
        bottomPanel.add(includeTablesPanel);
        bottomPanel.add(fillPanel);
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        bottomPanel.add(OkCancelPanel);
        this.getContentPane().add(bottomPanel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void filterOperatorValueChanged(ListSelectionEvent evt) {
        if (this.filterOperator.getSelectedIndex() < 0 || this.filterOperator.getSelectedIndex() > this.filterOperator.getMaxSelectionIndex()) {
            this.filterOperator.setSelectedIndex(0);
        }
        ItemViewFilter filter = (ItemViewFilter)this.filterOperator.getSelectedValue();
        this.filterDataLabel.setEnabled(false);
        this.filterData.setModel(new DefaultComboBoxModel());
        this.filterData.setEnabled(false);
        this.filterData.setEditable(false);
        if (filter.getSelector() == 3) {
            return;
        }
        this.filterDataLabel.setEnabled(true);
        this.filterData.setEnabled(true);
        if (filter.getSelector() == 1) {
            this.filterData.setEditable(true);
            return;
        }
        this.filterData.setModel(new DefaultComboBoxModel<Object>(filter.getSelections().toArray()));
    }

    private void filterFieldActionPerformed(ActionEvent evt) {
        FilterRule rule = (FilterRule)this.filterField.getSelectedItem();
        DefaultListModel model = new DefaultListModel();
        rule.getFilters().forEach(model::addElement);
        this.filterOperator.setModel(model);
        this.filterOperator.setSelectedIndex(0);
    }

    private void filterCancelActionPerformed(ActionEvent evt) {
        this.filterDialog.setVisible(false);
        this.filter = null;
        this.filterDialogCloseAction = Const.CloseAction.CANCEL;
    }

    private void filterOkActionPerformed(ActionEvent evt) {
        String data = "";
        this.filterDialog.setVisible(false);
        this.filterDialogCloseAction = Const.CloseAction.OK;
        this.filter = (ItemViewFilter)this.filterOperator.getSelectedValue();
        if (this.filter.getSelector() != 3) {
            data = this.filter.getSelector() == 1 ? (String)this.filterData.getSelectedItem() : ((Selection)this.filterData.getSelectedItem()).getValue();
            try {
                this.filter = (ItemViewFilter)this.filter.clone();
                this.filter.setClauseData(data);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private void clearFilterActionPerformed(ActionEvent evt) {
        ((FilterTableModel)this.filterTable.getModel()).set(new ArrayList<ItemViewFilter>());
    }

    private void removeFilterActionPerformed(ActionEvent evt) {
        List<ItemViewFilter> data = ((FilterTableModel)this.filterTable.getModel()).get();
        int row = this.filterTable.getSelectedRow();
        if (row >= 0 && row < data.size()) {
            data.remove(this.filterTable.getSelectedRow());
        }
        ((FilterTableModel)this.filterTable.getModel()).set(data);
    }

    private void editFilterActionPerformed(ActionEvent evt) {
        if (this.filterTable.getSelectedRow() >= 0 || this.filterTable.getSelectedRow() < this.filterTable.getRowCount()) {
            int row;
            FilterTableModel model = (FilterTableModel)this.filterTable.getModel();
            if (model.getRow(row = this.filterTable.getSelectedRow()) == null) {
                return;
            }
            this.filter = model.getRow(row);
            FilterRule rule = this.getTemplateRule(this.filter);
            this.filterField.setSelectedItem(rule);
            ItemViewFilter template = this.getTemplateFilter(this.filter);
            this.filterOperator.setSelectedValue(template, true);
            if (template.getSelector() != 3) {
                if (template.getSelector() == 1) {
                    this.filterData.setSelectedItem(this.filter.getClauseData());
                } else {
                    int i = 0;
                    while (i < this.filterData.getModel().getSize()) {
                        if (((Selection)this.filterData.getModel().getElementAt(i)).getValue().equals(this.filter.getClauseData())) {
                            this.filterData.setSelectedIndex(i);
                        }
                        ++i;
                    }
                }
            }
            this.filterDialog.setLocationRelativeTo(null);
            this.filterDialog.pack();
            this.filterDialog.setVisible(true);
            if (this.filterDialogCloseAction == Const.CloseAction.OK) {
                model.setRow(row, this.filter);
            }
        }
    }

    private void addFilterActionPerformed(ActionEvent evt) {
        this.filter = null;
        this.filterField.setSelectedIndex(0);
        this.filterDialog.setLocationRelativeTo(null);
        this.filterDialog.pack();
        this.filterDialog.setVisible(true);
        if (this.filterDialogCloseAction == Const.CloseAction.OK && this.filter != null) {
            ((FilterTableModel)this.filterTable.getModel()).add(this.filter);
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.setVisible(false);
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    public ItemView getView() {
        this.view.setName(this.viewTitle.getText());
        if (this.filterModeAndRadioButton.isSelected()) {
            this.view.setMode(0);
        } else {
            this.view.setMode(1);
        }
        FilterTableModel data = (FilterTableModel)this.filterTable.getModel();
        this.view.setFilters(new HashSet<ItemViewFilter>(data.get()));
        if (this.includeGamesRadioButton.isSelected()) {
            this.view.setInclude(0);
        } else if (this.includeMusicRadioButton.isSelected()) {
            this.view.setInclude(1);
        } else {
            this.view.setInclude(2);
        }
        return this.view;
    }

    private void initFieldRules() {
        this.filterRules = new ArrayList<FilterRule>();
        FilterRule rule = new FilterRule("Name");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "Name", "Music", "Name");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "Name", "Music", "Name");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "Name", "Music", "Name");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "Name", "Music", "Name");
        this.filterRules.add(rule);
        rule = new FilterRule("Publisher");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Publishers", "Publisher", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Publishers", "Publisher", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Publishers", "Publisher", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Publishers", "Publisher", "", "");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "Publishers", "PU_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "Publishers", "PU_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Year Published");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Years", "YE_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Years", "YE_Id", "", "");
        rule.add(DESCRIPTION_AFTER, 4, 3, 3, "Years", "Year", "", "");
        rule.add(DESCRIPTION_BEFORE, 4, 3, 2, "Years", "Year", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Programmer");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Programmers", "Programmer", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Programmers", "Programmer", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Programmers", "Programmer", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Programmers", "Programmer", "", "");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "Programmers", "PR_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "Programmers", "PR_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Musician");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Musicians", "Musician", "Musicians", "Musician");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Musicians", "Musician", "Musicians", "Musician");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Musicians", "Musician", "Musicians", "Musician");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Musicians", "Musician", "Musicians", "Musician");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "Musicians", "MU_Id", "Musicians", "MU_Id");
        this.filterRules.add(rule);
        rule = new FilterRule("Genre");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Genres", "Genre", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Genres", "Genre", "", "");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Genres", "GE_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Genres", "GE_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Parent Genre");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "PGenres", "ParentGenre", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "PGenres", "ParentGenre", "", "");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "PGenres", "PG_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "PGenres", "PG_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("No. of Players");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "PlayersFrom", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "PlayersFrom", "", "");
        rule.add(DESCRIPTION_LESSTHAN, 4, 3, 4, "Games", "PlayersTo", "", "");
        rule.add(DESCRIPTION_MORETHAN, 4, 3, 5, "Games", "PlayersFrom", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Simultaneous Play");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "PlayersSim", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Language");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Languages", "Language", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Languages", "Language", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Languages", "Language", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Languages", "Language", "", "");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "Languages", "LA_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "Languages", "LA_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Has Prequel");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Prequel", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Has Sequel");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Sequel", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Has Related Game");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Related", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Personal Comment");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "Comment", "", "");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "Comment", "", "");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "Comment", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "Comment", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "Comment", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "Comment", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Game Filename");
        rule.add(DESCRIPTION_EXISTS, 3, 1, 0, "Games", "FA", "", "");
        rule.add(DESCRIPTION_MISSING, 3, 1, 1, "Games", "FA", "", "");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "Filename", "", "");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "Filename", "", "");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "Filename", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "Filename", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "Filename", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "Filename", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Music Filename");
        rule.add(DESCRIPTION_EXISTS, 3, 1, 0, "Games", "SA", "Music", "SA");
        rule.add(DESCRIPTION_MISSING, 3, 1, 1, "Games", "SA", "Music", "SA");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "SidFilename", "Music", "Filename");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "SidFilename", "Music", "Filename");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "SidFilename", "Music", "Filename");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "SidFilename", "Music", "Filename");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "SidFilename", "Music", "Filename");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "SidFilename", "Music", "Filename");
        this.filterRules.add(rule);
        rule = new FilterRule("Screenshot Filename");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "ScrnShotFilename", "", "");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "ScrnShotFilename", "", "");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "ScrnShotFilename", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "ScrnShotFilename", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "ScrnShotFilename", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "ScrnShotFilename", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Cracker");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Crackers", "Cracker", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Crackers", "Cracker", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Crackers", "Cracker", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Crackers", "Cracker", "", "");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "Crackers", "CR_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "Crackers", "CR_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("No. of Trainers");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "V_Trainers", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "V_Trainers", "", "");
        rule.add(DESCRIPTION_MORETHAN, 4, 3, 5, "Games", "V_Trainers", "", "");
        rule.add(DESCRIPTION_LESSTHAN, 4, 3, 4, "Games", "V_Trainers", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Loading Screen");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "V_LoadingScreen", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("High Score Saver");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "V_HighScoreSaver", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Included Docs");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "V_IncludedDocs", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("PAL/NTSC");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "V_PalNTSC", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "V_PalNTSC", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("True Drive Emul");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "V_TrueDriveEmu", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Game Length");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "V_Length", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "V_Length", "", "");
        rule.add(DESCRIPTION_MORETHAN, 4, 3, 5, "Games", "V_Length", "", "");
        rule.add(DESCRIPTION_LESSTHAN, 4, 3, 4, "Games", "V_Length", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Game Length Type");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "V_LengthType", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "V_LengthType", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Version Comment");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "V_Comment", "", "");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "V_Comment", "", "");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "V_Comment", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "V_Comment", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "V_Comment", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "V_Comment", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Game-File Version");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "Version", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "Version", "", "");
        rule.add(DESCRIPTION_MORETHAN, 4, 3, 5, "Games", "Version", "", "");
        rule.add(DESCRIPTION_LESSTHAN, 4, 3, 4, "Games", "Version", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Difficulty");
        rule.add(DESCRIPTION_EQUAL, 2, 3, 0, "Difficulty", "DI_Id", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 2, 3, 1, "Difficulty", "DI_Id", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("High Score");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "HighScore", "", "");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "HighScore", "", "");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "HighScore", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "HighScore", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "HighScore", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "HighScore", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Favourite");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Fav", "Music", "SFav");
        this.filterRules.add(rule);
        rule = new FilterRule("Game Has Extras");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Extras", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Extras Name");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Extras", "Name", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Extras", "Name", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Extras", "Name", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Extras", "Name", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Classic");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Classic", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Rating");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "Rating", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "Rating", "", "");
        rule.add(DESCRIPTION_MORETHAN, 4, 3, 5, "Games", "Rating", "", "");
        rule.add(DESCRIPTION_LESSTHAN, 4, 3, 4, "Games", "Rating", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Control");
        rule.add(DESCRIPTION_EQUAL, 4, 3, 0, "Games", "Control", "", "");
        rule.add(DESCRIPTION_NOTEQUAL, 4, 3, 1, "Games", "Control", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Notes");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Games", "MemoText", "", "");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Games", "MemoText", "", "");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Games", "MemoText", "", "");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Games", "MemoText", "", "");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Games", "MemoText", "", "");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Games", "MemoText", "", "");
        this.filterRules.add(rule);
        rule = new FilterRule("Musician Group");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Musicians", "Grp", "Musicians", "Grp");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Musicians", "Grp", "Musicians", "Grp");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Musicians", "Grp", "Musicians", "Grp");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Musicians", "Grp", "Musicians", "Grp");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Musicians", "Grp", "Musicians", "Grp");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Musicians", "Grp", "Musicians", "Grp");
        this.filterRules.add(rule);
        rule = new FilterRule("Musician Nickname");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Musicians", "Nick", "Musicians", "Nick");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Musicians", "Nick", "Musicians", "Nick");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Musicians", "Nick", "Musicians", "Nick");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Musicians", "Nick", "Musicians", "Nick");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Musicians", "Nick", "Musicians", "Nick");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Musicians", "Nick", "Musicians", "Nick");
        this.filterRules.add(rule);
        rule = new FilterRule("Musician Photo");
        rule.add(DESCRIPTION_FILLED, 3, 2, 0, "Musicians", "Photo", "Musicians", "Photo");
        rule.add(DESCRIPTION_EMPTY, 3, 2, 1, "Musicians", "Photo", "Musicians", "Photo");
        rule.add(DESCRIPTION_CONTAINS, 1, 0, 0, "Musicians", "Photo", "Musicians", "Photo");
        rule.add(DESCRIPTION_NOTCONTAINS, 1, 0, 1, "Musicians", "Photo", "Musicians", "Photo");
        rule.add(DESCRIPTION_STARTSWITH, 1, 0, 6, "Musicians", "Photo", "Musicians", "Photo");
        rule.add(DESCRIPTION_ENDWITH, 1, 0, 7, "Musicians", "Photo", "Musicians", "Photo");
        this.filterRules.add(rule);
        rule = new FilterRule("Adult");
        rule.add(DESCRIPTION_EQUAL, 0, 3, 0, "Games", "Adult", "Music", "Adult");
        this.filterRules.add(rule);
    }

    static class FilterRule {
        private final String name;
        private final List<ItemViewFilter> filters = new ArrayList<ItemViewFilter>();

        public FilterRule(String name) {
            this.name = name;
        }

        public List<ItemViewFilter> getFilters() {
            return this.filters;
        }

        public String getName() {
            return this.name;
        }

        public void add(String name, int filterSelector, int clauseType, int operator, String gameFieldTable, String gameFieldName, String musicFieldTable, String musicFieldName) {
            this.filters.add(new ItemViewFilter(name, filterSelector, clauseType, operator, gameFieldTable, gameFieldName, musicFieldTable, musicFieldName));
        }

        public String toString() {
            return this.name;
        }
    }

    class FilterTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5917540689766594578L;
        private List<ItemViewFilter> data = new ArrayList<ItemViewFilter>();

        FilterTableModel() {
        }

        public void set(List<ItemViewFilter> newData) {
            this.data = newData;
            this.fireTableDataChanged();
        }

        public void add(ItemViewFilter filter) {
            this.data.add(filter);
            this.fireTableDataChanged();
        }

        public List<ItemViewFilter> get() {
            return this.data;
        }

        public ItemViewFilter getRow(int row) {
            if (row >= 0 && row < this.data.size()) {
                return this.data.get(row);
            }
            return null;
        }

        public void setRow(int row, ItemViewFilter filter) {
            this.data.set(row, filter);
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Field";
                }
                case 1: {
                    return "Operator";
                }
                case 2: {
                    return "Filter Data";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.data.get(row) instanceof ItemViewFilter) {
                ItemViewFilter filter = this.data.get(row);
                FilterRule rule = ViewDialog.this.getTemplateRule(filter);
                ItemViewFilter template = ViewDialog.this.getTemplateFilter(filter);
                switch (col) {
                    case 0: {
                        if (rule == null) {
                            return String.valueOf(filter.getGameField()) + " (no template found)";
                        }
                        return rule.getName();
                    }
                    case 1: {
                        if (template == null) {
                            return String.valueOf(filter.getClauseType()) + " (no template found)";
                        }
                        return template.getName();
                    }
                    case 2: {
                        String data = null;
                        if (filter != null) {
                            if (filter.getSelector() == 3) {
                                return "";
                            }
                            if (filter.getSelector() == 1) {
                                return "\"" + filter.getClauseData() + "\"";
                            }
                            List<Selection> selections = filter.getSelections();
                            for (Selection selection : selections) {
                                if (!filter.getClauseData().equals(selection.getValue())) continue;
                                data = selection.getName();
                            }
                        }
                        if (data == null) {
                            data = filter.getClauseData();
                        }
                        return data;
                    }
                }
            }
            return "";
        }

        public Class<? extends Object> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

