/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui.widgets;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private final Icon[] icons;
    private final Axis axis;
    private final int gap;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public CompoundIcon(Icon ... icons) {
        this(Axis.X_AXIS, icons);
    }

    public CompoundIcon(Axis axis, Icon ... icons) {
        this(axis, 0, icons);
    }

    public CompoundIcon(Axis axis, int gap, Icon ... icons) {
        this(axis, gap, 0.5f, 0.5f, icons);
    }

    public CompoundIcon(Axis axis, int gap, float alignmentX, float alignmentY, Icon ... icons) {
        this.axis = axis;
        this.gap = gap;
        float f = alignmentX > 1.0f ? 1.0f : (this.alignmentX = alignmentX < 0.0f ? 0.0f : alignmentX);
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
        int i = 0;
        while (i < icons.length) {
            if (icons[i] == null) {
                String message = "Icon (" + i + ") cannot be null";
                throw new IllegalArgumentException(message);
            }
            ++i;
        }
        this.icons = icons;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getGap() {
        return this.gap;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public int getIconCount() {
        return this.icons.length;
    }

    public Icon getIcon(int index) {
        return this.icons[index];
    }

    @Override
    public int getIconWidth() {
        int width = 0;
        if (this.axis == Axis.X_AXIS) {
            width += (this.icons.length - 1) * this.gap;
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n2 = 0;
            while (n2 < n) {
                Icon icon = iconArray[n2];
                width += icon.getIconWidth();
                ++n2;
            }
        } else {
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n3 = 0;
            while (n3 < n) {
                Icon icon = iconArray[n3];
                width = Math.max(width, icon.getIconWidth());
                ++n3;
            }
        }
        return width;
    }

    @Override
    public int getIconHeight() {
        int height = 0;
        if (this.axis == Axis.Y_AXIS) {
            height += (this.icons.length - 1) * this.gap;
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n2 = 0;
            while (n2 < n) {
                Icon icon = iconArray[n2];
                height += icon.getIconHeight();
                ++n2;
            }
        } else {
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n3 = 0;
            while (n3 < n) {
                Icon icon = iconArray[n3];
                height = Math.max(height, icon.getIconHeight());
                ++n3;
            }
        }
        return height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.axis == Axis.X_AXIS) {
            int height = this.getIconHeight();
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n2 = 0;
            while (n2 < n) {
                Icon icon = iconArray[n2];
                int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(c, g, x, y + iconY);
                x += icon.getIconWidth() + this.gap;
                ++n2;
            }
        } else if (this.axis == Axis.Y_AXIS) {
            int width = this.getIconWidth();
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n3 = 0;
            while (n3 < n) {
                Icon icon = iconArray[n3];
                int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                icon.paintIcon(c, g, x + iconX, y);
                y += icon.getIconHeight() + this.gap;
                ++n3;
            }
        } else {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            Icon[] iconArray = this.icons;
            int n = this.icons.length;
            int n4 = 0;
            while (n4 < n) {
                Icon icon = iconArray[n4];
                int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(c, g, x + iconX, y + iconY);
                ++n4;
            }
        }
    }

    private int getOffset(int maxValue, int iconValue, float alignment) {
        float offset = (float)(maxValue - iconValue) * alignment;
        return Math.round(offset);
    }

    public static enum Axis {
        X_AXIS,
        Y_AXIS,
        Z_AXIS;

    }
}

