/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui.widgets;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import jgamebase.Const;
import jgamebase.gui.widgets.JZoomableScalingImage;
import jgamebase.gui.widgets.flushable;
import jgamebase.tools.FileTools;

public class JScalingImage
extends JLabel
implements flushable {
    static final int widthSubtraction = 4;
    private static final long serialVersionUID = 1L;
    String filename = "";
    String tooltip = "";
    boolean loadImageAutomatically = true;
    Image image = null;
    JZoomableScalingImage wrappingImage = null;
    JScalingImage chainedImage = null;
    SwingWorker<Image, Void> worker;
    boolean isLoading = false;
    float aspect = 0.75f;
    int width;

    public JScalingImage(Icon icon) {
        super(icon);
        this.setImage(((ImageIcon)icon).getImage());
    }

    public JScalingImage(String filename, String tooltip, boolean loadImageAutomatically) throws Exception {
        super("Loading...", Const.ICON_LOADING, 0);
        if (filename == null) {
            throw new NullPointerException("Filename must not be null!");
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException("Filename must not be empty!");
        }
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String ext = FileTools.getExtension(filename);
        if (ext == null || ext.isEmpty()) {
            throw new IOException("Could not determine extension of filename '" + filename + "'");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.filename = filename;
        this.tooltip = tooltip;
        this.loadImageAutomatically = loadImageAutomatically;
        this.setToolTipText(tooltip);
        this.setAlignmentX(0.0f);
    }

    @Override
    public synchronized void flush() {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    @Override
    public int getHeight() {
        if (this.image == null) {
            return super.getHeight();
        }
        return (int)((float)this.width * this.aspect);
    }

    protected Image getImage() {
        return this.image;
    }

    @Override
    public int getWidth() {
        if (this.image == null) {
            return super.getWidth();
        }
        return this.width;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void startLoadingImage() {
        this.loadImageAutomatically = true;
    }

    protected void loadedImage() {
        this.isLoading = false;
        this.setText("");
        this.aspect = (float)this.image.getHeight(null) / (float)this.image.getWidth(null);
        this.scaleImage();
        if (this.wrappingImage != null) {
            JZoomableScalingImage.cache.put((Object)this.filename, (Object)this.wrappingImage);
        }
    }

    protected void loadImage() {
        if (this.image != null || this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.worker = new SwingWorker<Image, Void>(){

            @Override
            protected Image doInBackground() throws Exception {
                return ImageIO.read(new File(JScalingImage.this.filename));
            }

            @Override
            protected void done() {
                block6: {
                    try {
                        try {
                            JScalingImage.this.image = (Image)this.get();
                            if (JScalingImage.this.image != null) {
                                JScalingImage.this.loadedImage();
                                break block6;
                            }
                            JScalingImage.this.setText("Error loading image!");
                            JScalingImage.this.setToolTipText(JScalingImage.this.filename);
                            JScalingImage.this.setIcon(Const.ICON_LOADERROR);
                        }
                        catch (InterruptedException | CancellationException | ExecutionException exception) {
                            JScalingImage.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    finally {
                        JScalingImage.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        };
        this.worker.execute();
    }

    @Override
    public void paint(Graphics g) {
        if (this.getParent().getParent() != null) {
            this.setWidth(this.getParent().getParent().getWidth());
        }
        if (!this.isLoading) {
            if (this.image == null) {
                if (this.loadImageAutomatically) {
                    this.loadImage();
                }
            } else if (this.chainedImage != null) {
                this.chainedImage.startLoadingImage();
                this.chainedImage = null;
            }
        }
        super.paint(g);
    }

    protected void scaleImage() {
        if (this.image == null || this.getWidth() - 4 <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.image.getWidth(null) * this.image.getHeight(null) <= 307200) {
            this.setIcon(new ImageIcon(this.image.getScaledInstance(this.getWidth() - 4, this.getHeight(), 4)));
        } else {
            this.setIcon(new ImageIcon(this.image.getScaledInstance(this.getWidth() - 4, this.getHeight(), 2)));
            this.worker = new SwingWorker<Image, Void>(){

                @Override
                protected Image doInBackground() throws Exception {
                    return JScalingImage.this.image.getScaledInstance(JScalingImage.this.getWidth() - 4, JScalingImage.this.getHeight(), 4);
                }

                @Override
                protected void done() {
                    try {
                        JScalingImage.this.setIcon(new ImageIcon((Image)this.get()));
                    }
                    catch (Exception exception) {}
                }
            };
            this.worker.execute();
        }
    }

    public void setChainedImage(JScalingImage image) {
        this.chainedImage = image;
    }

    protected void setImage(Image image) {
        this.image = image;
        this.loadedImage();
    }

    @Override
    public void setSize(int width, int height) {
        this.setWidth(width);
    }

    public void setWidth(int newWidth) {
        if (newWidth != this.width) {
            this.width = newWidth;
            super.setSize(this.width, this.getHeight());
            this.scaleImage();
        }
    }
}

