/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui.widgets;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import jgamebase.Const;
import jgamebase.gui.Gui;
import jgamebase.gui.widgets.JScalingImage;
import jgamebase.model.Databases;
import jgamebase.tools.StringTools;

public class JZoomableScalingImage
extends JScalingImage {
    protected static final float screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
    protected static final float screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
    protected static final int heightAddition = 32;
    protected static final Cache<String, JZoomableScalingImage> cache = CacheBuilder.newBuilder().softValues().build();
    final JFrame frame = new JFrame();
    final JScrollPane scrollPane = new JScrollPane(22, 31);
    int initialWidth;
    JScalingImage scalingImage = null;

    public static JZoomableScalingImage createOrGet(String filename) throws Exception {
        JZoomableScalingImage image = (JZoomableScalingImage)cache.getIfPresent((Object)filename);
        if (image == null) {
            image = new JZoomableScalingImage(filename);
        }
        return image;
    }

    private JZoomableScalingImage(final String filename) throws Exception {
        super(filename, "", false);
        this.wrappingImage = this;
        this.initFrame();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JZoomableScalingImage.this.image == null) {
                    return;
                }
                if (JZoomableScalingImage.this.scalingImage == null) {
                    try {
                        JZoomableScalingImage.this.scalingImage = new JScalingImage(new ImageIcon(JZoomableScalingImage.this.image));
                        JZoomableScalingImage.this.scrollPane.setViewportView(JZoomableScalingImage.this.scalingImage);
                        JZoomableScalingImage.this.frame.getContentPane().add((Component)JZoomableScalingImage.this.scrollPane, 0);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                Dimension d = JZoomableScalingImage.this.calculateScaledSize(JZoomableScalingImage.this.image);
                JZoomableScalingImage.this.setSizes(d);
                JZoomableScalingImage.this.frame.setLocationRelativeTo(null);
                String externalViewerCommand = Databases.getCurrent().getPreferences().get("extra_open_image_cmd");
                boolean useInternalViewer = false;
                if (externalViewerCommand.isEmpty() || Gui.rightClick(e)) {
                    useInternalViewer = true;
                } else {
                    Object[] command = new String[]{externalViewerCommand, filename};
                    Const.log.info((Object)("Executing viewer: " + Arrays.toString(command)));
                    try {
                        ProcessBuilder builder = new ProcessBuilder((String[])command);
                        builder.start();
                    }
                    catch (IOException iOException) {
                        Const.log.info((Object)("Warning: error while executing command '" + Arrays.toString(command) + "'; using internal viewer."));
                        useInternalViewer = true;
                    }
                }
                if (useInternalViewer) {
                    JZoomableScalingImage.this.frame.setVisible(true);
                }
            }
        });
    }

    protected Dimension calculateScaledSize(Image image) {
        float width = image.getWidth(null);
        float height = image.getHeight(null);
        float aspect = (float)image.getHeight(null) / (float)image.getWidth(null);
        int clickedWidth = width / screenWidth > height / screenHeight ? (int)((double)screenWidth * 0.75) : (int)((double)screenHeight * 0.75 * (double)width / (double)height);
        return new Dimension(clickedWidth, (int)((float)clickedWidth * aspect));
    }

    protected void setSizes(Dimension d) {
        this.frame.setSize(new Dimension(d.width, d.height + 32));
        this.scrollPane.setSize(d);
        this.scalingImage.setSize(d);
    }

    protected void initFrame() {
        this.frame.setTitle(StringTools.htmlDecode(this.tooltip));
        this.frame.setResizable(true);
        this.scrollPane.setToolTipText("<html><i>Right click</i> to rotate</html>");
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (Gui.doubleClick(evt)) {
                    JZoomableScalingImage.this.frame.setVisible(false);
                }
                if (Gui.rightClick(evt)) {
                    int newWidth = JZoomableScalingImage.this.scalingImage.getHeight();
                    int newHeight = JZoomableScalingImage.this.scalingImage.getWidth();
                    Image newImage = JZoomableScalingImage.this.rotate(JZoomableScalingImage.this.scalingImage.getImage());
                    JZoomableScalingImage.this.scalingImage.setImage(newImage);
                    Dimension d = new Dimension(newWidth, newHeight);
                    if ((float)newWidth > screenWidth || (float)newHeight > screenHeight) {
                        d = JZoomableScalingImage.this.calculateScaledSize(newImage);
                    }
                    JZoomableScalingImage.this.setSizes(d);
                }
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JZoomableScalingImage.this.scalingImage.setSize(JZoomableScalingImage.this.frame.getWidth(), JZoomableScalingImage.this.frame.getHeight() - 32);
            }
        });
    }

    public Image rotate(Image imageIn) {
        int width = imageIn.getWidth(null);
        int height = imageIn.getHeight(null);
        BufferedImage bufferedimageIn = new BufferedImage(width, height, 1);
        Graphics2D g = bufferedimageIn.createGraphics();
        g.drawImage(imageIn, 0, 0, null);
        g.dispose();
        BufferedImage bufferedimageOut = new BufferedImage(height, width, 1);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                bufferedimageOut.setRGB(j, width - 1 - i, bufferedimageIn.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        bufferedimageIn.flush();
        bufferedimageOut.flush();
        return new ImageIcon(bufferedimageOut).getImage();
    }

    @Override
    public synchronized void flush() {
        super.flush();
        if (this.scalingImage != null) {
            this.scalingImage.flush();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
    }
}

