/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.db.Db;
import jgamebase.gui.Gui;
import jgamebase.model.Database;
import jgamebase.model.FileExtensions;
import jgamebase.model.Paths;
import jgamebase.tools.FileTools;
import jgamebase.tools.IniFileManager;
import jgamebase.tools.ListerTools;

public class Databases {
    public static final String DB_INI_FILENAME = "db.ini";
    private static List<Database> dbList = null;
    private static Database current;

    private Databases() {
    }

    public static void setList(List<Database> databases) {
        dbList = databases;
    }

    public static List<Database> getList() {
        return dbList;
    }

    public static void setCurrent(Database currentDatabase) {
        current = currentDatabase;
        Db.init(Databases.getCurrent().getName(), false);
    }

    public static Database getCurrent() {
        return current;
    }

    private static void copyDatabases() {
        if (JGameBase.option_debug) {
            Const.log.info((Object)("Looking for databases to copy in base directory '" + Const.GBDIR_RO + "'..."));
        }
        List<String> dirs_ro = ListerTools.list_Dirs_Files_Paths(Const.GBDIR_RO.toString(), true, false, true);
        for (String dir : dirs_ro) {
            File dir_ro;
            File dir_rw;
            String subdir = Paths.removePath(dir);
            if (JGameBase.option_debug) {
                Const.log.info((Object)("Looking for database in directory '" + subdir + "'"));
            }
            if (Databases.isKnownGBSubdir(subdir)) continue;
            boolean possible_db = false;
            File dbdir = new File(dir, "Database");
            if (dbdir.exists() && dbdir.isDirectory()) {
                possible_db = true;
            } else {
                List<String> mdbs = new FileExtensions("mdb").getMatching(ListerTools.list_Dirs_Files_Paths(dir, false, true, false));
                if (mdbs.size() > 0) {
                    possible_db = true;
                }
            }
            if (!possible_db || (dir_rw = FileTools.replacePath(dir_ro = new File(dir), Const.GBDIR_RO, Const.GBDIR_RW)).exists()) continue;
            Const.log.info((Object)("Found database in \"" + dir_ro + "\", copying to \"" + dir_rw + "\","));
            StringBuilder s = new StringBuilder("  (excluding sub directories ");
            int i = 0;
            while (i < Const.DB_SUBDIRS.length) {
                s.append("\"").append(Const.DB_SUBDIRS[i]).append("\"");
                if (i < Const.DB_SUBDIRS.length - 1) {
                    s.append(", ");
                }
                ++i;
            }
            Const.log.info((Object)s.append(").").toString());
            Const.log.info((Object)"");
            try {
                FileTools.copyDir(dir_ro, dir_rw, Const.DB_SUBDIRS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String[] stringArray = Const.DB_SUBDIRS;
            int n = Const.DB_SUBDIRS.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                new File(dir_rw, element).mkdir();
                ++n2;
            }
        }
    }

    private static boolean isKnownGBSubdir(String subdir) {
        return "Artwork".equals(subdir) || "bin".equals(subdir) || "Docs".equals(subdir) || "javadoc".equals(subdir) || "lib".equals(subdir) || "Overlays".equals(subdir) || "src".equals(subdir);
    }

    private static void copyDatabaseNames() {
        File src = new File(Const.GBDIR_RO, DB_INI_FILENAME);
        File dst = new File(Const.GBDIR_RW, DB_INI_FILENAME);
        if (!dst.exists() || dst.length() == 0L) {
            try {
                Const.log.info((Object)("Copying database names from \"" + src + "\" to \"" + dst + "\".\n"));
                FileTools.copyFile(src, dst);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void importDatabases() {
        List<String> dirs = ListerTools.list_Dirs_Files_Paths(Const.GBDIR_RW.toString(), true, false, true);
        for (String dir : dirs) {
            File dbdir;
            String subdir = Paths.removePath(dir);
            if ("Artwork".equals(subdir) || "bin".equals(subdir) || "Docs".equals(subdir) || "javadoc".equals(subdir) || "lib".equals(subdir) || "src".equals(subdir) || (dbdir = new File(dir, "Database")).exists() && dbdir.isDirectory()) continue;
            System.out.println("Looking for Access databases to import in '" + dir + "'");
            List<String> potentialMdbs = new FileExtensions("mdb").getMatching(ListerTools.list_Dirs_Files_Paths(dir, false, true, false));
            ArrayList mdbs = new ArrayList();
            mdbs.addAll(potentialMdbs.stream().filter(mdb -> !mdb.toLowerCase().startsWith("empty")).collect(Collectors.toList()));
            if (mdbs.size() > 1) {
                Const.log.info((Object)("Found more than one unimported access database in dir '" + dir + "'.\nWill NOT import (please remove additional access databases)."));
                Gui.displayWarningDialog("Found more than one unimported access database in dir '" + dir + "'.\nWill NOT import (please remove additional access databases).");
            }
            if (mdbs.size() != 1) continue;
            String mdb2 = (String)mdbs.get(0);
            Const.log.info((Object)("Found unimported access database '" + new File(dir, mdb2) + "'."));
            if (JOptionPane.showConfirmDialog(null, "Found access database '" + new File(dir, mdb2) + "'.\nTry to import ?", "jGameBase", 0) != 0) continue;
            Gui.importAccessToDatabase(new File(dir, mdb2));
        }
        System.out.println();
    }

    public static void init() {
        if (Const.FHS) {
            Databases.copyDatabases();
            Databases.copyDatabaseNames();
        }
        Databases.importDatabases();
        List<String> dirs = ListerTools.list_Dirs_Files_Paths(Const.GBDIR_RW.toString(), true, false, true);
        dbList = new ArrayList<Database>();
        dirs.forEach(dir -> {
            File dbdir;
            String dirname = Paths.removePath(dir);
            if (!"gamebase".equals(dirname) && !"lib".equals(dirname) && !"Artwork".equals(dirname) && (dbdir = new File((String)dir, "Database")).exists() && dbdir.isDirectory()) {
                Const.log.info((Object)("Found database '" + dirname + "'."));
                Database database = new Database(dirname);
                dbList.add(database);
            }
        });
        try {
            File globalDbIniFile = new File(Const.GBDIR_RW, DB_INI_FILENAME);
            IniFileManager globalDbIni = null;
            if (globalDbIniFile.exists()) {
                globalDbIni = new IniFileManager(globalDbIniFile);
            }
            for (Database db : dbList) {
                String displayName = "";
                File localDbIniFile = new File(db.getPath(), DB_INI_FILENAME);
                if (localDbIniFile.exists()) {
                    IniFileManager localDbIni = new IniFileManager(localDbIniFile.toString());
                    displayName = localDbIni.get("DB_NAME", "NAME");
                }
                if ((displayName == null || displayName.isEmpty()) && globalDbIni != null) {
                    displayName = globalDbIni.get("DB_NAMES", db.getName());
                }
                if (displayName == null || displayName.isEmpty()) {
                    displayName = db.getName().replaceAll("_", " ");
                }
                db.setDisplayName(displayName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(dbList, new Comparator<Database>(){

            @Override
            public int compare(Database d1, Database d2) {
                return d1.getDisplayName().compareToIgnoreCase(d2.getDisplayName());
            }
        });
    }
}

