/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import jgamebase.Const;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.Music;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.model.Emulator;
import jgamebase.model.FileExtensions;
import jgamebase.model.Plugins;
import jgamebase.model.RunningGame;
import jgamebase.plugins.DiskInfo;
import jgamebase.tools.FileTools;
import jgamebase.tools.IniFileManager;
import jgamebase.tools.StringTools;
import jgamebase.tools.TempDir;

public class Emulators {
    private static final File FILE_GAME = new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), "GameEmulators.ini");
    private static final File FILE_MUSIC = new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), "MusicEmulators.ini");
    private static final String OPTION_NAME = "Name";
    private static final String OPTION_EXTENSIONS = "Extensions";
    private static final String OPTION_COMMAND = "Command";
    private static final String OPTION_CONFIGURATIONFILENAME = "ConfigurationFilename";
    private static List<Emulator> gameEmulators = null;
    private static List<Emulator> musicEmulators = null;
    private static List<RunningGame> runningGames = new ArrayList<RunningGame>();
    private static Process runningMusic = null;

    private Emulators() {
    }

    public static void setGameEmulators(List<Emulator> emulators) {
        gameEmulators = emulators;
    }

    public static List<Emulator> getGameEmulators() {
        return gameEmulators;
    }

    public static void setMusicEmulators(List<Emulator> emulators) {
        musicEmulators = emulators;
    }

    public static List<Emulator> getMusicEmulators() {
        return musicEmulators;
    }

    public static FileExtensions getSupportedGameExtensions() {
        FileExtensions supported = new FileExtensions();
        for (Emulator emulator : gameEmulators) {
            if (emulator.getSupportedExtensions().matchesAll()) {
                return emulator.getSupportedExtensions();
            }
            supported.add(emulator.getSupportedExtensions());
        }
        return supported;
    }

    public static FileExtensions getSupportedMusicExtensions() {
        FileExtensions supported = new FileExtensions();
        for (Emulator emulator : musicEmulators) {
            if (emulator.getSupportedExtensions().matchesAll()) {
                return emulator.getSupportedExtensions();
            }
            supported.add(emulator.getSupportedExtensions());
        }
        return supported;
    }

    public static void readFromIniFile() {
        try {
            gameEmulators = Emulators.load(FILE_GAME);
            musicEmulators = Emulators.load(FILE_MUSIC);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<Emulator> load(File filename) throws IOException {
        ArrayList<Emulator> emulators = new ArrayList<Emulator>();
        IniFileManager ini = new IniFileManager(filename);
        List<String> sectionNames = ini.getSectionNames();
        sectionNames.forEach(sectionName -> {
            Emulator emulator = new Emulator();
            String title = ini.get((String)sectionName, OPTION_NAME);
            if (title == null || title.isEmpty()) {
                title = "New Emulator";
            }
            emulator.setName(title);
            FileExtensions extensions = new FileExtensions(ini.get((String)sectionName, OPTION_EXTENSIONS));
            if (extensions == null || extensions.isEmpty()) {
                extensions.setMatchesAll();
            }
            emulator.setSupportedExtensions(extensions);
            String command = ini.get((String)sectionName, OPTION_COMMAND);
            if (command == null || command.isEmpty()) {
                command = String.valueOf(emulator.getName().toLowerCase()) + "." + Const.DEFAULT_SCRIPT_EXTENSION;
            }
            emulator.setCommand(command);
            String configurationFilename = ini.get((String)sectionName, OPTION_CONFIGURATIONFILENAME);
            if (configurationFilename == null) {
                configurationFilename = "";
            }
            emulator.setConfigurationFilename(configurationFilename);
            emulators.add(emulator);
        });
        return emulators;
    }

    public static void writeToIniFile() {
        try {
            Emulators.save(FILE_GAME, gameEmulators);
            Emulators.save(FILE_MUSIC, musicEmulators);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void save(File file, List<Emulator> emulators) throws IOException {
        IniFileManager ini = new IniFileManager(file);
        String sectionName = "";
        ini.removeAllSections();
        int i = 1;
        for (Emulator emulator : emulators) {
            sectionName = Integer.toString(i);
            ini.addSection(sectionName);
            ini.set(sectionName, OPTION_NAME, emulator.getName());
            ini.set(sectionName, OPTION_EXTENSIONS, emulator.getSupportedExtensions().toString());
            ini.set(sectionName, OPTION_COMMAND, emulator.getCommand());
            ini.set(sectionName, OPTION_CONFIGURATIONFILENAME, emulator.getConfigurationFilename());
            ++i;
        }
        ini.save();
    }

    public static Emulator findGameEmulatorForExtension(String extension) {
        return gameEmulators.stream().filter(emulator -> emulator.getSupportedExtensions().contains(extension)).findFirst().orElse(null);
    }

    public static Emulator findMusicEmulatorForExtension(String extension) {
        return musicEmulators.stream().filter(emulator -> emulator.getSupportedExtensions().contains(extension)).findFirst().orElse(null);
    }

    public static synchronized void executeGame(String[] command, Map<String, Object> itemEnvironment, TempDir tempDir) {
        Emulators.checkRunningGames();
        if (Databases.getCurrent().getPreferences().is("game_stop_running")) {
            Emulators.stopRunningGames();
        }
        Emulators.stopRunningMusic();
        try {
            StringBuilder commandline = new StringBuilder();
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                commandline.append("<").append(part).append("> ");
                ++n2;
            }
            Const.log.info((Object)("Executing game: '" + commandline.toString().trim() + "'"));
            if (command.length == 0) {
                Const.log.info((Object)"no command to execute!");
                return;
            }
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            File commandFile = new File(command[0]);
            File workDir = null;
            workDir = commandFile.isAbsolute() ? commandFile.getParentFile() : new File(Databases.getCurrent().getPath(), "Scripts");
            Const.log.info((Object)("Setting work directory to '" + workDir.getAbsolutePath() + "'."));
            builder.directory(workDir);
            if (itemEnvironment != null) {
                Map<String, String> environment = builder.environment();
                environment.putAll(Emulators.convertEnvironmentToString(itemEnvironment));
            }
            runningGames.add(new RunningGame(builder.start(), tempDir));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Gui.displayErrorDialog("Command '" + Arrays.toString(command) + "' not found.");
        }
        catch (IOException e) {
            Gui.displayErrorDialog("Error while executing command '" + Arrays.toString(command) + "':\n" + e.getMessage() + ".");
            Const.log.info((Object)e.getMessage());
        }
    }

    private static Map<String, String> convertEnvironmentToString(Map<String, Object> envIn) {
        HashMap<String, String> envOut = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : envIn.entrySet()) {
            Object o;
            Object object = o = entry.getValue() != null ? entry.getValue() : "";
            if (o.getClass().isArray()) {
                int i = 0;
                while (i < Array.getLength(o)) {
                    envOut.put(String.valueOf(entry.getKey()) + "_" + i, Array.get(o, i).toString());
                    ++i;
                }
                envOut.put(String.valueOf(entry.getKey()) + "_length", Integer.toString(Array.getLength(o)));
                continue;
            }
            envOut.put(entry.getKey(), o.toString());
        }
        return envOut;
    }

    public static synchronized void executeGame(String[] command, TempDir tempDir) {
        Emulators.executeGame(command, null, tempDir);
    }

    public static synchronized void executeMusic(String[] command) {
        Emulators.stopRunningMusic();
        Const.log.info((Object)("Executing music: " + Arrays.toString(command)));
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            runningMusic = builder.start();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Gui.displayErrorDialog("Command '" + Arrays.toString(command) + "' not found.");
        }
        catch (IOException iOException) {
            Gui.displayErrorDialog("Error while executing command '" + Arrays.toString(command) + "'.");
        }
    }

    public static synchronized boolean isMusicRunning() {
        if (runningMusic == null) {
            return false;
        }
        try {
            runningMusic.exitValue();
            Emulators.stopRunningMusic();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public static synchronized void stopRunningGames() {
        for (RunningGame runningGame : runningGames) {
            try {
                runningGame.stop();
            }
            catch (Exception exception) {}
        }
        runningGames = new ArrayList<RunningGame>();
    }

    public static synchronized void checkRunningGames() {
        ArrayList<RunningGame> stoppedGames = new ArrayList<RunningGame>();
        for (RunningGame game : runningGames) {
            try {
                if (game.isAlive()) continue;
                game.stop();
                stoppedGames.add(game);
            }
            catch (Exception exception) {}
        }
        runningGames.removeAll(stoppedGames);
    }

    public static synchronized void stopRunningMusic() {
        if (runningMusic != null) {
            runningMusic.destroy();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static Map<String, Object> setupEnvironment(Item item, String fileToRun, int filenameIndex, Emulator emulator, List<String> namesOfSupportedFiles, TempDir tempDir) {
        String emulatorConfigFile;
        boolean isGame;
        HashMap<String, Object> environment = new HashMap<String, Object>();
        Game game = null;
        Music music = null;
        if (item instanceof Game) {
            game = (Game)item;
            isGame = true;
        } else if (item instanceof Music) {
            music = (Music)item;
            isGame = false;
        } else {
            throw new RuntimeException("Item must be instance of Game or instance of Music");
        }
        environment.put("isGame", isGame);
        environment.put("Database", Databases.getCurrent());
        environment.put("Emulator", emulator);
        environment.put("Item", item);
        environment.put("Game", game);
        environment.put("Music", music);
        environment.put("osName", System.getProperty("os.name"));
        environment.put("isOsWindows", Const.OS_IS_WINDOWS);
        environment.put("lineSeparator", Const.LINE_SEPARATOR);
        environment.put("separator", File.separator);
        environment.put("dbPath", Databases.getCurrent().getPath());
        environment.put("emulatorPath", new File(Databases.getCurrent().getPath(), "Scripts").getAbsolutePath());
        if (emulator.getConfigurationFilename() == null || emulator.getConfigurationFilename().isEmpty()) {
            emulatorConfigFile = new File(new File(Databases.getCurrent().getPath(), "Scripts"), String.valueOf(emulator.getName().toLowerCase()) + ".cfg").getAbsolutePath();
        } else {
            String string = emulatorConfigFile = new File(emulator.getConfigurationFilename()).isAbsolute() ? emulator.getConfigurationFilename() : new File(new File(Databases.getCurrent().getPath(), "Scripts"), emulator.getConfigurationFilename()).getAbsolutePath();
        }
        if (!new File(emulatorConfigFile).exists()) {
            try {
                new File(emulatorConfigFile).createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        environment.put("emulatorConfigFile", emulatorConfigFile);
        environment.put("tempDir", tempDir);
        if (tempDir != null) {
            environment.put("workPath", tempDir.toString());
        } else {
            environment.put("workPath", TempDir.getPath().getAbsolutePath());
        }
        environment.put("itemName", isGame ? game.getName() : music.getName());
        environment.put("itemComment", isGame ? game.getComment() : "");
        environment.put("itemVersionComment", isGame ? game.getVersionComment() : "");
        environment.put("itemControl", isGame ? game.getControlForDisplay() : "");
        environment.put("itemPalNtsc", isGame ? game.getPalNtscForDisplay() : "");
        environment.put("itemPlayersMin", isGame ? game.getPlayersMin() : 1);
        environment.put("itemPlayersMax", isGame ? game.getPlayersMax() : 1);
        environment.put("isRunsOnPal", isGame ? game.isRunsOnPal() : true);
        environment.put("isRunsOnNtsc", isGame ? game.isRunsOnNtsc() : true);
        environment.put("isRunsOnTrueDrive", isGame ? game.getNeedsTruedriveEmu() : false);
        environment.put("useHardwareJoystick", Databases.getCurrent().getPreferences().is("hardware_joystick"));
        environment.put("fileToRun", fileToRun);
        environment.put("imageIndex", filenameIndex);
        environment.put("imageName", "");
        environment.put("imageNameNative", "");
        environment.put("isBootable", false);
        if (Plugins.existsDiskInfoForExtension(FileTools.getExtension(fileToRun))) {
            try {
                DiskInfo diskinfo = Plugins.getDiskInfoForExtension(FileTools.getExtension(fileToRun));
                diskinfo.load(fileToRun);
                String imageName = diskinfo.getFilenameAt(filenameIndex) == null ? "" : diskinfo.getFilenameAt(filenameIndex);
                environment.put("imageName", imageName != null ? imageName : "");
                String imageNameNative = diskinfo.getNativeFilenameAt(filenameIndex) == null ? "" : diskinfo.getNativeFilenameAt(filenameIndex);
                environment.put("imageNameNative", imageNameNative != null ? imageNameNative : "");
                environment.put("isBootable", diskinfo.isBootable());
            }
            catch (Exception exception) {
                Const.log.warn((Object)("Could not open the Diskimage '" + fileToRun + "'."));
            }
        }
        ArrayList<String> itemfilepaths = new ArrayList<String>();
        ArrayList<String> itempaths = new ArrayList<String>();
        ArrayList<String> itemfiles = new ArrayList<String>();
        ArrayList<String> itemfileexts = new ArrayList<String>();
        ArrayList<String> itemfilesnoext = new ArrayList<String>();
        File file = new File(fileToRun).getAbsoluteFile();
        itemfilepaths.add(file.getAbsolutePath());
        itempaths.add(file.getParent());
        itemfiles.add(file.getName());
        itemfileexts.add(FileTools.getExtension(file.getName()));
        itemfilesnoext.add(FileTools.removeExtension(file.getName()));
        for (String nameOfSupportedFile : namesOfSupportedFiles) {
            if (nameOfSupportedFile.equals(fileToRun)) continue;
            file = new File(nameOfSupportedFile).getAbsoluteFile();
            itemfilepaths.add(file.getAbsolutePath());
            itempaths.add(file.getParent());
            itemfiles.add(file.getName());
            itemfileexts.add(FileTools.getExtension(file.getName()));
            itemfilesnoext.add(FileTools.removeExtension(file.getName()));
        }
        environment.put("itemPathAndFile", itemfilepaths.get(0));
        environment.put("itemPath", itempaths.get(0));
        environment.put("itemFile", itemfiles.get(0));
        environment.put("itemFileExt", itemfileexts.get(0));
        environment.put("itemType", itemfileexts.get(0));
        environment.put("itemFileNoExt", itemfilesnoext.get(0));
        environment.put("itemPathsAndFiles", itemfilepaths.toArray());
        environment.put("itemPaths", itempaths.toArray());
        environment.put("itemFiles", itemfiles.toArray());
        environment.put("itemFilesExt", itemfileexts.toArray());
        environment.put("itemFilesNoExt", itemfilesnoext.toArray());
        if (isGame) {
            Scanner scanner = new Scanner(game.getKeyValuePairs());
            scanner.useDelimiter("\r\n|[\n\r\u2028\u2029\u0085]");
            while (scanner.hasNext()) {
                String keyAndValue = scanner.next();
                environment.put("keyAndValue_" + StringTools.beforeEqualsign(keyAndValue).toLowerCase(), StringTools.afterEqualsign(keyAndValue));
            }
        }
        return environment;
    }
}

