/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.model.Database;
import jgamebase.model.Databases;
import jgamebase.model.Plugins;
import jgamebase.plugins.Extractor;
import jgamebase.tools.FileTools;
import jgamebase.tools.IniFileManager;
import jgamebase.tools.ListerTools;
import jgamebase.tools.TempDir;

public class Overlays {
    private static String latestFilename = "";
    private static int latestVersion = -1;

    private Overlays() {
    }

    public static void init() {
        if (Const.FHS) {
            File overlayDir_ro = new File(Const.GBDIR_RO, "Overlays");
            File overlayDir_rw = new File(Const.GBDIR_RW, "Overlays");
            List<String> overlays = ListerTools.list_Dirs_Files_Paths(overlayDir_ro.toString(), false, true, false);
            overlays.forEach(overlay -> {
                File src = new File(overlayDir_ro, (String)overlay);
                File dst = new File(overlayDir_rw, (String)overlay);
                if (!dst.exists() || dst.length() == 0L) {
                    try {
                        Const.log.info((Object)("Found overlay \"" + overlay + "\", copying to directory \"" + overlayDir_rw + "\"."));
                        FileTools.copyFile(src, dst);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private static void deleteOldFile() {
        File file = new File(Databases.getCurrent().getPath(), "overlay_installed");
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {}
        }
    }

    public static void findLatestVersion(Database database) {
        Overlays.deleteOldFile();
        latestFilename = "";
        latestVersion = -1;
        File dir = new File(Const.GBDIR_RW, "Overlays");
        File iniFile = new File(new File(Const.GBDIR_RW, "Overlays"), "overlays.ini");
        IniFileManager ini = null;
        if (iniFile.exists()) {
            try {
                ini = new IniFileManager(iniFile);
            }
            catch (IOException iOException) {}
        }
        if (ini != null) {
            List<String> names = ini.getSectionNames();
            for (String name : names) {
                if (JGameBase.option_debug) {
                    Const.log.info((Object)("Found entry for overlay '" + name + "'"));
                }
                List<String> patterns = ini.getList(name);
                for (String patternString : patterns) {
                    if (JGameBase.option_debug) {
                        Const.log.info((Object)("Found pattern '" + patternString + "'"));
                    }
                    try {
                        Pattern pattern = Pattern.compile(patternString.toLowerCase());
                        boolean matchFound = false;
                        Matcher matcher = pattern.matcher(database.getName().toLowerCase());
                        if (matcher.matches()) {
                            matchFound = true;
                            if (JGameBase.option_debug) {
                                Const.log.info((Object)("Match found for pattern '" + patternString + "' in database name '" + database.getName() + "'"));
                            }
                        }
                        if ((matcher = pattern.matcher(database.getDisplayName().toLowerCase())).matches()) {
                            matchFound = true;
                            if (JGameBase.option_debug) {
                                Const.log.info((Object)("Match found for pattern '" + patternString + "' in database display name '" + database.getDisplayName() + "'"));
                            }
                        }
                        if (!matchFound) continue;
                        List<String> allFilenames = ListerTools.list_Dirs_Files_Paths(dir.getAbsolutePath(), false, true, false);
                        ArrayList matchingFilenames = new ArrayList();
                        matchingFilenames.addAll(allFilenames.stream().filter(overlayFilename -> overlayFilename.matches(String.valueOf(name) + "\\.overlay\\.\\d{8}+\\.zip")).collect(Collectors.toList()));
                        if (matchingFilenames.size() > 0) {
                            String filename;
                            Collections.sort(matchingFilenames);
                            latestFilename = filename = (String)matchingFilenames.get(matchingFilenames.size() - 1);
                            int pos = name.length() + ".overlay.".length();
                            String versionString = filename.substring(pos, pos + 8);
                            try {
                                latestVersion = Integer.parseInt(versionString);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (latestVersion > 0) {
                            return;
                        }
                        latestFilename = "";
                        latestVersion = -1;
                        Const.log.info((Object)("Found overlay match for '" + name + "' in database '" + database.getName() + ": " + database.getDisplayName() + "', but no matching overlay file was found."));
                    }
                    catch (PatternSyntaxException pse) {
                        Const.log.warn((Object)("Problem with regular expression for overlay '" + name + "':"));
                        Const.log.warn((Object)pse.getMessage());
                    }
                }
            }
        }
    }

    public static void installLatestVersion(Database database) {
        File dir = new File(Const.GBDIR_RW, "Overlays");
        Const.log.info((Object)("Extracting overlay '" + latestFilename + "'..."));
        try {
            TempDir.cleanPath();
            TempDir.getPath();
            Extractor extractor = Plugins.getExtractorForExtension("zip");
            extractor.extractToDir(new File(dir, latestFilename).getAbsolutePath(), TempDir.getPath().getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FileTools.copyDir(TempDir.getPath(), database.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getLatestVersion() {
        return latestVersion;
    }
}

