/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jgamebase.Const;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.model.Paths;

public class Path {
    private List<File> dirs = new ArrayList<File>();
    private final String defaultDirname;

    public Path(String defaultDirname) {
        this.defaultDirname = defaultDirname;
    }

    public List<File> get() {
        return this.dirs;
    }

    public void set(List<File> dirs) {
        this.dirs = dirs;
    }

    public List<File> getWithDefault() {
        ArrayList<File> dirsWithDefault = new ArrayList<File>(this.dirs);
        dirsWithDefault.add(this.getDefault_rw());
        if (!this.getDefault_rw().equals(this.getDefault_ro())) {
            dirsWithDefault.add(this.getDefault_ro());
        }
        return dirsWithDefault;
    }

    public File getDefault_rw() {
        return new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), this.defaultDirname);
    }

    public File getDefault_ro() {
        return new File(new File(Const.GBDIR_RO, Databases.getCurrent().getName()), this.defaultDirname);
    }

    public File find(File fileToFind) {
        if (fileToFind == null || fileToFind.getPath().isEmpty()) {
            return null;
        }
        File file = null;
        for (File dir : this.getWithDefault()) {
            file = new File(dir, fileToFind.toString().trim());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public File findAndWarn(File fileToFind) {
        File found = this.find(fileToFind);
        if (found != null) {
            return found;
        }
        Gui.displayWarningDialog("File '" + fileToFind + "' not found.");
        return null;
    }

    public File whichBasePath(File fileToFind) {
        File file = null;
        for (File dir : this.getWithDefault()) {
            file = new File(dir, fileToFind.toString().trim());
            if (!file.exists()) continue;
            return dir;
        }
        return null;
    }

    public File getRelativePathFor(File fileToFind) {
        if (!fileToFind.isAbsolute()) {
            throw new IllegalArgumentException("File must be absolute");
        }
        String absolute = fileToFind.getAbsolutePath();
        for (File dir : this.getWithDefault()) {
            String base = dir.getAbsolutePath();
            if (!absolute.startsWith(base)) continue;
            return new File(absolute.substring(base.length() + 1, absolute.length()));
        }
        return null;
    }

    public boolean exists(File file) {
        return this.find(file) != null;
    }

    public String findCorrectFilename(File fileToFind) {
        File tmp = new File(fileToFind.toString().trim());
        ArrayList<String> paths = new ArrayList<String>();
        while (tmp.getParentFile() != null) {
            paths.add(0, tmp.getName());
            tmp = tmp.getParentFile();
        }
        paths.add(0, tmp.getName());
        block1: for (File dir : this.getWithDefault()) {
            String correct = "";
            for (String path : paths) {
                boolean found = false;
                File dirToList = new File(dir, correct);
                String[] potentialMatches = dirToList.list();
                if (potentialMatches != null) {
                    String[] stringArray = potentialMatches;
                    int n = potentialMatches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String potentialMatche = stringArray[n2];
                        if (path.equalsIgnoreCase(potentialMatche)) {
                            found = true;
                            correct = new File(correct, potentialMatche).toString();
                        }
                        ++n2;
                    }
                }
                if (!found) continue block1;
            }
            File file = new File(dir, correct);
            if (!file.exists()) continue;
            return Paths.pathStartingWithoutSeparator(correct);
        }
        return null;
    }
}

