/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jgamebase.Const;
import jgamebase.tools.TempDir;

class RunningGame {
    protected final Process process;
    protected final TempDir tempDir;
    protected Thread logger = null;

    RunningGame(final Process process, TempDir tempDir) {
        this.process = process;
        this.tempDir = tempDir;
        this.logger = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var3_3 = null;
                    try (BufferedReader stdOutErr = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line;
                        while (!RunningGame.this.logger.isInterrupted() && (line = stdOutErr.readLine()) != null) {
                            Const.log.info((Object)line);
                        }
                        Const.log.info((Object)"");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        });
        this.logger.start();
    }

    public synchronized void stop() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.logger != null) {
            this.logger.interrupt();
        }
        if (this.tempDir != null) {
            this.tempDir.close();
        }
    }

    public boolean isAlive() {
        if (this.process != null) {
            return this.process.isAlive();
        }
        return false;
    }
}

