/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.plugins.diskinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import jgamebase.Const;
import jgamebase.plugins.DiskInfo;

public class ADF
implements DiskInfo {
    private static final String[] supportedExtensions = new String[]{"adf"};
    private static final int BYTES_PER_SECTOR = 512;
    private static final int SECTORS_PER_TRACK = 11;
    private static final int TRACKS_PER_CYLINDER = 2;
    private static final int CYLINDERS_PER_DISK = 80;
    private static final int SECTORS_PER_DISK = 1760;
    private static final int IMAGE_SIZE = 901120;
    private static final int OFFSET_CHECKSUM = 4;
    private static final int OFFSET_ROOT_BLOCK_NUMBER = 8;
    private static final int DEFAULT_ROOT_BLOCK_NUMBER = 880;
    private byte[] nativeDisk;
    private String header;
    private String footer;
    private boolean isDosDisk = false;
    private long rootBlockNumber;
    private long storedRootChecksum;
    private long calculatedChecksum;

    public ADF() {
        Const.log.info((Object)"Loaded plugin: disk info 'ADF'.");
    }

    @Override
    public void load(String filename) throws IOException {
        File file = new File(filename);
        int filesize = (int)file.length();
        this.nativeDisk = new byte[filesize];
        this.header = "";
        this.footer = "";
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        FileInputStream input = new FileInputStream(filename);
        input.read(this.nativeDisk);
        input.close();
        this.isDosDisk = false;
        if (this.getByteAt(0) == 68 && this.getByteAt(1) == 79 && this.getByteAt(2) == 83) {
            this.isDosDisk = true;
        }
        this.storedRootChecksum = this.getLongAt(4);
        this.calculateRootChecksum();
        this.rootBlockNumber = this.getLongAt(8);
        if (this.rootBlockNumber == 880L) {
            int length = this.getByteAt((int)(512L * this.rootBlockNumber + 512L - 80L));
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < length) {
                sb.append(Character.valueOf((char)this.getByteAt((int)(512L * this.rootBlockNumber + 512L - 79L + (long)i))));
                ++i;
            }
            this.header = sb.toString();
        }
    }

    private void calculateRootChecksum() {
        long checksum = 0L;
        long precsum = 0L;
        int i = 0;
        while (i < 256) {
            if (i != 1 && ((checksum = (precsum = checksum) + this.getLongAt(i * 4)) & 0xFFFFFFFFL) < (precsum & 0xFFFFFFFFL)) {
                ++checksum;
            }
            ++i;
        }
        this.calculatedChecksum = (checksum ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
    }

    @Override
    public String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    @Override
    public boolean supportsExtension(String extensionToFind) {
        extensionToFind = extensionToFind.toLowerCase();
        String[] stringArray = supportedExtensions;
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            String extension = supportedExtension.toLowerCase();
            if (extension.equals(extensionToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int getByteAt(int pos) {
        return this.nativeDisk[pos] & 0xFF;
    }

    private long getLongAt(int pos) {
        return ((long)(this.getByteAt(pos) << 24) & 0xFF000000L | (long)(this.getByteAt(pos + 1) << 16) & 0xFF0000L | (long)(this.getByteAt(pos + 2) << 8) & 0xFF00L | (long)this.getByteAt(pos + 3) & 0xFFL) & 0xFFFFFFFFL;
    }

    @Override
    public String[] getDirectory() {
        String[] entries = new String[]{};
        return entries;
    }

    @Override
    public String getFilenameAt(int pos) {
        return "";
    }

    @Override
    public String getNativeFilenameAt(int pos) {
        return "";
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public String getFooter() {
        return this.footer;
    }

    @Override
    public boolean isBootable() {
        return this.isDosDisk && this.storedRootChecksum == this.calculatedChecksum;
    }
}

