/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.plugins.diskinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jgamebase.Const;
import jgamebase.plugins.DiskInfo;

public class T64
implements DiskInfo {
    private static final String[] supportedExtensions = new String[]{"t64"};
    private static final String IDENTIFIER = "C64";
    private static final int OFFSET_START = 0;
    private static final int OFFSET_IDENTIFIER = 0;
    private static final int OFFSET_IDENTIFIEREND = 3;
    private static final int OFFSET_DIR_ENTRIES = 36;
    private static final int OFFSET_NAME = 40;
    private static final int OFFSET_DIR_START = 64;
    private static final int DIR_ENTRY_SIZE = 32;
    private static final int[] cbmToAscii = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 32, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 126};
    private byte[] cbmTape;
    private String header;
    private String footer;
    private List<CbmFile> cbmFiles;

    public T64() {
        Const.log.info((Object)"Loaded plugin: disk info 'T64'.");
    }

    @Override
    public void load(String filename) throws IOException {
        File file = new File(filename);
        int filesize = (int)file.length();
        this.cbmTape = new byte[filesize];
        this.header = "";
        this.footer = "";
        this.cbmFiles = new ArrayList<CbmFile>();
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        FileInputStream input = new FileInputStream(filename);
        input.read(this.cbmTape);
        input.close();
        String identifier = this.bufferToString(0, 3);
        if (!identifier.equals(IDENTIFIER)) {
            throw new FileNotFoundException(filename);
        }
        StringBuilder headerSb = new StringBuilder("\"");
        int i = 0;
        while (i < 24) {
            headerSb.append(Character.valueOf((char)cbmToAscii[this.getCbmTapeValue(40 + i)]));
            ++i;
        }
        this.header = headerSb.append("\"").toString();
        int entry_count = this.getCbmTapeValue(36) + 256 * this.getCbmTapeValue(37);
        int i2 = 0;
        while (i2 < entry_count) {
            CbmFile cbmFile = this.readDirectoryEntry(64 + i2 * 32);
            this.cbmFiles.add(cbmFile);
            ++i2;
        }
    }

    private CbmFile readDirectoryEntry(int dataPosition) {
        CbmFile file = new CbmFile();
        file.setType(this.getCbmTapeValue(dataPosition + 1) & 7);
        int position = 0;
        while (position <= 15) {
            file.setNativeName(String.valueOf(file.getNativeName()) + (char)this.getCbmTapeValue(dataPosition + 16 + position));
            file.setName(String.valueOf(file.getName()) + (char)cbmToAscii[this.getCbmTapeValue(dataPosition + 16 + position)]);
            ++position;
        }
        file.setName(file.getName().trim());
        String nativeName = file.getNativeName().trim().toLowerCase();
        nativeName = this.replaceAll(nativeName, '[', '{');
        nativeName = this.replaceAll(nativeName, ']', '}');
        file.setNativeName(nativeName);
        file.setNativeName(file.getNativeName().toLowerCase().trim());
        file.setSize((this.getCbmTapeValue(dataPosition + 4) + this.getCbmTapeValue(dataPosition + 5) * 256 - (this.getCbmTapeValue(dataPosition + 2) + this.getCbmTapeValue(dataPosition + 3) * 256)) / 256);
        return file;
    }

    private String replaceAll(String s, char what, char withWhat) {
        while (s.indexOf(what) != -1) {
            s = s.replace(what, withWhat);
        }
        return s;
    }

    private int getCbmTapeValue(int position) {
        return this.cbmTape[position] & 0xFF;
    }

    private String bufferToString(int start, int end) {
        StringBuilder s = new StringBuilder();
        int i = start;
        while (i < end) {
            s.append((char)this.getCbmTapeValue(i));
            ++i;
        }
        return s.toString();
    }

    @Override
    public String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    @Override
    public boolean supportsExtension(String extensionToFind) {
        extensionToFind = extensionToFind.toLowerCase();
        String[] stringArray = supportedExtensions;
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            String extension = supportedExtension.toLowerCase();
            if (extension.equals(extensionToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String[] getDirectory() {
        String[] entries = new String[this.cbmFiles.size()];
        this.cbmFiles.forEach(cbmFile -> {
            String string = cbmFile.toString();
        });
        return entries;
    }

    @Override
    public String getFilenameAt(int pos) {
        return this.cbmFiles.get(pos).getName();
    }

    @Override
    public String getNativeFilenameAt(int pos) {
        return this.cbmFiles.get(pos).getNativeName();
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public String getFooter() {
        return this.footer;
    }

    @Override
    public boolean isBootable() {
        return false;
    }

    static class CbmFile {
        private int type = 0;
        private String name = "";
        private String nativeName = "";
        private int size = 0;
        private final String[] types = new String[]{"DEL", "SEQ", "PRG", "USR", "REL"};

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getNativeName() {
            return this.nativeName;
        }

        public void setType(int b) {
            this.type = b;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setNativeName(String string) {
            this.nativeName = string;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int i) {
            this.size = i;
        }

        public String getFileType(int type) {
            return this.types[type];
        }

        public String toString() {
            Object[] param = new Object[]{this.size, "\"" + this.name + "\"", this.types[this.type]};
            return String.format("%1$-4s %2$-18s %3$s", param);
        }
    }
}

