/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.plugins.extractor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jgamebase.Const;
import jgamebase.model.Paths;
import jgamebase.plugins.Extractor;

public class Zip
implements Extractor {
    private static final String[] supportedExtensions = new String[]{"zip"};
    private final byte[] buffer = new byte[8192];

    public Zip() {
        Const.log.info((Object)("Loaded plugin: extractor '" + supportedExtensions[0].toUpperCase() + "'."));
    }

    @Override
    public String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    @Override
    public boolean supportsExtension(String extensionToFind) {
        extensionToFind = extensionToFind.toLowerCase();
        String[] stringArray = supportedExtensions;
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            String extension = supportedExtension.toLowerCase();
            if (extension.equals(extensionToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public List<String> extractToDir(String filename, String dir) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        Const.log.info((Object)("Extract file '" + filename + "' to dir '" + dir + "'."));
        ZipFile zipFile = new ZipFile(filename);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            Const.log.info((Object)("extract '" + entry.getName() + "'"));
            String entryFilename = new File(dir, entry.getName()).toString();
            if (entry.isDirectory()) {
                new File(entryFilename).mkdirs();
                continue;
            }
            InputStream in = zipFile.getInputStream(entry);
            new File(Paths.getPathOnly(entryFilename)).mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFilename));
            while ((len = in.read(this.buffer)) >= 0) {
                ((OutputStream)out).write(this.buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            fileNames.add(new File(dir, entry.getName()).toString());
        }
        zipFile.close();
        return fileNames;
    }
}

