/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.StringTokenizer;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.model.Databases;

public class SystemTools {
    public static boolean isOtherInstanceRunning() {
        FileLock fileLock = null;
        try {
            fileLock = new RandomAccessFile(Const.LOCKFILE, "rw").getChannel().tryLock();
            if (fileLock == null) {
                Const.log.info((Object)("failed to lock file '" + Const.LOCKFILE.getAbsolutePath() + "'.\nExiting..."));
                return true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    private static String[] toCmdArray(String command) {
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return cmdarray;
    }

    public static void execScript(String command) {
        new File(command).setExecutable(true, false);
        SystemTools.exec(SystemTools.toCmdArray(command));
    }

    public static void exec(String[] command) {
        block15: {
            BufferedReader stderr = null;
            try {
                try {
                    Process process = Runtime.getRuntime().exec(command, SystemTools.getSystemEnvironment());
                    stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String line = null;
                    while ((line = stderr.readLine()) != null) {
                        Const.log.info((Object)line);
                    }
                    process.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    if (stderr != null) {
                        try {
                            stderr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (stderr != null) {
                    try {
                        stderr.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stderr != null) {
                try {
                    stderr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void open(URI uri) {
        Desktop desktop = null;
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                SystemTools.openWithOsCommand(uri);
            }
            catch (IOException iOException) {}
        }
        SystemTools.openWithOsCommand(uri);
    }

    private static void openWithOsCommand(URI uri) {
        Const.log.info((Object)("Opening URI '" + uri + "' with OS command '" + Databases.getCurrent().getPreferences().get("extra_open_document_cmd") + "'."));
        SystemTools.exec(new String[]{Databases.getCurrent().getPreferences().get("extra_open_document_cmd"), uri.toString()});
    }

    public static void handleFatalError(Throwable e) {
        StackTraceElement[] trace;
        String message = "A fatal error occured:\n" + e + ".\n\nThe program will write debug information and exit.\n\n";
        message = String.valueOf(message) + "Please try to reproduce the error and find out which specific action triggers it.\nThen check the bug tracking system at \n  '" + Const.URI_BUGTRACKING + "'\n" + "to see if the error has already been reported.\n" + "If you found a new error please enter a bug report.";
        message = String.valueOf(message) + "\n\nThanks in advance.";
        Const.log.error((Object)"\n\n");
        JGameBase.displayError(message);
        Const.log.error((Object)"*** option_dangerous INFORMATION START ***");
        Const.log.error((Object)("OS:      " + System.getProperty("os.name") + " on " + System.getProperty("os.arch")));
        Const.log.error((Object)("JAVA:    " + System.getProperty("java.vendor") + " Version " + System.getProperty("java.version") + " Class-Version " + System.getProperty("java.class.version")));
        Const.log.error((Object)"PROGRAM: jGameBase V0.71-4 (2023-11-24)");
        Const.log.error((Object)("ERROR: " + e));
        StackTraceElement[] stackTraceElementArray = trace = e.getStackTrace();
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            Const.log.error((Object)("\tat " + element));
            ++n2;
        }
        Const.log.error((Object)"*** option_dangerous INFORMATION END ***");
        Const.log.error((Object)"");
        Const.log.error((Object)"");
        Const.log.error((Object)"Exiting...");
    }

    public static String[] getSystemEnvironment() {
        Map<String, String> sysEnv = System.getenv();
        String[] env = new String[sysEnv.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : sysEnv.entrySet()) {
            env[i++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        return env;
    }
}

