package sidplay.audio;

public class Audio_Null extends AudioBase {

	private boolean isOpen;

	public Audio_Null() {
		isOpen = false;
	}

	@Override
	public byte[] open(AudioConfig cfg, String name) {
		int /* uint_least32_t */bufSize = cfg.bufSize;

		if (isOpen) {
			_errorString = "NULL ERROR: Audio device already open.";
			return null;
		}

		if (bufSize == 0) {
			bufSize = (int) (cfg.frequency * cfg.precision / 8 * cfg.channels);
			bufSize /= 4;
		}

		// We need to make a buffer for the user
		_sampleBuffer = new byte[bufSize];

		isOpen = true;
		cfg.bufSize = bufSize;
		_settings = cfg;
		
		return _sampleBuffer;
	}

	@Override
	public byte[] write() {
		if (!isOpen) {
			_errorString = "NULL ERROR: Audio device not open.";
			return null;
		}
		return _sampleBuffer;
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public void close() {
		if (!isOpen)
			return;
		_sampleBuffer = null;
		isOpen = false;
	}

	@Override
	public void reset() {
	}

}
