// **********************************
// * FUSE Default Javascript Script *
// *        (C) by F. Gerbig        *
// *           01.11.2011           *
// *                                *
// *            based on            *
// *  WinVICE Default GEMUS Script  *
// *        (c) The GB64 Team       *
// *          8 August 2007         *
// *             and on             *
// *           "vice.sh"            *
// *        (C) by F. Gerbig        *
// *           2006, 2007           *
// **********************************
// 
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
// 
//  Emulator File: fuse
//  Emulator configuration file: 
//  File Types: z80;szx;sna;zxs;snp;tzx;tap;spc;sta;ltp;rzx;dsk;fdi;sad;scl;td0;trd;udi;dck;hdf;mdr
// 
//  This script was written for FUSE v0.10.0.2,
//  but may work with other versions too.
// 
//  Emulator Website: http://fuse-emulator.sourceforge.net/

command = "fuse";
Add_CLP(command);

// print all variables (remove for production)
Dump();

if (itemType.contains("z80", "szx", "sna", "zxs", "snp", "tzx", "tap", "spc", "sta", "ltp", "rzx", "dsk", "fdi", "sad", "scl", "td0", "trd", "udi", "dck", "hdf", "mdr")) {

Add_CLP(itemPathAndFile);

	// set the item controls
	// These settings are designed to automatically set the controls for player 1
	// to the same controller, regardless of which PORT the item uses for player 1.
	// 
	// 0=None, 1=numpad, 2=custom keyset 1, 3=custom keyset 2, 4=joystick 1, 5=joystick 2
	// 
	// Replace * with <DISABLED> to disable the automatic settings for the JoyPorts
//	if (itemFile.contains("*")) {
//		if (itemControl === JOYPORT2) {

//			// set joystick 2
//			if (useHardwareJoystick) {
//				Add_CLP("-joydev2", "4"); // joystick 1
//			} else {
//				Add_CLP("-joydev2", "2"); // custom keyset 1
//			}	

//			// set joystick 1
//			if (itemPlayersMax > 1) {
//				if (useHardwareJoystick) {
//					Add_CLP("-joydev1", "5"); // joystick 2 
//				} else {
//					Add_CLP("-joydev1", "3"); // custom keyset 2 
//				}	
//			} else { 
//				Add_CLP("-joydev1", "0"); // no joystick
//			}

//		} else if (itemControl === JOYPORT1) {

//			// set joystick 1
//			if (useHardwareJoystick) {
//				Add_CLP("-joydev1", "4"); // joystick 1
//			} else {
//				Add_CLP("-joydev1", "2"); // custom keyset 1
//			}	

//			// set joystick 2
//			if (itemPlayersMax > 1) {
//				if (useHardwareJoystick) {
//					Add_CLP("-joydev2", "5"); // joystick 2 
//				} else {
//					Add_CLP("-joydev2", "3"); // custom keyset 2
//				}	
//			} else { 
//				Add_CLP("-joydev2", "0"); // no joystick
//			}

//		} else { // keyboard
//			// Disable Joysticks and Mouse
//			Add_CLP("-joydev1", "0");
//			Add_CLP("-joydev2", "0");
//		}
//	}

	// unsupported item controls
	if (itemControl === LIGHTPEN) {
		Show_Message("This emulator does not have LightPen emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === KOALAPAD) {
		Show_Message("This emulator does not have KoalaPad emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === LIGHTGUN) {
		Show_Message("This emulator does not have LightGun emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT1) {
		Show_Message("This emulator does not have Paddle emulation.\n\nMouse Port1 setting may allow partial control via the mouse.\n\nThis item may still be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT2) {
		Show_Message("This emulator does not have Paddle emulation.\n\nMouse Port2 setting may allow partial control via the mouse.\n\nThis item may still be uncontrollable/unplayable.");
	}

	// give the user a warning message?
	if (itemVersionComment.contains("*not 100%*", "*not working*", "*doesn't work*")) { 
		Show_Message("This item may not work properly.");
	}
	if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
		// point out that critical info is in the version comment
		Show_Message("Read this item's Version Comments for very important information/instructions.");
	}

	// show message for the user
	if (Value("msg").contains("*")) {
		Show_Message(Value("msg"));
	}

	// run the emulator
	Run_Emulator();

} else { 

	// invalid item file type
	Show_Message(NOT_SUPPORTED + "\n\nSupported types: Z80, SZX, SNA, ZXS, SNP, TZX, TAP, SPC, STA, LTP, RZX, DSK, FDI, SAD, SCL, TD0, TRD, UDI, DCK, HDF, MDR");

}



