// **********************************
// *    Audio Overload JavaScript   *
// *        (C) by F. Gerbig        *
// *           10.12.2022           *
// **********************************
//
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
//
//  Emulator File: deadbeef.js
//  Emulator configuration file:
//  File Types: mod;sc68;snd;sndh;ym


// look for play command
command = findInPath("deadbeef");
// if command was not found, look further
if (!command) {
    command = "/opt/deadbeef/bin/deadbeef"
    println("deadbeef not found in path, looking in " + command + ".");
    if (! new File(command).exists()) {
        command = emulatorPath + "/db/deadbeef";
        println("deadbeef not found in /opt/deadbeef/bin/deadbeef, looking in script directory " + command + ".");
        if (! new File(command).exists()) {
            println("deadbeef not found in script directory " + command + ".");
            Show_Message("Could not find deadbeef (neither in path, nor in /opt/deadbeef/bin/deadbeef nor in script directory " + command + ".");
            throw ''; // end script
        }
    }
}
Add_CLP(command)

// empty queue by deleting the dbpl (deadbeef playlists) in ~/.config
// !!! ugly hack, because deadbeef has no option to clear the queue !!!
var playlist;

var home = Packages.java.lang.System.getProperty("user.home");
for(let i = 0; i < 5; i++) {
    playlist = new File(home + "/.config/deadbeef/playlists/" + i + ".dbpl");
    if (playlist.exists()) {
        playlist.delete();
    }
}

// queue and play media file
Add_CLP("--play-queue", itemPathAndFile);

// print all variables
Dump();

// run the emulator
Run_MusicEmulator();

