// **********************************
// *   JSwingC64 Javascript Script  *
// *        (C) by F. Gerbig        *
// *           28.10.2011           *
// *                                *
// *            based on            *
// *  WinVICE Default GEMUS Script  *
// *        (c) The GB64 Team       *
// *          8 August 2007         *
// *             and on             *
// *           "vice.sh"            *
// *        (C) by F. Gerbig        *
// *            2006-2010           *
// **********************************
// 
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
// 
//  Emulator File: jswingc64
//  Emulator configuration file: JSwingC64.properties.xml
//  File Types: d64;t64;prg;p00
// 
//  This script was written for jSwingC64 v1.10.2a,
//  but may work with other versions too.
// 
//  Emulator Website: http://sourceforge.net/projects/jmec64/
// 
//  if VICE requires True Drive Emulation use the key=value pair: vtde=yes

command = "java";
Add_CLP(command);
Add_CLP("-jar", emulatorPath + java.io.File.separator + "jswingc64.jar");

// print all variables (remove for production)
Dump();

if (itemType.contains("d64", "t64", "prg", "p00")) {

		// autostart or 'manual load' the item image
	if (itemVersionComment.contains("*load manually*")) {
		Show_Message("This program should be loaded manually.");
	} else { 
		Add_CLP(itemPathAndFile);
	}

	// true drive emulation ("vtde=yes is for VICE only, not CCS64");
	// set GEMUS key "vtde" to overrule database isRunsOnTrueDrive settings
	if ((isRunsOnTrueDrive) || Value("vtde").contains(true)) {
		Set_CFG_Item(emulatorConfigFile, "<entry key=\"DriveMode\">", "", "100</entry>");
	} else { 
		Set_CFG_Item(emulatorConfigFile, "<entry key=\"DriveMode\">", "", "50</entry>");
	}

	// set the item controls
	// These settings are designed to automatically set the controls for player 1
	// to the same controller, regardless of which PORT the item uses for player 1.
	if (itemControl === JOYPORT1) {
		// set joystick 1
		Set_CFG_Item(emulatorConfigFile, "<entry key=\"JoystickPort\">", "", "0</entry>");
	} else {
		// set joystick 2
		Set_CFG_Item(emulatorConfigFile, "<entry key=\"JoystickPort\">", "", "1</entry>");
	}

	// unsupported item controls
	if (itemControl === LIGHTPEN) {
		Show_Message("This emulator does not have LightPen emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === KOALAPAD) {
		Show_Message("This emulator does not have KoalaPad emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === LIGHTGUN) {
		Show_Message("This emulator does not have LightGun emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT1) {
		Show_Message("This emulator does not have Paddle emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT2) {
		Show_Message("This emulator does not have Paddle emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === MOUSE) {
		Show_Message("This emulator does not have Mouse emulation.\n\nThis item may be uncontrollable/unplayable.");
	}

	// give the user a warning message?
	if (itemVersionComment.contains("*use C64S*", "*use CCS*", "*use real C64*")) {
		Show_Message("This item may not work properly with this emulator.\n\nSee Version Comment for more info.");
	}
	if (itemVersionComment.contains("*not 100%*", "*not working*", "*doesn't work*")) { 
		Show_Message("This item may not work properly.");
	}
	if (itemVersionComment.contains("*PET Emulator*")) {
		Show_Message("Use PET Emulator to run this item.");
	}
	if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
		// point out that critical info is in the version comment
		Show_Message("Read this item's Version Comments for very important information/instructions.");
	}
	if (itemVersionComment.contains("*VIC-20*", "*VIC20*", "*VC-20*", "*VC20*")) {
		if (itemVersionComment.contains("*emulator*")) {
			Show_Message("Use VIC-20 column Emulator to run this item properly.");
		}
	}

	// show message for the user
	if (Value("msg").contains("*")) {
		Show_Message(Value("msg"));
	}

	// run the emulator
	Run_Emulator();

} else { 

	// invalid item file type
	Show_Message(NOT_SUPPORTED + "\n\nSupported types: D64, T64, PRG, P00");

}



