// **********************************
// *    FS-UAE Javascript Script    *
// *        (C) by F. Gerbig        *
// *           07.12.2022           *
// *                                *
// *            based on            *
// *    UAE Default GEMUS Script    *
// *      (c) The GB Amiga Team     *
// **********************************

command = "fs-uae";
Add_CLP(command);
Add_CLP(emulatorConfigFile);

Dump();

var chipset = "OCS";
if (Value("chipset").contains("*")) {
  chipset = Value("chipset");
}

var cpu_type = "68000";
if (Value("cpu_type").contains("*")) {
  cpu_type = Value("cpu_type");
}

var chip_memory=512;
if (Value("chipmem_size").contains("*")) {
  chip_memory = Value("chipmem_size") * 512;
}

var slow_memory=0;
if (Value("bogomem_size").contains("*")) {
  slow_memory = Value("bogomem_size") * 256;
}

var fast_memory=0;
if (Value("fastmem_size").contains("*")) {
  fast_memory = Value("fastmem_size") * 1024;
}

var model = "A500";
if (chipset.contains("*ECS*")) {
  model = "A500+";
}
if (cpu_type.contains("*20*")) {
  model = "A1200";
}

// [amiga]

Set_INI_Value(emulatorConfigFile, "amiga", "model", model);

Set_INI_Value(emulatorConfigFile, "amiga", "chip_memory", chip_memory);
Set_INI_Value(emulatorConfigFile, "amiga", "slow_memory", slow_memory);
Set_INI_Value(emulatorConfigFile, "amiga", "fast_memory", fast_memory);


// [media]

// remove old settings for floppies
Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_1", "");
Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_2", "");
Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_3", "");


var bootable = 1; // 0 = true, 1 = false

if (isBootable) {
  bootable = 0;
} else {
  bootable = 1;
  Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_0", "/home/frank/Desktop/Dateien/Software/Spiele/Emulation/Amiga/Workbench/Amiga Workbench 1.3.3 (34.34) - Boot (Commodore) (1991) [m].adf");
}

// 1st floppy
Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_" + (0 + bootable), itemPathsAndFiles[0]);
// 2nd floppy
if ((itemFiles.length > 1) && ( (Value("floppy1type=") != -1) || (Value("nr_floppies=1") > 1) ) ) {
  Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_" + (1 + bootable), itemPathsAndFiles[1]);
}
// 3rd floppy
if ((itemFiles.length > 2) && ( (Value("floppy2type=") != -1) || (Value("nr_floppies=1") > 2) ) ) {
  Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_" + (2 + bootable), itemPathsAndFiles[2]);
}
// 4th floppy
if ((itemFiles.length > 3) && ( (Value("floppy3type=") != -1) || (Value("nr_floppies=1") > 3) ) ) {
  Set_INI_Value(emulatorConfigFile, "media", "floppy_drive_" + (3 + bootable), itemPathsAndFiles[3]);
}


// delete paths of old floppy images
for (var i = 0; i < 25; i++) {
  Set_INI_Value(emulatorConfigFile, "media", "floppy_image_" + i, "");
}
// set paths of floppy images
for (var i = 0; i < itemFiles.length; i++) {
  Set_INI_Value(emulatorConfigFile, "media", "floppy_image_" + i, itemPathsAndFiles[i]);
}
Set_INI_Value(emulatorConfigFile, "media", "floppy_image_" + itemFiles.length, "/home/frank/Desktop/Dateien/Software/Spiele/Emulation/Amiga/Workbench/Amiga Workbench 1.3.3 (34.34) - Boot (Commodore) (1991) [m].adf");


// [application]
Set_INI_Value(emulatorConfigFile, "application", "title", itemName);
Set_INI_Value(emulatorConfigFile, "application", "sub_title", "jGamebase");





//if (itemControl === JOYPORT1) {
//	Set_CFG_Value(emulatorConfigFile, "joyport0", "kbd1");
//	Set_CFG_Value(emulatorConfigFile, "joyport1", "kbd2");
///*  Set_CFG_Value("dbPath\WHDLoad.uae", "joyport0", "kbd1");*/
///*	Set_CFG_Value("dbPath\WHDLoad.uae", "joyport1", "kbd2");*/
//} else { 
//	Set_CFG_Value(emulatorConfigFile, "joyport0", "mouse1");
//	Set_CFG_Value(emulatorConfigFile, "joyport1", "kbd1");
///*  Set_CFG_Value("dbPath\WHDLoad.uae", "joyport0", "mouse1");*/
///*	Set_CFG_Value("dbPath\WHDLoad.uae", "joyport1", "kbd1");*/
//}

//var rom = dbPath + separator + "Roms" + separator + Value("kickstart_rom");
// check rom path
//if (! new File(rom).exists()) {
//	Show_Message("ROM-File '" + rom + "' could not be found.\nThe emulation will probably not run correctly!");
//}

//Set_CFG_Value(emulatorConfigFile, "kickstart_rom_file", rom);
//Set_CFG_Value(emulatorConfigFile, "floppy1type", Value("floppy1type"));
//Set_CFG_Value(emulatorConfigFile, "floppy2type", Value("floppy2type"));
//Set_CFG_Value(emulatorConfigFile, "floppy3type", Value("floppy3type"));
//Set_CFG_Value(emulatorConfigFile, "nr_floppies", Value("nr_floppies"));
//Set_CFG_Value(emulatorConfigFile, "sound_output", Value("sound_output"));
//Set_CFG_Value(emulatorConfigFile, "immediate_blits", Value("immediate_blits"));
//Set_CFG_Value(emulatorConfigFile, "ntsc", Value("ntsc"));
//Set_CFG_Value(emulatorConfigFile, "chipset", Value("chipset"));
//Set_CFG_Value(emulatorConfigFile, "chipset_compatible", Value("chipset_compatible"));
//Set_CFG_Value(emulatorConfigFile, "collision_level", Value("collision_level"));
//Set_CFG_Value(emulatorConfigFile, "fastmem_size", Value("fastmem_size"));
//Set_CFG_Value(emulatorConfigFile, "bogomem_size", Value("bogomem_size"));
//Set_CFG_Value(emulatorConfigFile, "chipmem_size", Value("chipmem_size"));
//Set_CFG_Value(emulatorConfigFile, "cpu_speed", Value("cpu_speed"));
//Set_CFG_Value(emulatorConfigFile, "finegrain_cpu_speed", Value("finegrain_cpu_speed"));
//Set_CFG_Value(emulatorConfigFile, "cpu_type", Value("cpu_type"));
//Set_CFG_Value(emulatorConfigFile, "cpu_model", Value("cpu_type"));
//Set_CFG_Value(emulatorConfigFile, "fpu_model", Value("fpu_model"));
//Set_CFG_Value(emulatorConfigFile, "cpu_compatible", Value("cpu_compatible"));
//Set_CFG_Value(emulatorConfigFile, "fpu_strict", Value("fpu_strict"));
//Set_CFG_Value(emulatorConfigFile, "cpu_24bit_addressing", Value("cpu_24bit_addressing"));
//Set_CFG_Value(emulatorConfigFile, "cpu_cycle_exact", Value("cpu_cycle_exact"));
//Set_CFG_Value(emulatorConfigFile, "blitter_cycle_exact", Value("blitter_cycle_exact"));
//Set_CFG_Value(emulatorConfigFile, "statefile", Value("statefile"));


if (itemVersionComment.contains("whd")) {
/*	Set_CFG_Item("dbPath\WHDLoad.uae", "filesystem2=rw,DH0:DH0", ":", "dbPath\whd,0");*/
/*	Set_CFG_Item("dbPath\WHDLoad.uae", "filesystem=rw,DH0", ":", "%dbpath\whd");*/
/*	Set_CFG_Item("dbPath\WHDLoad.uae", "filesystem2=rw,DH1:DH1", ":", "workPath\rezip\gameFileNoExt,0");*/
/*	Set_CFG_Item("dbPath\WHDLoad.uae", "filesystem=rw,DH1", ":", "workPath\rezip\gameFileNoExt);*/
/*	Set_CFG_Item(Value("dbpath%\WHD\s\user-startup", "cd", , "%cd"));*/
/*	Set_CFG_Item(Value("dbpath%\WHD\s\user-startup", "whdload", , "%whdload"));*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "immediate_blits", "%immediate_blits%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "chipset_compatible", "%chipset_compatible%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "collision_level", "%collision_level%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "z3mem_size", "%z3mem_size%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "cpu_speed", "%cpu_speed%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "finegrain_cpu_speed", "%finegrain_cpu_speed%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "cpu_type", "%cpu_type%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "fpu_model", "%fpu_model%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "cpu_compatible", "%cpu_compatible%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "fpu_strict", "%fpu_strict%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "cpu_24bit_addressing", "%cpu_24bit_addressing%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "cpu_cycle_exact", "%cpu_cycle_exact%);*/
/*	Set_CFG_Value("dbPath\WHDLoad.uae", "blitter_cycle_exact", "%blitter_cycle_exact%);*/
/*	Run_Program("dbPath\whdrun.exe", "%gamepathfile% workPath\rezip\gameFileNoExt/ "emulatorPath\winuae.exe" "dbPath\WHDLoad.uae" "dbPath\WHD\s\user-startup", "nowait");*/


/*	if ("itemPalNtsc = NTSC") {*/
/*		Set_CFG_Value("dbPath\WHDLoad.uae", "ntsc", "true");*/
/*	} else { */
/*		Set_CFG_Value("dbPath\WHDLoad.uae", "ntsc", "false");*/
/*	}*/

} else { 


//	for (var i = 0; i < itemFiles.length; i++) {
//		Add_CLP("-" + i, itemPathsAndFiles[i]);
//	}


	Run_Emulator();

}



