// **********************************
// * VICE Default Javascript Script *
// *        (C) by F. Gerbig        *
// *           05.03.2010           *
// *                                *
// *            based on            *
// *  WinVICE Default GEMUS Script  *
// *        (c) The GB64 Team       *
// *        16 December 2004        *
// *             and on             *
// *           "vice.sh"            *
// *        (C) by F. Gerbig        *
// *           2006, 2007           *
// **********************************
// 
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
// 
//  Emulator File: xvic
//  Emulator configuration file: vice.ini
//  File Types: d64;t64;g64;g41;tap;crt;p00;prg
// 
//  This script was written for VICE VIC20 v2.3,
//  but may work with other versions too.
// 
//  Emulator Website: http://www.viceteam.org
// 
//  Memory configuration is set through the key=value pair:
//  memory=x
//  where x is: none,all,3k,8k,16k,24k,"0,1,2,3,5" or "04,20,40,60,A0"
//  as specified in the VICE manual section 7.2.2.2
//  (Note: the Memory Expansion field can not be used by GEMUS)
// 
//  if the program requires a SYS call to start, then use:
//  sys=x
//  where x is the starting address as entered from BASIC
//  and it will be displayed in a REM statement in the emulator
// 
//  Multipart cartridges must have the memory locations in the file names.
//  The cartridge memory locations are set in the key=value pairs
//  cart=A
//  cart2=B
//  where A and B are 2000,4000,6000,a000 or b000 (or 20,40,60,a0 or b0).
//  Single carts may need to have a cart=A value set..

command = "xvic";
Add_CLP(command);

Add_CLP("-config", emulatorConfigFile);

// print all variables (remove for production)
Dump();

if (itemType.contains("d64", "t64", "g64", "g41", "tap", "crt", "p00", "prg")) {

	// set paths to file location for possible image swaps
//	Set_INI_Value(emulatorConfigFile, "VIC20", "InitialDiskDir", itemPath);
//	Set_INI_Value(emulatorConfigFile, "VIC20", "InitialTapeDir", itemPath);
//	Set_INI_Value(emulatorConfigFile, "VIC20", "InitialCartDir", itemPath);
//	Set_INI_Value(emulatorConfigFile, "VIC20", "InitialAutostartDir", itemPath);

	// autostart or 'manual load' the game image
	if (Value("cart").contains("*")) {
		if (Value("cart").contains("*20*")) {
			Add_CLP("-cart2 ", itemPathsAndFiles[0]);
		} else if (Value("cart").contains("*40*")) {
			Add_CLP("-cart4 ", itemPathsAndFiles[0]);
		} else if (Value("cart").contains("*60*")) {
			Add_CLP("-cart6 ", itemPathsAndFiles[0]);
		} else if (Value("cart").contains("*a0*")) {
			Add_CLP("-cartA", itemPathsAndFiles[0]);
		} else if (Value("cart").contains("*b0*")) {
			Add_CLP("-cartB ", itemPathsAndFiles[0]);
		}

		if (Value("cart2").contains("*20*")) {
			Add_CLP("-cart2 ", itemPathsAndFiles[1]);
		} else if (Value("cart2").contains("*40*")) {
			Add_CLP("-cart4 ", itemPathsAndFiles[1]);
		} else if (Value("cart2").contains("*60*")) {
			Add_CLP("-cart6 ", itemPathsAndFiles[1]);
		} else if (Value("cart2").contains("*a0*")) {
			Add_CLP("-cartA ", itemPathsAndFiles[1]);
		} else if (Value("cart2").contains("*b0*")) {
			Add_CLP("-cartB ", itemPathsAndFiles[1]);
		}

		// autostart or 'manual load' the game image (with SYS call messages)
		if (itemVersionComment.contains("*load manually*")) {
			// check if a SYS call is needed to start
			if (Value("sys").contains("*")) {
				Add_CLP("-keybuf", "REM LOAD MANUALLY THEN START WITH SYS" + Value("sys") + "\n");
			} else {
				Add_CLP("-keybuf", "REM LOAD MANUALLY THEN SOFT RESET TO START\n");
			}
		} else {
			// check if a SYS call is needed to start
			if (Value("sys").contains("*")) {
				Add_CLP("-keybuf", "SYS" + Value("sys") + "\n");
			}
		}

	} else {

		// autostart or 'manual load' the game image (with SYS call messages)
		if (imageName.contains("*")) {
			if (itemVersionComment.contains("*load manually*")) {
				// check if a SYS call is needed to start
				if (Value("sys").contains("*")) {
					Add_CLP("-keybuf", "REM LOAD MANUALLY THEN START WITH SYS" + Value("sys") + "\n");
					Add_CLP("-autoload", itemPathAndFile + ":" + imageNameNative);
				} else {
					Add_CLP("-keybuf", "REM YOU MUST LOAD AND START MANUALLY\n");
					Add_CLP("-autoload", itemPathAndFile + ":" + imageNameNative);
				}
			} else {
				// check if a SYS call is needed to start
				if (Value("sys").contains("*")) {
					Add_CLP("-keybuf", "\n\n\n\nSYS" + Value("sys") + "PRESS ENTER\n");
					Add_CLP("-autoload", itemPathAndFile + ":" + imageNameNative);
				} else {
					Add_CLP("-autostart", itemPathAndFile + ":" + imageNameNative);
				}
			}
		} else {
			if (itemVersionComment.contains("*load manually*")) {
				// check if a SYS call is needed to start
				if (Value("sys").contains("*")) {
					Add_CLP("-keybuf", "REM LOAD MANUALLY THEN START WITH SYS" + Value("sys") + "\n");
					Add_CLP("-autoload", itemPathAndFile);
				} else {
					Add_CLP("-keybuf", "REM YOU MUST LOAD AND START MANUALLY\n");
					Add_CLP("-autoload", itemPathAndFile);
				}
			} else {
				// check if a SYS call is needed to start
				if (Value("sys").contains("*")) {
					Add_CLP("-keybuf", "\n\n\n\nSYS" + Value("sys") + "PRESS ENTER\n");
					Add_CLP("-autoload", itemPathAndFile);
				} else {
					Add_CLP("-autostart", itemPathAndFile);
				}
			}
		}
	}

	// do we want a PAL or NTSC setup?
	if (isRunsOnPal) {
		Add_CLP("-pal");
	} else { 
		Add_CLP("-ntsc");
	}

	// settings for expanded memory
	if (Value("memory").contains("*")) {
		Add_CLP("-memory", Value("memory"));
	} else {
		Add_CLP("-memory", "none");
	}

	// set the item controls
	// These settings are designed to automatically set the controls for player 1
	// to the same controller, regardless of which PORT the item uses for player 1.
	// 
	// 0=None, 1=numpad, 2=custom keyset 1, 3=custom keyset 2, 4=joystick 1, 5=joystick 2
	// 
	// Replace * with <DISABLED> to disable the automatic settings for the JoyPorts
	if (itemFile.contains("*")) {
		if (itemControl === JOYPORT1) {
			// set joystick 1
			if (useHardwareJoystick) {
				Add_CLP("-joydev1", "4"); // joystick 1
			} else {
				Add_CLP("-joydev1", "2"); // custom keyset 1
			}	
		} else { // keyboard
			// Disable Joystick
			Add_CLP("-joydev1", "0");
		}
	}

	// unsupported item controls
	if (itemControl === PADDLEPORT1) {
		Show_Message("This emulator does not have Paddle emulation.\n\nMouse Port1 setting may allow partial control via the mouse.\n\nThis item may still be uncontrollable/unplayable.");
	} else if (itemControl === PADDLEPORT2) {
		Show_Message("This emulator does not have Paddle emulation.\n\nMouse Port2 setting may allow partial control via the mouse.\n\nThis item may still be uncontrollable/unplayable.");
	}

	// give the user a warning message?
	if (itemVersionComment.contains("*use C64S*", "*use CCS*", "*use real C64*")) {
		Show_Message("This item may not work properly with this emulator.\n\nSee Version Comment for more info.");
	}
	if (itemVersionComment.contains("*not 100%*", "*not working*", "*doesn't work*")) { 
		Show_Message("This item may not work properly.");
	}
	if (itemVersionComment.contains("*PET Emulator*")) {
		Show_Message("Use PET Emulator to run this item.");
	}
	if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
		// point out that critical info is in the version comment
		Show_Message("Read this item's Version Comments for very important information/instructions.");
	}

	// show message for the user
	if (Value("msg").contains("*")) {
		Show_Message(Value("msg"));
	}

	// run the emulator
	Run_Emulator();

} else { 

	// invalid item file type
	Show_Message(NOT_SUPPORTED + "\n\nSupported types: D64, T64, G64/G41, TAP, CRT, P00, PRG, LNX");

}



