// ******************************
// *  CCS64 v3.8 GEMUS Script   *
// *      (c) The GB64 Team     *
// *       20 August 2011       *
// ******************************
// 
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
// 
//  Emulator File: CCS64.EXE ("DOS Version");
//                 CCS.EXE   ("DirectX Version");
//  Associated Script File: C64.CFG
//  File Types: D64, T64, PRG, P00, P01, G64, G41, CRT, TAP
// 
//  This script was written for CCS64 v3.8,
//  and may not work with other versions.
// 
//  Emulator Website: http://www.ccs64.com
// 
//  To enable the REU ("RAM Expansion Unit"),
//  use the key=value pair: reu=x
//  where x is 128,256,512,1024,2048,4086,8192 or 16384

command = "wine";

Add_CLP(command);
//Add_CLP("CCS64.exe");
Add_CLP("CCS64-2005.exe");

if (itemType.contains("t64", "prg", "p00", "p01", "d64", "g64", "g41", "crt", "tap")) {

   // Screen mode ("and window mode") options
   // Some video modes may not be supported and may look different dependent on used emulator
   // Option to start in a preset screen mode. Some video modes may not be supported.
   // CCS64 v2: 0=windowed, 10=600x800.
   // CCS64 v3: 0=Window, 1=Window 2X, 3=Window 3X, 12=320x200x16, 13=320x240x16, 14=400x300x16.
   // Set_CFG_Value(emulatorConfigFile, "$SCREENMODE", "0");
   // option to start in fulscreen mode
   if (Value("windowsize").contains("1")) {
      Set_CFG_Value(emulatorConfigFile, "$SCREENMODE", "0");
   } else if (Value("windowsize").contains("2")) {
      Set_CFG_Value(emulatorConfigFile, "$SCREENMODE", "1");
   } else if (Value("windowsize").contains("3")) {
      Set_CFG_Value(emulatorConfigFile, "$SCREENMODE", "2");
   }
   if (Value("fullscreen").contains("yes", "1", "on", "true")) {
      Set_CFG_Value(emulatorConfigFile, "$SCREENMODE", "22");
   }

   // option to enable/disable emulation of a CRT monitor
   if (Value("crtemu").contains("yes", "1", "on", "true")) {
      Set_CFG_Value(emulatorConfigFile, "$SCREENFILTER", "1");
   } else if (Value("crtemu").contains("no", "0", "off", "false")) {
      Set_CFG_Value(emulatorConfigFile, "$SCREENFILTER", "0");
   }

   // Option to start in windowed mode. Not all video modes are supported,
   // The window is not floating ("it is fixed in the upper-left corner");
   // This option is only valid for the DirectX emu versions
   Add_CLP(" -window");

   // set the HardSID ID ("5 is the default ID");
   // This option is only valid for the emu versions supporting HardSID
   // Add_CLP(" -hardsid 5");

   // option to enable/disable sound output
   if (Value("sound").contains("yes", "1", "on", "true")) {
      Set_CFG_Value(emulatorConfigFile, "$SOUNDENABLE", "YES");
   } else if (Value("sound").contains("no", "0", "off", "false")) {
      Set_CFG_Value(emulatorConfigFile, "$SOUNDENABLE", "NO");
   }

   // Option to use max emulator speed during disk load ("not always reliable");
   // Set_CFG_Value(emulatorConfigFile, "$MAX1541SPEED", "1");

   // set disk save mode ("0=never, 1=ask, 2=continuously");
   Set_CFG_Value(emulatorConfigFile, "$DISKSAVEMODE", "2");

   // do we want a PAL or NTSC setup?
   if (itemPalNtsc === NTSC) {
      // 1=NTSC ("65x263"), 2=NTSC ("65x262");
      Set_CFG_Value(emulatorConfigFile, "$SYSTEMMODE", "1");
   } else { 
      // 0=PAL ("63x312");
      Set_CFG_Value(emulatorConfigFile, "$SYSTEMMODE", "0");
   }

   // load the selected game image
   Add_CLP(itemPathAndFile);
   if (itemType.contains("d64", "t64")) {
      Add_CLP(imageIndex);

      // true drive emulation?
      if (isRunsOnTrueDrive) {
         Add_CLP(" -fastload");
      } else { 
         Add_CLP(" -normalload");
      }
   }

   // set the game path for the emulator
   Set_CFG_Value(emulatorConfigFile, "$LOADPATH", itemPath);

   // check for 'manual load' verison comments
   if (itemVersionComment.contains("*load manually*")) {
      Add_CLP(" -manualrun");
   } else { 
      // autorun the loaded image
      Add_CLP(" -autorun");
   }

   // option to set screenshot size settings to 320x200 with no C64 border ("GBC style");
   // Set_CFG_Value(emulatorConfigFile, "$SCREENSHOTSTARTX", "128");
   // Set_CFG_Value(emulatorConfigFile, "$SCREENSHOTSTOPX", "448");
   // Set_CFG_Value(emulatorConfigFile, "$SCREENSHOTSTARTY", "51");
   // Set_CFG_Value(emulatorConfigFile, "$SCREENSHOTSTOPY", "251");

   // set the game controls
   // These settings are designed to automatically set the controls for player 1
   // to the same controller, regardless of which PORT the game uses for player 1.
   // 
   // PORTx: 0=None, 1=Joystick, 2=MOUSE C1531, 3=Paddles
   // MODE for PORTx=1: 0-15=PC Gameport 1-16 16=Key-Set 1,
   //      17=Key-Set 2, 18=Key-Set 3, 19=Adapter Port 1, 20=Adapter Port 2
   // 
   // MODE for PORTx=2: 0=PC MOUSE, 1=PC Gameport 1, 2=PC Gameport 2,
   //                   3=Key-Set 1, 4=Key-Set 2, 5=Key-Set 3
   // 
   // MODE for PORTx=3: 0=PC MOUSE+PC MOUSE, ..., 80=PC MOUSE+Key-Set 3,
   //      48=PC MOUSE+Key-Set 1, 64=PC MOUSE+Key-Set 2
   // 
   // Replace * with <DISABLED> to disable the automatic settings for the JoyPorts
   if (itemFile.contains("*")) {
      if (itemControl === JOYPORT2) {
         // default for JOYPORT2 is PORT2=Key-Set 2 ("and PORT1=Key-Set 1");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "1");
         if (Value("realjoystick1").contains("yes", "1", "on", "true")) {
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "19");
         } else { 
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "17");
         }
         if (itemPlayersMin > 1) {
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "1");
            if (Value("realjoystick2").contains("yes", "1", "on", "true")) {
               Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "20");
            } else { 
               Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "16");
            }
         } else { 
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "0");
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "0");
         }
      } else if (itemControl === JOYPORT1) {
         // default for JOYPORT1 is PORT1=Key-Set 2 ("and PORT2=Key-Set 1");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "1");
         if (Value("realjoystick1").contains("yes", "1", "on", "true")) {
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "19");
         } else { 
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "16");
         }
         if (itemPlayersMin > 1) {
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "1");
            if (Value("realjoystick1").contains("yes", "1", "on", "true")) {
               Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "20");
            } else { 
               Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "17");
            }
         } else { 
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "0");
            Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "0");
         }
      } else if (itemControl === MOUSE) {
         // C1531 MOUSE in PORT1
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "2");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "0");
      } else if (itemControl === PADDLEPORT1) {
         // PADDLEPORT1 is typically for 1P or 2P ("Simultaneous") games
         // default is player 1 uses PC MOUSE, player 2 uses Key-Set 2
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "3");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "64");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "0");
      } else if (itemControl === PADDLEPORT2) {
         // PADDLEPORT2 is typically for 2P ("Alternating") or 1P PORT2 games
         // default is both players 1 and 2 use the PC MOUSE
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "3");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "0");
      } else { 
         // clear the ports if not one of the above controls
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT1MODE", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2", "0");
         Set_CFG_Value(emulatorConfigFile, "$CONTROLPORT2MODE", "0");
      }
   }

   // REU ("Ram Expansion Unit") = 128,256,512,1024,2048,4086,8192 or 16384 kB
   if (Value("reu").contains("*")) {
      // enable REU and set to reu value
      Set_CFG_Value(emulatorConfigFile, "$REUENABLE", "YES");
      // set REU to reu value in number of 64kB units
      if (Value("reu").contains("128")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "2");
      } else if (Value("reu").contains("256")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "4");
      } else if (Value("reu").contains("512")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "8");
      } else if (Value("reu").contains("1024")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "16");
      } else if (Value("reu").contains("2048")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "32");
      } else if (Value("reu").contains("4096")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "64");
      } else if (Value("reu").contains("8192")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "128");
      } else if (Value("reu").contains("16384")) {
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "256");
      } else if (Value("reu").contains("no", "no*", "off", "false", "0")) {
         // disable REU if set to off
         Set_CFG_Value(emulatorConfigFile, "$REUENABLE", "NO");
      } else { 
         // default to 512 kB for all other REU values ("on, yes, 500, etc.");
         Set_CFG_Value(emulatorConfigFile, "$REUSIZE", "8");
      }
   } else { 
      // disable REU
      Set_CFG_Value(emulatorConfigFile, "$REUENABLE", "NO");
   }

   // unsupported game controls
   if (itemControl === LIGHTPEN) {
      Show_Message("This emulator does not have LIGHTPEN emulation.\n\nThis game may be uncontrollable/unplayable.");
   } else if (itemControl === KOALAPAD) {
      Show_Message("This emulator does not have KOALAPAD emulation.\n\nThis game may be uncontrollable/unplayable.");
   } else if (itemControl === LIGHTGUN) {
      Show_Message("This emulator does not have LIGHTGUN emulation.\n\nThis game may be uncontrollable/unplayable.");
   }

   // give the user a warning message?
   if (itemVersionComment.contains("*use VICE*", "*use C64S*", "*use CCS v1*", "*use real C64*")) {
      Show_Message("This game may not work properly with this emulator.\n\nSee Version Comment for more info.");
   }
   if (itemVersionComment.contains("*not 100%*", "*not working*", "doesn't work*")) {
      Show_Message("This game may not work properly.");
   }
   if (itemVersionComment.contains("*load manually*")) {
      Show_Message("You must load this game manually within the emulator.\n\nGame file:" + itemPathAndFile);
   }
   if (itemVersionComment.contains("*PET Emulator*")) {
      Show_Message("Use PET Emulator to run this game.");
   }
   if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
      // point out that critical info is in the version comment
      Show_Message("Read this game's Version Comments for very important information/instructions.");
   }
  if (itemVersionComment.contains("*VIC-20*", "*VIC20*", "*VC-20*", "*VC20*")) {
      if (itemVersionComment.contains("*emulator*")) {
         Show_Message("Use VIC-20 column Emulator to run this game properly.");
      }
   }

   // run DirectX or DOS emulator
   Run_Emulator();
   // Run_Emulator("DOSCLOSE");

} else { 

   // invalid game file type
   Show_Message(NOT_SUPPORTED + "\n\nSupported types: D64, T64, G64/G41, TAP, CRT, P00, P01, PRG");

}
