// **********************************
// * MESS Default Javascript Script *
// *        (C) by F. Gerbig        *
// *           15.11.2011           *
// *                                *
// *            based on            *
// *  WinVICE Default GEMUS Script  *
// *        (c) The GB64 Team       *
// *          8 August 2007         *
// *             and on             *
// *           "vice.sh"            *
// *        (C) by F. Gerbig        *
// *           2006, 2007           *
// **********************************
// 
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
// 
//  Emulator File: mess
//  Emulator configuration file: mess.ini
//  File Types: 1dd;2img;2mg;bin;cqm;d77;d88;do;dsk;fdi;image.dc;imd;img;nib;po;td0
// 
//  This script was written for MESS v0.144,
//  but may work with other versions too.
// 
//  Emulator Website: http://mess.org/

// SYSTEM      MEDIA NAME (brief)   IMAGE FILE EXTENSIONS SUPPORTED     
//----------  --------------------  ------------------------------------
//apple2e      floppydisk1 (flop1)    .do   .dsk  .bin  .po   .nib  .fdi  .td0  .imd  .cqm  .d77  .d88  .1dd  
//             floppydisk2 (flop2)    .do   .dsk  .bin  .po   .nib  .fdi  .td0  .imd  .cqm  .d77  .d88  .1dd  
//             cassette    (cass)     .wav  

// SYSTEM      MEDIA NAME (brief)   IMAGE FILE EXTENSIONS SUPPORTED     
//----------  --------------------  ------------------------------------
//apple2gs     floppydisk1 (flop1)    .do   .dsk  .bin  .po   .nib  .fdi  .td0  .imd  .cqm  .d77  .d88  .1dd  
//             floppydisk2 (flop2)    .do   .dsk  .bin  .po   .nib  .fdi  .td0  .imd  .cqm  .d77  .d88  .1dd  
//             floppydisk3 (flop3)    .dsk  .img  .image.dc   .2img .2mg  .fdi  .td0  .imd  .cqm  .d77  .d88  .1dd  
//             floppydisk4 (flop4)    .dsk  .img  .image.dc   .2img .2mg  .fdi  .td0  .imd  .cqm  .d77  .d88  .1dd  

if (existsInPath("mess64")) {
  command = "mess64";
} else {
  command = "mess";
}
Add_CLP(command);

Add_CLP("-inipath", emulatorPath);
Add_CLP("-rompath", emulatorPath + separator + "roms");

Add_CLP("-skip_gameinfo");

// print all variables (remove for production)
Dump();

if (itemType.contains("1dd", "2img", "2mg", "bin", "cqm", "d77", "d88", "do", "dsk", "fdi", "image.dc", "imd", "img", "nib", "po", "td0")) {

  if ( (Value("emu").contains("*Apple2GS*")) || (itemName.contains("2GS") || (itemType.contains("2img", "2mg", "image.dc", "img")) )) {
    // Apple2GS

    // apple2gsr0  Apple IIgs (ROM00)
    // apple2gsr1  Apple IIgs (ROM01)
    // apple2gs    Apple IIgs (ROM03)

    // currently emu can have the following values
    // emu=Kegs
    // emu=Mess Apple2GS-01
    // emu=Mess Apple2GS-03

    // default: use ROM 03
    var system = "apple2gs";

    if (Value("emu").contains("*00*")) {
      // use ROM 00 (currently not used in Apple2Mania V2)
      system = "apple2gsr0";
    }

    if (Value("emu").contains("*01*")) {
      // use ROM 01
      system = "apple2gsr1";
    }

    if (Value("emu").contains("*03*")) {
      // use ROM 01
      system = "apple2gs";
    }

    Add_CLP(system);

    // look for boot disk
    //var index = itemFiles.indexOfContains("*sys*", "*start*", "*boot*", "*loader*");
    var index = -1;


    if (index !== -1) {
      // boot disk
      Add_CLP("-flop3", itemPathsAndFiles[index]);
      if (itemPathsAndFiles.length > 1) { // more than one disk
        if (index === 0) {
          Add_CLP("-flop4", itemPathsAndFiles[1]);
        } else {
          Add_CLP("-flop4", itemPathsAndFiles[0]);
        }
      }

    } else {
      // no boot disk => simply insert first disk
      Add_CLP("-flop3", itemPathsAndFiles[0]);
      if (itemPathsAndFiles.length > 1) { // more than one disk
        Add_CLP("-flop4", itemPathsAndFiles[1]);
      }
    }




  } else {
    // Apple2e
    Add_CLP("apple2e");
    Add_CLP("-flop1", itemPathsAndFiles[0]);
    if (itemPathsAndFiles.length > 1) { // more than one disk
      Add_CLP("-flop2", itemPathsAndFiles[1]);
    }
  }

// set the item controls
// These settings are designed to automatically set the controls for player 1
// to the same controller, regardless of which PORT the item uses for player 1.
// 
// Replace * with <DISABLED> to disable the automatic settings for the JoyPorts
  if (itemFile.contains("*")) {
    if ((itemControl === JOYPORT1) || (itemControl === JOYPORT2)) {
      Add_CLP("-joystick");
    }
    if (itemControl === MOUSE) {
      Add_CLP("-mouse");
    }
    if ((itemControl === PADDLEPORT1) || (itemControl === PADDLEPORT2)) {
      // not sure what to do ;-(
    }
  }

	// unsupported item controls
	if (itemControl === LIGHTPEN) {
		Show_Message("This emulator does not have LightPen emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === KOALAPAD) {
		Show_Message("This emulator does not have KoalaPad emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === LIGHTGUN) {
		Show_Message("This emulator does not have LightGun emulation.\n\nThis item may be uncontrollable/unplayable.");
	//} else if (itemControl === PADDLEPORT1) {
	//	Show_Message("This emulator does not have Paddle emulation.\n\nMouse Port1 setting may allow partial control via the mouse.\n\nThis item may still be uncontrollable/unplayable.");
	//} else if (itemControl === PADDLEPORT2) {
	//	Show_Message("This emulator does not have Paddle emulation.\n\nMouse Port2 setting may allow partial control via the mouse.\n\nThis item may still be uncontrollable/unplayable.");
	}

	// give the user a warning message?
	if (itemVersionComment.contains("*not 100%*", "*not working*", "*doesn't work*")) { 
		Show_Message("This item may not work properly.");
	}
	if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
		// point out that critical info is in the version comment
		Show_Message("Read this item's Version Comments for very important information/instructions.");
	}

	// show message for the user
	if (Value("msg").contains("*")) {
		Show_Message(Value("msg"));
	}

	if ( (Value("emu").contains("*kegs*")) ) {
		Show_Message("This item may not work properly with this emulator.\n\nUse KEGS Emulator to run this item properly.");
	}

	// run the emulator
	Run_Emulator();

} else { 

	// invalid item file type
	Show_Message(NOT_SUPPORTED + "\n\nSupported types: 1DD, 2IMG, 2MG, BIN, CQM, D77, D88, DO, DSK, FDI, IMAGE.DC, IMD, IMG, NIB, PO, TD0");

}



