#!/bin/bash

error() {
  local MESSAGE="$1"
  local RC="$2"

  # display message on console
  echo ""
  echo -e "${MESSAGE}"
  echo ""

  # display message in GUI
  if [ -x /usr/bin/zenity ]; then
      /usr/bin/zenity --error --width=480 --text "${MESSAGE}"
  elif [ -x /usr/bin/kdialog ]; then
      /usr/bin/kdialog --title ERROR --error "${MESSAGE}"
  elif [ -x /usr/bin/Xdialog ]; then
      /usr/bin/Xdialog --msgbox "ERROR: ${MESSAGE}" 0 0
  elif [ -x /usr/bin/dialog ]; then
      /usr/bin/dialog --msgbox "ERROR: ${MESSAGE}" 0 0
  fi

  # end program
  exit ${RC}
}

# set java executable to use
JAVA_CMD="java"
if [ -n "${JAVA_HOME}" ] && [ -x "${JAVA_HOME}/bin/java" ]; then
  JAVA_CMD="${JAVA_HOME}/bin/java"
  echo "JAVA_HOME set: using java executable \"${JAVA_HOME}/bin/java\""
  echo
fi

# find the major version of java
JAVA_VERSION="$( ${JAVA_CMD} -version 2>&1 | head -n 1 | awk -F'"' '{ print $2 }' )"

IFS=. read MAJOR minor extra <<<"${JAVA_VERSION}"
if (( MAJOR == 1 )); then
  MAJOR=$minor
fi

ADD_OPTION=""
ADD_CLASSPATH=""

# check java major version
if (( MAJOR < 8 )); then
  echo "Java version: \"${JAVA_VERSION}\": ERROR version too low!"
  MESSAGE="An error occured.\n"
  MESSAGE+="The java version found \"${JAVA_VERSION}\" with major version \"${MAJOR}\" is too low.\n"
  MESSAGE+="The version must be at least Java 8.\n"

  error "$MESSAGE" 1

elif (( MAJOR >= 8 && MAJOR <= 17)); then
  echo "Java version: \"${JAVA_VERSION}\": ok"

else
  echo "Java version: \"${JAVA_VERSION}\": WARNING untested version"

fi

echo

# find the directory this script is in
CMD="$(cd "${0%/*}" 2>/dev/null; echo "$PWD"/"${0##*/}")"
DIR=$( dirname "${CMD}" )

# change dir
cd "${DIR}" || exit 1


# start programm: the directory is passed as system property "gb.dir"
if (( $# > 1 ));then
  # item id specified, don't show splashscreen
  "${JAVA_CMD}" ${ADD_OPTION} -Dgb.dir="${DIR}" -Dpolyglot.js.nashorn-compat=true -classpath "${CLASSPATH}:${ADD_CLASSPATH}" -jar jgamebase.jar $*
  rc=$?
else
  "${JAVA_CMD}" ${ADD_OPTION} -Dgb.dir="${DIR}" -Dpolyglot.js.nashorn-compat=true -splash:Artwork/SplashScreens/GameBase.png -classpath "${CLASSPATH}:${ADD_CLASSPATH}" -jar jgamebase.jar $*
  rc=$?
fi

# if error, display message
if [[ $rc != 0 ]]; then
  MESSAGE="It seems an error occured.\n"
  MESSAGE+="Please try to reproduce the error and find out which specific action triggers it.\n"
  MESSAGE+="Then check the bug tracking system to see if the error has already been reported.\n"
  MESSAGE+="If you found a new error please enter a bug report.\n"
  MESSAGE+="Thank you in advance.\n"

  error "$MESSAGE" $rc
fi

exit 0

