package libsidutils;

import static libsidplay.common.SIDEndian.endian_little16;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import libsidplay.components.sidtune.SidTune;

public class SidTuneMod extends SidTune {
	public final static int SIDTUNE_MD5_LENGTH = 32;

	public SidTuneMod(final String fileName) {
		super(fileName, null);
	}

	/**
	 * An md5 buffer must be provided. The buffer is cleared first.
	 * 
	 * @return MD5 checksum of the tune
	 */
	final String createMD5(StringBuffer md5) {
		if (md5.length() > 0)
			md5.delete(0, md5.length() - 1);
		if (status) {
			// Include C64 data.
			byte[] myMD5 = new byte[info.c64dataLen + 6 + info.songs
					+ (info.clockSpeed == SIDTUNE_CLOCK_NTSC ? 1 : 0)];
			short /* md5_byte_t */tmp[] = new short[2];
			int i = 0;
			for (; i < info.c64dataLen; i++) {
				short sh = cache.get()[fileOffset + i];
				myMD5[i] = (byte) sh;
			}
			// Include INIT and PLAY address.
			endian_little16(tmp, 0, info.initAddr);
			myMD5[i++] = ((byte) tmp[0]);
			myMD5[i++] = ((byte) tmp[1]);
			endian_little16(tmp, 0, info.playAddr);
			myMD5[i++] = ((byte) tmp[0]);
			myMD5[i++] = ((byte) tmp[1]);
			// Include number of songs.
			endian_little16(tmp, 0, info.songs);
			myMD5[i++] = ((byte) tmp[0]);
			myMD5[i++] = ((byte) tmp[1]);
			{ // Include song speed for each song.
				int /* uint_least16_t */currentSong = info.currentSong;
				for (int /* uint_least16_t */s = 1; s <= info.songs; s++) {
					selectSong(s);
					myMD5[i++] = ((byte) info.songSpeed);
				}
				// Restore old song
				selectSong(currentSong);
			}
			// Deal with PSID v2NG clock speed flags: Let only NTSC
			// clock speed change the MD5 fingerprint. That way the
			// fingerprint of a PAL-speed sidtune in PSID v1, v2, and
			// PSID v2NG format is the same.
			if (info.clockSpeed == SIDTUNE_CLOCK_NTSC)
				myMD5[i++] = ((byte) info.clockSpeed);
			// NB! If the fingerprint is used as an index into a
			// song-lengths database or cache, modify above code to
			// allow for PSID v2NG files which have clock speed set to
			// SIDTUNE_CLOCK_ANY. If the SID player program fully
			// supports the SIDTUNE_CLOCK_ANY setting, a sidtune could
			// either create two different fingerprints depending on
			// the clock speed chosen by the player, or there could be
			// two different values stored in the database/cache.

			try {
				MessageDigest md = MessageDigest.getInstance("MD5");
				byte[] encryptMsg = md.digest(myMD5);
				for (int j = 0; j < encryptMsg.length; j++) {
					String x = Integer.toHexString(encryptMsg[j] & 0xff);
					if (x.length() < 2)
						md5.append("0");
					md5.append(x);
				}
				// System.out.println(md5.toString());
			} catch (NoSuchAlgorithmException e) {
				e.printStackTrace();
			}
		}
		return md5.toString();

	}
}
