package sidplay.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

import sidplay.audio.AudioConfig.encoding_t;

public class AudioDriver extends AudioBase {

	private AudioFormat fAudioFormat;
	private SourceDataLine dataLine;

	@Override
	public byte[] open(AudioConfig cfg, String name) {
		cfg.encoding = (cfg.precision != 8) ? encoding_t.AUDIO_SIGNED_PCM
				: encoding_t.AUDIO_UNSIGNED_PCM;
		boolean bigEndian = false;
		fAudioFormat = new AudioFormat((int) cfg.frequency, cfg.precision,
				cfg.channels, cfg.encoding == encoding_t.AUDIO_SIGNED_PCM,
				bigEndian);
		DataLine.Info info = new DataLine.Info(SourceDataLine.class,
				fAudioFormat);
		try {
			dataLine = (SourceDataLine) AudioSystem.getLine(info);

			if (dataLine == null) {
				System.err.println("Audio(Soundcard): DataLine is null!");
				System.exit(1);
			} else {
				int nBlockAlign = (cfg.precision / 8 * cfg.channels);
				cfg.bufSize = (int) (cfg.frequency / 4 * nBlockAlign);
				dataLine.open(dataLine.getFormat(), (int) cfg.bufSize);
				_sampleBuffer = new byte[dataLine.getBufferSize()];
				System.out.println("Audio(Soundcard): Format: " + dataLine.getFormat() + ", buffer size: " + dataLine.getBufferSize());
				// Startup the dataline
				dataLine.start();
			}
		} catch (LineUnavailableException unavailable) {
			System.err
					.println("Audio(Soundcard): Problem while getting data line! "
							+ unavailable);
			System.exit(1);
		}
		return _sampleBuffer;
	}

	@Override
	public byte[] write() {
		dataLine.write(_sampleBuffer, 0, _sampleBuffer.length);
		return _sampleBuffer;
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub

	}

	@Override
	public void close() {
		dataLine.stop();
		dataLine.close();
	}

	@Override
	public void reset() {
	}

}
