// **********************************
// * ZSNES Default Javascript Script*
// *        (C) by F. Gerbig        *
// *           30.03.2012           *
// *                                *
// *            based on            *
// *  WinVICE Default GEMUS Script  *
// *        (c) The GB64 Team       *
// *          8 August 2007         *
// *             and on             *
// *           "vice.sh"            *
// *        (C) by F. Gerbig        *
// *           2006, 2007           *
// **********************************
// 
//  PLEASE SET YOUR EMULATOR PROPERTIES AS FOLLOWS:
// 
//  Emulator File: zsnes
//  Emulator configuration file: 
//  File Types: sfc
// 
//  This script was written for ZSNES v1.51,
//  but may work with other versions too.
// 
//  Emulator Website: http://www.zsnes.com/

command = "zsnes";
Add_CLP(command);

// print all variables (remove for production)
Dump();

if (itemType.contains("sfc")) {

  Add_CLP(itemPathsAndFiles[0]);

// set the item controls
// These settings are designed to automatically set the controls for player 1
// to the same controller, regardless of which PORT the item uses for player 1.
// 
// Replace * with <DISABLED> to disable the automatic settings for the JoyPorts
  if (itemFile.contains("*")) {
    if ((itemControl === JOYPORT1) || (itemControl === JOYPORT2)) {
        // not sure what to do ;-(
    }
  }

	// unsupported item controls
	if (itemControl === LIGHTPEN) {
		Show_Message("This emulator does not have LightPen emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === MOUSE) {
		Show_Message("This emulator does not have mouse emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === KOALAPAD) {
		Show_Message("This emulator does not have KoalaPad emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if (itemControl === LIGHTGUN) {
		Show_Message("This emulator does not have LightGun emulation.\n\nThis item may be uncontrollable/unplayable.");
	} else if ((itemControl === PADDLEPORT1) || (itemControl === PADDLEPORT1)) {
		Show_Message("This emulator does not have Paddle emulation.\n\nThis item may be uncontrollable/unplayable.");
	}

	// give the user a warning message?
	if (itemVersionComment.contains("*not 100%*", "*not working*", "*doesn't work*")) { 
		Show_Message("This item may not work properly.");
	}
	if (itemVersionComment.contains("*ATTN:*", "*NOTE:*", "*ATTN!:*", "*NOTE!:*")) {
		// point out that critical info is in the version comment
		Show_Message("Read this item's Version Comments for very important information/instructions.");
	}

	// show message for the user
	if (Value("msg").contains("*")) {
		Show_Message(Value("msg"));
	}

	// run the emulator
	Run_Emulator();

} else { 

	// invalid item file type
	Show_Message(NOT_SUPPORTED + "\n\nSupported types: SFC");

}

