/*
 * Decompiled with CFR 0.152.
 */
package assembler.rgbds;

import assembler.AbortException;
import assembler.AbstractZ80ParseResult;
import assembler.EnumTrie;
import assembler.Macro;
import assembler.ROMBankMap;
import assembler.Section;
import assembler.Z80Assembler;
import assembler.Z80Instruction;
import assembler.Z80SourceLine;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.ParseException;
import assembler.parsers.UnknownIdentifierException;
import assembler.rgbds.RGBDSCharmap;
import assembler.rgbds.RGBDSROMBankMap;
import assembler.rgbds.RGBDSSourceLine;
import disassembler.dialects.AssemblerDialect;
import disassembler.dialects.RgbdsDialect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import platform.debugger.EvaluateException;
import util.string.StringUtilities;
import util.string.SubCharSequence;

public final class RGBDSParser {
    private static final SubCharSequence NARGS = SubCharSequence.from("_NARG");
    private static final String OPERATORS = "|&^<>+-!=%~*/";
    private static final String OPERATORS_AND_IDENTIFIER_SYMBOLS = "|&^<>+-!=%~*/{}:?#.@";
    private static final int MAX_CONCAT_LENGTH = 1000;
    private static final int EVALUATION_FAILED = -1073741824;
    private static final EnumTrie keywordTrie = new EnumTrie(Keyword.class);

    private RGBDSParser() {
    }

    public static ParseResult readLines(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return RGBDSParser.readLines(file, new ParsingState(file, z80Assembler, expressionEvaluator, 4), 1);
    }

    public static ParseResult readLines(String string, int n, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return RGBDSParser.readLines(new StringReader(string), null, n, z80Assembler, expressionEvaluator);
    }

    public static ParseResult readLines(Reader reader, File file, int n, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return RGBDSParser.readLines(reader, file, new ParsingState(file, z80Assembler, expressionEvaluator, n), 1);
    }

    private static ParseResult readLines(File file, ParsingState parsingState, int n) throws IOException {
        return RGBDSParser.readLines(new FileInputStream(file), file, parsingState, n);
    }

    private static ParseResult readLines(InputStream inputStream, File file, ParsingState parsingState, int n) throws IOException {
        return RGBDSParser.readLines(new InputStreamReader(inputStream, "UTF-8"), file, parsingState, n);
    }

    private static ParseResult readLines(Reader reader, File file, ParsingState parsingState, int n) throws IOException {
        BufferedReader bufferedReader;
        ArrayList<Z80SourceLine> arrayList = new ArrayList<Z80SourceLine>();
        BufferedReader bufferedReader2 = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        if (file != null && n == 1) {
            parsingState.lines.add(new RGBDSSourceLine(-1, file, ";* BEGINNING OF " + file.getName()));
        }
        int n2 = 0;
        Object object = bufferedReader.readLine();
        while (object != null) {
            RGBDSParser.readLine(parsingState, n2++, file, (CharSequence)object, arrayList, null, n + 1);
            object = bufferedReader.readLine();
        }
        if (parsingState.lineContinuation != null) {
            object = parsingState.lineContinuation;
            parsingState.lineContinuation = null;
            RGBDSParser.readLine(parsingState, n2, file, (CharSequence)object, arrayList, null, n + 1);
        }
        reader.close();
        if (parsingState.blockComment) {
            System.err.println("Block comment was still open at the end of a file");
        }
        parsingState.blockComment = false;
        parsingState.addParsedFile(file);
        if (file != null && file == parsingState.rootFile) {
            Object object2;
            int n3;
            object = file.getParentFile();
            String string = ((File)object).getName();
            File file2 = new File((File)object, "home.asm");
            Object object3 = "src".equalsIgnoreCase(string) || "srcs".equalsIgnoreCase(string) || "source".equalsIgnoreCase(string) || "code".equalsIgnoreCase(string) || RGBDSParser.isVSCodeProject(((File)object).getParentFile()) || RGBDSParser.isGitRepository(((File)object).getParentFile()) ? (((File)object).getParentFile() != null ? ((File)object).getParentFile() : object) : ("main.asm".equals(file.getName()) && file2.exists() ? object : (RGBDSParser.isVSCodeProject((File)object) ? object : null));
            if (object3 != null && (n3 = ((String)(object2 = file.getName())).lastIndexOf(46)) >= 0) {
                RGBDSParser.readFilesWithExtension((File)object3, ((String)object2).substring(n3), parsingState);
            }
            if (file2.exists() && !parsingState.isParsed(file2)) {
                parsingState.complete();
                parsingState.resetCharmaps();
                RGBDSParser.readLines(file2, parsingState, 1);
            }
            if (((File)(object2 = new File((File)object, "main.asm"))).exists() && !parsingState.isParsed((File)object2)) {
                parsingState.complete();
                parsingState.resetCharmaps();
                RGBDSParser.readLines((File)object2, parsingState, 1);
            }
            parsingState.complete();
        }
        return new ParseResult(parsingState);
    }

    private static boolean isVSCodeProject(File file) {
        return new File(file, ".vscode").isDirectory() && !new File(new File(file, ".vscode"), "extensions").isDirectory();
    }

    private static boolean isGitRepository(File file) {
        return new File(file, ".git").isDirectory();
    }

    private static void readFilesWithExtension(File file, final String string, ParsingState parsingState) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(string);
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                RGBDSParser.readFilesWithExtension(file2, string, parsingState);
                ++n2;
            }
        } else if (!parsingState.isParsed(file)) {
            parsingState.complete();
            parsingState.resetCharmaps();
            RGBDSParser.readLines(file, parsingState, 1);
        }
    }

    private static void readLine(ParsingState parsingState, int n, File file, CharSequence charSequence, List<Z80SourceLine> list, MacroArgs macroArgs, int n2) throws IOException {
        if (n2 >= 32) {
            return;
        }
        List<Z80SourceLine> list2 = parsingState.lines;
        List<Section> list3 = parsingState.sections;
        Deque<Section> deque = parsingState.sectionStack;
        Map<SubCharSequence, Macro> map = parsingState.macros;
        Map<SubCharSequence, Integer> map2 = parsingState.macroCalls;
        Map<SubCharSequence, CharSequence> map3 = parsingState.definitions;
        Map<SubCharSequence, CharSequence> map4 = parsingState.equs;
        Z80Assembler z80Assembler = parsingState.assembler;
        ExpressionEvaluator expressionEvaluator = parsingState.expressionEvaluator;
        try {
            CharSequence charSequence2;
            CharSequence[] charSequenceArray;
            Keyword keyword;
            int n3;
            Object object;
            CharSequence charSequence3;
            int n4;
            int n5;
            if (parsingState.multiLineString) {
                int n6 = charSequence.length();
                n5 = 0;
                while (n5 < n6 && parsingState.multiLineString) {
                    switch (charSequence.charAt(n5)) {
                        case '\"': {
                            if (n5 + 2 < n6 && charSequence.charAt(n5 + 1) == '\"' && charSequence.charAt(n5 + 2) == '\"') {
                                parsingState.multiLineString = false;
                                n5 += 2;
                            }
                            ++n5;
                        }
                    }
                    ++n5;
                }
                if (parsingState.multiLineString) {
                    parsingState.lineContinuation = StringUtilities.concat(parsingState.lineContinuation, charSequence);
                    return;
                }
            }
            if (parsingState.lineContinuation != null) {
                charSequence = StringUtilities.concat(parsingState.lineContinuation, charSequence);
            }
            n5 = 0;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = charSequence.length();
            int n11 = 0;
            while (n11 < n10) {
                switch (charSequence.charAt(n11)) {
                    case '\"': {
                        if (n11 > 0 && charSequence.charAt(n11 - 1) == '#') {
                            ++n11;
                            while (n11 < n10 && charSequence.charAt(n11) != '\"') {
                                ++n11;
                            }
                            ++n11;
                            break;
                        }
                        if (n11 + 2 < n10 && charSequence.charAt(n11 + 1) == '\"' && charSequence.charAt(n11 + 2) == '\"') {
                            parsingState.multiLineString = true;
                            n11 += 2;
                        }
                        ++n11;
                        while (n11 < n10) {
                            n4 = charSequence.charAt(n11);
                            if (n4 == 34 && (charSequence.charAt(n11 - 1) != '\\' || n11 >= 2 && charSequence.charAt(n11 - 2) == '\\') && (!parsingState.multiLineString || n11 + 2 < n10 && charSequence.charAt(n11 + 1) == '\"' && charSequence.charAt(n11 + 2) == '\"')) {
                                if (!parsingState.multiLineString) break;
                                n11 += 2;
                                parsingState.multiLineString = false;
                                break;
                            }
                            if (n5 == 0 && n4 == 92) {
                                n5 = 1;
                            }
                            ++n11;
                        }
                        if (!parsingState.multiLineString) break;
                        parsingState.lineContinuation = charSequence;
                        return;
                    }
                    case ':': {
                        if (n11 <= 0 || n11 + 1 >= n10 || charSequence.charAt(n11 + 1) != ':' || charSequence.charAt(n11 - 1) > ' ') break;
                        list2.add(new RGBDSSourceLine(-1, n, file, "; " + charSequence));
                        RGBDSParser.readLine(parsingState, n, file, charSequence.subSequence(0, n11), list, macroArgs, n2);
                        n4 = n11 += 2;
                        while (n11 + 1 < n10) {
                            if (charSequence.charAt(n11++) != ':' || charSequence.charAt(n11) != ':') continue;
                            RGBDSParser.readLine(parsingState, n, file, charSequence.subSequence(n4, n11 - 1), list, macroArgs, n2);
                            n4 = ++n11;
                        }
                        RGBDSParser.readLine(parsingState, n, file, charSequence.subSequence(n4, n10), list, macroArgs, n2);
                        return;
                    }
                    case ';': {
                        n7 = n11;
                        if (parsingState.blockComment || n9 >= 0) break;
                        n11 = n10;
                        break;
                    }
                    case '*': {
                        if (n11 > 0 && charSequence.charAt(n11 - 1) == '/') {
                            n9 = n11 - 1;
                            break;
                        }
                        if (n11 + 1 >= n10 || charSequence.charAt(n11 + 1) != '/') break;
                        n8 = n11;
                        break;
                    }
                    case '_': {
                        if (n5 != 0 || !StringUtilities.startsWithIgnoreCase(charSequence, NARGS, n11)) break;
                        n5 = 1;
                        break;
                    }
                    case '\\': {
                        n5 = 1;
                    }
                }
                ++n11;
            }
            if (n5 != 0 && list.isEmpty()) {
                CharSequence charSequence4 = charSequence;
                n11 = (charSequence = RGBDSParser.inlineMacroArgs(charSequence, macroArgs, parsingState)).length() - charSequence4.length();
                if (n11 != 0) {
                    if (n7 >= 0 && (n7 >= charSequence.length() || charSequence.charAt(n7) != ';')) {
                        n7 += n11;
                    }
                    if (n9 >= 0 && (n9 >= charSequence.length() || charSequence.charAt(n9) != '/')) {
                        n9 += n11;
                    }
                    if (n8 >= 0 && (n8 >= charSequence.length() || charSequence.charAt(n8) != '*')) {
                        n8 += n11;
                    }
                }
            }
            if (parsingState.blockComment && n8 >= 0) {
                charSequence3 = StringUtilities.subSequence(charSequence, n8 + "*/".length());
                n7 -= n8 + "*/".length();
                parsingState.blockComment = false;
                if (StringUtilities.isEmpty(charSequence3)) {
                    list2.add(new RGBDSSourceLine(-1, n, file, "; " + charSequence));
                    return;
                }
            } else {
                charSequence3 = charSequence;
            }
            if (parsingState.blockComment) {
                list2.add(new RGBDSSourceLine(-1, n, file, "; " + charSequence));
                return;
            }
            if (n9 >= 0) {
                boolean bl = parsingState.blockComment = n8 < 0;
                if (n8 >= 0) {
                    charSequence3 = StringUtilities.trim(StringUtilities.concat(StringUtilities.subSequence(charSequence, 0, n9), StringUtilities.subSequence(charSequence, n8 + 2)));
                } else {
                    if (n7 < 0 || n9 < n7) {
                        n7 = n9;
                    }
                    charSequence3 = StringUtilities.trim(n7 >= 0 ? StringUtilities.subSequence(charSequence, 0, n7) : charSequence);
                }
            } else {
                charSequence3 = StringUtilities.trim(n7 >= 0 ? StringUtilities.subSequence(charSequence, 0, n7) : charSequence3);
            }
            if (StringUtilities.isEmpty(charSequence3)) {
                if (!list.isEmpty()) {
                    list.add(new RGBDSSourceLine(-1, n, file, charSequence));
                } else {
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                }
                return;
            }
            if (charSequence3.charAt(charSequence3.length() - 1) == '\\') {
                parsingState.lineContinuation = charSequence3.subSequence(0, charSequence3.length() - 1);
                return;
            }
            parsingState.lineContinuation = null;
            Keyword keyword2 = (Keyword)((Object)keywordTrie.get(charSequence3));
            if (!parsingState.skipToNextIfPart) {
                if (keyword2 == Keyword.ENDM) {
                    if (parsingState.currentMacro != null) {
                        map.put(SubCharSequence.from(parsingState.currentMacro.getName()), parsingState.currentMacro);
                    } else {
                        System.err.println("ENDM encountered before encountering a MACRO head in " + file + " (" + n + ")");
                    }
                    parsingState.currentMacro = null;
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                    return;
                }
                if (keyword2 == Keyword.MACRO) {
                    n7 = "MACRO".length();
                    while (n7 < charSequence3.length() && charSequence3.charAt(n7) <= ' ') {
                        ++n7;
                    }
                    n8 = n7;
                    while (n8 < charSequence3.length() && charSequence3.charAt(n8) > ' ') {
                        ++n8;
                    }
                    CharSequence charSequence5 = StringUtilities.subSequence(charSequence3, "MACRO".length(), n8);
                    parsingState.currentMacro = new Macro(charSequence5, new CharSequence[0]);
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                    return;
                }
            }
            if (parsingState.currentMacro != null) {
                RGBDSSourceLine rGBDSSourceLine = new RGBDSSourceLine(-1, n, file, charSequence);
                list2.add(rGBDSSourceLine);
                parsingState.currentMacro.addLine(rGBDSSourceLine);
                return;
            }
            if (!parsingState.skipToNextIfPart && !list.isEmpty()) {
                if (keyword2 == Keyword.ENDR) {
                    n7 = -1;
                    for (Z80SourceLine z80SourceLine : list) {
                        CharSequence charSequence6 = StringUtilities.trim(z80SourceLine.toString());
                        if (StringUtilities.isEmpty(charSequence6)) continue;
                        if (StringUtilities.equalsIgnoreCase(charSequence6, "ENDR")) {
                            --n7;
                            continue;
                        }
                        if (!StringUtilities.startsWithIgnoreCase(charSequence6, "REPT") && !StringUtilities.startsWithIgnoreCase(charSequence6, "FOR")) continue;
                        ++n7;
                    }
                    if (n7 <= 0) {
                        int n12;
                        Z80SourceLine z80SourceLine = list.remove(0);
                        CharSequence charSequence7 = StringUtilities.trim(z80SourceLine.toString());
                        n10 = StringUtilities.startsWithIgnoreCase(charSequence7, "REPT") ? 1 : 0;
                        n11 = n10 != 0 ? 0 : 1;
                        CharSequence[] charSequenceArray2 = RGBDSParser.splitOperands(SubCharSequence.from(charSequence7, n10 != 0 ? "REPT".length() : "FOR".length(), charSequence7.length()));
                        int n13 = -1073741824;
                        int n14 = -1073741824;
                        int n15 = -1073741824;
                        try {
                            n13 = charSequenceArray2.length == 4 ? RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray2[3]) : 1;
                            n14 = charSequenceArray2.length >= 3 ? RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray2[1]) : 0;
                            n15 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray2[charSequenceArray2.length == 4 ? 2 : charSequenceArray2.length - 1]);
                        }
                        catch (AbortException abortException) {
                            throw abortException;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (n14 == -1073741824 || n15 == -1073741824 || n13 == -1073741824) {
                            n12 = -1073741824;
                        } else {
                            int n16 = n12 = n13 >= 0 ? (n15 - n14 - 1) / n13 + 1 : (n14 - n15 - 1) / -n13 + 1;
                        }
                        if (n12 < 0) {
                            list2.add(new RGBDSSourceLine(z80SourceLine.getLineNumber(), z80SourceLine.getFile(), charSequence7));
                        } else {
                            list2.add(new RGBDSSourceLine(-1, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), "; " + charSequence7));
                        }
                        ArrayList<Z80SourceLine> arrayList = new ArrayList<Z80SourceLine>();
                        if (n11 == 0 && list.size() == 1) {
                            Z80SourceLine z80SourceLine2 = list.remove(0);
                            if (n12 < 0) {
                                list2.add(new RGBDSSourceLine(-1, n, file, z80SourceLine2.toString()));
                                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                                return;
                            }
                            if (n12 != 0) {
                                RGBDSParser.readLine(parsingState, z80SourceLine2.getLineNumber(), z80SourceLine2.getFile(), z80SourceLine2.toString(), arrayList, macroArgs, n2 + 1);
                            }
                            RGBDSSourceLine rGBDSSourceLine = (RGBDSSourceLine)list2.get(list2.size() - 1);
                            if (n12 > 1000) {
                                list2.set(list2.size() - 2, new RGBDSSourceLine(-1, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), "; " + charSequence7));
                                list2.set(list2.size() - 1, rGBDSSourceLine.repeatLine(n12));
                                parsingState.sectionSize += rGBDSSourceLine.getSize() * (n12 - 1);
                            } else {
                                int n17 = 1;
                                while (n17 < n12) {
                                    RGBDSParser.readLine(parsingState, z80SourceLine2.getLineNumber(), z80SourceLine2.getFile(), z80SourceLine2.toString(), arrayList, macroArgs, n2 + 1);
                                    ++n17;
                                }
                            }
                            list2.add(new RGBDSSourceLine(-1, n, file, "; " + charSequence));
                            return;
                        }
                        parsingState.shouldBreak = false;
                        CharSequence charSequence8 = n11 != 0 ? charSequenceArray2[0] : null;
                        int n18 = n14;
                        while (n12-- > 0) {
                            if (charSequence8 != null) {
                                RGBDSParser.addDefinition(charSequence8, Integer.toString(n18), map3);
                            }
                            for (Z80SourceLine z80SourceLine3 : list) {
                                if (z80SourceLine3.getSize() < 0) {
                                    list2.add(z80SourceLine3);
                                } else {
                                    RGBDSParser.readLine(parsingState, z80SourceLine3.getLineNumber(), z80SourceLine3.getFile(), z80SourceLine3.toString().replace("\\@", Integer.toString(n18)), arrayList, macroArgs, n2 + 1);
                                }
                                if (!parsingState.shouldBreak) continue;
                                n12 = 0;
                                parsingState.shouldBreak = false;
                                break;
                            }
                            n18 += n13;
                        }
                        map3.remove(charSequence8);
                        list.clear();
                        list2.add(new RGBDSSourceLine(-1, n, file, "; " + charSequence));
                        return;
                    }
                }
                list.add(new RGBDSSourceLine(n, file, charSequence));
                return;
            }
            if (keyword2 != null) {
                switch (keyword2) {
                    case ENDC: {
                        if (parsingState.nestedIfs == 0 || parsingState.nestedIfs-- == 0) {
                            parsingState.skipToNextIfPart = false;
                            parsingState.skipToEndIfPart = false;
                            parsingState.inCondition = false;
                        }
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case ELSE: {
                        if (!parsingState.skipToEndIfPart && parsingState.nestedIfs == 0) {
                            parsingState.skipToNextIfPart = !parsingState.skipToNextIfPart;
                        }
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case FAIL: {
                        if (parsingState.inCondition) {
                            parsingState.skipToNextIfPart = true;
                        }
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case ELIF: {
                        if (!parsingState.skipToNextIfPart || parsingState.skipToEndIfPart || parsingState.nestedIfs > 0) {
                            list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                            parsingState.skipToNextIfPart = true;
                            parsingState.skipToEndIfPart = true;
                            return;
                        }
                        parsingState.skipToNextIfPart = false;
                    }
                    case IF: {
                        parsingState.inCondition = true;
                        if (parsingState.skipToNextIfPart) {
                            ++parsingState.nestedIfs;
                        } else {
                            n7 = keyword2.toString().length();
                            while (n7 < charSequence3.length() && charSequence3.charAt(n7) <= ' ') {
                                ++n7;
                            }
                            CharSequence[] charSequenceArray3 = RGBDSParser.splitOperands(charSequence3 = charSequence3.charAt(n7) == '(' && charSequence3.charAt(charSequence3.length() - 1) == ')' ? charSequence3.subSequence(n7 + 1, charSequence3.length() - 1) : charSequence3.subSequence(n7, charSequence3.length()));
                            if (StringUtilities.startsWithIgnoreCase(charSequenceArray3[0], "DEF") || StringUtilities.startsWithIgnoreCase(charSequenceArray3[0], "!DEF")) {
                                n9 = StringUtilities.indexOf(charSequenceArray3[0], '(') + 1;
                                if (n9 > 0) {
                                    parsingState.skipToNextIfPart = map3.containsKey(SubCharSequence.from(charSequenceArray3[0].subSequence(n9, charSequenceArray3[0].length() - 1))) ^ charSequence3.charAt(0) != '!';
                                }
                                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                                return;
                            }
                            charSequence3 = RGBDSParser.inlineDefinitions(charSequence3, map3, map3, 0, false, parsingState);
                            charSequenceArray3 = RGBDSParser.splitOperands(charSequence3 = RGBDSParser.inlineFunctionCalls(charSequence3, expressionEvaluator, parsingState.charmap));
                            if (StringUtilities.startsWithIgnoreCase(charSequenceArray3[0], "ISCONST") && (n9 = StringUtilities.indexOf(charSequenceArray3[0], '(') + 1) >= 0 && (n10 = StringUtilities.indexOf(charSequenceArray3[0], ')', n9)) >= 0) {
                                CharSequence charSequence9 = StringUtilities.trim(charSequence3.subSequence(n9, n10));
                                try {
                                    Integer.parseInt(charSequence9.toString());
                                    parsingState.skipToNextIfPart = false;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    parsingState.skipToNextIfPart = true;
                                }
                                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                                return;
                            }
                            n9 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray3[0]) != 0 ? 1 : 0;
                            parsingState.skipToNextIfPart = n9 == 0;
                        }
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                }
            }
            if (parsingState.skipToNextIfPart) {
                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                return;
            }
            charSequence3 = RGBDSParser.inlineDefinitions(charSequence3, map4, map4, keyword2 != null ? (keyword2 == Keyword.DEF || keyword2 == Keyword.REDEF ? 2 : 1) : 0, keyword2 == Keyword.PURGE, parsingState);
            if (parsingState.newLineEncountered) {
                parsingState.newLineEncountered = false;
                list2.add(new RGBDSSourceLine(-1, n, file, ";" + charSequence));
                String[] stringArray = charSequence3.toString().split("\n");
                n9 = stringArray.length;
                n8 = 0;
                while (n8 < n9) {
                    String string = stringArray[n8];
                    RGBDSParser.readLine(parsingState, n, file, string, list, macroArgs, n2 + 1);
                    ++n8;
                }
                int n19 = 0;
                while (n19 < charSequence.length() && charSequence.charAt(n19) <= ' ') {
                    ++n19;
                }
                StringBuilder stringBuilder = new StringBuilder(StringUtilities.subSequence(charSequence, 0, n19));
                while (stringBuilder.length() < n19) {
                    stringBuilder.append(' ');
                }
                String string = stringBuilder.toString();
                list2.add(new RGBDSSourceLine(";" + (!StringUtilities.isEmpty(string) ? string.substring(1) : string) + "END OF " + charSequence));
                return;
            }
            if (StringUtilities.isEmpty(charSequence3)) {
                if (!list.isEmpty()) {
                    list.add(new RGBDSSourceLine(-1, n, file, charSequence));
                } else {
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                }
                return;
            }
            if (charSequence3.charAt(0) <= ' ') {
                charSequence3 = StringUtilities.trim(charSequence3);
                n7 = 0;
            } else {
                n7 = charSequence.charAt(0) > ' ' ? 1 : 0;
            }
            Keyword keyword3 = (Keyword)((Object)keywordTrie.get(charSequence3));
            if (keyword3 != null) {
                switch (keyword3) {
                    case BREAK: {
                        parsingState.shouldBreak = true;
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case POPS: {
                        if (parsingState.currentSection != null) {
                            Section section = parsingState.currentSection;
                            CharSequence charSequence10 = section.getName();
                            list3.add(new Section(charSequence10, section.getMode(), parsingState.sectionSize, section.getOrg(), section.getBank(), section.getBegin(), list2.size()));
                        }
                        parsingState.currentSection = deque.pop();
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case PUSHS: {
                        deque.push(parsingState.currentSection);
                        parsingState.currentSection = null;
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case SECTION: {
                        CharSequence[] charSequenceArray4;
                        parsingState.loadSectionDefinition = false;
                        parsingState.ramSectionDefinition = false;
                        if (parsingState.currentSection != null) {
                            Section section = parsingState.currentSection;
                            CharSequence charSequence11 = section.getName();
                            parsingState.currentSection = null;
                            list3.add(new Section(charSequence11, section.getMode(), parsingState.sectionSize, section.getOrg(), section.getBank(), section.getBegin(), list2.size()));
                        }
                        int n20 = n10 = (charSequenceArray4 = RGBDSParser.splitOperands(RGBDSParser.inlineDefinitions(charSequence3, map3, map3))).length > 1 && StringUtilities.equalsIgnoreCase(charSequenceArray4[1], "FRAGMENT") ? 2 : 1;
                        if (charSequenceArray4.length > n10 + 1) {
                            Section.Mode mode;
                            int n21;
                            CharSequence charSequence12;
                            if (StringUtilities.startsWithIgnoreCase(charSequenceArray4[n10 + 1], "ROM")) {
                                charSequence12 = charSequenceArray4[n10].charAt(0) == '\"' ? charSequenceArray4[n10].subSequence(1, charSequenceArray4[n10].length() - 1) : charSequenceArray4[n10];
                                n4 = -1;
                                if (charSequenceArray4.length > n10 + 2 && !StringUtilities.equalsIgnoreCase(charSequenceArray4[n10 + 2], "BANK") && !StringUtilities.equalsIgnoreCase(charSequenceArray4[n10 + 2], "ALIGN")) {
                                    try {
                                        n4 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray4[n10 + 2].subSequence(StringUtilities.indexOf(charSequenceArray4[n10 + 2], '[') + 1, charSequenceArray4[n10 + 2].length() - 1));
                                    }
                                    catch (Exception exception) {}
                                }
                                n21 = 0;
                                mode = null;
                                int n22 = n10 + 2;
                                while (n22 < charSequenceArray4.length) {
                                    if (StringUtilities.equalsIgnoreCase(charSequenceArray4[n22], "BANK") && n22 + 1 < charSequenceArray4.length) {
                                        try {
                                            n21 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray4[n22 + 1]);
                                            mode = Section.Mode.FREE;
                                        }
                                        catch (Exception exception) {}
                                    }
                                    ++n22;
                                }
                                if (n4 >= 0) {
                                    mode = Section.Mode.SUPERFREE;
                                } else {
                                    n4 = 0;
                                }
                                if (mode == null) {
                                    mode = Section.Mode.SUPERFREE;
                                }
                                if ((n22 = StringUtilities.indexOf(charSequence, '{')) >= 0) {
                                    int n23;
                                    int n24 = StringUtilities.indexOf(charSequence, '\"');
                                    int n25 = n23 = n24 >= 0 ? StringUtilities.indexOf(charSequence, '\"', n24 + 1) : -1;
                                    if (n23 >= 0) {
                                        charSequence = StringUtilities.concat(charSequence.subSequence(0, n24 + 1), StringUtilities.concat(charSequence12, charSequence.subSequence(n23, charSequence.length())));
                                    }
                                }
                            } else {
                                parsingState.ramSectionDefinition = true;
                                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                                return;
                            }
                            parsingState.currentSection = new Section(charSequence12, mode, 0, n4, n21, list2.size(), list2.size());
                            parsingState.sectionSize = 0;
                        }
                        list2.add(new RGBDSSourceLine(n, file, charSequence));
                        return;
                    }
                    case ENDSECTION: {
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case LOAD: {
                        parsingState.loadSectionDefinition = true;
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case ENDL: {
                        parsingState.loadSectionDefinition = false;
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case DEF: 
                    case REDEF: {
                        if (StringUtilities.indexOf(charSequence3, '=') >= 0 && RGBDSParser.parseDefinitions(parsingState, n, file, charSequence, SubCharSequence.from(charSequence3, keyword3.toString().length(), charSequence3.length()), n2)) {
                            return;
                        }
                        CharSequence[] charSequenceArray5 = RGBDSParser.splitOperands(charSequence3);
                        RGBDSParser.parseDefinition(Arrays.copyOfRange(charSequenceArray5, 1, charSequenceArray5.length), map3, map4, expressionEvaluator, parsingState.charmap);
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case PURGE: {
                        CharSequence[] charSequenceArray6 = RGBDSParser.splitOperands(charSequence3);
                        n10 = 1;
                        while (n10 < charSequenceArray6.length) {
                            map3.remove(charSequenceArray6[n10]);
                            map4.remove(charSequenceArray6[n10]);
                            ++n10;
                        }
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case CHARMAP: {
                        CharSequence[] charSequenceArray7 = RGBDSParser.splitOperands(charSequence3);
                        n10 = 2;
                        while (n10 < charSequenceArray7.length) {
                            if (charSequenceArray7[n10].charAt(0) == '\"') {
                                charSequenceArray7[n10] = parsingState.charmap.map(charSequenceArray7[n10].toString()).replace('\"', '\'');
                            }
                            ++n10;
                        }
                        if (charSequenceArray7.length >= 3) {
                            n10 = 3;
                            while (n10 < charSequenceArray7.length) {
                                charSequenceArray7[2] = StringUtilities.concat(StringUtilities.concat(charSequenceArray7[2], " "), charSequenceArray7[n10]);
                                ++n10;
                            }
                            parsingState.charmap.put(charSequenceArray7[1].subSequence(1, charSequenceArray7[1].length() - 1).toString(), (char)RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray7[2]));
                        }
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case NEWCHARMAP: {
                        CharSequence[] charSequenceArray8 = RGBDSParser.splitOperands(charSequence3);
                        parsingState.newCharmap(charSequenceArray8[1].toString(), charSequenceArray8.length > 2 ? charSequenceArray8[2].toString() : null);
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case SETCHARMAP: {
                        CharSequence[] charSequenceArray9 = RGBDSParser.splitOperands(charSequence3);
                        parsingState.setCharmap(charSequenceArray9[1].toString());
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case PUSHC: {
                        parsingState.pushCharmap();
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case POPC: {
                        parsingState.popCharmap();
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                    case REPT: 
                    case FOR: {
                        list.add(new RGBDSSourceLine(-1, n, file, RGBDSParser.inlineFunctionCalls(RGBDSParser.inlineDefinitions(charSequence, map3, map4), expressionEvaluator, parsingState.charmap)));
                        return;
                    }
                    case SHIFT: {
                        n9 = "SHIFT".length();
                        n10 = charSequence3.length() > n9 && charSequence3.charAt(n9) < '0' ? RGBDSParser.evaluateExpression(expressionEvaluator, charSequence3.subSequence(n9, charSequence3.length())) : 1;
                        macroArgs.shiftBy(n10);
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                        return;
                    }
                }
            }
            n9 = 0;
            n10 = 0;
            if (keyword3 == null) {
                if (StringUtilities.isEmpty(charSequence3) || charSequence3.charAt(0) == ';') {
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                    return;
                }
                do {
                    CharSequence charSequence13 = RGBDSParser.parseLabel(charSequence3, n7 != 0);
                    n4 = charSequence13.length();
                    while (n4 < charSequence3.length() && charSequence3.charAt(n4) <= ' ') {
                        ++n4;
                    }
                    if (charSequence3.charAt(0) != '.' && (n4 == charSequence3.length() || charSequence3.charAt(n4) != ':')) {
                        n4 = -1;
                    }
                    Object object2 = object = n4 >= 0 ? charSequence13 : "";
                    if (n4 < 0 && (object.length() == 0 || map.containsKey(SubCharSequence.from(charSequence3)))) {
                        n9 = charSequence13.length();
                        break;
                    }
                    int n26 = object.length();
                    if (n26 < charSequence3.length() && charSequence3.charAt(n26) == ':' && (n3 = StringUtilities.indexOf(charSequence, ':')) > 0 && charSequence.charAt(n3 - 1) == '}') {
                        int n27 = n3 - 1;
                        while (n27 >= 0 && charSequence.charAt(n27) != '{') {
                            --n27;
                        }
                        charSequence = StringUtilities.concat(StringUtilities.concat(charSequence.subSequence(0, n27), (CharSequence)object), charSequence.subSequence(n3, charSequence.length()));
                    }
                    while (n26 < charSequence3.length() && ": \t".indexOf(charSequence3.charAt(n26)) >= 0) {
                        ++n26;
                    }
                    if (n26 > 0) {
                        n10 = 1;
                    }
                    if (!StringUtilities.equalsIgnoreCase(charSequence3 = StringUtilities.subSequence(charSequence3, n26), "MACRO")) continue;
                    parsingState.currentMacro = new Macro((CharSequence)object, new CharSequence[0]);
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                    return;
                } while (StringUtilities.indexOf(charSequence3, ':') >= 0 && Character.isJavaIdentifierPart(charSequence3.charAt(StringUtilities.indexOf(charSequence3, ':') - 1)));
                if (charSequence3.length() <= 1) {
                    if (parsingState.ramSectionDefinition || parsingState.loadSectionDefinition) {
                        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                    } else {
                        list2.add(new RGBDSSourceLine(n, file, charSequence));
                    }
                    return;
                }
            }
            Keyword keyword4 = keyword = keyword3 != null ? keyword3 : keywordTrie.get(charSequence3);
            if (keyword == null) {
                n4 = n9;
                while (n4 < charSequence3.length() && (Character.isJavaIdentifierPart(charSequence3.charAt(n4)) || charSequence3.charAt(n4) == '#')) {
                    ++n4;
                }
                object = map.get(SubCharSequence.from(charSequence3, 0, n4));
                if (object != null) {
                    CharSequence charSequence14;
                    Object object3;
                    Integer n28 = map2.get(SubCharSequence.from(((Macro)object).getName()));
                    n28 = n28 == null ? Integer.valueOf(0) : Integer.valueOf(n28 + 1);
                    map2.put(SubCharSequence.from(((Macro)object).getName()), n28);
                    if (n10 != 0) {
                        n3 = 0;
                        while (n3 < charSequence.length() && charSequence.charAt(n3) > ' ' && charSequence.charAt(n3) != ':') {
                            ++n3;
                        }
                        if (n3 >= charSequence.length() || charSequence.charAt(n3) != ':') {
                            n3 = -1;
                        }
                    } else {
                        n3 = -1;
                    }
                    CharSequence charSequence15 = StringUtilities.subSequence(charSequence, n3 + 1, charSequence.length());
                    int n29 = 0;
                    while (n29 < charSequence15.length() && charSequence15.charAt(n29) <= ' ') {
                        ++n29;
                    }
                    if (n10 != 0) {
                        object3 = new StringBuilder(StringUtilities.subSequence(charSequence15, 0, n29));
                        while (((StringBuilder)object3).length() < n29 + n3 + 1) {
                            ((StringBuilder)object3).append(' ');
                        }
                        charSequence14 = ((StringBuilder)object3).toString();
                    } else {
                        charSequence14 = StringUtilities.subSequence(charSequence15, 0, n29);
                    }
                    list2.add(new RGBDSSourceLine(-1, n, file, StringUtilities.concat(n3 >= 0 ? StringUtilities.concat(StringUtilities.subSequence(charSequence, 0, n3 + 1), ";") : ";", n29 > 0 ? StringUtilities.subSequence(charSequence15, 1) : charSequence15)));
                    object3 = new MacroArgs(RGBDSParser.splitOperands(StringUtilities.subSequence(charSequence3, n4)), n28);
                    for (Z80SourceLine z80SourceLine : ((Macro)object).getLines()) {
                        RGBDSParser.readLine(parsingState, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), StringUtilities.concat(charSequence14, z80SourceLine.toString()), list, (MacroArgs)object3, n2 + 1);
                    }
                    list2.add(new RGBDSSourceLine(";" + (!StringUtilities.isEmpty(charSequence14) ? charSequence14.toString().substring(1) : charSequence14) + "END OF " + ((Macro)object).getName()));
                    return;
                }
            }
            if (keyword == Keyword.ASSERT || keyword == Keyword.STATIC_ASSERT || keyword == Keyword.WARN || keyword == Keyword.EXPORT) {
                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                return;
            }
            if (RGBDSParser.parseIncludeDirective(charSequence3, keyword, n, file, charSequence, parsingState, expressionEvaluator, n2)) {
                return;
            }
            if (keyword == Keyword.RSRESET) {
                RGBDSParser.addDefinition("_RS", "0", map3);
                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                return;
            }
            if (keyword == Keyword.RSSET && (charSequenceArray = RGBDSParser.splitOperands(RGBDSParser.inlineDefinitions(charSequence3, map3, map4, 1, false, parsingState))).length == 2) {
                RGBDSParser.addDefinition("_RS", charSequenceArray[1], map3);
                list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                return;
            }
            if (parsingState.ramSectionDefinition) {
                if (!RGBDSParser.parseDefinitions(parsingState, n, file, charSequence, charSequence3, n2)) {
                    list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
                }
                return;
            }
            if (RGBDSParser.parseDataDirective(charSequence3, n, file, charSequence, parsingState)) {
                return;
            }
            charSequence3 = RGBDSParser.inlineDefinitions(charSequence3, map3, map4, keyword != null ? 1 : 0, false, parsingState);
            charSequence3 = RGBDSParser.inlineFunctionCalls(charSequence3, expressionEvaluator, parsingState.charmap);
            if (parsingState.tokens.size() > 1 && (StringUtilities.equalsIgnoreCase(charSequence2 = (CharSequence)parsingState.tokens.get(1), "EQU") || StringUtilities.equalsIgnoreCase(charSequence2, "SET") || StringUtilities.equalsIgnoreCase(charSequence2, "RB") || StringUtilities.equalsIgnoreCase(charSequence2, "RW")) && RGBDSParser.parseDefinitions(parsingState, n, file, charSequence, charSequence3, n2)) {
                return;
            }
            try {
                Z80Instruction z80Instruction = z80Assembler.assemble(charSequence3.toString().replaceAll("([ ,])\\(", "$10+\\("));
                list2.add(new RGBDSSourceLine(n, file, charSequence, z80Instruction));
                if (parsingState.currentSection == null) {
                    parsingState.currentSection = new Section("$Unknown$", Section.Mode.SUPERFREE, 0, 0, 0, list2.size(), list2.size());
                    parsingState.sectionSize = 0;
                }
                parsingState.sectionSize += z80Instruction.getSize();
                return;
            }
            catch (ParseException parseException) {
                if (RGBDSParser.parseDefinitions(parsingState, n, file, charSequence, charSequence3, n2)) {
                    return;
                }
                parsingState.addException(parseException);
            }
            catch (Exception exception) {
                parsingState.addException(exception);
            }
        }
        catch (AbortException abortException) {
            throw abortException;
        }
        catch (RuntimeException runtimeException) {
            parsingState.addException(runtimeException);
            list.clear();
        }
        list2.add(new RGBDSSourceLine(-1, n, file, charSequence));
    }

    private static boolean parseDefinitions(ParsingState parsingState, int n, File file, CharSequence charSequence, CharSequence charSequence2, int n2) {
        CharSequence[] charSequenceArray;
        ExpressionEvaluator expressionEvaluator;
        Map<SubCharSequence, CharSequence> map;
        Map<SubCharSequence, CharSequence> map2;
        List<Z80SourceLine> list;
        block7: {
            int n3;
            list = parsingState.lines;
            map2 = parsingState.definitions;
            map = parsingState.equs;
            expressionEvaluator = parsingState.expressionEvaluator;
            charSequenceArray = RGBDSParser.splitOperands(charSequence2);
            if (charSequenceArray.length != 1 || (n3 = StringUtilities.indexOf(charSequenceArray[0], '=')) <= 0) break block7;
            char c = charSequenceArray[0].charAt(n3 - 1);
            CharSequence charSequence3 = charSequenceArray[0];
            charSequenceArray = new CharSequence[3];
            if (OPERATORS.indexOf(c) >= 0) {
                charSequenceArray[0] = charSequence3.subSequence(0, n3 - 1);
                charSequenceArray[1] = charSequence3.subSequence(n3, n3 + 1);
                charSequenceArray[2] = StringUtilities.concat(charSequence3.subSequence(0, n3), charSequence3.subSequence(n3 + 1, charSequence3.length()));
            } else {
                charSequenceArray[0] = charSequence3.subSequence(0, n3);
                charSequenceArray[1] = charSequence3.subSequence(n3, n3 + 1);
                charSequenceArray[2] = charSequence3.subSequence(n3 + 1, charSequence3.length());
            }
            RGBDSParser.parseDefinition(charSequenceArray, map2, map, expressionEvaluator, parsingState.charmap);
            list.add(new RGBDSSourceLine(-1, n, file, charSequence));
            return true;
        }
        try {
            if (charSequenceArray.length >= 2 && (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "SET") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "EQU") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "EQUS") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "RB") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "RW") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "RL"))) {
                RGBDSParser.parseDefinition(charSequenceArray, map2, map, expressionEvaluator, parsingState.charmap);
                list.add(new RGBDSSourceLine(-1, n, file, charSequence));
                return true;
            }
        }
        catch (DefinitionException definitionException) {
            throw definitionException;
        }
        catch (Exception exception) {}
        return false;
    }

    public static CharSequence parseLabel(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n && charSequence.charAt(n2) <= ' ') {
            ++n2;
        }
        int n3 = n2;
        if (n2 < n) {
            char c;
            if (RGBDSParser.isLabelStart(c = charSequence.charAt(n2++))) {
                while (n2 < n && RGBDSParser.isLabelPart(charSequence.charAt(n2))) {
                    ++n2;
                }
            } else {
                --n2;
            }
        }
        if (n2 <= n3) {
            return "";
        }
        if (!bl && charSequence.charAt(n3) != '.' && n2 < charSequence.length() && charSequence.charAt(n2) != ':') {
            return "";
        }
        return SubCharSequence.from(charSequence, n3, n2);
    }

    private static boolean isLabelStart(char c) {
        return Character.isJavaIdentifierStart(c) || c == '.';
    }

    private static boolean isLabelPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '#' || c == '@' || c == '.';
    }

    private static CharSequence[] splitOperands(CharSequence charSequence) {
        return RGBDSParser.splitOperands(charSequence, false);
    }

    private static CharSequence[] splitOperands(CharSequence charSequence, boolean bl) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n = charSequence.length();
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            char c = charSequence.charAt(n3);
            if (c == ';') {
                RGBDSParser.addOperandToList(charSequence, n2, n3, bl2, arrayList);
                n2 = n3 = n;
            } else if (c == '#' && n3 + 1 < n && charSequence.charAt(n3 + 1) == '\"') {
                n3 += 2;
                while (n3 < n && charSequence.charAt(n3) != '\"') {
                    ++n3;
                }
                RGBDSParser.addOperandToList(charSequence, n2, n3 + 1, false, arrayList);
                n2 = n3 + 1;
            } else if (c == '\"' && (n3 <= 0 || charSequence.charAt(n3 - 1) != '\\')) {
                if (!bl) {
                    RGBDSParser.addOperandToList(charSequence, n2, n3, bl2, arrayList);
                }
                if (n3 + 2 < n && charSequence.charAt(n3 + 1) == '\"' && charSequence.charAt(n3 + 2) == '\"') {
                    n3 += 2;
                    if (!bl) {
                        n2 = n3;
                    }
                    ++n3;
                    while (n3 + 2 < n && (charSequence.charAt(n3) != '\"' || charSequence.charAt(n3 + 1) != '\"' || charSequence.charAt(n3 + 2) != '\"' || charSequence.charAt(n3 - 1) == '\\' && (n3 < 2 || charSequence.charAt(n3 - 2) != '\\'))) {
                        ++n3;
                    }
                } else {
                    if (!bl) {
                        n2 = n3;
                    }
                    ++n3;
                    while (n3 < n && (charSequence.charAt(n3) != '\"' || charSequence.charAt(n3 - 1) == '\\' && (n3 < 2 || charSequence.charAt(n3 - 2) != '\\'))) {
                        ++n3;
                    }
                }
                if (n3 >= n) {
                    throw new IllegalArgumentException("Missing closing quotation mark in " + charSequence);
                }
                if (!bl) {
                    RGBDSParser.addOperandToList(charSequence, n2, n3 + 1, false, arrayList);
                    n2 = n3 + 1;
                }
            } else if (c == '(' || c == '[') {
                char c2;
                char c3 = c2 = c == '(' ? (char)')' : ']';
                if (!(bl || n3 >= 1 && Character.isJavaIdentifierPart(charSequence.charAt(n3 - 1)))) {
                    RGBDSParser.addOperandToList(charSequence, n2, n3, bl2, arrayList);
                    n2 = n3;
                }
                int n4 = 0;
                while (n3 < n) {
                    char c4 = charSequence.charAt(n3);
                    if (c4 == '\"') {
                        ++n3;
                        while (n3 < n && (charSequence.charAt(n3) != '\"' || charSequence.charAt(n3 - 1) == '\\' && (n3 < 2 || charSequence.charAt(n3 - 2) != '\\'))) {
                            ++n3;
                        }
                    } else if (c4 == c) {
                        ++n4;
                    } else if (c4 == c2 && --n4 == 0) break;
                    ++n3;
                }
                bl2 = false;
                if (!bl) {
                    RGBDSParser.addOperandToList(charSequence, n2, Math.min(n, n3 + 1), bl2, arrayList);
                    n2 = n3 + 1;
                }
            } else if (!Character.isJavaIdentifierPart(c) && OPERATORS_AND_IDENTIFIER_SYMBOLS.indexOf(c) < 0 || c == '$' && n2 != n3) {
                if (bl) {
                    if (c == ',') {
                        arrayList.add(StringUtilities.subSequence(charSequence, n2, n3));
                    }
                    if (c == ',' || charSequence.charAt(n2) <= ' ') {
                        n2 = n3 + 1;
                    }
                } else {
                    if (RGBDSParser.addOperandToList(charSequence, n2, n3, bl2, arrayList)) {
                        bl2 = false;
                    }
                    if (c > ' ') {
                        bl2 = c == ',';
                    }
                    n2 = c == '$' ? n3 : n3 + 1;
                }
            }
            ++n3;
        }
        if (!bl) {
            RGBDSParser.addOperandToList(charSequence, n2, n, bl2, arrayList);
        } else {
            arrayList.add(StringUtilities.subSequence(charSequence, n2, n));
        }
        return arrayList.toArray(new CharSequence[arrayList.size()]);
    }

    private static boolean addOperandToList(CharSequence charSequence, int n, int n2, boolean bl, List<CharSequence> list) {
        if (n2 > n) {
            CharSequence charSequence2;
            CharSequence charSequence3 = StringUtilities.subSequence(charSequence, n, n2);
            CharSequence charSequence4 = charSequence2 = list.isEmpty() ? null : list.get(list.size() - 1);
            if (!(list.isEmpty() || bl || OPERATORS.indexOf(charSequence.charAt(n)) < 0 && (charSequence2 == null || OPERATORS.indexOf(charSequence2.charAt(charSequence2.length() - 1)) < 0) || StringUtilities.equalsIgnoreCase(charSequence2, "EQU") || StringUtilities.equalsIgnoreCase(charSequence2, "RB") || StringUtilities.equalsIgnoreCase(charSequence2, "RW"))) {
                if (charSequence2 != null && charSequence2.charAt(charSequence2.length() - 1) == '%') {
                    list.set(list.size() - 1, StringUtilities.concat(list.get(list.size() - 1), StringUtilities.concat(" ", charSequence3)));
                } else if (charSequence3.charAt(0) == '+' && StringUtilities.indexOf(charSequence2, "<<") >= 0) {
                    list.set(list.size() - 1, StringUtilities.concat("(", StringUtilities.concat(StringUtilities.concat(list.get(list.size() - 1), ")"), charSequence3)));
                } else {
                    list.set(list.size() - 1, StringUtilities.concat(list.get(list.size() - 1), charSequence3));
                }
            } else {
                list.add(charSequence3);
            }
            return true;
        }
        return false;
    }

    private static void addDefinition(CharSequence charSequence, CharSequence charSequence2, Map<SubCharSequence, CharSequence> map) {
        map.put(SubCharSequence.from(charSequence), charSequence2);
    }

    private static CharSequence inlineDefinitions(CharSequence charSequence, Map<SubCharSequence, CharSequence> map, Map<SubCharSequence, CharSequence> map2) {
        return RGBDSParser.inlineDefinitions(charSequence, map, map2, 0, false, null);
    }

    private static CharSequence inlineDefinitions(CharSequence charSequence, Map<SubCharSequence, CharSequence> map, Map<SubCharSequence, CharSequence> map2, int n, boolean bl, ParsingState parsingState) {
        if (!map.isEmpty()) {
            int n2 = 0;
            List<SubCharSequence> list = parsingState != null ? parsingState.splitTokens(charSequence) : RGBDSParser.splitTokens(charSequence);
            Map<SubCharSequence, CharSequence> map3 = map2;
            for (SubCharSequence subCharSequence : list) {
                if (!(n > 0 || StringUtilities.isEmpty(subCharSequence) || bl && subCharSequence.charAt(0) != '{')) {
                    if (parsingState != null && parsingState.macros.containsKey(subCharSequence)) break;
                    CharSequence charSequence2 = null;
                    if (subCharSequence.charAt(0) == '{') {
                        charSequence2 = SubCharSequence.from(RGBDSParser.inlineDefinitions(subCharSequence.subSequence(1, subCharSequence.length() - 1), map, map2, 0, true, null));
                        if (charSequence2.length() > 2 && charSequence2.charAt(1) == ':') {
                            if ((charSequence2 = map3.get(charSequence2.subSequence(2, charSequence2.length()))) != null) {
                                switch (subCharSequence.charAt(1)) {
                                    default: 
                                }
                            }
                        } else if ((charSequence2 = map3.get(charSequence2)) != null && parsingState != null && (charSequence2 = RGBDSParser.inlineFunctionCalls(charSequence2, parsingState.expressionEvaluator, parsingState.charmap)).length() > 2 && charSequence2.charAt(0) == '\"' && charSequence2.charAt(charSequence2.length() - 1) == '\"') {
                            charSequence2 = charSequence2.subSequence(1, charSequence2.length() - 1);
                        }
                    } else {
                        charSequence2 = subCharSequence.length() == 2 && subCharSequence.charAt(0) == '\\' && subCharSequence.charAt(1) == 'n' ? "\n" : map3.get(subCharSequence);
                    }
                    if (charSequence2 != null) {
                        CharSequence charSequence3 = charSequence.subSequence(0, n2 + subCharSequence.getBeginIndex());
                        CharSequence charSequence4 = charSequence.subSequence(n2 + subCharSequence.getEndIndex(), charSequence.length());
                        if (charSequence3.length() + charSequence2.length() + charSequence4.length() < 1000) {
                            charSequence = StringUtilities.concat(StringUtilities.concat(charSequence3, charSequence2), charSequence4);
                            n2 += charSequence2.length() - (subCharSequence.getEndIndex() - subCharSequence.getBeginIndex());
                            if (map3 == map2 && parsingState != null && StringUtilities.indexOf(charSequence2, '\n') >= 0 && subCharSequence.charAt(0) != '{' && (subCharSequence.length() != 2 || subCharSequence.charAt(0) != '\\' || subCharSequence.charAt(1) != 'n')) {
                                parsingState.newLineEncountered = true;
                            }
                        }
                    }
                }
                --n;
                map3 = map;
            }
        }
        return charSequence;
    }

    private static CharSequence inlineMacroArgs(CharSequence charSequence, MacroArgs macroArgs, ParsingState parsingState) {
        if (macroArgs != null) {
            int n = 0;
            Map<SubCharSequence, CharSequence> map = parsingState.definitions;
            List<SubCharSequence> list = parsingState.splitTokens(charSequence);
            for (SubCharSequence subCharSequence : list) {
                int n2;
                if (StringUtilities.isEmpty(subCharSequence)) continue;
                CharSequence charSequence2 = null;
                boolean bl = subCharSequence.length() > 2 && subCharSequence.charAt(0) == '{';
                int n3 = n2 = bl ? Math.max(0, StringUtilities.indexOf((CharSequence)subCharSequence, '\\')) : 0;
                if (NARGS.equals(subCharSequence)) {
                    charSequence2 = Integer.toString(macroArgs.getNumberOfArgs());
                } else if (subCharSequence.length() >= 2 && subCharSequence.charAt(n2) == '\\') {
                    if (subCharSequence.charAt(n2 + 1) == '@') {
                        charSequence2 = Integer.toString(macroArgs.getCallCount());
                    } else if (subCharSequence.charAt(n2 + 1) == '#') {
                        charSequence2 = macroArgs.getAllArgs();
                    } else if (subCharSequence.charAt(n2 + 1) == '<') {
                        try {
                            charSequence2 = macroArgs.getArg(Integer.parseInt(RGBDSParser.inlineDefinitions(subCharSequence.subSequence(n2 + 2, subCharSequence.length() - 1 - n2), map, map).toString()));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (Character.isDigit(subCharSequence.charAt(n2 + 1)) && (charSequence2 = macroArgs.getArg(subCharSequence.charAt(n2 + 1) - 48)) != null && charSequence2.length() > 0 && charSequence2.charAt(0) == '\"') {
                        int n4 = n + subCharSequence.getBeginIndex();
                        boolean bl2 = charSequence.charAt(0) == '\"';
                        int n5 = 1;
                        while (n5 < n4) {
                            if (charSequence.charAt(n5) == '\"' && charSequence.charAt(n5 - 1) != '\\') {
                                bl2 = !bl2;
                            }
                            ++n5;
                        }
                        if (bl2) {
                            charSequence2 = StringUtilities.concat("\\", StringUtilities.concat(charSequence2.subSequence(0, charSequence2.length() - 1), "\\\""));
                        }
                    }
                    if (bl && charSequence2 != null) {
                        charSequence2 = RGBDSParser.inlineDefinitions(charSequence2, map, parsingState.equs);
                    }
                }
                if (charSequence2 == null) continue;
                CharSequence charSequence3 = charSequence.subSequence(0, n + subCharSequence.getBeginIndex());
                CharSequence charSequence4 = charSequence.subSequence(n + subCharSequence.getEndIndex(), charSequence.length());
                charSequence = StringUtilities.concat(StringUtilities.concat(charSequence3, charSequence2), charSequence4);
                n += charSequence2.length() - (subCharSequence.getEndIndex() - subCharSequence.getBeginIndex());
            }
        }
        return charSequence;
    }

    private static CharSequence inlineFunctionCalls(CharSequence charSequence, ExpressionEvaluator expressionEvaluator, RGBDSCharmap rGBDSCharmap) {
        int n;
        int n2;
        CharSequence charSequence2;
        Object object;
        CharSequence[] charSequenceArray;
        int n3;
        int n4;
        int n5 = StringUtilities.lastIndexOfIgnoreCase(charSequence, "STR");
        while (n5 >= 0) {
            n4 = StringUtilities.indexOf(charSequence, '(', n5);
            if (n4 >= 0) {
                CharSequence charSequence3;
                n3 = RGBDSParser.indexOfClosingParenthesis(charSequence, n4);
                CharSequence[] charSequenceArray2 = charSequenceArray = n3 >= 0 ? RGBDSParser.splitOperands(charSequence.subSequence(n4 + 1, n3)) : null;
                if (charSequenceArray == null || charSequenceArray.length <= 0) break;
                object = charSequence.subSequence(0, n5);
                charSequence2 = charSequence.subSequence(n3 + 1, charSequence.length());
                if (StringUtilities.startsWithIgnoreCase(charSequence, "STRLEN", n5)) {
                    charSequence3 = Integer.toString(charSequenceArray[0].length() - StringUtilities.countEscapedChars(charSequenceArray[0]) - 2);
                } else if (StringUtilities.startsWithIgnoreCase(charSequence, "STRUPR", n5)) {
                    charSequence3 = charSequenceArray[0].toString().toUpperCase();
                } else if (StringUtilities.startsWithIgnoreCase(charSequence, "STRLWR", n5)) {
                    charSequence3 = charSequenceArray[0].toString().toLowerCase();
                } else {
                    if (charSequenceArray.length <= 1) break;
                    if (StringUtilities.startsWithIgnoreCase(charSequence, "STRCAT", n5)) {
                        charSequence3 = StringUtilities.concat(charSequenceArray[0].subSequence(1, charSequenceArray[0].length() - 1), charSequenceArray[1].subSequence(1, charSequenceArray[1].length() - 1));
                    } else if (StringUtilities.startsWithIgnoreCase(charSequence, "STRCMP", n5)) {
                        charSequence3 = Integer.toString(charSequenceArray[0].toString().compareTo(charSequenceArray[1].toString()));
                    } else if (StringUtilities.startsWithIgnoreCase(charSequence, "STRIN", n5)) {
                        charSequence3 = Integer.toString(StringUtilities.indexOf(charSequenceArray[0].subSequence(1, charSequenceArray[0].length() - 1), charSequenceArray[1].subSequence(1, charSequenceArray[1].length() - 1)) + 1);
                    } else {
                        if (charSequenceArray.length < 2 || !StringUtilities.startsWithIgnoreCase(charSequence, "STRSUB", n5)) break;
                        int n6 = Math.max(1, RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]));
                        int n7 = Math.min(charSequenceArray[0].length() - n6, (charSequenceArray.length > 2 ? RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]) : charSequenceArray[0].length() - n6 - StringUtilities.countEscapedChars(charSequenceArray[0], n6, charSequenceArray[0].length()) - 1) & Integer.MAX_VALUE);
                        charSequence3 = StringUtilities.concat(StringUtilities.concat("\"", charSequenceArray[0].subSequence(n6, n6 + n7 + StringUtilities.countEscapedChars(charSequenceArray[0], n6, n6 + n7))), "\"");
                    }
                }
                if (charSequence3 != null) {
                    charSequence = StringUtilities.concat(StringUtilities.concat((CharSequence)object, charSequence3), charSequence2);
                    n5 = charSequence.length();
                }
            }
            n5 = StringUtilities.lastIndexOfIgnoreCase(charSequence, "STR", n5 - 1);
        }
        n5 = StringUtilities.lastIndexOfIgnoreCase(charSequence, "LOW");
        while (n5 >= 0) {
            n4 = StringUtilities.indexOf(charSequence, '(', n5);
            if (n4 < 0 || (charSequenceArray = RGBDSParser.splitOperands(charSequence.subSequence(n4 + 1, n3 = RGBDSParser.indexOfClosingParenthesis(charSequence, n4)))).length != 1) break;
            object = charSequence.subSequence(0, n5);
            charSequence2 = charSequence.subSequence(n3 + 1, charSequence.length());
            if (charSequenceArray[0].length() == 2 && (StringUtilities.equalsIgnoreCase(charSequenceArray[0], "BC") || StringUtilities.equalsIgnoreCase(charSequenceArray[0], "DE") || StringUtilities.equalsIgnoreCase(charSequenceArray[0], "HL"))) {
                charSequence = StringUtilities.concat(StringUtilities.concat((CharSequence)object, charSequenceArray[0].subSequence(1, 2)), charSequence2);
            } else {
                int n8;
                if (charSequenceArray[0].charAt(0) == '\"') {
                    charSequenceArray[0] = rGBDSCharmap.map(charSequenceArray[0].toString());
                    charSequenceArray[0] = Integer.toString(charSequenceArray[0].charAt(1));
                }
                if ((n8 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[0])) == -1073741824) break;
                charSequence = StringUtilities.concat(StringUtilities.concat((CharSequence)object, Integer.toString(n8 & 0xFF)), charSequence2);
            }
            n5 = StringUtilities.lastIndexOfIgnoreCase(charSequence, "LOW");
        }
        if ((n5 = StringUtilities.lastIndexOfIgnoreCase(charSequence, "HIGH")) >= 0 && (n4 = StringUtilities.indexOf(charSequence, '(', n5)) >= 0 && (charSequenceArray = RGBDSParser.splitOperands(charSequence.subSequence(n4 + 1, n3 = RGBDSParser.indexOfClosingParenthesis(charSequence, n4)))).length == 1) {
            object = charSequence.subSequence(0, n5);
            charSequence2 = charSequence.subSequence(n3 + 1, charSequence.length());
            if (charSequenceArray[0].length() == 2 && (StringUtilities.equalsIgnoreCase(charSequenceArray[0], "BC") || StringUtilities.equalsIgnoreCase(charSequenceArray[0], "DE") || StringUtilities.equalsIgnoreCase(charSequenceArray[0], "HL"))) {
                return StringUtilities.concat(StringUtilities.concat((CharSequence)object, charSequenceArray[0].subSequence(0, 1)), charSequence2);
            }
            int n9 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[0]);
            if (n9 != -1073741824) {
                return StringUtilities.concat(StringUtilities.concat((CharSequence)object, Integer.toString(n9 >> 8 & 0xFF)), charSequence2);
            }
        }
        if ((n4 = StringUtilities.lastIndexOfIgnoreCase(charSequence, "CHARSUB")) >= 0 && (n3 = StringUtilities.indexOf(charSequence, '(', n4)) >= 0 && ((CharSequence[])(object = RGBDSParser.splitOperands(charSequence.subSequence(n3 + 1, n2 = RGBDSParser.indexOfClosingParenthesis(charSequence, n3))))).length == 2 && (n = RGBDSParser.evaluateExpression(expressionEvaluator, object[1])) != -1073741824) {
            CharSequence charSequence4 = StringUtilities.concat(charSequence.subSequence(0, n4), "'");
            CharSequence charSequence5 = StringUtilities.concat("'", charSequence.subSequence(n2 + 1, charSequence.length()));
            object[0] = rGBDSCharmap.map(object[0].toString());
            return StringUtilities.concat(StringUtilities.concat(charSequence4, object[0].subSequence(n, n + 1)), charSequence5);
        }
        return charSequence;
    }

    private static int indexOfClosingParenthesis(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 < charSequence.length()) {
            char c = charSequence.charAt(n3);
            if (c == '(') {
                ++n2;
            } else if (c == ')') {
                if (--n2 <= 0) {
                    return n3;
                }
            } else if (c == '\"') {
                ++n3;
                while (n3 < charSequence.length() && (charSequence.charAt(n3) != '\"' || charSequence.charAt(n3 - 1) == '\\' && (n3 < 2 || charSequence.charAt(n3 - 2) != '\\'))) {
                    ++n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    static List<SubCharSequence> splitTokens(CharSequence charSequence) {
        ArrayList<SubCharSequence> arrayList = new ArrayList<SubCharSequence>();
        int n = charSequence.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = charSequence.charAt(n3);
            if (c == ';') {
                if (n3 > n2 && charSequence.charAt(n2) != '$') {
                    arrayList.add(SubCharSequence.from(charSequence, n2, n3));
                }
                n2 = n3 = n;
            } else if (c == '\"') {
                if (n3 > 0 && charSequence.charAt(n3 - 1) == '#') {
                    ++n3;
                    while (n3 < n && charSequence.charAt(n3) != '\"') {
                        ++n3;
                    }
                } else {
                    n2 = ++n3;
                    while (n3 < n && (charSequence.charAt(n3) != '\"' || charSequence.charAt(n3 - 1) == '\\' && (n3 < 2 || charSequence.charAt(n3 - 2) != '\\'))) {
                        ++n3;
                    }
                    if (n3 - n2 == 1 || n3 - n2 == 2 && charSequence.charAt(n2) == '\\' && !Character.isDigit(charSequence.charAt(n2 + 1))) {
                        arrayList.add(SubCharSequence.from(charSequence, n2 - 1, n3 + 1));
                    } else {
                        for (SubCharSequence subCharSequence : RGBDSParser.splitTokens(charSequence.subSequence(n2, n3))) {
                            if (StringUtilities.isEmpty(subCharSequence) || subCharSequence.charAt(0) != '{' && subCharSequence.charAt(0) != '\\') continue;
                            arrayList.add(SubCharSequence.from(charSequence, n2 + subCharSequence.getBeginIndex(), n2 + subCharSequence.getEndIndex()));
                        }
                    }
                }
                n2 = n3 + 1;
            } else if (c == '\\') {
                if (n3 > n2 && charSequence.charAt(n2) != '$') {
                    arrayList.add(SubCharSequence.from(charSequence, n2, n3));
                }
                n2 = n3++;
                if (n3 < n && (charSequence.charAt(n3) == '@' || charSequence.charAt(n3) == '#')) {
                    ++n3;
                } else if (n3 < n && charSequence.charAt(n3) == 'n') {
                    ++n3;
                } else if (n3 < n && charSequence.charAt(n3) == '<') {
                    ++n3;
                    while (n3 < n && charSequence.charAt(n3) != '>') {
                        ++n3;
                    }
                    ++n3;
                } else if (Character.isDigit(charSequence.charAt(n3))) {
                    ++n3;
                }
                if (n3 > n2 + 1 && charSequence.charAt(n2) != '$') {
                    arrayList.add(SubCharSequence.from(charSequence, n2, n3));
                }
                n2 = n3 + 1;
            } else if (c == '{') {
                if (n3 > n2) {
                    arrayList.add(SubCharSequence.from(charSequence, n2, n3));
                }
                n2 = n3++;
                int n4 = 1;
                while (n3 < n) {
                    if (charSequence.charAt(n3) == '{') {
                        ++n4;
                    }
                    if (charSequence.charAt(n3) == '}' && --n4 <= 0) break;
                    ++n3;
                }
                if (n3 > n2 && n3 < n) {
                    arrayList.add(SubCharSequence.from(charSequence, n2, n3 + 1));
                }
                n2 = n3 + 1;
            } else if ((n3 == n2 ? !Character.isLetter(c) : !Character.isLetterOrDigit(c)) && c != '?' && c != '.' && c != '_' && c != '$' && c != '#') {
                if (n3 > n2 && charSequence.charAt(n2) != '$') {
                    arrayList.add(SubCharSequence.from(charSequence, n2, n3));
                }
                n2 = n3 + 1;
            }
            ++n3;
        }
        if (n > n2 && charSequence.charAt(n2) != '$') {
            arrayList.add(SubCharSequence.from(charSequence, n2, n));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseDefinition(CharSequence[] charSequenceArray, Map<SubCharSequence, CharSequence> map, Map<SubCharSequence, CharSequence> map2, ExpressionEvaluator expressionEvaluator, RGBDSCharmap rGBDSCharmap) {
        if (charSequenceArray.length < 2) return;
        charSequenceArray[0] = RGBDSParser.inlineDefinitions(charSequenceArray[0], map, map2, 0, true, null);
        if (StringUtilities.isEmpty(charSequenceArray[0]) || !Character.isJavaIdentifierStart(charSequenceArray[0].charAt(0))) throw new DefinitionException("A definition must be a valid identifier: " + charSequenceArray[0]);
        if (charSequenceArray.length > 2) {
            charSequenceArray[2] = RGBDSParser.inlineDefinitions(charSequenceArray[2], map, map);
            charSequenceArray[2] = RGBDSParser.inlineFunctionCalls(charSequenceArray[2], expressionEvaluator, rGBDSCharmap);
        }
        if (charSequenceArray.length > 2 && StringUtilities.equalsIgnoreCase(charSequenceArray[1], "EQUS")) {
            CharSequence charSequence = charSequenceArray[2].length() > 0 && charSequenceArray[2].charAt(0) == '\"' ? charSequenceArray[2].subSequence(1, charSequenceArray[2].length() - 1) : charSequenceArray[2];
            RGBDSParser.addDefinition(charSequenceArray[0], charSequence, map);
            RGBDSParser.addDefinition(charSequenceArray[0], charSequence, map2);
            return;
        } else if (charSequenceArray[1].length() == 2 && Character.toUpperCase(charSequenceArray[1].charAt(0)) == 'R' && (Character.toUpperCase(charSequenceArray[1].charAt(1)) == 'B' || Character.toUpperCase(charSequenceArray[1].charAt(1)) == 'W' || Character.toUpperCase(charSequenceArray[1].charAt(1)) == 'L')) {
            char c = Character.toUpperCase(charSequenceArray[1].charAt(1));
            try {
                int n = c == 'L' ? 4 : (c == 'W' ? 2 : 1);
                int n2 = charSequenceArray.length > 2 ? expressionEvaluator.evaluate(charSequenceArray[2]) : 1;
                SubCharSequence subCharSequence = SubCharSequence.from("_RS");
                CharSequence charSequence = map.get(subCharSequence);
                RGBDSParser.addDefinition(charSequenceArray[0], charSequence, map);
                RGBDSParser.addDefinition(subCharSequence, Integer.toString(expressionEvaluator.evaluate(charSequence.toString()) + n2 * n), map);
                return;
            }
            catch (EvaluateException evaluateException) {
                return;
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                if (charSequenceArray.length <= 2) return;
                RGBDSParser.addDefinition(charSequenceArray[0], charSequenceArray[2], map);
            }
            return;
        } else {
            if (charSequenceArray.length <= 2) throw new DefinitionException("Missing operand: " + Arrays.toString(charSequenceArray));
            try {
                int n = expressionEvaluator.evaluate(charSequenceArray[2]);
                RGBDSParser.addDefinition(charSequenceArray[0], Integer.toString(n), map);
                return;
            }
            catch (EvaluateException evaluateException) {
                return;
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                RGBDSParser.addDefinition(charSequenceArray[0], charSequenceArray[2], map);
            }
        }
    }

    private static boolean parseIncludeDirective(CharSequence charSequence, Keyword keyword, int n, File file, CharSequence charSequence2, ParsingState parsingState, ExpressionEvaluator expressionEvaluator, int n2) {
        int n3;
        CharSequence charSequence3;
        if (keyword != Keyword.INCLUDE && keyword != Keyword.INCBIN) {
            return false;
        }
        List<Z80SourceLine> list = parsingState.lines;
        charSequence = charSequence.subSequence(keyword.toString().length(), charSequence.length());
        charSequence = RGBDSParser.inlineDefinitions(charSequence, parsingState.definitions, parsingState.definitions);
        CharSequence[] charSequenceArray = RGBDSParser.splitOperands(charSequence = RGBDSParser.inlineFunctionCalls(charSequence, expressionEvaluator, parsingState.charmap));
        if (charSequenceArray.length <= 0) {
            return false;
        }
        CharSequence charSequence4 = charSequence3 = charSequenceArray[0].charAt(0) == '\"' ? charSequenceArray[0].subSequence(1, charSequenceArray[0].length() - 1) : charSequenceArray[0];
        if (keyword == Keyword.INCLUDE) {
            File file2 = RGBDSParser.getFile(charSequence3.toString(), file, parsingState);
            try {
                list.add(new RGBDSSourceLine(-1, n, file, ";* " + charSequence2));
                RGBDSParser.readLines(file2, parsingState, n2 + 1);
                list.add(new RGBDSSourceLine(";* END OF " + charSequence2));
            }
            catch (IOException iOException) {
                list.add(new RGBDSSourceLine(";* END OF " + charSequence2 + ": Failed to read include file: " + iOException.getMessage()));
            }
            return true;
        }
        int n4 = 0;
        int n5 = -1;
        if (charSequenceArray.length >= 2) {
            n4 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
            if (charSequenceArray.length >= 3) {
                n5 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
            }
        }
        File file3 = RGBDSParser.getFile(charSequence3.toString(), file, parsingState);
        if (n5 < 0 && !file3.exists()) {
            list.add(new RGBDSSourceLine(-1, n, file, charSequence2 + " ; File does not exist: " + file3.getAbsolutePath()));
            return true;
        }
        int n6 = n3 = n5 >= 0 ? n5 : (int)file3.length() - n4;
        if (n3 < 0 || n4 < 0 || n5 == -1073741824) {
            list.add(new RGBDSSourceLine(-1, n, file, charSequence2 + " ; Failed to determine size"));
            return true;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file3);
            fileInputStream.skip(n4);
            int[] nArray = new int[Math.min(33, n3)];
            byte[] byArray = new byte[nArray.length];
            fileInputStream.read(byArray);
            int n7 = 0;
            while (n7 < nArray.length) {
                nArray[n7] = byArray[n7] & 0xFF;
                ++n7;
            }
            list.add(new RGBDSSourceLine(n3, n, file, charSequence2, nArray));
            fileInputStream.close();
        }
        catch (IOException iOException) {
            list.add(new RGBDSSourceLine(n3, n, file, charSequence2));
        }
        parsingState.sectionSize += n3;
        return true;
    }

    private static File getFile(String string, File file, ParsingState parsingState) {
        File file2;
        File file3 = file2 = new File(string).isAbsolute() ? new File(string) : new File(file.getParentFile(), string);
        if (file2.exists()) {
            return file2;
        }
        File file4 = parsingState.findFile(string);
        if (file4 != null) {
            return file4;
        }
        File file5 = parsingState.rootFile;
        File file6 = file5.getParentFile();
        while (file6 != null) {
            File file7;
            File file8 = new File(file6, string);
            if (file8.exists()) {
                parsingState.addIncDir(file6);
                return file8;
            }
            File file9 = new File(file6, "include");
            if (!file9.exists()) {
                file9 = new File(file6, "inc");
            }
            if (file9.exists() && (file7 = new File(file9, string)).exists()) {
                parsingState.addIncDir(file9);
                return file7;
            }
            file6 = file6.getParentFile();
        }
        return new File(file5.getParentFile(), string);
    }

    private static boolean parseDataDirective(CharSequence charSequence, int n, File file, CharSequence charSequence2, ParsingState parsingState) {
        if (charSequence.length() > 2 && Character.toUpperCase(charSequence.charAt(0)) == 'D') {
            int n2;
            int[] nArray;
            int n3;
            int n4;
            List<Z80SourceLine> list;
            block43: {
                ExpressionEvaluator expressionEvaluator = parsingState.expressionEvaluator;
                list = parsingState.lines;
                int n5 = parsingState.maxBytePrefixLength;
                char c = Character.toUpperCase(charSequence.charAt(1));
                int n6 = c == 'L' ? 4 : (c == 'W' ? 2 : (n4 = c == 'B' || c == 'S' ? 1 : 0));
                if (n4 <= 0) {
                    return false;
                }
                charSequence = RGBDSParser.inlineDefinitions(charSequence, parsingState.definitions, parsingState.equs, 1, false, parsingState);
                charSequence = RGBDSParser.inlineFunctionCalls(charSequence, expressionEvaluator, parsingState.charmap);
                CharSequence[] charSequenceArray = RGBDSParser.splitOperands(charSequence.subSequence(2, charSequence.length()));
                n3 = 0;
                nArray = null;
                if (c == 'S') {
                    n3 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[0]);
                    if (n3 >= 0) {
                        try {
                            if (charSequenceArray.length == 2) {
                                n2 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                                if (n2 != -1073741824) {
                                    int n7;
                                    int n8 = n7 = n4 == 1 && n3 == 0 ? StringUtilities.indexOf(charSequenceArray[0], '@') : -1;
                                    if (n7 >= 0) {
                                        nArray = new int[]{RGBDSParser.evaluateExpression(expressionEvaluator, StringUtilities.concat(charSequenceArray[0].subSequence(0, n7), "0"))};
                                    } else if (n4 == 1 && n3 > 0) {
                                        nArray = new int[]{n2};
                                    } else {
                                        nArray = new int[Math.min(n5, n3)];
                                        int n9 = 0;
                                        while (n9 < nArray.length) {
                                            nArray[n9] = n2 >> 8 * (n9 & n4 - 1) & 0xFF;
                                            ++n9;
                                        }
                                    }
                                }
                                break block43;
                            }
                            if (charSequenceArray.length <= 2) break block43;
                            int[] nArray2 = new int[charSequenceArray.length - 1];
                            int n10 = 0;
                            while (n10 < nArray2.length) {
                                nArray2[n10] = RGBDSParser.evaluateExpression(expressionEvaluator, charSequenceArray[1 + n10]);
                                ++n10;
                            }
                            n10 = 0;
                            while (n10 < n5 && n10 < nArray2.length * n3 && nArray2[n10 % nArray2.length] != -1073741824) {
                                ++n10;
                            }
                            if (n10 <= 0) break block43;
                            nArray = new int[n10];
                            int n11 = 0;
                            while (n11 < nArray.length) {
                                nArray[n11] = nArray2[n11 % nArray2.length];
                                ++n11;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            nArray = new int[Math.min(n5, n3 * n4)];
                            Arrays.fill(nArray, -1);
                        }
                    }
                } else {
                    int n12;
                    int n13 = 0;
                    while (n13 < charSequenceArray.length) {
                        if (StringUtilities.startsWithIgnoreCase(charSequenceArray[n13], "__ISO_8601_")) {
                            n3 += 20;
                        } else if (charSequenceArray[n13].charAt(charSequenceArray[n13].length() - 1) == '\"') {
                            n12 = charSequenceArray[n13].charAt(0) == '\"' ? StringUtilities.countEscapedChars(charSequenceArray[n13]) : 1;
                            charSequenceArray[n13] = parsingState.charmap.map(charSequenceArray[n13].toString());
                            n3 += charSequenceArray[n13].length() - n12 - 2;
                        } else {
                            ++n3;
                        }
                        ++n13;
                    }
                    nArray = new int[Math.min(n5, n3 * n4)];
                    n13 = 0;
                    n12 = 0;
                    while (n12 < nArray.length) {
                        try {
                            int n14;
                            CharSequence charSequence3 = charSequenceArray[n13 / n4];
                            if (charSequence3.charAt(0) == '\"') {
                                n14 = 1;
                                while (n14 < charSequence3.length() - 1 && n12 < nArray.length) {
                                    if (charSequence3.charAt(n14) == '\\') {
                                        switch (charSequence3.charAt(++n14)) {
                                            case '\"': 
                                            case '\'': 
                                            case '\\': {
                                                nArray[n12++] = charSequence3.charAt(n14);
                                                break;
                                            }
                                            case 'r': {
                                                nArray[n12++] = 13;
                                                break;
                                            }
                                            case 'n': {
                                                nArray[n12++] = 10;
                                                break;
                                            }
                                            case 't': {
                                                nArray[n12++] = 9;
                                                break;
                                            }
                                            case '0': {
                                                nArray[n12++] = 0;
                                                break;
                                            }
                                            default: {
                                                nArray[n12++] = -1;
                                                --n14;
                                                break;
                                            }
                                        }
                                    } else {
                                        nArray[n12++] = -1;
                                    }
                                    ++n14;
                                }
                                --n12;
                            } else if (charSequence3.charAt(0) == '#') {
                                n14 = 1;
                                while (n14 < charSequence3.length() - 1 && n12 < nArray.length) {
                                    nArray[n12++] = -1;
                                    ++n14;
                                }
                            } else {
                                n14 = RGBDSParser.evaluateExpression(expressionEvaluator, charSequence3);
                                nArray[n12] = n14 != -1073741824 ? n14 >> 8 * (n13 & n4 - 1) & 0xFF : -1;
                            }
                        }
                        catch (AbortException abortException) {
                            throw abortException;
                        }
                        catch (RuntimeException runtimeException) {
                            nArray[n12] = -1;
                        }
                        ++n12;
                        ++n13;
                    }
                }
            }
            int n15 = n2 = n3 < 0 ? 0 : n3 * n4;
            if (n2 > 0 || n2 == 0 && nArray != null) {
                list.add(new RGBDSSourceLine(n2, n, file, charSequence2, nArray));
            } else {
                list.add(new RGBDSSourceLine(-1, n, file, charSequence2));
            }
            parsingState.sectionSize += n2;
            return true;
        }
        return false;
    }

    private static int evaluateExpression(ExpressionEvaluator expressionEvaluator, CharSequence charSequence) {
        try {
            return expressionEvaluator.evaluate(charSequence.toString());
        }
        catch (UnknownIdentifierException unknownIdentifierException) {
        }
        catch (EvaluateException evaluateException) {}
        return -1073741824;
    }

    private static class DefinitionException
    extends RuntimeException {
        public DefinitionException(String string) {
            super(string);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static enum Keyword {
        DEF,
        FRAGMENT,
        BANK,
        ALIGN,
        SIZEOF,
        STARTOF,
        ROUND,
        CEIL,
        FLOOR,
        DIV,
        MUL,
        POW,
        LOG,
        SIN,
        COS,
        TAN,
        ASIN,
        ACOS,
        ATAN,
        ATAN2,
        HIGH,
        LOW,
        ISCONST,
        STRCMP,
        STRIN,
        STRRIN,
        STRSUB,
        STRLEN,
        STRCAT,
        STRUPR,
        STRLWR,
        STRRPL,
        STRFMT,
        CHARLEN,
        CHARSUB,
        INCLUDE,
        PRINT,
        PRINTLN,
        PRINTT,
        PRINTI,
        PRINTV,
        PRINTF,
        EXPORT,
        DS,
        DB,
        DW,
        DL,
        SECTION,
        ENDSECTION,
        PURGE,
        RSRESET,
        RSSET,
        INCBIN,
        CHARMAP,
        NEWCHARMAP,
        SETCHARMAP,
        INCHARMAP,
        PUSHC,
        POPC,
        FAIL,
        WARN,
        FATAL,
        ASSERT,
        STATIC_ASSERT,
        MACRO,
        ENDM,
        SHIFT,
        REPT,
        FOR,
        ENDR,
        BREAK,
        LOAD,
        ENDL,
        IF,
        ELSE,
        ELIF,
        ENDC,
        UNION,
        NEXTU,
        ENDU,
        RB,
        RW,
        RL,
        EQU,
        EQUS,
        REDEF,
        SET,
        PUSHS,
        POPS,
        PUSHO,
        POPO,
        OPT;

    }

    private static class MacroArgs {
        private final CharSequence[] args;
        private final int callCount;
        private int shift;

        public MacroArgs(CharSequence[] charSequenceArray, int n) {
            this.args = charSequenceArray;
            this.callCount = n;
        }

        public CharSequence getArg(int n) {
            return (n = n - 1 + this.shift) < this.args.length ? this.args[n] : null;
        }

        public CharSequence getAllArgs() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.args.length > this.shift) {
                stringBuilder.append(this.args[this.shift]);
            }
            int n = this.shift + 1;
            while (n < this.args.length) {
                stringBuilder.append(',').append(this.args[n]);
                ++n;
            }
            return stringBuilder.toString();
        }

        public int getNumberOfArgs() {
            return this.args.length - this.shift;
        }

        public int getCallCount() {
            return this.callCount;
        }

        public void shiftBy(int n) {
            this.shift = Math.max(0, Math.min(this.args.length, this.shift + n));
        }

        public String toString() {
            return this.getAllArgs().toString();
        }
    }

    public static class ParseResult
    extends AbstractZ80ParseResult {
        private final List<Z80SourceLine> lines;
        private final List<Section> sections;
        private final List<Exception> exceptions;
        private final ROMBankMap romBankMap;

        public ParseResult(ParsingState parsingState) {
            this.lines = parsingState.lines;
            this.sections = parsingState.sections;
            this.exceptions = parsingState.exceptions;
            this.romBankMap = new RGBDSROMBankMap(512);
        }

        @Override
        public List<Z80SourceLine> getLines() {
            return this.lines;
        }

        @Override
        public List<Section> getSections() {
            return this.sections;
        }

        @Override
        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        @Override
        public ROMBankMap getROMBankMap() {
            return this.romBankMap;
        }

        @Override
        public AssemblerDialect getDialect() {
            return RgbdsDialect.getInstance();
        }
    }

    private static class ParsingState {
        Macro currentMacro;
        boolean blockComment;
        boolean shouldBreak;
        boolean skipToNextIfPart;
        boolean skipToEndIfPart;
        boolean inCondition;
        boolean ramSectionDefinition;
        boolean loadSectionDefinition;
        boolean newLineEncountered;
        Section currentSection;
        int sectionSize;
        int nestedIfs;
        boolean multiLineString;
        CharSequence lineContinuation;
        CharSequence lineOfTokens;
        List<SubCharSequence> tokens;
        RGBDSCharmap charmap;
        private final ArrayDeque<RGBDSCharmap> charmapStack = new ArrayDeque();
        private final Map<String, RGBDSCharmap> charmaps = new HashMap<String, RGBDSCharmap>();
        final List<Z80SourceLine> lines = new ArrayList<Z80SourceLine>();
        final List<Section> sections = new ArrayList<Section>();
        final List<Exception> exceptions = new ArrayList<Exception>();
        final Deque<Section> sectionStack = new ArrayDeque<Section>();
        final File rootFile;
        final int maxBytePrefixLength;
        final Map<SubCharSequence, CharSequence> definitions = new HashMap<SubCharSequence, CharSequence>();
        final Map<SubCharSequence, CharSequence> equs = new HashMap<SubCharSequence, CharSequence>();
        final Map<SubCharSequence, Macro> macros = new HashMap<SubCharSequence, Macro>();
        final Map<SubCharSequence, Integer> macroCalls = new HashMap<SubCharSequence, Integer>();
        final Z80Assembler assembler;
        final ExpressionEvaluator expressionEvaluator;
        private final Set<File> parsedFiles = new HashSet<File>();
        private final List<File> incDirs = new ArrayList<File>();

        public ParsingState(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator, int n) {
            this.rootFile = file;
            this.assembler = z80Assembler;
            this.expressionEvaluator = expressionEvaluator;
            this.maxBytePrefixLength = n;
            this.definitions.put(SubCharSequence.from("_RS"), "0");
            this.charmap = this.newCharmap("main", null);
        }

        public RGBDSCharmap newCharmap(String string, String string2) {
            RGBDSCharmap rGBDSCharmap = this.charmaps.get(string);
            if (rGBDSCharmap == null) {
                rGBDSCharmap = new RGBDSCharmap(this.charmaps.get(string2));
                this.charmaps.put(string, rGBDSCharmap);
            }
            this.charmap = rGBDSCharmap;
            return this.charmap;
        }

        public void setCharmap(String string) {
            RGBDSCharmap rGBDSCharmap = this.charmaps.get(string);
            if (rGBDSCharmap != null) {
                this.charmap = rGBDSCharmap;
            }
        }

        public void pushCharmap() {
            this.charmapStack.push(this.charmap);
        }

        public void popCharmap() {
            this.charmap = this.charmapStack.pop();
        }

        public void resetCharmaps() {
            this.charmap = this.newCharmap("main", null);
            this.charmaps.clear();
            this.charmapStack.clear();
        }

        public void addIncDir(File file) {
            this.incDirs.add(file);
        }

        public File findFile(String string) {
            for (File file : this.incDirs) {
                File file2 = new File(file, string);
                if (!file2.exists()) continue;
                return file2;
            }
            return null;
        }

        public void addException(Exception exception) {
            this.exceptions.add(exception);
        }

        public void addParsedFile(File file) {
            this.parsedFiles.add(file);
        }

        public boolean isParsed(File file) {
            return this.parsedFiles.contains(file);
        }

        public List<SubCharSequence> splitTokens(CharSequence charSequence) {
            if (charSequence != this.lineOfTokens) {
                this.tokens = RGBDSParser.splitTokens(charSequence);
                this.lineOfTokens = charSequence;
            }
            return this.tokens;
        }

        public void complete() {
            if (this.currentSection != null) {
                this.sections.add(new Section(this.currentSection.getName(), this.currentSection.getMode(), this.sectionSize, this.currentSection.getOrg(), this.currentSection.getBank(), this.currentSection.getBegin(), this.lines.size()));
            }
            this.currentSection = null;
            this.ramSectionDefinition = false;
            this.loadSectionDefinition = false;
        }
    }
}

