/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.JLabelUtilities;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;

public abstract class ClickableJLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();

    public ClickableJLabel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public ClickableJLabel(String string) {
        super(string);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public final void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        int n = JLabelUtilities.indexAt(this, mouseEvent);
        if (n >= 0 && this.canClick(n)) {
            this.setCursor(HAND_CURSOR);
        } else {
            this.setCursor(DEFAULT_CURSOR);
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        int n = JLabelUtilities.indexAt(this, mouseEvent);
        if (n >= 0) {
            this.indexClicked(n);
        }
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(DEFAULT_CURSOR);
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    protected abstract boolean canClick(int var1);

    protected abstract void indexClicked(int var1);
}

