/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import components.OutputListener;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;

public class AY38910 {
    public static final int SIGNATURE = 0x440000;
    public static final int REGISTER_WRITE = 0x440000;
    public static final int UPDATE = 4456575;
    private final int CYCLES_PER_SECOND;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    private final int[] regs = new int[16];
    private int regLinearFeedbackShift = 131070;
    private final int[] counter = new int[4];
    private final int[] samples = new int[3];
    private final int[] direction = new int[3];
    private int noiseChannelSamples;
    private int randomNumber;
    private int frequencyCounterEnvelope;
    private int envelopeCounter;
    private int envelopeVolume;
    private int envelopeAttack;
    private boolean envelopeHolding;
    private int latchedRegister;
    private final int[] VOLUMES;

    public AY38910(int n) {
        int[] nArray = new int[16];
        nArray[0] = 2827;
        nArray[1] = 2001;
        nArray[2] = 1417;
        nArray[3] = 1003;
        nArray[4] = 710;
        nArray[5] = 502;
        nArray[6] = 356;
        nArray[7] = 252;
        nArray[8] = 178;
        nArray[9] = 126;
        nArray[10] = 89;
        nArray[11] = 63;
        nArray[12] = 45;
        nArray[13] = 32;
        nArray[14] = 22;
        this.VOLUMES = nArray;
        this.CYCLES_PER_SECOND = n;
    }

    public int getCyclesPerSecond() {
        return this.CYCLES_PER_SECOND;
    }

    public int calcNextLFSRNumber() {
        this.regLinearFeedbackShift = ((this.regLinearFeedbackShift >> 2 ^ this.regLinearFeedbackShift & 1) & 1) << 16 | this.regLinearFeedbackShift >> 1;
        return this.regLinearFeedbackShift & 1;
    }

    public int getVolume(int n) {
        return this.regs[8 + n];
    }

    private int getCyclesPerSample(int n) {
        return Math.max(1, 16 * (n == 3 ? this.regs[6] & 0x1F : (this.regs[n << 1 | 1] & 0xF) << 8 | this.regs[n << 1]));
    }

    private int getCyclesPerEnvelopeUpdate() {
        return Math.max(1, 32 * (this.regs[12] << 8 | this.regs[11]));
    }

    public int getEnvelopeShape() {
        return this.regs[13] & 0xF;
    }

    public boolean isEnvelopeAttack() {
        return (this.regs[13] & 4) != 0;
    }

    public boolean isEnvelopeHold() {
        return (this.regs[13] & 8) == 0 || (this.regs[13] & 1) != 0;
    }

    public boolean isEnvelopeAlternate() {
        return (this.regs[13] & 0xC) == 4 || (this.regs[13] & 0xA) == 10;
    }

    private void advanceEnvelope(int n) {
        if (!this.envelopeHolding) {
            int n2 = this.getCyclesPerEnvelopeUpdate();
            this.frequencyCounterEnvelope -= n;
            if (this.frequencyCounterEnvelope <= 0) {
                do {
                    if (--this.envelopeCounter < 0) {
                        if (this.isEnvelopeHold()) {
                            if (this.isEnvelopeAlternate()) {
                                this.envelopeAttack ^= 0xF;
                            }
                            this.envelopeHolding = true;
                            this.envelopeCounter = 0;
                        } else {
                            if (this.isEnvelopeAlternate() && (this.envelopeCounter & 0x20) != 0) {
                                this.envelopeAttack ^= 0xF;
                            }
                            this.envelopeCounter &= 0xF;
                        }
                    }
                    this.frequencyCounterEnvelope += n2;
                } while (this.frequencyCounterEnvelope <= 0);
                this.envelopeVolume = this.envelopeCounter ^ this.envelopeAttack;
            }
        }
    }

    public void processInput(int n, int n2, int n3) {
        this.fireOutputAvailable(4456575, n3);
        switch (n) {
            case 0: {
                this.latchedRegister = n2 & 0xF;
                break;
            }
            case 1: {
                this.regs[this.latchedRegister] = n2;
                if (this.latchedRegister == 13) {
                    this.envelopeAttack = this.isEnvelopeAttack() ? 15 : 0;
                    this.envelopeCounter = 15;
                    this.envelopeVolume = this.envelopeCounter ^ this.envelopeAttack;
                    this.envelopeHolding = false;
                    this.frequencyCounterEnvelope = 0;
                }
                this.fireOutputAvailable(0x440000, n2 << 8 | this.latchedRegister);
            }
        }
    }

    public int readByte(int n) {
        return this.latchedRegister < 14 ? this.regs[this.latchedRegister] : 255;
    }

    public boolean isChannelEnabled(int n) {
        return (this.regs[7] & 1 << n) == 0;
    }

    public int getSamples(int n) {
        return this.samples[n];
    }

    public void advanceChannels(int n) {
        if (n <= 0) {
            return;
        }
        this.advanceEnvelope(n);
        int n2 = 0;
        while (n2 < this.counter.length) {
            this.advanceChannel(n2, n);
            ++n2;
        }
    }

    private void advanceChannel(int n, int n2) {
        int n3 = this.counter[n];
        int n4 = n;
        this.counter[n4] = this.counter[n4] - n2;
        int n5 = this.getCyclesPerSample(n);
        int n6 = (n == 3 ? this.randomNumber : this.direction[n]) * n3;
        while (this.counter[n] <= 0) {
            if (n == 3) {
                this.randomNumber = this.calcNextLFSRNumber();
                n6 += this.randomNumber * n5;
            } else {
                int n7 = n;
                this.direction[n7] = this.direction[n7] ^ 1;
                n6 += this.direction[n] * n5;
            }
            int n8 = n;
            this.counter[n8] = this.counter[n8] + n5;
        }
        n6 -= (n == 3 ? this.randomNumber : this.direction[n]) * this.counter[n];
        if (n == 3) {
            this.noiseChannelSamples = n6;
        } else {
            int n9;
            int n10 = this.getVolume(n);
            int n11 = n9 = (n10 & 0x10) != 0 ? this.envelopeVolume : n10 & 0xF;
            if (this.isChannelEnabled(n) && this.isChannelEnabled(n + 3)) {
                n6 = Math.min(n6, this.noiseChannelSamples);
            } else if (!this.isChannelEnabled(n)) {
                n6 = this.isChannelEnabled(n + 3) ? this.noiseChannelSamples : n2;
            }
            this.samples[n] = n6 * this.VOLUMES[15 - n9];
        }
    }

    public void reset() {
        Arrays.fill(this.regs, 0);
        this.regs[7] = 63;
    }

    public void setReg(int n, int n2) {
        this.regs[n] = n2;
    }

    protected void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getReg(int n) {
                return AY38910.this.regs[n];
            }

            @Override
            public int getRegLinearFeedbackShift() {
                return AY38910.this.regLinearFeedbackShift;
            }

            @Override
            public int getLatchedRegister() {
                return AY38910.this.latchedRegister;
            }
        };
    }

    public void setState(State state) {
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = state.getReg(n);
            ++n;
        }
        this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
        this.latchedRegister = state.getLatchedRegister();
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getReg(int var1);

        public int getRegLinearFeedbackShift();

        public int getLatchedRegister();
    }

    private static class StateClone
    implements State {
        private final int[] regs = new int[16];
        private int regLinearFeedbackShift;
        private int latchedRegister;

        public StateClone(State state) {
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            int n = 0;
            while (n < this.regs.length) {
                this.regs[n] = state.getReg(n);
                ++n;
            }
            this.regLinearFeedbackShift = state.getRegLinearFeedbackShift();
            this.latchedRegister = state.getLatchedRegister();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getReg(int n) {
            return this.regs[n];
        }

        @Override
        public int getRegLinearFeedbackShift() {
            return this.regLinearFeedbackShift;
        }

        @Override
        public int getLatchedRegister() {
            return this.latchedRegister;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

