/*
 * Decompiled with CFR 0.152.
 */
package dap.base;

import dap.base.DebugAdapterProtocolMessage;
import dap.base.DebugAdapterProtocolMessageHandler;
import dap.messages.ProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class DebugAdapterBaseProtocol
implements Runnable {
    private final ServerSocket server;
    private final DebugAdapterProtocolMessageHandler messageHandler;
    private Socket socket;
    private OutputStream out;
    private volatile boolean stopped;
    private volatile boolean closed;

    public DebugAdapterBaseProtocol(int n, DebugAdapterProtocolMessageHandler debugAdapterProtocolMessageHandler) throws IOException {
        this.server = new ServerSocket(n);
        this.messageHandler = debugAdapterProtocolMessageHandler;
        new Thread((Runnable)this, "Debug Adapter").start();
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        while (!this.closed) {
            try {
                this.socket = this.server.accept();
                this.out = this.socket.getOutputStream();
                inputStream = this.socket.getInputStream();
                ProtocolMessage.resetCounter();
            }
            catch (BindException bindException) {
                bindException.printStackTrace();
            }
            catch (IOException iOException) {}
            if (inputStream == null) continue;
            boolean bl = true;
            try {
                byte[] byArray = new byte[8192];
                char[] cArray = new char[128];
                this.stopped = false;
                while (!this.closed && !this.stopped) {
                    Map<String, String> map = DebugAdapterBaseProtocol.readHeader(inputStream, cArray);
                    bl = false;
                    int n = Integer.parseInt(map.get("Content-Length"));
                    int n2 = 0;
                    while (n2 < n) {
                        n2 += inputStream.read(byArray, n2, n - n2);
                    }
                    String string = new String(byArray, 0, n, "UTF-8");
                    this.messageHandler.handleMessage(new DebugAdapterProtocolMessage(map, string));
                }
                if (this.socket == null) continue;
                this.socket.close();
                this.socket = null;
                this.out = null;
            }
            catch (IOException iOException) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
                this.socket = null;
                this.out = null;
                if (bl || this.closed) continue;
                iOException.printStackTrace();
            }
        }
    }

    public void sendMessage(ProtocolMessage protocolMessage) {
        this.send(protocolMessage.toString());
    }

    private synchronized void send(String string) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        if (this.out != null) {
            byte[] byArray;
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                byArray = string.getBytes();
            }
            try {
                this.out.write(("Content-Length: " + byArray.length + "\r\n\r\n").getBytes());
                this.out.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public void close() {
        this.closed = true;
        try {
            this.server.close();
        }
        catch (IOException iOException) {}
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
                this.out = null;
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    static Map<String, String> readHeader(InputStream inputStream, char[] cArray) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = DebugAdapterBaseProtocol.readHeaderLine(inputStream, cArray);
        while (!string.isEmpty()) {
            int n = 0;
            while (n < string.length() && string.charAt(n) != ':') {
                ++n;
            }
            String string2 = string.substring(0, n);
            if (n < string.length()) {
                ++n;
            }
            while (n < string.length() && string.charAt(n) <= ' ') {
                ++n;
            }
            hashMap.put(string2, string.substring(n));
            string = DebugAdapterBaseProtocol.readHeaderLine(inputStream, cArray);
        }
        return hashMap;
    }

    private static String readHeaderLine(InputStream inputStream, char[] cArray) throws IOException {
        int n = 0;
        while (n < cArray.length) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Connection closed");
            }
            if (n2 == 13) {
                if (inputStream.read() == 10) break;
                throw new IOException("Missing line feed after line: " + new String(cArray, 0, n));
            }
            cArray[n++] = (char)n2;
        }
        return new String(cArray, 0, n);
    }
}

