/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.responses;

import dap.DebugAdapter;
import dap.messages.Response;
import dap.messages.requests.InitializeRequest;
import dap.types.ExceptionBreakpointsFilter;
import json.JSONArray;
import json.JSONObject;

public class InitializeResponse
extends Response {
    private final DebugAdapter.Capabilities capabilities;

    public InitializeResponse(InitializeRequest initializeRequest, String string, DebugAdapter.Capabilities capabilities) {
        super(initializeRequest, string);
        this.capabilities = capabilities;
    }

    @Override
    public JSONObject getBody() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("supportsConfigurationDoneRequest", this.capabilities.supportsConfigurationDoneRequest());
        jSONObject.put("supportsFunctionBreakpoints", this.capabilities.supportsFunctionBreakpoints());
        jSONObject.put("supportsConditionalBreakpoints", this.capabilities.supportsConditionalBreakpoints());
        jSONObject.put("supportsHitConditionalBreakpoints", this.capabilities.supportsHitConditionalBreakpoints());
        jSONObject.put("supportsEvaluateForHovers", this.capabilities.supportsEvaluateForHovers());
        jSONObject.put("exceptionBreakpointFilters", this.createExceptionBreakpointFiltersArray());
        jSONObject.put("supportsStepBack", this.capabilities.supportsStepBack());
        jSONObject.put("supportsSetVariable", this.capabilities.supportsSetVariable());
        jSONObject.put("supportsRestartFrame", this.capabilities.supportsRestartFrame());
        jSONObject.put("supportsGotoTargetsRequest", this.capabilities.supportsGotoTargetsRequest());
        jSONObject.put("supportsStepInTargetsRequest", this.capabilities.supportsStepInTargetsRequest());
        jSONObject.put("supportsCompletionsRequest", this.capabilities.supportsCompletionsRequest());
        jSONObject.put("supportsModulesRequest", this.capabilities.supportsModulesRequest());
        jSONObject.put("supportsRestartRequest", this.capabilities.supportsRestartRequest());
        jSONObject.put("supportsExceptionOptions", this.capabilities.supportsExceptionOptions());
        jSONObject.put("supportsValueFormattingOptions", this.capabilities.supportsValueFormattingOptions());
        jSONObject.put("supportsExceptionInfoRequest", this.capabilities.supportsExceptionInfoRequest());
        jSONObject.put("supportTerminateDebuggee", this.capabilities.supportTerminateDebuggee());
        jSONObject.put("supportsDelayedStackTraceLoading", this.capabilities.supportsDelayedStackTraceLoading());
        jSONObject.put("supportsLoadedSourcesRequest", this.capabilities.supportsLoadedSourcesRequest());
        jSONObject.put("supportsLogPoints", this.capabilities.supportsLogPoints());
        jSONObject.put("supportsTerminateThreadsRequest", this.capabilities.supportsTerminateThreadsRequest());
        jSONObject.put("supportsSetExpression", this.capabilities.supportsSetExpression());
        jSONObject.put("supportsTerminateRequest", this.capabilities.supportsTerminateRequest());
        jSONObject.put("supportsDataBreakpoints", this.capabilities.supportsDataBreakpoints());
        jSONObject.put("supportsReadMemoryRequest", this.capabilities.supportsReadMemoryRequest());
        jSONObject.put("supportsDisassembleRequest", this.capabilities.supportsDisassembleRequest());
        jSONObject.put("supportsCancelRequest", this.capabilities.supportsCancelRequest());
        jSONObject.put("supportsBreakpointLocationsRequest", this.capabilities.supportsBreakpointLocationsRequest());
        jSONObject.put("supportsClipboardContext", this.capabilities.supportsClipboardContext());
        jSONObject.put("supportsSteppingGranularity", this.capabilities.supportsSteppingGranularity());
        jSONObject.put("supportsInstructionBreakpoints", this.capabilities.supportsInstructionBreakpoints());
        return jSONObject;
    }

    private JSONArray createExceptionBreakpointFiltersArray() {
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray = this.capabilities.getExceptionBreakpointFilters();
        if (exceptionBreakpointsFilterArray == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        ExceptionBreakpointsFilter[] exceptionBreakpointsFilterArray2 = exceptionBreakpointsFilterArray;
        int n = exceptionBreakpointsFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionBreakpointsFilter exceptionBreakpointsFilter = exceptionBreakpointsFilterArray2[n2];
            jSONArray.add(exceptionBreakpointsFilter);
            ++n2;
        }
        return jSONArray;
    }
}

