/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.EventFilterListener;
import events.EventFilterModel;
import events.EventModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DefaultEventFilterModel
implements EventFilterModel {
    private final List<EventFilterListener> eventFilterListeners = new ArrayList<EventFilterListener>();
    private final boolean[] filters;
    private boolean showReads;

    public DefaultEventFilterModel(EventModel eventModel) {
        int n = 0;
        int n2 = 0;
        while (n2 < eventModel.getNumberOfEventGroups()) {
            n += eventModel.getEventTypes(n2).length;
            ++n2;
        }
        this.filters = new boolean[n];
        Arrays.fill(this.filters, true);
    }

    @Override
    public boolean isEventTypeFilterEnabled(int n) {
        return n == this.filters.length || this.filters[n];
    }

    @Override
    public void setEventTypeFilterEnabled(int n, boolean bl) {
        this.filters[n] = bl;
        this.fireEventFilterChanged(n, bl);
    }

    @Override
    public boolean isShowReads() {
        return this.showReads;
    }

    @Override
    public void setShowReads(boolean bl) {
        this.showReads = bl;
        this.fireShowReadsChanged(bl);
    }

    protected void fireEventFilterChanged(int n, boolean bl) {
        for (EventFilterListener eventFilterListener : this.eventFilterListeners) {
            eventFilterListener.eventFilterChanged(n, bl);
        }
    }

    protected void fireShowReadsChanged(boolean bl) {
        for (EventFilterListener eventFilterListener : this.eventFilterListeners) {
            eventFilterListener.eventFilterChanged(-1, bl);
        }
    }

    @Override
    public void addEventFilterListener(EventFilterListener eventFilterListener) {
        if (!this.eventFilterListeners.contains(eventFilterListener)) {
            this.eventFilterListeners.add(eventFilterListener);
        }
    }

    @Override
    public void removeEventFilterListener(EventFilterListener eventFilterListener) {
        this.eventFilterListeners.remove(eventFilterListener);
    }

    public String toString(EventModel eventModel) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < eventModel.getNumberOfEventGroups()) {
            int[] nArray = eventModel.getEventTypes(n);
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                if (!this.isEventTypeFilterEnabled(n4)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(eventModel.getEventTypeName(n4));
                }
                ++n3;
            }
            ++n;
        }
        if (this.isShowReads()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("READS");
        }
        return stringBuilder.toString();
    }

    public void updateFromString(String string, EventModel eventModel) {
        if (string != null && !string.isEmpty()) {
            int n;
            int n2;
            Object object;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n3 = 0;
            while (n3 < eventModel.getNumberOfEventGroups()) {
                object = eventModel.getEventTypes(n3);
                int n4 = ((int[])object).length;
                n2 = 0;
                while (n2 < n4) {
                    n = object[n2];
                    hashMap.put(eventModel.getEventTypeName(n), n);
                    ++n2;
                }
                ++n3;
            }
            String[] stringArray = string.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String string2 = stringArray[n];
                if ("READS".equals(string2)) {
                    this.setShowReads(true);
                } else {
                    object = (Integer)hashMap.get(string2);
                    if (object != null) {
                        this.setEventTypeFilterEnabled((Integer)object, false);
                    } else {
                        System.err.println("Unknown event type filter: " + string2);
                    }
                }
                ++n;
            }
        }
    }
}

