/*
 * Decompiled with CFR 0.152.
 */
package highlighting;

import highlighting.Highlighter;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import javax.swing.text.html.StyleSheet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NotepadPlusPlusHighlighter
extends DefaultHandler
implements Highlighter {
    private static final String[] NO_VALUES = new String[0];
    private boolean caseIgnored;
    private HashMap<String, WordsStyle> wordsStyles;
    private HashMap<String, String> keywords;
    private HashMap<String, WordsStyle> keyWordStyles;
    private boolean correctRootElement;
    private String qName;
    private String value;
    private String name;
    private HashMap<String, String> cache = new HashMap();
    private final String[] decimalNumberPrefixes;
    private final String[] extendedNumberPrefixes;
    private final String[] operators;
    private final BitSet operatorStartChars = new BitSet();
    private final String[] comments;
    private final String[] delimiters;
    private final BitSet delimiterStartChars = new BitSet();
    private final String extraNumberCharacters;
    private final Color currentLineForeground;
    private final Color currentLineBackground;
    private final Color selectionForeground;
    private final Color selectionBackground;
    private final Color foreground;
    private final Color background;
    private StyleSheet styleSheet;

    public NotepadPlusPlusHighlighter(File file) throws FileNotFoundException {
        Object object;
        Object object2;
        try {
            object2 = SAXParserFactory.newInstance().newSAXParser();
            ((SAXParser)object2).parse(file, (DefaultHandler)this);
            if (this.wordsStyles != null && !this.wordsStyles.isEmpty() && this.keywords != null && !this.keywords.isEmpty()) {
                String string;
                int n;
                int n2;
                String[] stringArray;
                String[] stringArray2;
                this.keyWordStyles = new HashMap();
                int n3 = 8;
                while (n3 >= 1) {
                    stringArray2 = this.wordsStyles.get("KEYWORDS" + n3);
                    stringArray = this.splitKeywords("Keywords" + n3);
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        string = stringArray[n];
                        this.keyWordStyles.put(this.caseIgnored ? string.toUpperCase() : string, (WordsStyle)stringArray2);
                        ++n;
                    }
                    --n3;
                }
                object = new String[]{"Folders in code1", "Folders in code2"};
                stringArray2 = new String[]{", open", ", middle", ", close"};
                stringArray = object;
                n2 = ((String[])object).length;
                n = 0;
                while (n < n2) {
                    string = stringArray[n];
                    WordsStyle wordsStyle = this.wordsStyles.get(string.replace("Folders", "Folder").toUpperCase());
                    String[] stringArray3 = stringArray2;
                    int n4 = stringArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String string2 = stringArray3[n5];
                        String[] stringArray4 = this.splitKeywords(String.valueOf(string) + string2);
                        int n6 = stringArray4.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String string3 = stringArray4[n7];
                            this.keyWordStyles.put(this.caseIgnored ? string3.toUpperCase() : string3, wordsStyle);
                            ++n7;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                throw (FileNotFoundException)iOException;
            }
            iOException.printStackTrace();
        }
        object2 = this.wordsStyles.get("DEFAULT");
        this.foreground = this.toColor(((WordsStyle)object2).getFgColor());
        this.background = this.toColor(((WordsStyle)object2).getBgColor());
        this.decimalNumberPrefixes = this.splitKeywords("Numbers, prefix1");
        this.extendedNumberPrefixes = this.splitKeywords("Numbers, prefix2");
        this.extraNumberCharacters = this.concatenateKeywords("Numbers, extras1");
        String[] stringArray = this.operators = this.splitKeywords("Operators1");
        int n = this.operators.length;
        int n8 = 0;
        while (n8 < n) {
            object = stringArray[n8];
            if (!((String)object).isEmpty()) {
                this.operatorStartChars.set(((String)object).charAt(0));
            }
            ++n8;
        }
        this.delimiters = this.splitNumberedKeywords("Delimiters");
        int n9 = 0;
        while (n9 < this.delimiters.length) {
            if (!this.delimiters[n9].isEmpty()) {
                this.delimiterStartChars.set(this.delimiters[n9].charAt(0));
            }
            n9 += 3;
        }
        this.comments = this.splitNumberedKeywords("Comments");
        this.selectionForeground = new Color(this.background.getRed() ^ 0xFF, this.background.getGreen() ^ 0xFF, this.background.getBlue() ^ 0xFF);
        this.selectionBackground = new Color(this.background.getRed() * 3 / 4, this.background.getGreen() * 3 / 4, this.background.getBlue() * 3 / 4);
        this.currentLineForeground = this.foreground;
        this.currentLineBackground = new Color((this.background.getRed() + this.foreground.getRed()) / 2, this.background.getGreen(), this.foreground.getBlue() ^ 0xFF);
    }

    private String[] splitKeywords(String string) {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return NO_VALUES;
        }
        String string2 = this.keywords.get(string);
        if (string2 == null) {
            return NO_VALUES;
        }
        String[] stringArray = string2.split("\\s+");
        return stringArray.length > 0 && !stringArray[0].isEmpty() ? stringArray : new String[]{};
    }

    private String[] splitNumberedKeywords(String string) {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return NO_VALUES;
        }
        String string2 = this.keywords.get(string);
        if (string2 == null) {
            return NO_VALUES;
        }
        String[] stringArray = string2.split("\\s+");
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].substring(2);
            ++n;
        }
        n = stringArray.length;
        while (n > 0 && stringArray[n - 1].isEmpty()) {
            --n;
        }
        return Arrays.copyOf(stringArray, n);
    }

    private String concatenateKeywords(String string) {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return null;
        }
        String string2 = this.keywords.get(string);
        if (string2 == null) {
            return null;
        }
        return string2.replace(" ", "");
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("NotepadPlus".equals(string3)) {
            this.correctRootElement = true;
        } else if (!this.correctRootElement) {
            throw new SAXException("Root element must be NotepadPlus");
        }
        this.qName = string3;
        this.name = attributes.getValue("name");
        if ("WordsStyle".equals(string3)) {
            if (this.wordsStyles == null) {
                this.wordsStyles = new HashMap();
            }
            this.wordsStyles.put(this.name.toUpperCase(), new WordsStyle(attributes));
        } else if ("Global".equals(string3)) {
            this.caseIgnored = "yes".equals(attributes.getValue("caseIgnored"));
        }
        this.value = "";
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("Keywords".equals(string3)) {
            if (this.keywords == null) {
                this.keywords = new HashMap();
            }
            this.keywords.put(this.name, this.value);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.value = String.valueOf(this.value) + ("Keywords".equals(this.qName) ? new String(cArray, n, n2) : "");
    }

    private static String findPrefix(String string, String[] stringArray) {
        return NotepadPlusPlusHighlighter.findPrefix(string, 0, stringArray);
    }

    private static String findPrefix(String string, int n, String[] stringArray) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.startsWith(stringArray[n2], n)) {
                return stringArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static boolean startsWithAny(String string, String[] stringArray) {
        return NotepadPlusPlusHighlighter.startsWithAny(string, 0, stringArray);
    }

    private static boolean startsWithAny(String string, int n, String[] stringArray) {
        return NotepadPlusPlusHighlighter.findPrefix(string, n, stringArray) != null;
    }

    public static Highlighter loadFromFile(File file) throws FileNotFoundException {
        return new NotepadPlusPlusHighlighter(file);
    }

    @Override
    public String highlight(String string) {
        String string2;
        CharSequence charSequence;
        int n;
        String string3;
        if (this.wordsStyles == null || this.wordsStyles.isEmpty() || string == null || string.isEmpty()) {
            return string;
        }
        if (string.length() >= 256) {
            string3 = string.substring(256);
            string = string.substring(0, 256);
        } else {
            string3 = "";
        }
        String string4 = "";
        if (this.comments != null && this.comments.length > 0 && (n = string.indexOf(this.comments[0])) >= 0) {
            charSequence = NotepadPlusPlusHighlighter.toHtmlAttributes(this.wordsStyles.get("LINE COMMENTS"));
            if (charSequence != null) {
                string4 = String.valueOf(string4) + (String)charSequence;
            }
            string4 = String.valueOf(string4) + string.substring(n).replace("<", "&lt;").replace("&lt;font ", "<font ").replace("&lt;/font>", "</font>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replace(" ", "&nbsp;");
            if (charSequence != null) {
                string4 = String.valueOf(string4) + "</b></i></u></font>";
            }
            string = string.substring(0, n);
        }
        if ((string2 = this.cache.get(string)) == null) {
            charSequence = new StringBuilder();
            int n2 = 0;
            if (string.endsWith(this.comments[4]) && string.lastIndexOf(this.comments[3]) <= 0) {
                NotepadPlusPlusHighlighter.appendHtmlAttributes((StringBuilder)charSequence, this.wordsStyles.get("COMMENTS")).append(string).append("</b></i></u></font>");
                n2 = string.length();
            }
            while (n2 < string.length()) {
                int n3;
                int n4;
                if (string.startsWith(this.comments[3], n2)) {
                    n4 = Math.min(string.length(), string.indexOf(this.comments[4], n2 + this.comments[3].length()) & Integer.MAX_VALUE);
                    n4 = Math.min(string.length(), n4 + this.comments[4].length());
                    NotepadPlusPlusHighlighter.appendHtmlAttributes((StringBuilder)charSequence, this.wordsStyles.get("COMMENTS")).append(string.substring(n2, n4)).append("</b></i></u></font>");
                    n2 = n4;
                    continue;
                }
                n4 = n2;
                while (n4 < string.length()) {
                    char c = string.charAt(n4);
                    if (c <= ' ' || c == ',' || c == ':' || this.operatorStartChars.get(c) && NotepadPlusPlusHighlighter.startsWithAny(string, n4, this.operators) && (n4 + 1 >= string.length() || !NotepadPlusPlusHighlighter.startsWithAny(string, n4, this.extendedNumberPrefixes) || !this.isNumberCharacter(string.charAt(n4 + 1)))) break;
                    if (this.delimiterStartChars.get(c)) {
                        n3 = 0;
                        int n5 = 0;
                        while (n5 < this.delimiters.length) {
                            if (!this.delimiters[n5].isEmpty() && string.startsWith(this.delimiters[n5], n4)) {
                                n3 = 1;
                                break;
                            }
                            n5 += 3;
                        }
                        if (n3 != 0) break;
                    }
                    ++n4;
                }
                String string5 = "";
                if (n4 < string.length()) {
                    string5 = string.substring(n4, n4 + 1);
                }
                n3 = 0;
                while (n3 < this.delimiters.length) {
                    if (!this.delimiters[n3].isEmpty() && string.startsWith(this.delimiters[n3], n4)) {
                        n4 += this.delimiters[n3].length();
                        while (n4 < string.length() && (!string.startsWith(this.delimiters[n3 + 2], n4) || !this.delimiters[n3 + 1].isEmpty() && string.startsWith(this.delimiters[n3 + 1], n4 - this.delimiters[n3 + 1].length()))) {
                            ++n4;
                        }
                        n4 = Math.min(string.length(), n4 + this.delimiters[n3 + 2].length());
                        string5 = "";
                        break;
                    }
                    n3 += 3;
                }
                this.appendHighlightedToken((StringBuilder)charSequence, string.substring(n2, n4));
                this.appendHighlightedSymbol((StringBuilder)charSequence, string5);
                n2 = n4 + string5.length();
            }
            string2 = ((StringBuilder)charSequence).toString();
            this.cache.put(string, string2);
        }
        string2 = String.valueOf(string2) + string4;
        if (!string3.isEmpty()) {
            return "<html><body style=\"white-space:nowrap\">" + string2 + string3 + "</body></html>";
        }
        return string2.isEmpty() ? "" : "<html><body style=\"white-space:nowrap\">" + string2 + "</body></html>";
    }

    private void appendHighlightedSymbol(StringBuilder stringBuilder, String string) {
        if (string != null && !string.isEmpty()) {
            if (string.length() == 1) {
                char c = string.charAt(0);
                if (c == '\t') {
                    stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    return;
                }
                if (c == ' ') {
                    stringBuilder.append("&nbsp;");
                    return;
                }
                if (c == '<') {
                    string = "&lt;";
                }
            }
            if (this.operatorStartChars.get(string.charAt(0)) && NotepadPlusPlusHighlighter.startsWithAny(string, this.operators)) {
                NotepadPlusPlusHighlighter.appendHtmlAttributes(stringBuilder, this.wordsStyles.get("OPERATORS")).append(string).append("</b></i></u></font>");
            } else {
                stringBuilder.append(string);
            }
        }
    }

    private void appendHighlightedToken(StringBuilder stringBuilder, String string) {
        if (!string.isEmpty()) {
            if (Character.isDigit(string.charAt(0)) || NotepadPlusPlusHighlighter.startsWithAny(string, this.decimalNumberPrefixes)) {
                NotepadPlusPlusHighlighter.appendHtmlAttributes(stringBuilder, this.wordsStyles.get("NUMBERS"));
                int n = 1;
                while (n < string.length() && (Character.isDigit(string.charAt(n)) || n + 1 < string.length() && string.charAt(n) == '.' && Character.isDigit(string.charAt(n + 1)))) {
                    ++n;
                }
                stringBuilder.append(string.substring(0, n)).append("</b></i></u></font>");
                stringBuilder.append(string.substring(n, string.length()));
            } else {
                WordsStyle wordsStyle = this.keyWordStyles.get(this.caseIgnored ? string.trim().toUpperCase() : string.trim());
                if (wordsStyle != null) {
                    NotepadPlusPlusHighlighter.appendHtmlAttributes(stringBuilder, wordsStyle);
                    stringBuilder.append(string).append("</b></i></u></font>");
                } else {
                    String string2 = NotepadPlusPlusHighlighter.findPrefix(string, this.extendedNumberPrefixes);
                    if (string2 != null) {
                        NotepadPlusPlusHighlighter.appendHtmlAttributes(stringBuilder, this.wordsStyles.get("NUMBERS"));
                        int n = string2.length();
                        while (n < string.length() && this.isNumberCharacter(string.charAt(n))) {
                            ++n;
                        }
                        stringBuilder.append(string.substring(0, n)).append("</b></i></u></font>");
                        stringBuilder.append(string.substring(n, string.length()));
                    } else {
                        int n = 0;
                        while (n < this.delimiters.length) {
                            if (!this.delimiters[n].isEmpty() && string.startsWith(this.delimiters[n])) {
                                NotepadPlusPlusHighlighter.appendHtmlAttributes(stringBuilder, this.wordsStyles.get("DELIMITERS" + (n / 3 + 1)));
                                stringBuilder.append(string).append("</b></i></u></font>");
                                return;
                            }
                            n += 3;
                        }
                        stringBuilder.append(string);
                    }
                }
            }
        }
    }

    private boolean isNumberCharacter(char c) {
        return Character.isDigit(c) || this.extraNumberCharacters.indexOf(c) >= 0;
    }

    private static StringBuilder appendHtmlAttributes(StringBuilder stringBuilder, WordsStyle wordsStyle) {
        if (wordsStyle != null) {
            stringBuilder.append("<font color=\"").append(wordsStyle.getFgColor()).append("\">");
            if ((wordsStyle.getFontStyle() & 1) != 0) {
                stringBuilder.append("<b>");
            }
            if ((wordsStyle.getFontStyle() & 2) != 0) {
                stringBuilder.append("<i>");
            }
            if ((wordsStyle.getFontStyle() & 4) != 0) {
                stringBuilder.append("<u>");
            }
        }
        return stringBuilder;
    }

    private static String toHtmlAttributes(WordsStyle wordsStyle) {
        if (wordsStyle == null) {
            return null;
        }
        return NotepadPlusPlusHighlighter.appendHtmlAttributes(new StringBuilder(), wordsStyle).toString();
    }

    private StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            this.styleSheet = new StyleSheet();
        }
        return this.styleSheet;
    }

    private Color toColor(String string) {
        return this.getStyleSheet().stringToColor(string);
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    @Override
    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    @Override
    public Color getCurrentLineForeground() {
        return this.currentLineForeground;
    }

    @Override
    public Color getCurrentLineBackground() {
        return this.currentLineBackground;
    }

    class WordsStyle {
        private final String fgColor;
        private final String bgColor;
        private final String fontName;
        private final int fontStyle;
        private final int nesting;

        WordsStyle(String string, String string2, String string3, int n, int n2) {
            this.fgColor = string;
            this.bgColor = string2;
            this.fontName = string3;
            this.fontStyle = n;
            this.nesting = n2;
        }

        WordsStyle(String string, String string2, String string3, String string4, String string5) {
            this(string, string2, string3, Integer.parseInt(string4), Integer.parseInt(string5));
        }

        public WordsStyle(Attributes attributes) {
            this(attributes.getValue("fgColor"), attributes.getValue("bgColor"), attributes.getValue("fontName"), attributes.getValue("fontStyle"), attributes.getValue("nesting"));
        }

        public String getFgColor() {
            return this.fgColor;
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public String getFontName() {
            return this.fontName;
        }

        public int getFontStyle() {
            return this.fontStyle;
        }

        public int getNesting() {
            return this.nesting;
        }
    }
}

