/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEvent;
import net.java.games.input.ControllerListener;
import net.java.games.input.DefaultControllerEnvironment;

public abstract class ControllerEnvironment {
    private static ControllerEnvironment defaultEnvironment = new DefaultControllerEnvironment();
    protected final ArrayList<ControllerListener> controllerListeners = new ArrayList();

    static void log(String string) {
        Logger.getLogger(ControllerEnvironment.class.getName()).info(string);
    }

    protected ControllerEnvironment() {
        if (System.getProperty("jinput.loglevel") != null) {
            String string = ControllerEnvironment.class.getPackage().getName();
            Level level = Level.parse(System.getProperty("jinput.loglevel"));
            Logger.getLogger(string).setLevel(level);
        }
    }

    public abstract Controller[] getControllers();

    public void addControllerListener(ControllerListener controllerListener) {
        assert (controllerListener != null);
        this.controllerListeners.add(controllerListener);
    }

    public abstract boolean isSupported();

    public void removeControllerListener(ControllerListener controllerListener) {
        assert (controllerListener != null);
        this.controllerListeners.remove(controllerListener);
    }

    protected void fireControllerAdded(Controller controller) {
        ControllerEvent controllerEvent = new ControllerEvent(controller);
        Iterator<ControllerListener> iterator = this.controllerListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().controllerAdded(controllerEvent);
        }
    }

    protected void fireControllerRemoved(Controller controller) {
        ControllerEvent controllerEvent = new ControllerEvent(controller);
        Iterator<ControllerListener> iterator = this.controllerListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().controllerRemoved(controllerEvent);
        }
    }

    public static ControllerEnvironment getDefaultEnvironment() {
        return defaultEnvironment;
    }
}

