/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import expressions.ParseException;
import expressions.UnknownVariableException;
import platform.debugger.Breakpoint;
import platform.debugger.ExpressionEvaluator;
import platform.debugger.InvalidBreakpoint;

public class Watchpoint
extends Breakpoint {
    private boolean read;
    private boolean write;

    protected Watchpoint(String string, int n, String string2, int n2, ExpressionEvaluator expressionEvaluator, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, String string4) throws ParseException, UnknownVariableException {
        super(string, n, string2, n2, expressionEvaluator, bl, bl2, string3, string4);
        this.read = bl3;
        this.write = bl4;
    }

    protected Watchpoint(String string, String string2, ExpressionEvaluator expressionEvaluator, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, String string4) throws ParseException, UnknownVariableException {
        this(string, 0, string2, 0, expressionEvaluator, bl, bl2, bl3, bl4, string3, string4);
    }

    public Watchpoint(String string, String string2, ExpressionEvaluator expressionEvaluator) throws ParseException, UnknownVariableException {
        this(string, string2, expressionEvaluator, true, true, true, true, null, null);
    }

    @Override
    public Breakpoint newInstance(String string, String string2, ExpressionEvaluator expressionEvaluator) {
        try {
            return new Watchpoint(string, string2, expressionEvaluator, this.isEnabled(), this.isSuspend(), this.isRead(), this.isWrite(), this.getCondition(), this.getMessage());
        }
        catch (Exception exception) {
            return InvalidBreakpoint.create(string, string2, this.isEnabled(), this.isSuspend(), this.getCondition(), this.getMessage(), null, exception);
        }
    }

    @Override
    public Breakpoint newInstance(int n, int n2) {
        try {
            return new Watchpoint(this.getAddressString(), n, this.getEndString(), n2, null, this.isEnabled(), this.isSuspend(), this.isRead(), this.isWrite(), this.getCondition(), this.getMessage());
        }
        catch (Exception exception) {
            return InvalidBreakpoint.create(this.getAddressString(), this.getEndString(), this.isEnabled(), this.isSuspend(), this.getCondition(), this.getMessage(), null, exception);
        }
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setRead(boolean bl) {
        this.read = bl;
    }

    public void setWrite(boolean bl) {
        this.write = bl;
    }

    @Override
    public String toString() {
        return String.format("type=watchpoint address=%s end=%s enabled=%b suspend=%b read=%b write=%b condition=%s message=%s", Watchpoint.escape(this.getAddressString()), Watchpoint.escape(this.getEndString()), this.isEnabled(), this.isSuspend(), this.isRead(), this.isWrite(), Watchpoint.escape(this.getCondition()), Watchpoint.escape(this.getMessage()));
    }
}

