/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.OutputListener;
import components.cartridge.GBCartridge;
import components.cpu.LR35902;
import components.input.ButtonInputProvider;
import components.sound.GBCSoundController;
import components.sound.GBSoundController;
import components.video.GBCLCDController;
import components.video.GBLCDController;
import events.Event;
import events.EventType;
import events.systems.GameBoyColorEventTypes;
import events.systems.GameBoyEventTypes;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import network.Network;
import output.GBDisplayWindow;
import output.GBSoundOutput;
import system.EmulatableSystem;
import system.GameBoy;

public class GameBoyColor
extends GameBoy {
    protected int regSVBK;
    protected boolean doubleSpeed;
    protected boolean dmgMode;
    private static GBCartridge emuliciousBootROM;

    public GameBoyColor(GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, GBSoundOutput gBSoundOutput, Network network) {
        this(gBDisplayWindow, buttonInputProvider, gBSoundOutput, network, false);
    }

    public GameBoyColor(GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, GBSoundOutput gBSoundOutput, Network network, boolean bl) {
        super(gBDisplayWindow, buttonInputProvider, gBSoundOutput, network, new int[32768], bl);
    }

    @Override
    protected void init(final GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, GBSoundOutput gBSoundOutput, Network network) {
        this.lcd = new GBCLCDController();
        this.sound = new GBCSoundController();
        this.lcd.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 0x110008) {
                    int n4 = n2 & 0x7F;
                    if ((n4 & 1) == 0) {
                        GameBoyColor.this.firePalettesWrite(n4 / 2, n2 >> 16, n2 >> 8 & 0xFF);
                    }
                } else if (n == 0x110009) {
                    int n5 = n2 & 0x7F;
                    gBDisplayWindow.updateColor(n5 >> 1 & 3, n5 >> 3);
                } else if (n == 85 && ((GBCLCDController)GameBoyColor.this.lcd).initiateHDMA(GameBoyColor.this.memory, GameBoyColor.this)) {
                    GameBoyColor.this.cpu.reduceCycleCount(4 + 32 * ((n2 & 0x80) == 0 ? n2 + 1 : 1) * (GameBoyColor.this.doubleSpeed ? 2 : 1));
                }
            }
        });
        super.init(gBDisplayWindow, buttonInputProvider, gBSoundOutput, network);
    }

    @Override
    protected void writePort(int n, int n2, int n3, GBDisplayWindow gBDisplayWindow, Network network) {
        if (this.doubleSpeed && (n >= 64 && n <= 75 || n >= 64 && n <= 108)) {
            n3 /= 2;
        }
        switch (n) {
            case 76: {
                if (!this.isBootROMenabled()) break;
                this.memory[n] = n2;
                break;
            }
            case 77: {
                if (this.dmgMode) break;
                this.memory[n] = this.doubleSpeed ? 0xFE | n2 & 1 : 0x7E | n2 & 1;
                break;
            }
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                this.memory[n] = n2;
                this.lcd.processInput(n, n2, n3);
                break;
            }
            case 86: {
                if (this.dmgMode) break;
                this.memory[n] = 0x3C | (GameBoyColor.isInfraredRead() ? 0 : 2) | n2;
                break;
            }
            case 112: {
                if (this.dmgMode) break;
                this.regSVBK = Math.max(1, n2 & 7);
                this.memory[n] = 0xF8 | n2;
                break;
            }
            case 116: {
                if (this.dmgMode) break;
            }
            case 114: 
            case 115: {
                this.memory[n] = n2;
                break;
            }
            case 117: {
                this.memory[n] = 0x8F | n2;
            }
        }
        super.writePort(n, n2, n3, gBDisplayWindow, network);
    }

    private static boolean isInfraredRead() {
        return false;
    }

    @Override
    protected void onReadPort(int n, int n2) {
        switch (n) {
            case 105: 
            case 107: {
                this.lcd.readPort(n, n2);
                return;
            }
            case 118: 
            case 119: {
                this.memory[n] = this.sound.readPort(n, this.calcNextSoundClock());
                return;
            }
        }
        if (this.doubleSpeed && (n >= 64 && n <= 75 || n >= 64 && n <= 108)) {
            super.onReadPort(n, n2 / 2);
        } else {
            super.onReadPort(n, n2);
        }
    }

    @Override
    protected void doWriteByte(int n, int n2, int n3) {
        super.doWriteByte(n, n2, this.doubleSpeed ? n3 / 2 : n3);
    }

    @Override
    protected int doReadByte(int n, int n2) {
        return super.doReadByte(n, this.doubleSpeed ? n2 / 2 : n2);
    }

    @Override
    protected void disableBootROM() {
        super.disableBootROM();
        boolean bl = this.dmgMode = (this.memory[76] & 0xC) != 0;
        if (this.dmgMode) {
            this.memory[77] = 255;
            this.memory[86] = 255;
            this.memory[112] = 255;
            this.memory[116] = 255;
        }
        ((GBCLCDController)this.lcd).setMode(this.memory[76]);
        this.memory[76] = 255;
        if (this.isEmuliciousBootROM()) {
            Arrays.fill(this.getRAM(), 8192, 12288, 0);
        }
    }

    @Override
    protected void handleStop() {
        if (!this.dmgMode && (this.memory[77] & 1) != 0) {
            this.doubleSpeed = !this.doubleSpeed;
            this.memory[77] = this.doubleSpeed ? 254 : 126;
            this.enterStopMode();
            this.lcd.update(19446);
            this.leaveStopMode();
        } else {
            super.handleStop();
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.isEmuliciousBootROM()) {
            this.counter = 46536;
        }
        this.memory[76] = 0;
        this.memory[77] = 126;
        this.memory[85] = 255;
        this.memory[86] = 62;
        this.regSVBK = 1;
        this.memory[112] = 248;
        this.memory[114] = 0;
        this.memory[115] = 0;
        this.memory[116] = 0;
        this.memory[117] = 143;
        this.memory[118] = 0;
        this.memory[119] = 0;
        this.doubleSpeed = false;
    }

    @Override
    protected boolean isEmuliciousBootROM() {
        return this.bootROM == emuliciousBootROM;
    }

    public static GBCartridge createEmuliciousBootROM() {
        if (emuliciousBootROM != null) {
            return emuliciousBootROM;
        }
        int[] nArray = new int[2304];
        nArray[0] = 49;
        nArray[1] = 254;
        nArray[2] = 255;
        nArray[3] = 195;
        nArray[4] = 130;
        nArray[5] = 0;
        nArray[6] = 60;
        nArray[7] = 66;
        nArray[8] = 185;
        nArray[9] = 165;
        nArray[10] = 185;
        nArray[11] = 165;
        nArray[12] = 66;
        nArray[13] = 60;
        nArray[33] = 17;
        nArray[34] = 4;
        nArray[35] = 1;
        nArray[36] = 33;
        nArray[37] = 16;
        nArray[38] = 128;
        nArray[39] = 26;
        nArray[40] = 205;
        nArray[41] = 149;
        nArray[42] = 0;
        nArray[43] = 205;
        nArray[44] = 150;
        nArray[45] = 0;
        nArray[46] = 19;
        nArray[47] = 123;
        nArray[48] = 254;
        nArray[49] = 52;
        nArray[50] = 32;
        nArray[51] = 243;
        nArray[52] = 17;
        nArray[53] = 6;
        nArray[54] = 0;
        nArray[55] = 6;
        nArray[56] = 8;
        nArray[57] = 26;
        nArray[58] = 19;
        nArray[59] = 34;
        nArray[60] = 35;
        nArray[61] = 5;
        nArray[62] = 32;
        nArray[63] = 249;
        nArray[64] = 250;
        nArray[65] = 0;
        nArray[66] = 208;
        nArray[67] = 254;
        nArray[68] = 88;
        nArray[69] = 40;
        nArray[70] = 3;
        nArray[71] = 254;
        nArray[72] = 67;
        nArray[73] = 192;
        nArray[74] = 62;
        nArray[75] = 25;
        nArray[76] = 234;
        nArray[77] = 16;
        nArray[78] = 153;
        nArray[79] = 33;
        nArray[80] = 47;
        nArray[81] = 153;
        nArray[82] = 14;
        nArray[83] = 12;
        nArray[84] = 61;
        nArray[85] = 40;
        nArray[86] = 8;
        nArray[87] = 50;
        nArray[88] = 13;
        nArray[89] = 32;
        nArray[90] = 249;
        nArray[91] = 46;
        nArray[92] = 15;
        nArray[93] = 24;
        nArray[94] = 243;
        nArray[95] = 201;
        nArray[130] = 205;
        nArray[131] = 117;
        nArray[132] = 2;
        nArray[133] = 33;
        nArray[134] = 0;
        nArray[135] = 254;
        nArray[136] = 14;
        nArray[137] = 160;
        nArray[138] = 175;
        nArray[139] = 34;
        nArray[140] = 13;
        nArray[141] = 32;
        nArray[142] = 252;
        nArray[143] = 205;
        nArray[144] = 33;
        nArray[145] = 0;
        nArray[146] = 195;
        nArray[147] = 185;
        nArray[148] = 0;
        nArray[149] = 79;
        nArray[150] = 6;
        nArray[151] = 4;
        nArray[152] = 197;
        nArray[153] = 203;
        nArray[154] = 17;
        nArray[155] = 23;
        nArray[156] = 193;
        nArray[157] = 203;
        nArray[158] = 17;
        nArray[159] = 23;
        nArray[160] = 5;
        nArray[161] = 32;
        nArray[162] = 245;
        nArray[163] = 34;
        nArray[164] = 35;
        nArray[165] = 34;
        nArray[166] = 35;
        nArray[167] = 201;
        nArray[185] = 205;
        nArray[186] = 240;
        nArray[187] = 3;
        nArray[188] = 205;
        nArray[189] = 208;
        nArray[190] = 5;
        nArray[192] = 62;
        nArray[193] = 145;
        nArray[194] = 224;
        nArray[195] = 64;
        nArray[196] = 33;
        nArray[197] = 13;
        nArray[198] = 0;
        nArray[199] = 17;
        nArray[200] = 86;
        nArray[201] = 255;
        nArray[202] = 229;
        nArray[203] = 33;
        nArray[204] = 15;
        nArray[205] = 255;
        nArray[206] = 203;
        nArray[207] = 134;
        nArray[208] = 203;
        nArray[209] = 70;
        nArray[210] = 40;
        nArray[211] = 252;
        nArray[212] = 225;
        nArray[213] = 6;
        nArray[214] = 255;
        nArray[215] = 4;
        nArray[216] = 55;
        nArray[217] = 63;
        nArray[252] = 62;
        nArray[253] = 17;
        nArray[254] = 224;
        nArray[255] = 80;
        nArray[522] = 42;
        nArray[523] = 18;
        nArray[524] = 19;
        nArray[525] = 13;
        nArray[526] = 32;
        nArray[527] = 250;
        nArray[528] = 201;
        nArray[586] = 62;
        nArray[587] = 128;
        nArray[588] = 224;
        nArray[589] = 104;
        nArray[590] = 224;
        nArray[591] = 106;
        nArray[592] = 14;
        nArray[593] = 107;
        nArray[594] = 42;
        nArray[595] = 226;
        nArray[596] = 5;
        nArray[597] = 32;
        nArray[598] = 251;
        nArray[599] = 74;
        nArray[600] = 9;
        nArray[601] = 67;
        nArray[602] = 14;
        nArray[603] = 105;
        nArray[604] = 42;
        nArray[605] = 226;
        nArray[606] = 5;
        nArray[607] = 32;
        nArray[608] = 251;
        nArray[609] = 201;
        nArray[629] = 62;
        nArray[630] = 128;
        nArray[631] = 224;
        nArray[632] = 38;
        nArray[633] = 224;
        nArray[634] = 17;
        nArray[635] = 62;
        nArray[636] = 243;
        nArray[637] = 224;
        nArray[638] = 18;
        nArray[639] = 224;
        nArray[640] = 37;
        nArray[641] = 62;
        nArray[642] = 119;
        nArray[643] = 224;
        nArray[644] = 36;
        nArray[656] = 62;
        nArray[657] = 193;
        nArray[658] = 224;
        nArray[659] = 19;
        nArray[660] = 62;
        nArray[661] = 7;
        nArray[662] = 224;
        nArray[663] = 20;
        nArray[664] = 201;
        nArray[1141] = 33;
        nArray[1142] = 75;
        nArray[1143] = 1;
        nArray[1144] = 126;
        nArray[1145] = 254;
        nArray[1146] = 51;
        nArray[1147] = 32;
        nArray[1148] = 11;
        nArray[1149] = 46;
        nArray[1150] = 68;
        nArray[1151] = 30;
        nArray[1152] = 48;
        nArray[1153] = 42;
        nArray[1154] = 187;
        nArray[1155] = 32;
        nArray[1156] = 73;
        nArray[1157] = 28;
        nArray[1158] = 24;
        nArray[1159] = 4;
        nArray[1160] = 46;
        nArray[1161] = 75;
        nArray[1162] = 30;
        nArray[1163] = 1;
        nArray[1164] = 42;
        nArray[1165] = 187;
        nArray[1166] = 32;
        nArray[1167] = 62;
        nArray[1168] = 46;
        nArray[1169] = 52;
        nArray[1170] = 1;
        nArray[1171] = 16;
        nArray[1172] = 0;
        nArray[1173] = 42;
        nArray[1174] = 128;
        nArray[1175] = 71;
        nArray[1176] = 13;
        nArray[1177] = 32;
        nArray[1178] = 250;
        nArray[1179] = 234;
        nArray[1180] = 0;
        nArray[1181] = 208;
        nArray[1182] = 33;
        nArray[1183] = 199;
        nArray[1184] = 6;
        nArray[1185] = 14;
        nArray[1186] = 0;
        nArray[1187] = 42;
        nArray[1188] = 184;
        nArray[1189] = 40;
        nArray[1190] = 8;
        nArray[1191] = 12;
        nArray[1192] = 121;
        nArray[1193] = 254;
        nArray[1194] = 79;
        nArray[1195] = 32;
        nArray[1196] = 246;
        nArray[1197] = 24;
        nArray[1198] = 31;
        nArray[1199] = 121;
        nArray[1200] = 214;
        nArray[1201] = 65;
        nArray[1202] = 56;
        nArray[1203] = 28;
        nArray[1230] = 14;
        nArray[1231] = 0;
        nArray[1232] = 33;
        nArray[1233] = 51;
        nArray[1234] = 7;
        nArray[1235] = 6;
        nArray[1236] = 0;
        nArray[1237] = 9;
        nArray[1238] = 126;
        nArray[1239] = 230;
        nArray[1240] = 31;
        nArray[1241] = 234;
        nArray[1242] = 8;
        nArray[1243] = 208;
        nArray[1244] = 126;
        nArray[1245] = 230;
        nArray[1246] = 224;
        nArray[1247] = 7;
        nArray[1248] = 7;
        nArray[1249] = 7;
        nArray[1250] = 234;
        nArray[1251] = 11;
        nArray[1252] = 208;
        nArray[1253] = 205;
        nArray[1254] = 233;
        nArray[1255] = 4;
        nArray[1256] = 201;
        nArray[1257] = 17;
        nArray[1258] = 145;
        nArray[1259] = 7;
        nArray[1260] = 33;
        nArray[1261] = 0;
        nArray[1262] = 217;
        nArray[1263] = 250;
        nArray[1264] = 11;
        nArray[1265] = 208;
        nArray[1266] = 71;
        nArray[1267] = 14;
        nArray[1268] = 30;
        nArray[1269] = 203;
        nArray[1270] = 64;
        nArray[1271] = 32;
        nArray[1272] = 2;
        nArray[1273] = 19;
        nArray[1274] = 19;
        nArray[1275] = 26;
        nArray[1276] = 34;
        nArray[1277] = 32;
        nArray[1278] = 2;
        nArray[1279] = 27;
        nArray[1280] = 27;
        nArray[1281] = 203;
        nArray[1282] = 72;
        nArray[1283] = 32;
        nArray[1284] = 2;
        nArray[1285] = 19;
        nArray[1286] = 19;
        nArray[1287] = 26;
        nArray[1288] = 34;
        nArray[1289] = 19;
        nArray[1290] = 19;
        nArray[1291] = 32;
        nArray[1292] = 2;
        nArray[1293] = 27;
        nArray[1294] = 27;
        nArray[1295] = 203;
        nArray[1296] = 80;
        nArray[1297] = 40;
        nArray[1298] = 5;
        nArray[1299] = 27;
        nArray[1300] = 43;
        nArray[1301] = 26;
        nArray[1302] = 34;
        nArray[1303] = 19;
        nArray[1304] = 26;
        nArray[1305] = 34;
        nArray[1306] = 19;
        nArray[1307] = 13;
        nArray[1308] = 32;
        nArray[1309] = 215;
        nArray[1310] = 33;
        nArray[1311] = 0;
        nArray[1312] = 217;
        nArray[1313] = 17;
        nArray[1314] = 0;
        nArray[1315] = 218;
        nArray[1316] = 205;
        nArray[1317] = 100;
        nArray[1318] = 5;
        nArray[1319] = 201;
        nArray[1380] = 14;
        nArray[1381] = 96;
        nArray[1382] = 42;
        nArray[1383] = 229;
        nArray[1384] = 197;
        nArray[1385] = 33;
        nArray[1386] = 232;
        nArray[1387] = 7;
        nArray[1388] = 6;
        nArray[1389] = 0;
        nArray[1390] = 79;
        nArray[1391] = 9;
        nArray[1392] = 14;
        nArray[1393] = 8;
        nArray[1394] = 205;
        nArray[1395] = 10;
        nArray[1396] = 2;
        nArray[1397] = 193;
        nArray[1398] = 225;
        nArray[1399] = 13;
        nArray[1400] = 32;
        nArray[1401] = 236;
        nArray[1402] = 201;
        nArray[1403] = 250;
        nArray[1404] = 8;
        nArray[1405] = 208;
        nArray[1406] = 17;
        nArray[1407] = 24;
        nArray[1408] = 0;
        nArray[1409] = 60;
        nArray[1410] = 61;
        nArray[1411] = 40;
        nArray[1412] = 3;
        nArray[1413] = 25;
        nArray[1414] = 32;
        nArray[1415] = 250;
        nArray[1416] = 201;
        nArray[1491] = 250;
        nArray[1492] = 67;
        nArray[1493] = 1;
        nArray[1494] = 203;
        nArray[1495] = 127;
        nArray[1496] = 40;
        nArray[1497] = 4;
        nArray[1498] = 224;
        nArray[1499] = 76;
        nArray[1500] = 24;
        nArray[1501] = 40;
        nArray[1502] = 62;
        nArray[1503] = 4;
        nArray[1504] = 224;
        nArray[1505] = 76;
        nArray[1506] = 62;
        nArray[1507] = 1;
        nArray[1508] = 224;
        nArray[1509] = 108;
        nArray[1510] = 33;
        nArray[1511] = 0;
        nArray[1512] = 218;
        nArray[1513] = 205;
        nArray[1514] = 123;
        nArray[1515] = 5;
        nArray[1516] = 6;
        nArray[1517] = 16;
        nArray[1518] = 22;
        nArray[1519] = 0;
        nArray[1520] = 30;
        nArray[1521] = 8;
        nArray[1522] = 205;
        nArray[1523] = 74;
        nArray[1524] = 2;
        nArray[1542] = 201;
        nArray[1735] = 0;
        nArray[1736] = 136;
        nArray[1737] = 22;
        nArray[1738] = 54;
        nArray[1739] = 209;
        nArray[1740] = 219;
        nArray[1741] = 242;
        nArray[1742] = 60;
        nArray[1743] = 140;
        nArray[1744] = 146;
        nArray[1745] = 61;
        nArray[1746] = 92;
        nArray[1747] = 88;
        nArray[1748] = 201;
        nArray[1749] = 62;
        nArray[1750] = 112;
        nArray[1751] = 29;
        nArray[1752] = 89;
        nArray[1753] = 105;
        nArray[1754] = 25;
        nArray[1755] = 53;
        nArray[1756] = 168;
        nArray[1757] = 20;
        nArray[1758] = 170;
        nArray[1759] = 117;
        nArray[1760] = 149;
        nArray[1761] = 153;
        nArray[1762] = 52;
        nArray[1763] = 111;
        nArray[1764] = 21;
        nArray[1765] = 255;
        nArray[1766] = 151;
        nArray[1767] = 75;
        nArray[1768] = 144;
        nArray[1769] = 23;
        nArray[1770] = 16;
        nArray[1771] = 57;
        nArray[1772] = 247;
        nArray[1773] = 246;
        nArray[1774] = 162;
        nArray[1775] = 73;
        nArray[1776] = 78;
        nArray[1777] = 67;
        nArray[1778] = 104;
        nArray[1779] = 224;
        nArray[1780] = 139;
        nArray[1781] = 240;
        nArray[1782] = 206;
        nArray[1783] = 12;
        nArray[1784] = 41;
        nArray[1785] = 232;
        nArray[1786] = 183;
        nArray[1787] = 134;
        nArray[1788] = 154;
        nArray[1789] = 82;
        nArray[1790] = 1;
        nArray[1791] = 157;
        nArray[1792] = 113;
        nArray[1793] = 156;
        nArray[1794] = 189;
        nArray[1795] = 93;
        nArray[1796] = 109;
        nArray[1797] = 103;
        nArray[1798] = 63;
        nArray[1799] = 107;
        nArray[1800] = 179;
        nArray[1801] = 70;
        nArray[1802] = 40;
        nArray[1803] = 165;
        nArray[1804] = 198;
        nArray[1805] = 211;
        nArray[1806] = 39;
        nArray[1807] = 97;
        nArray[1808] = 24;
        nArray[1809] = 102;
        nArray[1810] = 106;
        nArray[1811] = 191;
        nArray[1812] = 13;
        nArray[1813] = 244;
        nArray[1843] = 124;
        nArray[1844] = 8;
        nArray[1845] = 18;
        nArray[1846] = 163;
        nArray[1847] = 162;
        nArray[1848] = 7;
        nArray[1849] = 135;
        nArray[1850] = 75;
        nArray[1851] = 32;
        nArray[1852] = 18;
        nArray[1853] = 101;
        nArray[1854] = 168;
        nArray[1855] = 22;
        nArray[1856] = 169;
        nArray[1857] = 134;
        nArray[1858] = 177;
        nArray[1859] = 104;
        nArray[1860] = 160;
        nArray[1861] = 135;
        nArray[1862] = 102;
        nArray[1863] = 18;
        nArray[1864] = 161;
        nArray[1865] = 48;
        nArray[1866] = 60;
        nArray[1867] = 18;
        nArray[1868] = 133;
        nArray[1869] = 18;
        nArray[1870] = 100;
        nArray[1871] = 27;
        nArray[1872] = 7;
        nArray[1873] = 6;
        nArray[1874] = 111;
        nArray[1875] = 110;
        nArray[1876] = 110;
        nArray[1877] = 174;
        nArray[1878] = 175;
        nArray[1879] = 111;
        nArray[1880] = 178;
        nArray[1881] = 175;
        nArray[1882] = 178;
        nArray[1883] = 168;
        nArray[1884] = 171;
        nArray[1885] = 111;
        nArray[1886] = 175;
        nArray[1887] = 134;
        nArray[1888] = 174;
        nArray[1889] = 162;
        nArray[1890] = 162;
        nArray[1891] = 18;
        nArray[1892] = 175;
        nArray[1893] = 19;
        nArray[1894] = 18;
        nArray[1895] = 161;
        nArray[1896] = 110;
        nArray[1897] = 175;
        nArray[1898] = 175;
        nArray[1899] = 173;
        nArray[1900] = 6;
        nArray[1901] = 76;
        nArray[1902] = 110;
        nArray[1903] = 175;
        nArray[1904] = 175;
        nArray[1905] = 18;
        nArray[1906] = 124;
        nArray[1907] = 172;
        nArray[1908] = 168;
        nArray[1909] = 106;
        nArray[1910] = 110;
        nArray[1911] = 19;
        nArray[1912] = 160;
        nArray[1913] = 45;
        nArray[1914] = 168;
        nArray[1915] = 43;
        nArray[1916] = 172;
        nArray[1917] = 100;
        nArray[1918] = 172;
        nArray[1919] = 109;
        nArray[1920] = 135;
        nArray[1921] = 188;
        nArray[1922] = 96;
        nArray[1923] = 180;
        nArray[1924] = 19;
        nArray[1925] = 114;
        nArray[1926] = 124;
        nArray[1927] = 181;
        nArray[1928] = 174;
        nArray[1929] = 174;
        nArray[1930] = 124;
        nArray[1931] = 124;
        nArray[1932] = 101;
        nArray[1933] = 162;
        nArray[1934] = 108;
        nArray[1935] = 100;
        nArray[1936] = 133;
        nArray[1937] = 128;
        nArray[1938] = 176;
        nArray[1939] = 64;
        nArray[1940] = 136;
        nArray[1941] = 32;
        nArray[1942] = 104;
        nArray[1943] = 222;
        nArray[1944] = 0;
        nArray[1945] = 112;
        nArray[1946] = 222;
        nArray[1947] = 32;
        nArray[1948] = 120;
        nArray[1949] = 32;
        nArray[1950] = 32;
        nArray[1951] = 56;
        nArray[1952] = 32;
        nArray[1953] = 176;
        nArray[1954] = 144;
        nArray[1955] = 32;
        nArray[1956] = 176;
        nArray[1957] = 160;
        nArray[1958] = 224;
        nArray[1959] = 176;
        nArray[1960] = 192;
        nArray[1961] = 152;
        nArray[1962] = 182;
        nArray[1963] = 72;
        nArray[1964] = 128;
        nArray[1965] = 224;
        nArray[1966] = 80;
        nArray[1967] = 30;
        nArray[1968] = 30;
        nArray[1969] = 88;
        nArray[1970] = 32;
        nArray[1971] = 184;
        nArray[1972] = 224;
        nArray[1973] = 136;
        nArray[1974] = 176;
        nArray[1975] = 16;
        nArray[1976] = 32;
        nArray[1977] = 0;
        nArray[1978] = 16;
        nArray[1979] = 32;
        nArray[1980] = 224;
        nArray[1981] = 24;
        nArray[1982] = 224;
        nArray[1983] = 24;
        nArray[1984] = 0;
        nArray[1985] = 24;
        nArray[1986] = 224;
        nArray[1987] = 32;
        nArray[1988] = 168;
        nArray[1989] = 224;
        nArray[1990] = 32;
        nArray[1991] = 24;
        nArray[1992] = 224;
        nArray[1993] = 0;
        nArray[1994] = 32;
        nArray[1995] = 24;
        nArray[1996] = 216;
        nArray[1997] = 200;
        nArray[1998] = 24;
        nArray[1999] = 224;
        nArray[2000] = 0;
        nArray[2001] = 224;
        nArray[2002] = 64;
        nArray[2003] = 40;
        nArray[2004] = 40;
        nArray[2005] = 40;
        nArray[2006] = 24;
        nArray[2007] = 224;
        nArray[2008] = 96;
        nArray[2009] = 32;
        nArray[2010] = 24;
        nArray[2011] = 224;
        nArray[2012] = 0;
        nArray[2013] = 0;
        nArray[2014] = 8;
        nArray[2015] = 224;
        nArray[2016] = 24;
        nArray[2017] = 48;
        nArray[2018] = 208;
        nArray[2019] = 208;
        nArray[2020] = 208;
        nArray[2021] = 32;
        nArray[2022] = 224;
        nArray[2023] = 232;
        nArray[2024] = 255;
        nArray[2025] = 127;
        nArray[2026] = 191;
        nArray[2027] = 50;
        nArray[2028] = 208;
        nArray[2029] = 0;
        nArray[2030] = 0;
        nArray[2031] = 0;
        nArray[2032] = 159;
        nArray[2033] = 99;
        nArray[2034] = 121;
        nArray[2035] = 66;
        nArray[2036] = 176;
        nArray[2037] = 21;
        nArray[2038] = 203;
        nArray[2039] = 4;
        nArray[2040] = 255;
        nArray[2041] = 127;
        nArray[2042] = 49;
        nArray[2043] = 110;
        nArray[2044] = 74;
        nArray[2045] = 69;
        nArray[2046] = 0;
        nArray[2047] = 0;
        nArray[2048] = 255;
        nArray[2049] = 127;
        nArray[2050] = 239;
        nArray[2051] = 27;
        nArray[2052] = 0;
        nArray[2053] = 2;
        nArray[2054] = 0;
        nArray[2055] = 0;
        nArray[2056] = 255;
        nArray[2057] = 127;
        nArray[2058] = 31;
        nArray[2059] = 66;
        nArray[2060] = 242;
        nArray[2061] = 28;
        nArray[2062] = 0;
        nArray[2063] = 0;
        nArray[2064] = 255;
        nArray[2065] = 127;
        nArray[2066] = 148;
        nArray[2067] = 82;
        nArray[2068] = 74;
        nArray[2069] = 41;
        nArray[2070] = 0;
        nArray[2071] = 0;
        nArray[2072] = 255;
        nArray[2073] = 127;
        nArray[2074] = 255;
        nArray[2075] = 3;
        nArray[2076] = 47;
        nArray[2077] = 1;
        nArray[2078] = 0;
        nArray[2079] = 0;
        nArray[2080] = 255;
        nArray[2081] = 127;
        nArray[2082] = 239;
        nArray[2083] = 3;
        nArray[2084] = 214;
        nArray[2085] = 1;
        nArray[2086] = 0;
        nArray[2087] = 0;
        nArray[2088] = 255;
        nArray[2089] = 127;
        nArray[2090] = 181;
        nArray[2091] = 66;
        nArray[2092] = 200;
        nArray[2093] = 61;
        nArray[2094] = 0;
        nArray[2095] = 0;
        nArray[2096] = 116;
        nArray[2097] = 126;
        nArray[2098] = 255;
        nArray[2099] = 3;
        nArray[2100] = 128;
        nArray[2101] = 1;
        nArray[2102] = 0;
        nArray[2103] = 0;
        nArray[2104] = 255;
        nArray[2105] = 103;
        nArray[2106] = 172;
        nArray[2107] = 119;
        nArray[2108] = 19;
        nArray[2109] = 26;
        nArray[2110] = 107;
        nArray[2111] = 45;
        nArray[2112] = 214;
        nArray[2113] = 126;
        nArray[2114] = 255;
        nArray[2115] = 75;
        nArray[2116] = 117;
        nArray[2117] = 33;
        nArray[2118] = 0;
        nArray[2119] = 0;
        nArray[2120] = 255;
        nArray[2121] = 83;
        nArray[2122] = 95;
        nArray[2123] = 74;
        nArray[2124] = 82;
        nArray[2125] = 126;
        nArray[2126] = 0;
        nArray[2127] = 0;
        nArray[2128] = 255;
        nArray[2129] = 79;
        nArray[2130] = 210;
        nArray[2131] = 126;
        nArray[2132] = 76;
        nArray[2133] = 58;
        nArray[2134] = 224;
        nArray[2135] = 28;
        nArray[2136] = 237;
        nArray[2137] = 3;
        nArray[2138] = 255;
        nArray[2139] = 127;
        nArray[2140] = 95;
        nArray[2141] = 37;
        nArray[2142] = 0;
        nArray[2143] = 0;
        nArray[2144] = 106;
        nArray[2145] = 3;
        nArray[2146] = 31;
        nArray[2147] = 2;
        nArray[2148] = 255;
        nArray[2149] = 3;
        nArray[2150] = 255;
        nArray[2151] = 127;
        nArray[2152] = 255;
        nArray[2153] = 127;
        nArray[2154] = 223;
        nArray[2155] = 1;
        nArray[2156] = 18;
        nArray[2157] = 1;
        nArray[2158] = 0;
        nArray[2159] = 0;
        nArray[2160] = 31;
        nArray[2161] = 35;
        nArray[2162] = 95;
        nArray[2163] = 3;
        nArray[2164] = 242;
        nArray[2165] = 0;
        nArray[2166] = 9;
        nArray[2167] = 0;
        nArray[2168] = 255;
        nArray[2169] = 127;
        nArray[2170] = 234;
        nArray[2171] = 3;
        nArray[2172] = 31;
        nArray[2173] = 1;
        nArray[2174] = 0;
        nArray[2175] = 0;
        nArray[2176] = 159;
        nArray[2177] = 41;
        nArray[2178] = 26;
        nArray[2179] = 0;
        nArray[2180] = 12;
        nArray[2181] = 0;
        nArray[2182] = 0;
        nArray[2183] = 0;
        nArray[2184] = 255;
        nArray[2185] = 127;
        nArray[2186] = 127;
        nArray[2187] = 2;
        nArray[2188] = 31;
        nArray[2189] = 0;
        nArray[2190] = 0;
        nArray[2191] = 0;
        nArray[2192] = 255;
        nArray[2193] = 127;
        nArray[2194] = 224;
        nArray[2195] = 3;
        nArray[2196] = 6;
        nArray[2197] = 2;
        nArray[2198] = 32;
        nArray[2199] = 1;
        nArray[2200] = 255;
        nArray[2201] = 127;
        nArray[2202] = 235;
        nArray[2203] = 126;
        nArray[2204] = 31;
        nArray[2205] = 0;
        nArray[2206] = 0;
        nArray[2207] = 124;
        nArray[2208] = 255;
        nArray[2209] = 127;
        nArray[2210] = 255;
        nArray[2211] = 63;
        nArray[2212] = 0;
        nArray[2213] = 126;
        nArray[2214] = 31;
        nArray[2215] = 0;
        nArray[2216] = 255;
        nArray[2217] = 127;
        nArray[2218] = 255;
        nArray[2219] = 3;
        nArray[2220] = 31;
        nArray[2221] = 0;
        nArray[2222] = 0;
        nArray[2223] = 0;
        nArray[2224] = 255;
        nArray[2225] = 3;
        nArray[2226] = 31;
        nArray[2227] = 0;
        nArray[2228] = 12;
        nArray[2229] = 0;
        nArray[2230] = 0;
        nArray[2231] = 0;
        nArray[2232] = 255;
        nArray[2233] = 127;
        nArray[2234] = 63;
        nArray[2235] = 3;
        nArray[2236] = 147;
        nArray[2237] = 1;
        nArray[2238] = 0;
        nArray[2239] = 0;
        nArray[2240] = 0;
        nArray[2241] = 0;
        nArray[2242] = 0;
        nArray[2243] = 66;
        nArray[2244] = 127;
        nArray[2245] = 3;
        nArray[2246] = 255;
        nArray[2247] = 127;
        nArray[2248] = 255;
        nArray[2249] = 127;
        nArray[2250] = 140;
        nArray[2251] = 126;
        nArray[2252] = 0;
        nArray[2253] = 124;
        nArray[2254] = 0;
        nArray[2255] = 0;
        nArray[2256] = 255;
        nArray[2257] = 127;
        nArray[2258] = 239;
        nArray[2259] = 27;
        nArray[2260] = 128;
        nArray[2261] = 97;
        nArray[2262] = 0;
        nArray[2263] = 0;
        emuliciousBootROM = new GBCartridge(nArray);
        return emuliciousBootROM;
    }

    @Override
    protected int readWRAM(int n, int n2) {
        if ((n & 0x1FFF) >= 4096) {
            if (!this.wramInitialized[this.regSVBK * 4096 | n & 0xFFF]) {
                this.fireErrorOccurred(-1, n);
            }
            this.addEvent(GameBoyEventTypes.WRAM, this.wram[this.regSVBK * 4096 | n & 0xFFF], -1, n2, this.regSVBK * 4096 | n & 0xFFF);
            return this.wram[this.regSVBK * 4096 | n & 0xFFF];
        }
        return super.readWRAM(n, n2);
    }

    @Override
    protected int doReadWRAM(int n) {
        return (n & 0x1FFF) >= 4096 ? this.wram[this.regSVBK * 4096 | n & 0xFFF] : super.doReadWRAM(n);
    }

    @Override
    protected void writeWRAM(int n, int n2, int n3) {
        if ((n &= 0x1FFF) >= 4096) {
            n = this.regSVBK * 4096 | n & 0xFFF;
            this.updateWRAMsource(n);
            if (!this.isBootROMenabled()) {
                this.wramInitialized[n] = true;
            }
            this.addEvent(GameBoyEventTypes.WRAM, this.wram[n], n2, n3, n);
            this.wram[n] = n2;
        } else {
            super.writeWRAM(n, n2, n3);
        }
    }

    @Override
    public int getRAMlength() {
        if (this.dmgMode) {
            return 8192;
        }
        return super.getRAMlength();
    }

    @Override
    public int mapAddress(int n) {
        if (this.isWRAMaddress(n)) {
            if (n >= 53248 && n < 57344) {
                return this.regSVBK * 4096 | n & 0xFFF;
            }
        } else if (this.isVRAMaddress(n)) {
            return ((GBCLCDController)this.lcd).getRegVBK() * 8192 | n & 0x1FFF;
        }
        return super.mapAddress(n);
    }

    @Override
    public int mapAddress(int n, int n2) {
        if (this.isWRAMaddress(n)) {
            if (n >= 53248 && n < 57344) {
                return Math.max(1, n2) * 4096 | n & 0xFFF;
            }
        } else if (this.isVRAMaddress(n)) {
            return n2 * 8192 | n & 0x1FFF;
        }
        return super.mapAddress(n, n2);
    }

    @Override
    public int getNumberOfPaletteBytes() {
        return this.getNumberOfPaletteEntries() * 2;
    }

    @Override
    public int getNumberOfPaletteEntries() {
        return 64;
    }

    @Override
    public int getPaletteByte(int n) {
        long l = n >= 64 ? this.lcd.getOBP((n - 64) / 8) : this.lcd.getBGP(0, n / 8);
        return (int)(l >> (n & 7) * 8 & 0xFFL);
    }

    @Override
    public void setPaletteByte(int n, int n2) {
        long l = 8 * (n & 7);
        long l2 = 255L << (int)l;
        if (n >= 64) {
            this.lcd.setOBP((n - 64) / 8, this.lcd.getOBP((n - 64) / 8) & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | (long)n2 << (int)l);
        } else {
            this.lcd.setBGP(n / 8, this.lcd.getBGP(0, n / 8) & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | (long)n2 << (int)l);
        }
    }

    @Override
    public String getPaletteName(int n) {
        if ((n & 7) != 0) {
            return null;
        }
        if (n >= 64) {
            return "OBP" + (n - 64) / 8;
        }
        return "BGP" + n / 8;
    }

    @Override
    public int getRAMvalue(int n) {
        if (n >= 65280) {
            return this.memory[n & 0xFF];
        }
        return this.wram[n & 0x1FFF];
    }

    public void doHDMA(int n, int n2, int n3) {
        int n4 = this.peekByte(this.cpu.getPC());
        int n5 = 16;
        while (n5-- > 0) {
            int n6 = n >= 32768 && n < 40960 || n >= 57344 ? n4 : this.doReadByte(n++, 0);
            this.lcd.processWrite(0x8000 | n2++ & 0x1FFF, n6, n3, true);
            n4 = 255;
            n3 += 2;
        }
    }

    @Override
    protected void doDmaWrite(int n, int n2) {
        super.doDmaWrite(n, this.doubleSpeed ? n2 / 2 : n2);
    }

    @Override
    public int execute(int n) {
        while ((n = this.executeOnce(n)) > 0 && !this.isStopped()) {
        }
        return n;
    }

    @Override
    public int executeOnce(int n) {
        boolean bl;
        if (this.isStopped()) {
            return Math.min(0, n - 4);
        }
        do {
            int n2;
            boolean bl2 = this.doubleSpeed;
            bl = true;
            if (!this.cpu.isHalted() && ((GBCLCDController)this.lcd).continueHDMA(this.memory, this)) {
                n2 = 4 + 32 * (this.doubleSpeed ? 2 : 1);
            } else {
                n2 = bl2 ? this.cpu.execute(Math.min(Math.max(4, n), this.calcNextTimeout(this.lcd.getTimer() * 2))) : this.cpu.execute(Math.min(Math.max(4, n), this.calcNextTimeout(this.lcd.getTimer())));
                bl = false;
            }
            boolean bl3 = this.doubleSpeed;
            this.doubleSpeed = bl2;
            this.updateTimers(n2);
            this.updateDMA(n2);
            if (bl2) {
                n2 /= 2;
            }
            n -= n2;
            this.lcd.update(n2);
            this.cartridge.update(n2);
            this.doubleSpeed = bl3;
            if (this.lcd.isLCDDisplayEnabled() || this.lcd.getCyclesSinceLastFrame() < this.getCyclesPerFrame()) continue;
            this.frameFinished();
        } while (bl);
        return n;
    }

    @Override
    protected int getSerialBit() {
        return super.getSerialBit() >> (this.memory[2] >> 1 & 1) * 5;
    }

    @Override
    protected int getSoundBit() {
        return this.doubleSpeed ? super.getSoundBit() << 1 : super.getSoundBit();
    }

    @Override
    public int calcNextSoundClock() {
        return this.doubleSpeed ? super.calcNextSoundClock() >> 1 : super.calcNextSoundClock();
    }

    @Override
    protected boolean isCartridgeHeaderValid() {
        return this.cartridge == null || !(this.isAnaloguePocket() ? !super.isCartridgeHeaderValid() : !this.cartridge.isHeaderChecksumValid() || !this.cartridge.isHeaderLogoHalfValid());
    }

    @Override
    public boolean isBootromAddress(int n) {
        return super.isBootromAddress(n) || n >= 512 && n < 2304;
    }

    @Override
    public int getBank(int n) {
        if ((n &= 0xFFFF) >= 53248 && n < 57344) {
            return this.regSVBK;
        }
        if (n >= 32768 && n < 40960) {
            return ((GBCLCDController)this.lcd).getRegVBK();
        }
        return super.getBank(n);
    }

    @Override
    public void setBank(int n, int n2) {
        if ((n &= 0xFFFF) >= 53248 && n < 57344) {
            this.pokeByte(65392, n2);
        } else if (n >= 32768 && n < 40960) {
            this.pokeByte(65359, n2);
        } else {
            super.setBank(n, n2);
        }
    }

    @Override
    public void pokeByte(int n, int n2) {
        if (n == 65392) {
            if (!this.dmgMode) {
                this.regSVBK = Math.max(1, n2 & 7);
                this.memory[112] = 0xF8 | n2;
            }
        } else {
            super.pokeByte(n, n2);
        }
    }

    @Override
    public String cpuAddressToString(int n) {
        if (n >= 32768 && n < 40960) {
            return String.format("VRAM%X:%04X", ((GBCLCDController)this.lcd).getRegVBK(), n);
        }
        if (n >= 49152 && n < 53248) {
            return String.format("WRAM0:%04X", n);
        }
        if (n >= 53248 && n < 57344) {
            return String.format("WRAM%X:%04X", this.regSVBK, n);
        }
        return super.cpuAddressToString(n);
    }

    @Override
    public String virtualAddressToString(int n) {
        int n2 = n & 0xFFFF;
        if (n2 >= 32768 && n2 < 40960) {
            return String.format("VRAM%X:%04X", n >> 16, n2);
        }
        if (n2 >= 53248 && n2 < 57344) {
            return String.format("WRAM%X:%04X", n >> 16, n2);
        }
        return super.virtualAddressToString(n);
    }

    @Override
    public int toVirtualAddress(int n) {
        if (n >= 32768 && n < 40960) {
            return ((GBCLCDController)this.lcd).getRegVBK() << 16 | n;
        }
        if (n >= 53248 && n < 57344) {
            return this.regSVBK << 16 | n;
        }
        return super.toVirtualAddress(n);
    }

    @Override
    public String ramAddressToString(int n) {
        if (n < 4096) {
            return String.format("0:%04X", 0xC000 | n);
        }
        return String.format("%X:%04X", n / 4096, 0xD000 | n & 0xFFF);
    }

    @Override
    public String vramAddressToString(int n) {
        return String.format("%X:%04X", n / 8192, 0x8000 | n & 0x1FFF);
    }

    @Override
    public String palAddressToString(int n) {
        if (n < 64) {
            return String.format("BGP%X:%X", n / 8, n & 7);
        }
        return String.format("OBP%X:%X", n / 8 & 7, n & 7);
    }

    @Override
    public String getMemoryName(int n) {
        switch (n) {
            case 65357: {
                return "KEY1";
            }
            case 65359: {
                return "VBK";
            }
            case 65361: {
                return "HDMA1";
            }
            case 65362: {
                return "HDMA2";
            }
            case 65363: {
                return "HDMA3";
            }
            case 65364: {
                return "HDMA4";
            }
            case 65365: {
                return "HDMA5";
            }
            case 65366: {
                return "RP";
            }
            case 65384: {
                return "BCPS";
            }
            case 65385: {
                return "BCPD";
            }
            case 65386: {
                return "OCPS";
            }
            case 65387: {
                return "OCPD";
            }
            case 65392: {
                return "SVBK";
            }
            case 65398: {
                return "PCM12";
            }
            case 65399: {
                return "PCM34";
            }
        }
        return super.getMemoryName(n);
    }

    @Override
    protected GameBoy.GameBoyEventModel createGameBoyEventModel() {
        return new GameBoyColorEventModel();
    }

    @Override
    protected void handlePortEvent(int n, int n2, int n3, int n4) {
        GameBoyColorEventTypes gameBoyColorEventTypes;
        if (this.eventModel == null) {
            return;
        }
        if (this.doubleSpeed) {
            n4 /= 2;
        }
        switch (n) {
            case 79: {
                gameBoyColorEventTypes = GameBoyColorEventTypes.VBK;
                break;
            }
            case 81: {
                this.addEvent(GameBoyColorEventTypes.HDMA1, ((GBCLCDController)this.lcd).getRegHDMA1(), n3, n4, n3 << 8 | ((GBCLCDController)this.lcd).getRegHDMA2());
                return;
            }
            case 82: {
                this.addEvent(GameBoyColorEventTypes.HDMA2, ((GBCLCDController)this.lcd).getRegHDMA2(), n3, n4, ((GBCLCDController)this.lcd).getRegHDMA1() << 8 | n3);
                return;
            }
            case 83: {
                this.addEvent(GameBoyColorEventTypes.HDMA3, ((GBCLCDController)this.lcd).getRegHDMA3(), n3, n4, n3 << 8 | ((GBCLCDController)this.lcd).getRegHDMA4());
                return;
            }
            case 84: {
                this.addEvent(GameBoyColorEventTypes.HDMA4, ((GBCLCDController)this.lcd).getRegHDMA4(), n3, n4, ((GBCLCDController)this.lcd).getRegHDMA3() << 8 | n3);
                return;
            }
            case 85: {
                this.addEvent(GameBoyColorEventTypes.HDMA5, ((GBCLCDController)this.lcd).getRegHDMA5(), n3, n4, ((GBCLCDController)this.lcd).getRegHDMA1() << 24 | ((GBCLCDController)this.lcd).getRegHDMA2() << 16 | ((GBCLCDController)this.lcd).getRegHDMA3() << 8 | ((GBCLCDController)this.lcd).getRegHDMA4());
                return;
            }
            case 104: {
                gameBoyColorEventTypes = GameBoyColorEventTypes.BCPS;
                break;
            }
            case 105: {
                gameBoyColorEventTypes = GameBoyColorEventTypes.BCPD;
                break;
            }
            case 106: {
                gameBoyColorEventTypes = GameBoyColorEventTypes.OCPS;
                break;
            }
            case 107: {
                gameBoyColorEventTypes = GameBoyColorEventTypes.OCPD;
                break;
            }
            default: {
                gameBoyColorEventTypes = null;
            }
        }
        if (gameBoyColorEventTypes != null) {
            this.addEvent(gameBoyColorEventTypes, n2, n3, n4);
        } else {
            super.handlePortEvent(n, n2, n3, n4);
        }
    }

    @Override
    protected void addHaltEvent(int n, int n2) {
        super.addHaltEvent(n, this.doubleSpeed ? n2 / 2 : n2);
    }

    @Override
    public GameBoy.State getState() {
        final GameBoy.State state = super.getState();
        return new GameBoy.UnmodifiableState(){

            @Override
            public GameBoy.State clone() {
                return new StateClone(this);
            }

            @Override
            public int[] getWRam() {
                return state.getWRam();
            }

            @Override
            public int[] getHRam() {
                return state.getHRam();
            }

            @Override
            public GBCartridge.State getCartridgeState() {
                return state.getCartridgeState();
            }

            @Override
            public LR35902.State getCPUstate() {
                return state.getCPUstate();
            }

            @Override
            public GBLCDController.State getLCDstate() {
                return state.getLCDstate();
            }

            @Override
            public GBSoundController.State getSoundState() {
                return state.getSoundState();
            }

            @Override
            public boolean isPrevSTATline() {
                return state.isPrevSTATline();
            }

            @Override
            public boolean isBootROMenabled() {
                return state.isBootROMenabled();
            }

            @Override
            public int getCounter() {
                return state.getCounter();
            }

            @Override
            public GameBoy.TIMAState getTimaState() {
                return state.getTimaState();
            }

            @Override
            public int getSerialCounter() {
                return state.getSerialCounter();
            }

            @Override
            public boolean isStopped() {
                return state.isStopped();
            }

            @Override
            public int getDmaCounter() {
                return state.getDmaCounter();
            }

            @Override
            public int getDmaSource() {
                return state.getDmaSource();
            }

            @Override
            public int getTimerDMA() {
                return state.getTimerDMA();
            }

            @Override
            public boolean isDmaJustStarted() {
                return state.isDmaJustStarted();
            }

            @Override
            public boolean isDmaStillRunning() {
                return state.isDmaStillRunning();
            }

            @Override
            public boolean[] getWRamInitialized() {
                return state.getWRamInitialized();
            }

            @Override
            public boolean[] getHRamInitialized() {
                return state.getHRamInitialized();
            }

            @Override
            public int getRegSVBK() {
                return GameBoyColor.this.regSVBK;
            }

            @Override
            public boolean isDoubleSpeed() {
                return GameBoyColor.this.doubleSpeed;
            }

            @Override
            public boolean isDmgMode() {
                return GameBoyColor.this.dmgMode;
            }
        };
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        super.setState(state, bl, bl2);
        if (state instanceof GameBoy.State) {
            GameBoy.State state2 = (GameBoy.State)state;
            this.regSVBK = Math.max(1, state2.getRegSVBK() & 7);
            this.doubleSpeed = state2.isDoubleSpeed();
            this.dmgMode = state2.isDmgMode();
        }
    }

    protected class GameBoyColorEventModel
    extends GameBoy.GameBoyEventModel {
        private final GameBoyColorEventTypes[] eventTypes;

        public GameBoyColorEventModel() {
            this((EventType[])GameBoyColorEventTypes.values());
        }

        public GameBoyColorEventModel(EventType[] eventTypeArray) {
            super(eventTypeArray);
            this.eventTypes = GameBoyColorEventTypes.values();
        }

        @Override
        protected String getDetails(Event event) {
            if (event.getType() >= this.eventTypes.length) {
                return null;
            }
            switch (this.eventTypes[event.getType()]) {
                case BCPS: 
                case OCPS: {
                    return "Address: " + String.format("%02X", event.getNewValue() & 0x3F) + ((event.getNewValue() & 0x80) != 0 ? " (Auto Increment)" : "");
                }
                case HDMA1: 
                case HDMA2: {
                    return "HDMA Source: " + String.format("%04X", event.getDetailsData());
                }
                case HDMA3: 
                case HDMA4: {
                    return "HDMA Destination: " + String.format("%04X", event.getDetailsData());
                }
                case HDMA5: {
                    if (event.getNewValue() < 0) {
                        return event.getOldValue() == 255 ? "HDMA is finished" : "HDMA transfer has " + ((event.getOldValue() & 0x7F) + 1) * 16 + " bytes remaining to transfer";
                    }
                    return "Requested HDMA from " + String.format("%04X", event.getDetailsData() >>> 16) + " to " + String.format("%04X", event.getDetailsData() & 0xFFFF) + " of " + ((event.getNewValue() & 0x7F) + 1) * 16 + " bytes.";
                }
            }
            return super.getDetails(event);
        }
    }

    private static class StateClone
    extends GameBoy.StateClone {
        private int regSVBK;
        private boolean doubleSpeed;
        private boolean dmgMode;

        public StateClone(GameBoy.State state) {
            super(state);
            this.regSVBK = state.getRegSVBK();
            this.doubleSpeed = state.isDoubleSpeed();
            this.dmgMode = state.isDmgMode();
        }

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            super.setState(state);
            GameBoy.State state2 = (GameBoy.State)state;
            this.regSVBK = state2.getRegSVBK();
            this.doubleSpeed = state2.isDoubleSpeed();
            this.dmgMode = state2.isDmgMode();
        }

        @Override
        public int getRegSVBK() {
            return this.regSVBK;
        }

        @Override
        public boolean isDoubleSpeed() {
            return this.doubleSpeed;
        }

        @Override
        public boolean isDmgMode() {
            return this.dmgMode;
        }
    }
}

